/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.util.Triple;
import org.drools.core.util.TripleFactory;
import org.drools.core.util.TripleImpl;
import org.drools.core.util.TripleStore;
import org.drools.factmodel.traits.TripleBasedStruct;

public class TripleBasedBean
extends TripleBasedStruct {
    protected Object object;

    public TripleBasedBean() {
    }

    public TripleBasedBean(Object o, TripleStore store, TripleFactory factory) {
        this.store = store;
        this.storeId = store.getId();
        this.object = o;
        this.tripleFactory = factory;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        int N = this.getTriplesForSubject(this.getObject()).size();
        out.writeInt(N);
        for (Triple t : this.getTriplesForSubject(this.getObject())) {
            out.writeObject(this.tripleFactory.newTriple(null, t.getProperty(), t.getValue()));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int N = in.readInt();
        for (int j = 0; j < N; ++j) {
            Triple t = (Triple)in.readObject();
            ((TripleImpl)t).setInstance(this.getObject());
            this.store.put(t, false);
        }
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
    }

    @Override
    public String toString() {
        return "TBB " + this.storeId;
    }
}

