/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.drools.RuleBaseConfiguration;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.common.MemoryFactory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleBasePartitionId;
import org.drools.core.util.BitMaskUtil;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.SegmentMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.ContextEntry;
import org.drools.rule.constraint.MvelConstraint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleComponent;
import org.kie.definition.rule.Rule;

public class AlphaNode
extends ObjectSource
implements ObjectSinkNode,
MemoryFactory {
    private static final long serialVersionUID = 510L;
    private AlphaNodeFieldConstraint constraint;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;

    public AlphaNode() {
    }

    public AlphaNode(int id, AlphaNodeFieldConstraint constraint, ObjectSource objectSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.constraint = constraint;
        this.initDeclaredMask(context);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.constraint = (AlphaNodeFieldConstraint)in.readObject();
        this.declaredMask = in.readLong();
        this.inferredMask = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.constraint);
        out.writeLong(this.declaredMask);
        out.writeLong(this.inferredMask);
    }

    public AlphaNodeFieldConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    public short getType() {
        return 40;
    }

    @Override
    public void attach(BuildContext context) {
        this.source.addObjectSink(this);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.source.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
        if (this.constraint.isAllowed(factHandle, workingMemory, memory.context)) {
            this.sink.propagateAssertObject(factHandle, context, workingMemory);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (BitMaskUtil.intersect(context.getModificationMask(), this.inferredMask)) {
            AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
            if (this.constraint.isAllowed(factHandle, workingMemory, memory.context)) {
                this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        } else {
            this.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        AlphaMemory memory = (AlphaMemory)workingMemory.getNodeMemory(this);
        ObjectSinkUpdateAdapter adapter = new ObjectSinkUpdateAdapter(sink, this.constraint, memory.context);
        this.source.updateSink(adapter, context, workingMemory);
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config) {
        AlphaMemory memory = new AlphaMemory();
        memory.context = this.constraint.createContextEntry();
        return memory;
    }

    @Override
    public String toString() {
        return "[AlphaNode(" + this.id + ") constraint=" + this.constraint + "]";
    }

    @Override
    public int hashCode() {
        return this.source.hashCode() * 17 + (this.constraint != null ? this.constraint.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AlphaNode)) {
            return false;
        }
        AlphaNode other = (AlphaNode)object;
        return this.source.equals(other.source) && this.constraint.equals(other.constraint);
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    @Override
    public long calculateDeclaredMask(List<String> settableProperties) {
        if (settableProperties == null || !(this.constraint instanceof MvelConstraint)) {
            return Long.MAX_VALUE;
        }
        return ((MvelConstraint)this.constraint).getListenedPropertyMask(settableProperties);
    }

    @Override
    public long getDeclaredMask() {
        return this.declaredMask;
    }

    public long getInferredMask() {
        return this.inferredMask;
    }

    @Override
    public void addObjectSink(ObjectSink objectSink) {
        super.addObjectSink(objectSink);
    }

    private static class ObjectSinkUpdateAdapter
    implements ObjectSink {
        private final ObjectSink sink;
        private final AlphaNodeFieldConstraint constraint;
        private final ContextEntry contextEntry;

        public ObjectSinkUpdateAdapter(ObjectSink sink, AlphaNodeFieldConstraint constraint, ContextEntry contextEntry) {
            this.sink = sink;
            this.constraint = constraint;
            this.contextEntry = contextEntry;
        }

        @Override
        public void assertObject(InternalFactHandle handle, PropagationContext propagationContext, InternalWorkingMemory workingMemory) {
            if (this.constraint.isAllowed(handle, workingMemory, this.contextEntry)) {
                this.sink.assertObject(handle, propagationContext, workingMemory);
            }
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("This method should NEVER EVER be called");
        }

        @Override
        public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        @Override
        public short getType() {
            return 40;
        }

        @Override
        public Map<Rule, RuleComponent> getAssociations() {
            return this.sink.getAssociations();
        }
    }

    public static class AlphaMemory
    implements Memory {
        private static final long serialVersionUID = 510L;
        public ContextEntry context;

        @Override
        public short getNodeType() {
            return 40;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrevious(Memory previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNext(Memory next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getNext() {
            throw new UnsupportedOperationException();
        }
    }
}

