/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.drools.RuleBaseConfiguration;
import org.drools.base.DroolsQuery;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.common.MemoryFactory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.UpdateContext;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashMap;
import org.drools.marshalling.impl.PersisterHelper;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.JoinNodeLeftTuple;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RiaRuleMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleMemory;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.SegmentMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;

public class RightInputAdapterNode
extends ObjectSource
implements LeftTupleSinkNode,
MemoryFactory {
    private static final long serialVersionUID = 510L;
    private LeftTupleSource tupleSource;
    private LeftTupleSource startTupleSource;
    protected boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    protected boolean unlinkingEnabled;

    public RightInputAdapterNode() {
    }

    public RightInputAdapterNode(int id, LeftTupleSource source, LeftTupleSource startTupleSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.tupleSource = source;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.startTupleSource = startTupleSource;
        this.unlinkingEnabled = context.getRuleBase().getConfiguration().isUnlinkingEnabled();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.startTupleSource = (LeftTupleSource)in.readObject();
        this.unlinkingEnabled = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.tupleSource);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeObject(this.startTupleSource);
        out.writeBoolean(this.unlinkingEnabled);
    }

    public LeftTupleSource getStartTupleSource() {
        return this.startTupleSource;
    }

    public void setStartTupleSource(LeftTupleSource startTupleSource) {
        this.startTupleSource = startTupleSource;
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config) {
        RiaNodeMemory rianMem = new RiaNodeMemory();
        if (this.unlinkingEnabled) {
            LeftTupleSource tupleSource;
            int segmentCount = 0;
            int segmentPosMask = 1;
            long allLinkedTestMask = 1L;
            RiaRuleMemory rmem = new RiaRuleMemory(this);
            for (tupleSource = this.getLeftTupleSource(); tupleSource != null && tupleSource != this.getStartTupleSource(); tupleSource = tupleSource.getLeftTupleSource()) {
                if (tupleSource.getLeftTupleSource() == this.getStartTupleSource() || BetaNode.parentInSameSegment(tupleSource)) continue;
                allLinkedTestMask |= (long)(segmentPosMask <<= 1);
                ++segmentCount;
            }
            while (tupleSource != null) {
                if (!BetaNode.parentInSameSegment(tupleSource)) {
                    allLinkedTestMask <<= 1;
                    ++segmentCount;
                }
                tupleSource = tupleSource.getLeftTupleSource();
            }
            rmem.setAllLinkedMaskTest(allLinkedTestMask);
            rianMem.setRuleSegments(rmem);
            rmem.setSegmentMemories(new SegmentMemory[segmentCount]);
        }
        return rianMem;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        return null;
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        InternalFactHandle handle = this.createFactHandle(leftTuple, context, workingMemory);
        boolean useLeftMemory = true;
        if (!(this.tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        if (useLeftMemory) {
            RiaNodeMemory memory = (RiaNodeMemory)workingMemory.getNodeMemory(this);
            memory.getMap().put(leftTuple, handle);
        }
        this.sink.propagateAssertObject(handle, context, workingMemory);
    }

    public InternalFactHandle createFactHandle(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Map map;
        InternalFactHandle handle = null;
        ProtobufMessages.FactHandle _handle = null;
        if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.getId())) != null) {
            _handle = (ProtobufMessages.FactHandle)map.get(PersisterHelper.createTupleKey(leftTuple));
        }
        handle = _handle != null ? workingMemory.getFactHandleFactory().newFactHandle(_handle.getId(), leftTuple, _handle.getRecency(), workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), leftTuple), workingMemory, null) : workingMemory.getFactHandleFactory().newFactHandle(leftTuple, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), leftTuple), workingMemory, null);
        return handle;
    }

    @Override
    public void retractLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RiaNodeMemory memory = (RiaNodeMemory)workingMemory.getNodeMemory(this);
        InternalFactHandle factHandle = (InternalFactHandle)memory.getMap().remove(tuple);
        for (RightTuple rightTuple = factHandle.getFirstRightTuple(); rightTuple != null; rightTuple = rightTuple.getHandleNext()) {
            rightTuple.getRightTupleSink().retractRightTuple(rightTuple, context, workingMemory);
        }
        factHandle.clearRightTuples();
        for (LeftTuple leftTuple = factHandle.getLastLeftTuple(); leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
            leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, context, workingMemory);
        }
        factHandle.clearLeftTuples();
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This method should never be called");
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RiaNodeMemory memory = (RiaNodeMemory)workingMemory.getNodeMemory(this);
        InternalFactHandle handle = (InternalFactHandle)memory.getMap().get(leftTuple);
        for (RightTuple rightTuple = handle.getFirstRightTuple(); rightTuple != null; rightTuple = rightTuple.getHandleNext()) {
            rightTuple.getRightTupleSink().modifyRightTuple(rightTuple, context, workingMemory);
        }
    }

    @Override
    public void attach(BuildContext context) {
        this.tupleSource.addTupleSink(this, context);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.tupleSource.networkUpdated(updateContext);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        RiaNodeMemory memory = (RiaNodeMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.getMap().iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            sink.assertObject((InternalFactHandle)entry.getValue(), context, workingMemory);
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeObjectSink((ObjectSink)((Object)node));
        }
        if (!this.isInUse()) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                RiaNodeMemory memory = (RiaNodeMemory)workingMemory.getNodeMemory(this);
                Iterator it = memory.getMap().iterator();
                ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
                while (entry != null) {
                    LeftTuple leftTuple = (LeftTuple)entry.getKey();
                    leftTuple.unlinkFromLeftParent();
                    leftTuple.unlinkFromRightParent();
                    entry = (ObjectHashMap.ObjectEntry)it.next();
                }
                workingMemory.clearNodeMemory(this);
            }
        }
        this.tupleSource.remove(context, builder, this, workingMemories);
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 71;
    }

    @Override
    public int hashCode() {
        return this.tupleSource.hashCode() * 17 + (this.tupleMemoryEnabled ? 1234 : 4321);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof RightInputAdapterNode)) {
            return false;
        }
        RightInputAdapterNode other = (RightInputAdapterNode)object;
        return this.tupleMemoryEnabled == other.tupleMemoryEnabled && this.tupleSource.equals(other.tupleSource);
    }

    @Override
    public String toString() {
        return "RightInputAdapterNode(" + this.id + ")[ tupleMemoryEnabled=" + this.tupleMemoryEnabled + ", tupleSource=" + this.tupleSource + ", source=" + this.source + ", associations=" + this.associations.keySet() + ", partitionId=" + this.partitionId + "]";
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new JoinNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new JoinNodeLeftTuple(leftTuple, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new JoinNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new JoinNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    @Override
    public int getLeftInputOtnId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLeftInputOtnId(int leftInputOtnId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long calculateDeclaredMask(List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }

    public static class RiaNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Memory {
        private ObjectHashMap map = new ObjectHashMap();
        private RuleMemory ruleSegments;

        public ObjectHashMap getMap() {
            return this.map;
        }

        public void setMap(ObjectHashMap map) {
            this.map = map;
        }

        public RuleMemory getRuleSegments() {
            return this.ruleSegments;
        }

        public void setRuleSegments(RuleMemory ruleSegments) {
            this.ruleSegments = ruleSegments;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public short getNodeType() {
            return 71;
        }
    }
}

