/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.common.InternalWorkingMemory;
import org.drools.spi.Activation;
import org.drools.time.Trigger;
import org.drools.time.impl.CompositeMaxDurationTrigger;
import org.drools.time.impl.DurationTimer;
import org.drools.time.impl.Timer;
import org.kie.runtime.Calendars;

public class CompositeMaxDurationTimer
implements Timer {
    private static final long serialVersionUID = -2531364489959820962L;
    private List<DurationTimer> durations;
    private Timer timer;

    public void addDurationTimer(DurationTimer durationTimer) {
        if (this.durations == null) {
            this.durations = new LinkedList<DurationTimer>();
        }
        this.durations.add(durationTimer);
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    @Override
    public Trigger createTrigger(Activation item, WorkingMemory wm) {
        long timestamp = ((InternalWorkingMemory)wm).getTimerService().getCurrentTime();
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = ((InternalWorkingMemory)wm).getCalendars();
        return this.createTrigger(timestamp, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        if (this.durations == null) {
            throw new IllegalStateException("CompositeMaxDurationTimer cannot have no durations");
        }
        Date maxDurationDate = new Date(this.getMaxDuration() + timestamp);
        return new CompositeMaxDurationTrigger(maxDurationDate, this.timer != null ? this.timer.createTrigger(timestamp, calendarNames, calendars) : null, calendarNames, calendars);
    }

    private long getMaxDuration() {
        long result = 0L;
        for (DurationTimer durationTimer : this.durations) {
            result = Math.max(result, durationTimer.getDuration());
        }
        return result;
    }
}

