/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.UpdateCommand;
import org.drools.core.common.DisconnectedFactHandle;
import org.drools.core.xml.jaxb.util.JaxbListWrapper;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.FactHandle;

public class CommandSerializationTest {
    private Class<?>[] annotatedJaxbClasses = new Class[]{JaxbListWrapper.class};

    @Test
    public void updateCommandTest() throws Exception {
        DisconnectedFactHandle discFactHandle = new DisconnectedFactHandle(2, 3, 4, 5L, "entry-point-id", (Object)"str-obj", true);
        DisconnectedFactHandle copyDiscFactHandle = (DisconnectedFactHandle)this.roundTrip(discFactHandle);
        this.verifyDisconnectedFactHandle(discFactHandle, copyDiscFactHandle);
        UpdateCommand cmd = new UpdateCommand((FactHandle)discFactHandle, (Object)"new-str-object");
        UpdateCommand copyCmd = (UpdateCommand)this.roundTrip(cmd);
        this.verifyDisconnectedFactHandle(discFactHandle, copyCmd.getHandle());
        Assert.assertEquals((String)"entry point", (Object)cmd.getEntryPoint(), (Object)copyCmd.getEntryPoint());
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
    }

    @Test
    public void insertObjectCommandTest() throws Exception {
        InsertObjectCommand cmd = new InsertObjectCommand((Object)"obj", "out-id");
        cmd.setReturnObject(false);
        cmd.setEntryPoint("entry-point");
        InsertObjectCommand copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
        Assert.assertEquals((String)"out id", (Object)cmd.getOutIdentifier(), (Object)copyCmd.getOutIdentifier());
        Assert.assertEquals((String)"return obj", (Object)cmd.isReturnObject(), (Object)copyCmd.isReturnObject());
        Assert.assertEquals((String)"entry point", (Object)cmd.getEntryPoint(), (Object)copyCmd.getEntryPoint());
        Assert.assertEquals((String)"disconnected", (Object)cmd.isDisconnected(), (Object)copyCmd.isDisconnected());
    }

    @Test
    public void insertObjectCommandListTest() throws Exception {
        ArrayList<String> objectList = new ArrayList<String>();
        objectList.add("obj");
        InsertObjectCommand cmd = new InsertObjectCommand(objectList, "out-id");
        InsertObjectCommand copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        Assert.assertNotNull((Object)copyCmd);
        Assert.assertThat((Object)copyCmd.getObject(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
    }

    @Test
    public void insertObjectCommandEmptyListTest() throws Exception {
        ArrayList<String> objectList = new ArrayList<String>();
        objectList.add("one-element");
        InsertObjectCommand cmd = new InsertObjectCommand(objectList, "out-id");
        InsertObjectCommand copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        Assert.assertNotNull((Object)copyCmd);
        Assert.assertThat((Object)copyCmd.getObject(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
        objectList.clear();
        copyCmd = (InsertObjectCommand)this.roundTrip(cmd);
        Assert.assertNotNull((Object)copyCmd);
        Assert.assertThat((Object)copyCmd.getObject(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        Assert.assertEquals((String)"object", (Object)cmd.getObject(), (Object)copyCmd.getObject());
    }

    private void verifyDisconnectedFactHandle(DisconnectedFactHandle orig, DisconnectedFactHandle copy) {
        Assert.assertNotNull((String)"copy disconnected fact handle is null", (Object)copy);
        Assert.assertEquals((String)"id", (long)orig.getId(), (long)copy.getId());
        Assert.assertEquals((String)"identity hash code", (long)orig.getIdentityHashCode(), (long)copy.getIdentityHashCode());
        Assert.assertEquals((String)"object hash code", (long)orig.getObjectHashCode(), (long)copy.getObjectHashCode());
        Assert.assertEquals((String)"recency", (long)orig.getRecency(), (long)copy.getRecency());
        Assert.assertEquals((String)"entry point id", (Object)orig.getEntryPointId(), (Object)copy.getEntryPointId());
        Assert.assertEquals((String)"object", (Object)orig.getObject(), (Object)copy.getObject());
        Assert.assertEquals((String)"trait type", (Object)orig.getTraitType(), (Object)copy.getTraitType());
    }

    private <T> T roundTrip(Object obj) throws Exception {
        Class[] classes = new Class[]{obj.getClass()};
        JAXBContext ctx = this.getJaxbContext(classes);
        String xmlOut = this.marshall(ctx, obj);
        return this.unmarshall(ctx, xmlOut);
    }

    private <T> T unmarshall(JAXBContext ctx, String xmlIn) throws Exception {
        ByteArrayInputStream xmlStrInputStream = new ByteArrayInputStream(xmlIn.getBytes(Charset.forName("UTF-8")));
        Object out = ctx.createUnmarshaller().unmarshal((InputStream)xmlStrInputStream);
        return (T)out;
    }

    private String marshall(JAXBContext ctx, Object obj) throws Exception {
        StringWriter writer = new StringWriter();
        ctx.createMarshaller().marshal(obj, (Writer)writer);
        return writer.getBuffer().toString();
    }

    private JAXBContext getJaxbContext(Class<?> ... classes) throws Exception {
        ArrayList jaxbClassList = new ArrayList();
        jaxbClassList.addAll(Arrays.asList(classes));
        jaxbClassList.addAll(Arrays.asList(this.annotatedJaxbClasses));
        Class[] jaxbClasses = jaxbClassList.toArray(new Class[jaxbClassList.size()]);
        return JAXBContext.newInstance((Class[])jaxbClasses);
    }
}

