/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event.knowledgebase;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.FieldFactory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.MvelConstraintTestUtil;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.ObjectType;
import org.drools.core.test.model.Cheese;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.kiebase.AfterFunctionRemovedEvent;
import org.kie.api.event.kiebase.AfterKieBaseLockedEvent;
import org.kie.api.event.kiebase.AfterKieBaseUnlockedEvent;
import org.kie.api.event.kiebase.AfterKiePackageAddedEvent;
import org.kie.api.event.kiebase.AfterKiePackageRemovedEvent;
import org.kie.api.event.kiebase.AfterProcessAddedEvent;
import org.kie.api.event.kiebase.AfterProcessRemovedEvent;
import org.kie.api.event.kiebase.AfterRuleAddedEvent;
import org.kie.api.event.kiebase.AfterRuleRemovedEvent;
import org.kie.api.event.kiebase.BeforeFunctionRemovedEvent;
import org.kie.api.event.kiebase.BeforeKieBaseLockedEvent;
import org.kie.api.event.kiebase.BeforeKieBaseUnlockedEvent;
import org.kie.api.event.kiebase.BeforeKiePackageAddedEvent;
import org.kie.api.event.kiebase.BeforeKiePackageRemovedEvent;
import org.kie.api.event.kiebase.BeforeProcessAddedEvent;
import org.kie.api.event.kiebase.BeforeProcessRemovedEvent;
import org.kie.api.event.kiebase.BeforeRuleAddedEvent;
import org.kie.api.event.kiebase.BeforeRuleRemovedEvent;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;

public class KnowledgeBaseEventSupportTest {
    private KnowledgeBase kbase;
    private TestRuleBaseListener listener1;
    private TestRuleBaseListener listener2;
    private InternalKnowledgePackage pkg;

    @Before
    public void setUp() throws Exception {
        this.kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.listener1 = new TestRuleBaseListener("(listener-1) ");
        this.listener2 = new TestRuleBaseListener("(listener-2) ");
        this.kbase.addEventListener((KieBaseEventListener)this.listener1);
        this.kbase.addEventListener((KieBaseEventListener)this.listener2);
        RuleImpl rule1 = new RuleImpl("test1");
        ClassObjectType cheeseObjectType = new ClassObjectType(Cheese.class);
        Pattern pattern = new Pattern(0, (ObjectType)cheeseObjectType);
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        ClassFieldReader extractor = store.getReader(Cheese.class, "type");
        FieldValue field = FieldFactory.getInstance().getFieldValue((Object)"cheddar");
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("type == \"cheddar\"", field, (InternalReadAccessor)extractor);
        pattern.addConstraint((Constraint)constraint);
        rule1.addPattern((RuleConditionElement)pattern);
        rule1.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        RuleImpl rule2 = new RuleImpl("test2");
        ClassObjectType cheeseObjectType2 = new ClassObjectType(Cheese.class);
        Pattern pattern2 = new Pattern(0, (ObjectType)cheeseObjectType2);
        FieldValue field2 = FieldFactory.getInstance().getFieldValue((Object)"stilton");
        MvelConstraintTestUtil constraint2 = new MvelConstraintTestUtil("type == \"stilton\"", field, (InternalReadAccessor)extractor);
        pattern2.addConstraint((Constraint)constraint2);
        rule2.addPattern((RuleConditionElement)pattern2);
        rule2.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        this.pkg = new KnowledgePackageImpl("org.drools.test1");
        this.pkg.addRule(rule1);
        this.pkg.addRule(rule2);
    }

    @Test
    public void testAddPackageEvents() throws Exception {
        Assert.assertEquals((long)0L, (long)this.listener1.getBeforePackageAdded());
        Assert.assertEquals((long)0L, (long)this.listener1.getAfterPackageAdded());
        Assert.assertEquals((long)0L, (long)this.listener2.getBeforePackageAdded());
        Assert.assertEquals((long)0L, (long)this.listener2.getAfterPackageAdded());
        Assert.assertEquals((long)0L, (long)this.listener1.getBeforeRuleAdded());
        Assert.assertEquals((long)0L, (long)this.listener1.getAfterRuleAdded());
        Assert.assertEquals((long)0L, (long)this.listener2.getBeforeRuleAdded());
        Assert.assertEquals((long)0L, (long)this.listener2.getAfterRuleAdded());
        ArrayList<InternalKnowledgePackage> pkgs = new ArrayList<InternalKnowledgePackage>();
        pkgs.add(this.pkg);
        this.kbase.addKnowledgePackages(pkgs);
        Assert.assertEquals((long)1L, (long)this.listener1.getBeforePackageAdded());
        Assert.assertEquals((long)1L, (long)this.listener1.getAfterPackageAdded());
        Assert.assertEquals((long)1L, (long)this.listener2.getBeforePackageAdded());
        Assert.assertEquals((long)1L, (long)this.listener2.getAfterPackageAdded());
        Assert.assertEquals((long)2L, (long)this.listener1.getBeforeRuleAdded());
        Assert.assertEquals((long)2L, (long)this.listener1.getAfterRuleAdded());
        Assert.assertEquals((long)2L, (long)this.listener2.getBeforeRuleAdded());
        Assert.assertEquals((long)2L, (long)this.listener2.getAfterRuleAdded());
    }

    @Test
    public void testRemovePackageEvents() throws Exception {
        ArrayList<InternalKnowledgePackage> pkgs = new ArrayList<InternalKnowledgePackage>();
        pkgs.add(this.pkg);
        this.kbase.addKnowledgePackages(pkgs);
        Assert.assertEquals((long)0L, (long)this.listener1.getBeforeKnowledgePackageRemoved());
        Assert.assertEquals((long)0L, (long)this.listener1.getAfterKnowledgePackageRemoved());
        Assert.assertEquals((long)0L, (long)this.listener2.getBeforeKnowledgePackageRemoved());
        Assert.assertEquals((long)0L, (long)this.listener2.getAfterKnowledgePackageRemoved());
        Assert.assertEquals((long)0L, (long)this.listener1.getBeforeRuleRemoved());
        Assert.assertEquals((long)0L, (long)this.listener1.getAfterRuleRemoved());
        Assert.assertEquals((long)0L, (long)this.listener2.getBeforeRuleRemoved());
        Assert.assertEquals((long)0L, (long)this.listener2.getAfterRuleRemoved());
        this.kbase.removeKnowledgePackage("org.drools.test1");
        Assert.assertEquals((long)1L, (long)this.listener1.getBeforeKnowledgePackageRemoved());
        Assert.assertEquals((long)1L, (long)this.listener1.getAfterKnowledgePackageRemoved());
        Assert.assertEquals((long)1L, (long)this.listener2.getBeforeKnowledgePackageRemoved());
        Assert.assertEquals((long)1L, (long)this.listener2.getAfterKnowledgePackageRemoved());
        Assert.assertEquals((long)2L, (long)this.listener1.getBeforeRuleRemoved());
        Assert.assertEquals((long)2L, (long)this.listener1.getAfterRuleRemoved());
        Assert.assertEquals((long)2L, (long)this.listener2.getBeforeRuleRemoved());
        Assert.assertEquals((long)2L, (long)this.listener2.getAfterRuleRemoved());
    }

    public static class TestRuleBaseListener
    implements KieBaseEventListener {
        private String id;
        private int beforePackageAdded = 0;
        private int afterPackageAdded = 0;
        private int beforePackageRemoved = 0;
        private int afterPackageRemoved = 0;
        private int beforeRuleAdded = 0;
        private int afterRuleAdded = 0;
        private int beforeRuleRemoved = 0;
        private int afterRuleRemoved = 0;

        public TestRuleBaseListener() {
        }

        public TestRuleBaseListener(String id) {
            this.id = id;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = (String)in.readObject();
            this.beforePackageAdded = in.readInt();
            this.afterPackageAdded = in.readInt();
            this.beforePackageRemoved = in.readInt();
            this.afterPackageRemoved = in.readInt();
            this.beforeRuleAdded = in.readInt();
            this.afterRuleAdded = in.readInt();
            this.beforeRuleRemoved = in.readInt();
            this.afterRuleRemoved = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.id);
            out.writeInt(this.beforePackageAdded);
            out.writeInt(this.afterPackageAdded);
            out.writeInt(this.beforePackageRemoved);
            out.writeInt(this.afterPackageRemoved);
            out.writeInt(this.beforeRuleAdded);
            out.writeInt(this.afterRuleAdded);
            out.writeInt(this.beforeRuleRemoved);
            out.writeInt(this.afterRuleRemoved);
        }

        public void afterKiePackageAdded(AfterKiePackageAddedEvent event) {
            ++this.afterPackageAdded;
        }

        public void beforeKiePackageAdded(BeforeKiePackageAddedEvent event) {
            ++this.beforePackageAdded;
        }

        protected int getAfterPackageAdded() {
            return this.afterPackageAdded;
        }

        protected int getBeforePackageAdded() {
            return this.beforePackageAdded;
        }

        protected String getId() {
            return this.id;
        }

        public void afterKiePackageRemoved(AfterKiePackageRemovedEvent event) {
            ++this.afterPackageRemoved;
        }

        public void beforeKiePackageRemoved(BeforeKiePackageRemovedEvent event) {
            ++this.beforePackageRemoved;
        }

        protected int getAfterKnowledgePackageRemoved() {
            return this.afterPackageRemoved;
        }

        protected int getBeforeKnowledgePackageRemoved() {
            return this.beforePackageRemoved;
        }

        public int getAfterRuleAdded() {
            return this.afterRuleAdded;
        }

        public int getBeforeRuleAdded() {
            return this.beforeRuleAdded;
        }

        public void afterRuleAdded(AfterRuleAddedEvent event) {
            ++this.afterRuleAdded;
        }

        public void beforeRuleAdded(BeforeRuleAddedEvent event) {
            ++this.beforeRuleAdded;
        }

        public int getAfterRuleRemoved() {
            return this.afterRuleRemoved;
        }

        public int getBeforeRuleRemoved() {
            return this.beforeRuleRemoved;
        }

        public void afterRuleRemoved(AfterRuleRemovedEvent event) {
            ++this.afterRuleRemoved;
        }

        public void beforeRuleRemoved(BeforeRuleRemovedEvent event) {
            ++this.beforeRuleRemoved;
        }

        public void afterFunctionRemoved(AfterFunctionRemovedEvent event) {
        }

        public void afterKieBaseLocked(AfterKieBaseLockedEvent event) {
        }

        public void afterKieBaseUnlocked(AfterKieBaseUnlockedEvent event) {
        }

        public void beforeFunctionRemoved(BeforeFunctionRemovedEvent event) {
        }

        public void beforeKieBaseLocked(BeforeKieBaseLockedEvent event) {
        }

        public void beforeKieBaseUnlocked(BeforeKieBaseUnlockedEvent event) {
        }

        public void afterProcessAdded(AfterProcessAddedEvent arg0) {
        }

        public void afterProcessRemoved(AfterProcessRemovedEvent arg0) {
        }

        public void beforeProcessAdded(BeforeProcessAddedEvent arg0) {
        }

        public void beforeProcessRemoved(BeforeProcessRemovedEvent arg0) {
        }
    }
}

