/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.facttemplates;

import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.facttemplates.Fact;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.facttemplates.FactTemplateFieldExtractor;
import org.drools.core.facttemplates.FactTemplateImpl;
import org.drools.core.facttemplates.FactTemplateObjectType;
import org.drools.core.facttemplates.FieldTemplate;
import org.drools.core.facttemplates.FieldTemplateImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.junit.Assert;
import org.junit.Test;

public class FactTemplateFieldExtractorTest {
    @Test
    public void testExtractor() {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields);
        FactTemplateFieldExtractor extractName = new FactTemplateFieldExtractor((FactTemplate)cheese, 0);
        FactTemplateFieldExtractor extractPrice = new FactTemplateFieldExtractor((FactTemplate)cheese, 1);
        Fact stilton = cheese.createFact(10L);
        stilton.setFieldValue("name", (Object)"stilton");
        stilton.setFieldValue("price", (Object)new Integer(200));
        Assert.assertEquals((Object)"stilton", (Object)extractName.getValue(null, (Object)stilton));
        Assert.assertEquals((Object)new Integer(200), (Object)extractPrice.getValue(null, (Object)stilton));
        Assert.assertFalse((boolean)extractName.isNullValue(null, (Object)stilton));
        stilton.setFieldValue("name", null);
        Assert.assertTrue((boolean)extractName.isNullValue(null, (Object)stilton));
        Assert.assertFalse((boolean)extractPrice.isNullValue(null, (Object)stilton));
        Fact brie = cheese.createFact(12L);
        brie.setFieldValue("name", (Object)"brie");
        brie.setFieldValue("price", (Object)new Integer(55));
        Assert.assertEquals((Object)"brie", (Object)extractName.getValue(null, (Object)brie));
        Assert.assertEquals((Object)new Integer(55), (Object)extractPrice.getValue(null, (Object)brie));
        Assert.assertFalse((boolean)extractName.isNullValue(null, (Object)brie));
        brie.setFieldValue("name", null);
        Assert.assertTrue((boolean)extractName.isNullValue(null, (Object)brie));
        Assert.assertFalse((boolean)extractPrice.isNullValue(null, (Object)stilton));
    }

    @Test
    public void testDeclaration() {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", 0, String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", 1, Integer.class);
        FieldTemplate[] fields = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese = new FactTemplateImpl((InternalKnowledgePackage)pkg, "Cheese", fields);
        FactTemplateFieldExtractor extractName = new FactTemplateFieldExtractor((FactTemplate)cheese, 0);
        Pattern pattern = new Pattern(0, (ObjectType)new FactTemplateObjectType((FactTemplate)cheese));
        Declaration declaration = new Declaration("typeOfCheese", (InternalReadAccessor)extractName, pattern);
        Fact brie = cheese.createFact(12L);
        brie.setFieldValue("name", (Object)"brie");
        brie.setFieldValue("price", (Object)new Integer(55));
        Assert.assertEquals((Object)"brie", (Object)declaration.getValue(null, (Object)brie));
    }
}

