/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.test;

import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import org.drools.core.reteoo.test.ReteDslTestEngine;
import org.drools.core.reteoo.test.dsl.NodeTestCase;
import org.drools.core.reteoo.test.dsl.NodeTestCaseResult;
import org.junit.Assert;
import org.junit.runner.notification.RunNotifier;

public class ReteDslTestEngineHelper {
    public static void executeDsl(String[] fileNames) {
        InputStream[] inputStreams = new InputStream[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            inputStreams[i] = ReteDslTestEngineHelper.class.getResourceAsStream(fileNames[i]);
            Assert.assertNotNull((String)fileNames[i], (Object)inputStreams[i]);
        }
        ReteDslTestEngineHelper.executeDsl(fileNames, inputStreams);
    }

    public static void executeDsl(String[] fileNames, InputStream[] inputStreams) {
        InputStream inputStream = inputStreams[0];
        for (int i = 1; i < inputStreams.length; ++i) {
            Assert.assertNotNull((Object)inputStreams[i]);
            inputStream = new SequenceInputStream(inputStream, inputStreams[i]);
        }
        ReteDslTestEngineHelper.executeDsl(Arrays.toString(fileNames), inputStream);
    }

    public static void executeDsl(String fileName) {
        ReteDslTestEngineHelper.executeDsl(fileName, ReteDslTestEngineHelper.class.getResourceAsStream(fileName));
    }

    public static void executeDsl(String fileName, InputStream inputStream) {
        Assert.assertNotNull((Object)inputStream);
        try {
            NodeTestCase testCase = ReteDslTestEngine.compile(inputStream);
            ReteDslTestEngine tester = new ReteDslTestEngine();
            NodeTestCaseResult result = tester.run(testCase, (RunNotifier)null);
            if (result.getTotalTests() - result.getSuccesses() > 0) {
                Assert.fail((String)("Error executing " + fileName + " : \n    " + result));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }
}

