/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.RBTree;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class RBTreeTest {
    @Test
    public void testFindNearestNode() {
        RBTree tree = new RBTree();
        tree.insert((Comparable)Integer.valueOf(10), (Object)"10");
        tree.insert((Comparable)Integer.valueOf(20), (Object)"20");
        tree.insert((Comparable)Integer.valueOf(25), (Object)"25");
        tree.insert((Comparable)Integer.valueOf(15), (Object)"15");
        tree.insert((Comparable)Integer.valueOf(5), (Object)"5");
        Assert.assertEquals((long)5L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)2), (boolean)false, (RBTree.Boundary)RBTree.Boundary.LOWER).key).intValue());
        Assert.assertEquals(null, (Object)tree.findNearestNode((Comparable)Integer.valueOf(2), false, RBTree.Boundary.UPPER));
        Assert.assertEquals((long)5L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)2), (boolean)true, (RBTree.Boundary)RBTree.Boundary.LOWER).key).intValue());
        Assert.assertEquals(null, (Object)tree.findNearestNode((Comparable)Integer.valueOf(2), true, RBTree.Boundary.UPPER));
        Assert.assertEquals((long)10L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)5), (boolean)false, (RBTree.Boundary)RBTree.Boundary.LOWER).key).intValue());
        Assert.assertEquals(null, (Object)tree.findNearestNode((Comparable)Integer.valueOf(5), false, RBTree.Boundary.UPPER));
        Assert.assertEquals((long)5L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)5), (boolean)true, (RBTree.Boundary)RBTree.Boundary.LOWER).key).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)5), (boolean)true, (RBTree.Boundary)RBTree.Boundary.UPPER).key).intValue());
        Assert.assertEquals((long)15L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)12), (boolean)false, (RBTree.Boundary)RBTree.Boundary.LOWER).key).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)12), (boolean)false, (RBTree.Boundary)RBTree.Boundary.UPPER).key).intValue());
        Assert.assertEquals((long)20L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)15), (boolean)false, (RBTree.Boundary)RBTree.Boundary.LOWER).key).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)15), (boolean)false, (RBTree.Boundary)RBTree.Boundary.UPPER).key).intValue());
        Assert.assertEquals((long)15L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)15), (boolean)true, (RBTree.Boundary)RBTree.Boundary.UPPER).key).intValue());
        Assert.assertEquals((long)15L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)15), (boolean)true, (RBTree.Boundary)RBTree.Boundary.LOWER).key).intValue());
        Assert.assertEquals((long)20L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)25), (boolean)false, (RBTree.Boundary)RBTree.Boundary.UPPER).key).intValue());
        Assert.assertEquals(null, (Object)tree.findNearestNode((Comparable)Integer.valueOf(25), false, RBTree.Boundary.LOWER));
        Assert.assertEquals((long)25L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)25), (boolean)true, (RBTree.Boundary)RBTree.Boundary.LOWER).key).intValue());
        Assert.assertEquals((long)25L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)25), (boolean)true, (RBTree.Boundary)RBTree.Boundary.UPPER).key).intValue());
        Assert.assertEquals((long)25L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)27), (boolean)false, (RBTree.Boundary)RBTree.Boundary.UPPER).key).intValue());
        Assert.assertEquals(null, (Object)tree.findNearestNode((Comparable)Integer.valueOf(27), false, RBTree.Boundary.LOWER));
        Assert.assertEquals((long)25L, (long)((Integer)tree.findNearestNode((Comparable)Integer.valueOf((int)27), (boolean)true, (RBTree.Boundary)RBTree.Boundary.UPPER).key).intValue());
        Assert.assertEquals(null, (Object)tree.findNearestNode((Comparable)Integer.valueOf(27), true, RBTree.Boundary.LOWER));
    }

    @Test
    public void testRange() {
        RBTree tree = new RBTree();
        tree.insert((Comparable)Integer.valueOf(10), (Object)"10");
        tree.insert((Comparable)Integer.valueOf(20), (Object)"20");
        tree.insert((Comparable)Integer.valueOf(25), (Object)"25");
        tree.insert((Comparable)Integer.valueOf(15), (Object)"15");
        tree.insert((Comparable)Integer.valueOf(5), (Object)"5");
        FastIterator fastIterator = tree.range((Comparable)Integer.valueOf(2), true, (Comparable)Integer.valueOf(15), false);
        RBTree.Node node = (RBTree.Node)fastIterator.next(null);
        Assert.assertEquals((long)5L, (long)((Integer)node.key).intValue());
        node = (RBTree.Node)fastIterator.next((Entry)node);
        Assert.assertEquals((long)10L, (long)((Integer)node.key).intValue());
        node = (RBTree.Node)fastIterator.next((Entry)node);
        Assert.assertNull((Object)node);
        fastIterator = tree.range((Comparable)Integer.valueOf(2), true, (Comparable)Integer.valueOf(5), false);
        node = (RBTree.Node)fastIterator.next(null);
        Assert.assertNull((Object)node);
        fastIterator = tree.range((Comparable)Integer.valueOf(5), false, (Comparable)Integer.valueOf(35), false);
        node = (RBTree.Node)fastIterator.next(null);
        Assert.assertEquals((long)10L, (long)((Integer)node.key).intValue());
        node = (RBTree.Node)fastIterator.next((Entry)node);
        Assert.assertEquals((long)15L, (long)((Integer)node.key).intValue());
        node = (RBTree.Node)fastIterator.next((Entry)node);
        Assert.assertEquals((long)20L, (long)((Integer)node.key).intValue());
        node = (RBTree.Node)fastIterator.next((Entry)node);
        Assert.assertEquals((long)25L, (long)((Integer)node.key).intValue());
        node = (RBTree.Node)fastIterator.next((Entry)node);
        Assert.assertNull((Object)node);
    }

    @Test
    public void testIterator() {
        int i;
        int ITEMS = 10000;
        RBTree tree = new RBTree();
        Random random = new Random(0L);
        for (i = 0; i < 10000; ++i) {
            int key = random.nextInt();
            tree.insert((Comparable)Integer.valueOf(key), (Object)("" + key));
        }
        i = 0;
        FastIterator fastIterator = tree.fastIterator();
        int lastKey = Integer.MIN_VALUE;
        RBTree.Node node = (RBTree.Node)fastIterator.next(null);
        while (node != null) {
            int currentKey = (Integer)node.key;
            if (currentKey < lastKey) {
                Assert.fail((String)(currentKey + " should be greater than " + lastKey));
            }
            lastKey = currentKey;
            ++i;
            node = (RBTree.Node)fastIterator.next((Entry)node);
        }
        Assert.assertEquals((long)10000L, (long)i);
    }

    @Test
    @Ignore
    public void testLargeData() {
        int range = 6000000;
        for (int i = 0; i < 10; ++i) {
            long startTime = System.currentTimeMillis();
            this.generateAndTest(90000, range - 90000, range, 1);
            long endTime = System.currentTimeMillis();
            System.out.println(endTime - startTime);
        }
    }

    @Test
    @Ignore
    public void testLargeData2() {
        int range = 6000000;
        for (int i = 0; i < 10; ++i) {
            long startTime = System.currentTimeMillis();
            this.generateAndTest2(90000, range - 90000, range, 1);
            long endTime = System.currentTimeMillis();
            System.out.println(endTime - startTime);
        }
    }

    public void generateAndTest(int start, int end, int range, int increment) {
        RBTree tree = new RBTree();
        for (int i = 0; i <= range; i += increment) {
            tree.insert((Comparable)Integer.valueOf(i), (Object)("" + i));
        }
        this.checkResults((RBTree<Integer, String>)tree, range, start, end, increment);
    }

    public void generateAndTest2(int start, int end, int range, int increment) {
        TreeMap<Integer, String> tree = new TreeMap<Integer, String>();
        for (int i = 0; i <= range; i += increment) {
            tree.put(i, "" + i);
        }
        this.checkResults2(tree, range, start, end, increment);
    }

    public void checkResults(RBTree<Integer, String> tree, int range, int start, int end, int increment) {
        FastIterator it = tree.range((Comparable)Integer.valueOf(start), true, (Comparable)Integer.valueOf(end), true);
        Entry entry = null;
        int i = 0;
        ArrayList actual = new ArrayList();
        while ((entry = it.next(entry)) != null) {
            RBTree.Node node = (RBTree.Node)entry;
        }
        for (i = 0; i < range; i += increment) {
            tree.delete((Comparable)Integer.valueOf(i));
        }
    }

    public void checkResults2(TreeMap<Integer, String> tree, int range, int start, int end, int increment) {
        SortedMap<Integer, String> map = tree.subMap(start, end);
        int i = 0;
        ArrayList actual = new ArrayList();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
        }
        for (i = 0; i < range; i += increment) {
            tree.remove(i);
        }
    }
}

