/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.IndexEvaluator;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ReadAccessor;
import org.drools.core.spi.Tuple;
import org.drools.core.util.Entry;
import org.drools.core.util.HashTableIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.index.TupleList;

public abstract class AbstractHashTable
implements Externalizable {
    static final int MAX_CAPACITY = 0x40000000;
    public static final int PRIME = 31;
    protected int size;
    protected int threshold;
    protected float loadFactor;
    protected ObjectComparator comparator;
    protected Entry<TupleList>[] table;
    private HashTableIterator iterator;

    public AbstractHashTable() {
        this(16, 0.75f);
    }

    public AbstractHashTable(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.comparator = EqualityEquals.getInstance();
    }

    public AbstractHashTable(Entry[] table) {
        this(0.75f, table);
    }

    public AbstractHashTable(float loadFactor, Entry[] table) {
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)table.length * loadFactor);
        this.table = table;
        this.comparator = EqualityEquals.getInstance();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.threshold = in.readInt();
        this.loadFactor = in.readFloat();
        this.comparator = (ObjectComparator)in.readObject();
        this.table = (Entry[])in.readObject();
        this.iterator = (HashTableIterator)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.threshold);
        out.writeFloat(this.loadFactor);
        out.writeObject(this.comparator);
        out.writeObject(this.table);
        out.writeObject(this.iterator);
    }

    public Iterator iterator() {
        if (this.iterator == null) {
            this.iterator = new HashTableIterator(this);
        } else {
            this.iterator.reset();
        }
        return this.iterator;
    }

    public Iterator newIterator() {
        return new HashTableIterator(this);
    }

    public void setComparator(ObjectComparator comparator) {
        this.comparator = comparator;
    }

    public void ensureCapacity(int itemsToBeAdded) {
        int newCapacity = this.size + itemsToBeAdded;
        if (newCapacity > this.threshold) {
            int newSize;
            for (newSize = this.table.length * 2; newSize < newCapacity; newSize *= 2) {
            }
            this.resize(newSize);
        }
    }

    protected void resize(int newCapacity) {
        Entry<TupleList>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        for (int i = 0; i < this.table.length; ++i) {
            TupleList entry = this.table[i];
            if (entry == null) continue;
            this.table[i] = null;
            while (entry != null) {
                TupleList next = entry.getNext();
                int index = AbstractHashTable.indexOf(this.getResizeHashcode(entry), newTable.length);
                entry.setNext((TupleList)newTable[index]);
                newTable[index] = entry;
                entry = next;
            }
        }
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    public abstract int getResizeHashcode(Entry var1);

    public Entry[] toArray() {
        Entry[] result = new Entry[this.size];
        int index = 0;
        for (int i = 0; i < this.table.length; ++i) {
            for (TupleList entry = this.table[i]; entry != null; entry = entry.getNext()) {
                result[index++] = entry;
            }
        }
        return result;
    }

    public Entry<TupleList>[] getTable() {
        return this.table;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public static int rehash(int hash) {
        hash ^= hash >>> 20 ^ hash >>> 12;
        return hash ^ hash >>> 7 ^ hash >>> 4;
    }

    protected static int indexOf(int hashCode, int dataSize) {
        return hashCode & dataSize - 1;
    }

    public String toString() {
        StringBuilder sbuilder = new StringBuilder();
        Iterator it = this.newIterator();
        boolean isFirst = true;
        Entry entry = (Entry)it.next();
        while (entry != null) {
            sbuilder.append(entry.toString());
            if (!isFirst) {
                sbuilder.append(", ");
            }
            isFirst = false;
            entry = (Entry)it.next();
        }
        return sbuilder.toString();
    }

    public void clear() {
        this.table = new Entry[Math.min(this.table.length, 16)];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
        this.size = 0;
        this.iterator = null;
    }

    public static class TripleIndexTupleList
    extends AbstractIndexTupleList {
        private Object indexKey0;
        private Object indexKey1;
        private Object indexKey2;

        public TripleIndexTupleList(TripleCompositeIndex index, Tuple tuple, int hashCode, boolean left) {
            super(index, hashCode);
            this.indexKey0 = index.index0.indexedValueOf(tuple, left);
            this.indexKey1 = index.index1.indexedValueOf(tuple, left);
            this.indexKey2 = index.index2.indexedValueOf(tuple, left);
        }

        @Override
        protected void copyStateInto(TupleList other) {
            super.copyStateInto(other);
            ((TripleIndexTupleList)other).indexKey0 = this.indexKey0;
            ((TripleIndexTupleList)other).indexKey1 = this.indexKey1;
            ((TripleIndexTupleList)other).indexKey2 = this.indexKey2;
        }
    }

    public static class TripleCompositeIndex
    implements Index {
        private static final long serialVersionUID = 510L;
        private FieldIndex index0;
        private FieldIndex index1;
        private FieldIndex index2;
        private int startResult;

        public TripleCompositeIndex() {
        }

        public TripleCompositeIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.index0 = indexes[0];
            this.index1 = indexes[1];
            this.index2 = indexes[2];
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index0 = (FieldIndex)in.readObject();
            this.index1 = (FieldIndex)in.readObject();
            this.index2 = (FieldIndex)in.readObject();
            this.startResult = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.index0);
            out.writeObject(this.index1);
            out.writeObject(this.index2);
            out.writeInt(this.startResult);
        }

        @Override
        public FieldIndex getFieldIndex(int index) {
            switch (index) {
                case 0: {
                    return this.index0;
                }
                case 1: {
                    return this.index1;
                }
                case 2: {
                    return this.index2;
                }
            }
            throw new IllegalArgumentException("IndexUtil position " + index + " does not exist");
        }

        @Override
        public int hashCodeOf(Tuple tuple, boolean left) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.index0.hashCodeOf(tuple, left);
            hashCode = 31 * hashCode + this.index1.hashCodeOf(tuple, left);
            hashCode = 31 * hashCode + this.index2.hashCodeOf(tuple, left);
            return AbstractHashTable.rehash(hashCode);
        }

        @Override
        public boolean areEqual(Object right, Tuple tuple) {
            return this.index0.evaluator.evaluate(null, this.index0.declaration.getExtractor(), tuple.getObject(this.index0.declaration), this.index0.extractor, right) && this.index1.evaluator.evaluate(null, this.index1.declaration.getExtractor(), tuple.getObject(this.index1.declaration), this.index1.extractor, right) && this.index2.evaluator.evaluate(null, this.index2.declaration.getExtractor(), tuple.getObject(this.index2.declaration), this.index2.extractor, right);
        }

        @Override
        public boolean areEqual(TupleList list, Tuple tuple2) {
            return this.index0.evaluator.evaluate(null, ((TripleIndexTupleList)list).indexKey0, this.index0.declaration.getExtractor(), tuple2.getObject(this.index0.declaration)) && this.index1.evaluator.evaluate(null, ((TripleIndexTupleList)list).indexKey1, this.index1.declaration.getExtractor(), tuple2.getObject(this.index1.declaration)) && this.index2.evaluator.evaluate(null, ((TripleIndexTupleList)list).indexKey2, this.index2.declaration.getExtractor(), tuple2.getObject(this.index2.declaration));
        }

        @Override
        public boolean areEqual(TupleList list, Object object2) {
            return this.index0.evaluator.evaluate(null, ((TripleIndexTupleList)list).indexKey0, this.index0.extractor, object2) && this.index1.evaluator.evaluate(null, ((TripleIndexTupleList)list).indexKey1, this.index1.extractor, object2) && this.index2.evaluator.evaluate(null, ((TripleIndexTupleList)list).indexKey2, this.index2.extractor, object2);
        }

        @Override
        public TupleList createEntry(Tuple tuple, int hashCode, boolean left) {
            return new TripleIndexTupleList(this, tuple, hashCode, left);
        }
    }

    public static class DoubleIndexTupleList
    extends AbstractIndexTupleList {
        private Object indexKey0;
        private Object indexKey1;

        public DoubleIndexTupleList(DoubleCompositeIndex index, Tuple tuple, int hashCode, boolean left) {
            super(index, hashCode);
            this.indexKey0 = index.index0.indexedValueOf(tuple, left);
            this.indexKey1 = index.index1.indexedValueOf(tuple, left);
        }

        @Override
        protected void copyStateInto(TupleList other) {
            super.copyStateInto(other);
            ((DoubleIndexTupleList)other).indexKey0 = this.indexKey0;
            ((DoubleIndexTupleList)other).indexKey1 = this.indexKey1;
        }
    }

    public static class DoubleCompositeIndex
    implements Index {
        private static final long serialVersionUID = 510L;
        private FieldIndex index0;
        private FieldIndex index1;
        private int startResult;

        public DoubleCompositeIndex() {
        }

        public DoubleCompositeIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.index0 = indexes[0];
            this.index1 = indexes[1];
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index0 = (FieldIndex)in.readObject();
            this.index1 = (FieldIndex)in.readObject();
            this.startResult = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.index0);
            out.writeObject(this.index1);
            out.writeInt(this.startResult);
        }

        @Override
        public FieldIndex getFieldIndex(int index) {
            switch (index) {
                case 0: {
                    return this.index0;
                }
                case 1: {
                    return this.index1;
                }
            }
            throw new IllegalArgumentException("IndexUtil position " + index + " does not exist");
        }

        @Override
        public int hashCodeOf(Tuple tuple, boolean left) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.index0.hashCodeOf(tuple, left);
            hashCode = 31 * hashCode + this.index1.hashCodeOf(tuple, left);
            return AbstractHashTable.rehash(hashCode);
        }

        @Override
        public boolean areEqual(Object right, Tuple tuple) {
            return this.index0.evaluator.evaluate(null, this.index0.declaration.getExtractor(), tuple.getObject(this.index0.declaration), this.index0.extractor, right) && this.index1.evaluator.evaluate(null, this.index1.declaration.getExtractor(), tuple.getObject(this.index1.declaration), this.index1.extractor, right);
        }

        @Override
        public boolean areEqual(TupleList list, Tuple tuple2) {
            return this.index0.evaluator.evaluate(null, ((DoubleIndexTupleList)list).indexKey0, this.index0.declaration.getExtractor(), tuple2.getObject(this.index0.declaration)) && this.index1.evaluator.evaluate(null, ((DoubleIndexTupleList)list).indexKey1, this.index1.declaration.getExtractor(), tuple2.getObject(this.index1.declaration));
        }

        @Override
        public boolean areEqual(TupleList list, Object object2) {
            return this.index0.evaluator.evaluate(null, ((DoubleIndexTupleList)list).indexKey0, this.index0.extractor, object2) && this.index1.evaluator.evaluate(null, ((DoubleIndexTupleList)list).indexKey1, this.index1.extractor, object2);
        }

        @Override
        public TupleList createEntry(Tuple tuple, int hashCode, boolean left) {
            return new DoubleIndexTupleList(this, tuple, hashCode, left);
        }
    }

    public static class SingleIndexTupleList
    extends AbstractIndexTupleList {
        private Object indexKey;

        public SingleIndexTupleList(SingleIndex index, Tuple tuple, int hashCode, boolean left) {
            super(index, hashCode);
            this.indexKey = index.index.indexedValueOf(tuple, left);
        }

        @Override
        protected void copyStateInto(TupleList other) {
            super.copyStateInto(other);
            ((SingleIndexTupleList)other).indexKey = this.indexKey;
        }
    }

    public static class AbstractIndexTupleList
    extends TupleList {
        private int hashCode;
        private Index index;

        public AbstractIndexTupleList(Index index, int hashCode) {
            this.index = index;
            this.hashCode = hashCode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AbstractIndexTupleList)) {
                return false;
            }
            AbstractIndexTupleList other = (AbstractIndexTupleList)object;
            return this.hashCode == other.hashCode && this.index == other.index;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        protected void copyStateInto(TupleList other) {
            super.copyStateInto(other);
            ((AbstractIndexTupleList)other).hashCode = this.hashCode;
            ((AbstractIndexTupleList)other).index = this.index;
        }
    }

    public static class SingleIndex
    implements Index {
        private static final long serialVersionUID = 510L;
        private FieldIndex index;
        private int startResult;

        public SingleIndex() {
        }

        public SingleIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.index = indexes[0];
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = (FieldIndex)in.readObject();
            this.startResult = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.index);
            out.writeInt(this.startResult);
        }

        @Override
        public FieldIndex getFieldIndex(int index) {
            if (index > 0) {
                throw new IllegalArgumentException("IndexUtil position " + index + " does not exist");
            }
            return this.index;
        }

        @Override
        public int hashCodeOf(Tuple tuple, boolean left) {
            return AbstractHashTable.rehash(31 * this.startResult + this.index.hashCodeOf(tuple, left));
        }

        @Override
        public boolean areEqual(Object right, Tuple tuple) {
            return this.index.evaluator.evaluate(null, this.index.declaration.getExtractor(), tuple.getObject(this.index.declaration), this.index.extractor, right);
        }

        @Override
        public boolean areEqual(TupleList list, Object object2) {
            return this.index.evaluator.evaluate(null, ((SingleIndexTupleList)list).indexKey, this.index.extractor, object2);
        }

        public boolean areEqual(Tuple tuple1, Tuple tuple2) {
            return this.index.evaluator.evaluate(null, this.index.declaration.getExtractor(), tuple1.getObject(this.index.declaration), this.index.declaration.getExtractor(), tuple2.getObject(this.index.declaration));
        }

        @Override
        public boolean areEqual(TupleList list, Tuple tuple2) {
            return this.index.evaluator.evaluate(null, ((SingleIndexTupleList)list).indexKey, this.index.declaration.getExtractor(), tuple2.getObject(this.index.declaration));
        }

        @Override
        public TupleList createEntry(Tuple tuple, int hashCode, boolean left) {
            return new SingleIndexTupleList(this, tuple, hashCode, left);
        }
    }

    public static interface Index
    extends Externalizable {
        public FieldIndex getFieldIndex(int var1);

        public int hashCodeOf(Tuple var1, boolean var2);

        public boolean areEqual(Object var1, Tuple var2);

        public boolean areEqual(TupleList var1, Tuple var2);

        public boolean areEqual(TupleList var1, Object var2);

        public TupleList createEntry(Tuple var1, int var2, boolean var3);
    }

    public static class FieldIndex
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        private InternalReadAccessor extractor;
        private Declaration declaration;
        private IndexEvaluator evaluator;
        private boolean requiresCoercion;

        public FieldIndex() {
        }

        public FieldIndex(InternalReadAccessor extractor, Declaration declaration, IndexEvaluator evaluator) {
            this.extractor = extractor;
            this.declaration = declaration;
            this.evaluator = evaluator;
            this.requiresCoercion = this.isCoercionRequired(extractor, declaration);
        }

        private boolean isCoercionRequired(InternalReadAccessor extractor, Declaration declaration) {
            return extractor.getValueType() != declaration.getExtractor().getValueType();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.extractor = (InternalReadAccessor)in.readObject();
            this.declaration = (Declaration)in.readObject();
            this.evaluator = (IndexEvaluator)in.readObject();
            this.requiresCoercion = this.isCoercionRequired(this.extractor, this.declaration);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.extractor);
            out.writeObject(this.declaration);
            out.writeObject(this.evaluator);
        }

        public Declaration getDeclaration() {
            return this.declaration;
        }

        public ReadAccessor getExtractor() {
            return this.extractor;
        }

        public IndexEvaluator getEvaluator() {
            return this.evaluator;
        }

        public int hashCodeOf(Tuple tuple, boolean left) {
            return left ? (this.requiresCoercion ? Objects.hashCode(this.extractor.getValueType().coerce(this.declaration.getExtractor().getValue(tuple.getObject(this.declaration)))) : this.declaration.getHashCode(null, tuple.getObject(this.declaration))) : this.extractor.getHashCode(null, tuple.getFactHandle().getObject());
        }

        public Object indexedValueOf(Tuple tuple, boolean left) {
            return left ? (this.requiresCoercion ? this.extractor.getValueType().coerce(this.declaration.getExtractor().getValue(tuple.getObject(this.declaration))) : this.declaration.getValue(null, tuple.getObject(this.declaration))) : this.extractor.getValue(null, tuple.getFactHandle().getObject());
        }
    }

    public static class EqualityEquals
    extends AbstractObjectComparator {
        private static final long serialVersionUID = 510L;
        public static final ObjectComparator INSTANCE = new EqualityEquals();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public static ObjectComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public int hashCodeOf(Object key) {
            return AbstractHashTable.rehash(key.hashCode());
        }

        @Override
        public boolean areEqual(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return object1.equals(object2);
        }
    }

    public static class InstanceEquals
    extends AbstractObjectComparator {
        private static final long serialVersionUID = 510L;
        public static final ObjectComparator INSTANCE = new InstanceEquals();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public static ObjectComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public int hashCodeOf(Object obj) {
            return AbstractHashTable.rehash(System.identityHashCode(obj));
        }

        @Override
        public boolean areEqual(Object object1, Object object2) {
            return object1 == object2;
        }
    }

    public static abstract class AbstractObjectComparator
    implements ObjectComparator {
    }

    public static interface ObjectComparator
    extends Externalizable {
        public int hashCodeOf(Object var1);

        public boolean areEqual(Object var1, Object var2);
    }
}

