/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.InitialFact;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.TupleStartEqualsConstraint;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.BuildUtils;
import org.drools.core.reteoo.builder.NodeFactory;
import org.drools.core.reteoo.builder.ReteooComponentBuilder;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.kie.api.definition.rule.Propagation;

public class GroupElementBuilder
implements ReteooComponentBuilder {
    protected final Map<GroupElement.Type, ReteooComponentBuilder> geBuilders = new HashMap<GroupElement.Type, ReteooComponentBuilder>();

    public GroupElementBuilder() {
        this.geBuilders.put(GroupElement.AND, new AndBuilder());
        this.geBuilders.put(GroupElement.OR, new OrBuilder());
        this.geBuilders.put(GroupElement.NOT, new NotBuilder());
        this.geBuilders.put(GroupElement.EXISTS, new ExistsBuilder());
    }

    @Override
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        GroupElement ge = (GroupElement)rce;
        ReteooComponentBuilder builder = this.geBuilders.get((Object)ge.getType());
        context.push(ge);
        context.pushRuleComponent(ge);
        builder.build(context, utils, rce);
        context.pop();
        context.popRuleComponent();
    }

    @Override
    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        GroupElement ge = (GroupElement)rce;
        ReteooComponentBuilder builder = this.geBuilders.get((Object)ge.getType());
        return builder.requiresLeftActivation(utils, rce);
    }

    public static class ExistsBuilder
    implements ReteooComponentBuilder {
        @Override
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            boolean existSubNetwort = false;
            GroupElement exists = (GroupElement)rce;
            int currentPatternIndex = context.getCurrentPatternOffset();
            LeftTupleSource tupleSource = context.getTupleSource();
            RuleConditionElement child = exists.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            builder.build(context, utils, child);
            if (context.getObjectSource() == null && context.getTupleSource() != null) {
                RightInputAdapterNode riaNode = context.getComponentFactory().getNodeFactoryService().buildRightInputNode(context.getNextId(), context.getTupleSource(), tupleSource, context);
                context.setObjectSource(utils.attachNode(context, riaNode));
                context.setTupleSource(tupleSource);
                TupleStartEqualsConstraint constraint = TupleStartEqualsConstraint.getInstance();
                ArrayList<BetaNodeFieldConstraint> predicates = new ArrayList<BetaNodeFieldConstraint>();
                predicates.add(constraint);
                context.setBetaconstraints(predicates);
                existSubNetwort = true;
            }
            NodeFactory nfactory = context.getComponentFactory().getNodeFactoryService();
            BetaConstraints betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
            ExistsNode node = context.getComponentFactory().getNodeFactoryService().buildExistsNode(context.getNextId(), context.getTupleSource(), context.getObjectSource(), betaConstraints, context);
            context.setTupleSource(utils.attachNode(context, node));
            context.setBetaconstraints(null);
            context.setObjectSource(null);
            context.setCurrentPatternOffset(currentPatternIndex);
        }

        @Override
        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            return true;
        }
    }

    public static class NotBuilder
    implements ReteooComponentBuilder {
        @Override
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            boolean existSubNetwort = false;
            GroupElement not = (GroupElement)rce;
            int currentPatternIndex = context.getCurrentPatternOffset();
            LeftTupleSource tupleSource = context.getTupleSource();
            RuleConditionElement child = not.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            builder.build(context, utils, child);
            if (context.getObjectSource() == null && context.getTupleSource() != null) {
                RightInputAdapterNode riaNode = context.getComponentFactory().getNodeFactoryService().buildRightInputNode(context.getNextId(), context.getTupleSource(), tupleSource, context);
                context.setObjectSource(utils.attachNode(context, riaNode));
                context.setTupleSource(tupleSource);
                TupleStartEqualsConstraint constraint = TupleStartEqualsConstraint.getInstance();
                ArrayList<BetaNodeFieldConstraint> predicates = new ArrayList<BetaNodeFieldConstraint>();
                predicates.add(constraint);
                context.setBetaconstraints(predicates);
                existSubNetwort = true;
            }
            NodeFactory nfactory = context.getComponentFactory().getNodeFactoryService();
            BetaConstraints betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
            NotNode node = context.getComponentFactory().getNodeFactoryService().buildNotNode(context.getNextId(), context.getTupleSource(), context.getObjectSource(), betaConstraints, context);
            node.setEmptyBetaConstraints(context.getBetaconstraints().isEmpty());
            context.setTupleSource(utils.attachNode(context, node));
            context.setBetaconstraints(null);
            context.setObjectSource(null);
            context.setCurrentPatternOffset(currentPatternIndex);
        }

        @Override
        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            return true;
        }
    }

    public static class OrBuilder
    implements ReteooComponentBuilder {
        @Override
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            throw new RuntimeException("BUG: Can't build a rete network with an inner OR group element");
        }

        @Override
        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            throw new RuntimeException("BUG: Can't build a rete network with an inner OR group element");
        }
    }

    public static class AndBuilder
    implements ReteooComponentBuilder {
        @Override
        public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
            GroupElement ge = (GroupElement)rce;
            if (ge.getChildren().size() == 1) {
                RuleConditionElement child = ge.getChildren().get(0);
                ReteooComponentBuilder builder = utils.getBuilderFor(child);
                builder.build(context, utils, child);
                AndBuilder.buildTupleSource(context, utils, this.isTerminalAlpha(context, child));
            } else {
                for (RuleConditionElement child : ge.getChildren()) {
                    ReteooComponentBuilder builder = utils.getBuilderFor(child);
                    builder.build(context, utils, child);
                    AndBuilder.buildTupleSource(context, utils, false);
                    AndBuilder.buildJoinNode(context, utils);
                }
            }
        }

        private boolean isTerminalAlpha(BuildContext context, RuleConditionElement child) {
            Class<?> patternClass = ((Pattern)child).getObjectType().getClassType();
            boolean isInitialFact = patternClass != null && InitialFact.class.isAssignableFrom(patternClass);
            boolean hasTimer = context.getRule().getTimer() != null;
            RuleBaseConfiguration conf = context.getKnowledgeBase().getConfiguration();
            boolean lockOnActive = context.getRule().isLockOnActive();
            boolean eager = context.getRule().getMetaData(Propagation.class.getName()) != null;
            return !isInitialFact && !hasTimer && !lockOnActive && !eager && !conf.isMultithreadEvaluation() && !conf.isSequential() && !conf.isDeclarativeAgenda();
        }

        public static void buildTupleSource(BuildContext context, BuildUtils utils, boolean terminal) {
            if (context.getObjectSource() != null && context.getTupleSource() == null) {
                ObjectSource source = context.getObjectSource();
                while (source.getType() != 30) {
                    source = source.getParentObjectSource();
                }
                context.setRootObjectTypeNode((ObjectTypeNode)source);
                context.setTupleSource(utils.attachNode(context, context.getComponentFactory().getNodeFactoryService().buildLeftInputAdapterNode(context.getNextId(), context.getObjectSource(), context, terminal)));
                context.setObjectSource(null);
            }
        }

        public static void buildJoinNode(BuildContext context, BuildUtils utils) {
            if (context.getObjectSource() != null && context.getTupleSource() != null) {
                BetaConstraints betaConstraints = utils.createBetaNodeConstraint(context, context.getBetaconstraints(), false);
                context.setTupleSource(utils.attachNode(context, context.getComponentFactory().getNodeFactoryService().buildJoinNode(context.getNextId(), context.getTupleSource(), context.getObjectSource(), betaConstraints, context)));
                context.setBetaconstraints(null);
                context.setObjectSource(null);
            }
        }

        @Override
        public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
            GroupElement and = (GroupElement)rce;
            if (and.getChildren().isEmpty()) {
                return true;
            }
            RuleConditionElement child = and.getChildren().get(0);
            ReteooComponentBuilder builder = utils.getBuilderFor(child);
            return builder.requiresLeftActivation(utils, child);
        }
    }
}

