/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event;

import java.util.Collections;
import java.util.List;
import org.drools.core.event.ProcessEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.ProcessInstance;

public class ProcessVariableChangedEventImpl
extends ProcessEvent
implements ProcessVariableChangedEvent {
    private static final long serialVersionUID = 510L;
    private String id;
    private String instanceId;
    private Object oldValue;
    private Object newValue;
    private List<String> tags;

    public ProcessVariableChangedEventImpl(String id, String instanceId, Object oldValue, Object newValue, List<String> tags, ProcessInstance processInstance, KieRuntime kruntime) {
        super(processInstance, kruntime);
        this.id = id;
        this.instanceId = instanceId;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.tags = tags == null ? Collections.emptyList() : tags;
    }

    public String getVariableInstanceId() {
        return this.instanceId;
    }

    public String getVariableId() {
        return this.id;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public String toString() {
        return "==>[ProcessVariableChanged(id=" + this.id + "; instanceId=" + this.instanceId + "; oldValue=" + this.oldValue + "; newValue=" + this.newValue + "; processName=" + this.getProcessInstance().getProcessName() + "; processId=" + this.getProcessInstance().getProcessId() + ")]";
    }
}

