/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.TupleSets;
import org.drools.core.impl.RuleBase;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.phreak.PhreakBuilder;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.phreak.TupleEvaluationUtil;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AlphaTerminalNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.util.FastIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EagerPhreakBuilder
implements PhreakBuilder {
    private static final Logger log = LoggerFactory.getLogger(EagerPhreakBuilder.class);

    EagerPhreakBuilder() {
    }

    @Override
    public void addRule(TerminalNode tn, Collection<InternalWorkingMemory> wms, RuleBase kBase) {
        if (log.isTraceEnabled()) {
            log.trace("Adding Rule {}", (Object)tn.getRule().getName());
        }
        HashSet<LeftTupleNode> splitNodes = new HashSet<LeftTupleNode>();
        Arrays.stream(tn.getPathEndNodes()).forEach(n -> EagerPhreakBuilder.addNetworkSplitPoint(n, splitNodes));
        PathEndNodes pathEndNodes = EagerPhreakBuilder.getPathEndNodes(tn, splitNodes);
        pathEndNodes.nodesToInvalidate.forEach(kBase::invalidateSegmentPrototype);
        tn.resetPathMemSpec(null);
        BuildtimeSegmentUtilities.createPathProtoMemories(tn, null, kBase);
        EagerPhreakBuilder.resetPaths(null, kBase, pathEndNodes);
        for (InternalWorkingMemory wm : wms) {
            wm.flushPropagations();
            PathEndNodeMemories tnms = EagerPhreakBuilder.getPathEndMemories(wm, pathEndNodes);
            if (tn.getPathNodes()[0].getAssociatedTerminalsSize() == 1) {
                EagerPhreakBuilder.insertLiaFacts(tn.getPathNodes()[0], wm);
            } else if (tnms.subjectPmem != null) {
                Map<PathMemory, SegmentMemory[]> prevSmemsLookup = EagerPhreakBuilder.reInitPathMemories(tnms.otherPmems);
                EagerPhreakBuilder.handleExistingPaths(tn, prevSmemsLookup, tnms.otherPmems, wm, ExistingPathStrategy.ADD_STRATEGY);
                EagerPhreakBuilder.addNewPaths(wm, tnms.subjectPmems);
                pathEndNodes.subjectSplits.forEach(n -> EagerPhreakBuilder.processLeftTuples(n, wm, true, tn));
            }
            EagerPhreakBuilder.addExistingSegmentMemories(pathEndNodes, wm);
            EagerPhreakBuilder.insertFacts(pathEndNodes, wm);
            EagerPhreakBuilder.notifySegments(tnms, wm);
        }
    }

    private static void addExistingSegmentMemories(PathEndNodes pathEndNodes, InternalWorkingMemory wm) {
        pathEndNodes.subjectEndNodes.forEach(endNode -> Arrays.stream(endNode.getSegmentPrototypes()).forEach(proto -> {
            if (proto == null) {
                return;
            }
            LeftTupleNode node = proto.getRootNode();
            Memory mem = wm.getNodeMemories().peekNodeMemory(node);
            if (mem != null && mem.getSegmentMemory() != null) {
                SegmentMemory smem = mem.getSegmentMemory();
                PathMemory pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory((NetworkNode)endNode);
                if (pmem == null) {
                    pmem = RuntimeSegmentUtilities.initializePathMemory(wm, endNode);
                }
                if (pmem.getSegmentMemories()[proto.getPos()] == null) {
                    pmem.setSegmentMemory(smem.getPos(), smem);
                    smem.addPathMemory(pmem);
                }
            }
        }));
    }

    @Override
    public void removeRule(TerminalNode tn, Collection<InternalWorkingMemory> wms, RuleBase kBase) {
        PathEndNodeMemories tnms;
        if (log.isTraceEnabled()) {
            log.trace("Removing Rule {}", (Object)tn.getRule().getName());
        }
        HashSet<LeftTupleNode> splitNodes = new HashSet<LeftTupleNode>();
        Arrays.stream(tn.getPathEndNodes()).forEach(n -> EagerPhreakBuilder.addNetworkSplitPoint(n, splitNodes));
        PathEndNodes pathEndNodes = EagerPhreakBuilder.getPathEndNodes(tn, splitNodes);
        PathEndNodeMemories[] tnmsList = new PathEndNodeMemories[wms.size()];
        int i = 0;
        for (InternalWorkingMemory wm : wms) {
            wm.flushPropagations();
            tnms = EagerPhreakBuilder.getPathEndMemories(wm, pathEndNodes);
            tnmsList[i++] = tnms;
            if (tnms.subjectPmems.isEmpty()) continue;
            if (tn.getPathNodes()[0].getAssociatedTerminalsSize() == 1 && tnms.subjectPmem != null) {
                pathEndNodes.subjectSplits.forEach(n -> EagerPhreakBuilder.flushStagedTuples(n, tnms.subjectPmem, wm));
            } else {
                EagerPhreakBuilder.flushStagedTuples(tn, tnms.subjectPmem, pathEndNodes, wm);
            }
            pathEndNodes.subjectSplits.forEach(n -> EagerPhreakBuilder.processLeftTuples(n, wm, false, tn));
        }
        pathEndNodes.nodesToInvalidate.forEach(kBase::invalidateSegmentPrototype);
        EagerPhreakBuilder.resetPaths(tn, kBase, pathEndNodes);
        i = 0;
        for (InternalWorkingMemory wm : wms) {
            tnms = tnmsList[i++];
            if (!tnms.subjectPmems.isEmpty()) {
                EagerPhreakBuilder.removeNewPaths(wm, tnms.subjectPmems);
                if (tn.getPathNodes()[0].getAssociatedTerminalsSize() > 1) {
                    Map<PathMemory, SegmentMemory[]> prevSmemsLookup = EagerPhreakBuilder.reInitPathMemories(tnms.otherPmems);
                    EagerPhreakBuilder.handleExistingPaths(tn, prevSmemsLookup, tnms.otherPmems, wm, ExistingPathStrategy.REMOVE_STRATEGY);
                    EagerPhreakBuilder.notifySegments(tnms, wm);
                }
            }
            if (tnms.subjectPmem == null || !tnms.subjectPmem.isInitialized() || !tnms.subjectPmem.getRuleAgendaItem().isQueued()) continue;
            tnms.subjectPmem.getRuleAgendaItem().dequeue();
        }
    }

    private static void resetPaths(TerminalNode tn, RuleBase kBase, PathEndNodes pathEndNodes) {
        pathEndNodes.otherTermNodes.forEach(other -> other.resetPathMemSpec(tn));
        pathEndNodes.otherTermNodes.forEach(other -> BuildtimeSegmentUtilities.createPathProtoMemories(other, tn, kBase));
    }

    static void adjustSegment(InternalWorkingMemory wm, SegmentMemory smem) {
        smem.unlinkSegment(wm);
        SegmentMemory.SegmentPrototype proto = wm.getKnowledgeBase().getSegmentPrototype(smem.getRootNode());
        long currentLinkedNodeMask = smem.getLinkedNodeMask();
        proto.updateSegmentMemory(smem, wm);
        smem.setLinkedNodeMask(currentLinkedNodeMask);
    }

    private static void handleExistingPaths(TerminalNode tn, Map<PathMemory, SegmentMemory[]> prevSmemsLookup, List<PathMemory> pmems, InternalWorkingMemory wm, ExistingPathStrategy strategy) {
        HashSet<SegmentMemory> visitedSegments = new HashSet<SegmentMemory>();
        HashSet<Integer> visitedNodes = new HashSet<Integer>();
        HashMap<LeftTupleNode, SegmentMemory> nodeToSegmentMap = new HashMap<LeftTupleNode, SegmentMemory>();
        for (PathMemory pmem : pmems) {
            LeftTupleNode node;
            LeftTupleNode[] nodes = pmem.getPathEndNode().getPathNodes();
            SegmentMemory[] prevSmems = prevSmemsLookup.get(pmem);
            SegmentMemory[] smems = strategy.getSegmenMemories(pmem);
            if (prevSmems.length == 0 && smems.length == 0) continue;
            int prevSmemIndex = 0;
            int smemIndex = 0;
            int nodeIndex = 0;
            boolean firstSplit = true;
            smems[smemIndex] = prevSmems[prevSmemIndex];
            do {
                LeftTupleSource parentNode;
                if (!EagerPhreakBuilder.isSplit(parentNode = (node = nodes[nodeIndex++]).getLeftTupleSource())) continue;
                smemIndex = strategy.incSmemIndex1(smemIndex);
                prevSmemIndex = strategy.incPrevSmemIndex1(prevSmemIndex);
                if (EagerPhreakBuilder.isSplit(parentNode, tn)) {
                    smemIndex = strategy.incSmemIndex2(smemIndex);
                    prevSmemIndex = strategy.incPrevSmemIndex2(prevSmemIndex);
                    smems[smemIndex] = prevSmems[prevSmemIndex];
                    if (smems[smemIndex] == null || firstSplit || !visitedSegments.add(smems[smemIndex])) continue;
                    EagerPhreakBuilder.adjustSegment(wm, smems[smemIndex]);
                    continue;
                }
                strategy.handleSplit(pmem, prevSmems, smems, smemIndex, prevSmemIndex, parentNode, node, tn, visitedNodes, nodeToSegmentMap, wm);
                firstSplit = false;
            } while (!NodeTypeEnums.isEndNode(node));
            strategy.processSegmentMemories(smems, pmem);
        }
    }

    private static void addNewPaths(InternalWorkingMemory wm, List<PathMemory> pmems) {
        block0: for (PathMemory pmem : pmems) {
            PathEndNode tipNode;
            LeftTupleNode child = tipNode = pmem.getPathEndNode();
            LeftTupleSource parent = tipNode.getLeftTupleSource();
            while (true) {
                SegmentMemory sm;
                Memory mem;
                if (parent != null && parent.getAssociatedTerminalsSize() != 1 && child.getAssociatedTerminalsSize() == 1) {
                    mem = wm.getNodeMemories().peekNodeMemory(parent);
                    if (mem != null && mem.getSegmentMemory() != null) {
                        sm = mem.getSegmentMemory();
                        if (sm.getFirst() != null && sm.size() < parent.getSinkPropagator().size()) {
                            LeftTupleSink[] sinks = parent.getSinkPropagator().getSinks();
                            for (int i = sm.size(); i < sinks.length; ++i) {
                                SegmentMemory childSmem = RuntimeSegmentUtilities.createChildSegment(wm, sinks[i]);
                                sm.add(childSmem);
                            }
                        }
                        EagerPhreakBuilder.correctMemoryOnSplitsChanged(parent, null, wm);
                    }
                } else {
                    mem = wm.getNodeMemories().peekNodeMemory(child);
                    if (mem != null && (sm = mem.getSegmentMemory()) != null && pmem.getPathEndNode().getSegmentPrototypes()[sm.getPos()] != null && !sm.getPathMemories().contains(pmem)) {
                        sm.addPathMemory(pmem);
                        pmem.setSegmentMemory(sm.getPos(), sm);
                    }
                }
                if (parent == null) continue block0;
                child = parent;
                parent = parent.getLeftTupleSource();
            }
        }
    }

    private static void removeNewPaths(InternalWorkingMemory wm, List<PathMemory> pmems) {
        HashSet<Integer> visitedNodes = new HashSet<Integer>();
        block0: for (PathMemory pmem : pmems) {
            PathEndNode tipNode;
            LeftTupleNode child = tipNode = pmem.getPathEndNode();
            LeftTupleSource parent = tipNode.getLeftTupleSource();
            while (true) {
                SegmentMemory sm;
                Memory mem;
                if (child.getAssociatedTerminalsSize() == 1 && NodeTypeEnums.isBetaNode(child)) {
                    EagerPhreakBuilder.deleteRightInputData(child, wm);
                }
                if (parent != null && parent.getAssociatedTerminalsSize() != 1 && child.getAssociatedTerminalsSize() == 1) {
                    if (!visitedNodes.contains(child.getId()) && (mem = wm.getNodeMemories().peekNodeMemory(parent)) != null && mem.getSegmentMemory() != null && (sm = mem.getSegmentMemory()).getFirst() != null) {
                        SegmentMemory childSm = wm.getNodeMemories().peekNodeMemory(child).getSegmentMemory();
                        sm.remove(childSm);
                    }
                } else {
                    mem = wm.getNodeMemories().peekNodeMemory(child);
                    if (mem != null && (sm = mem.getSegmentMemory()) != null && sm.getPathMemories().contains(pmem)) {
                        mem.getSegmentMemory().removePathMemory(pmem);
                    }
                }
                if (parent == null) continue block0;
                visitedNodes.add(child.getId());
                child = parent;
                parent = parent.getLeftTupleSource();
            }
        }
    }

    private static boolean isSplit(LeftTupleNode node) {
        return EagerPhreakBuilder.isSplit(node, null);
    }

    private static boolean isSplit(LeftTupleNode node, TerminalNode removingTN) {
        return node != null && BuildtimeSegmentUtilities.isTipNode(node, removingTN);
    }

    private static void flushStagedTuples(TerminalNode tn, PathMemory pmem, PathEndNodes pathEndNodes, InternalWorkingMemory wm) {
        if (pmem.isInitialized()) {
            RuleNetworkEvaluator.INSTANCE.evaluateNetwork(pmem, pmem.getRuleAgendaItem().getRuleExecutor(), wm);
        }
        ArrayList<Flushed> flushed = new ArrayList<Flushed>();
        for (LeftTupleNode node : pathEndNodes.subjectSplits) {
            SegmentMemory smem;
            Memory mem;
            if (EagerPhreakBuilder.isSplit(node, tn) || (mem = wm.getNodeMemories().peekNodeMemory(node)) == null || (smem = mem.getSegmentMemory()).isEmpty()) continue;
            for (SegmentMemory childSmem = (SegmentMemory)smem.getFirst(); childSmem != null; childSmem = childSmem.getNext()) {
                if (childSmem.getStagedLeftTuples().isEmpty()) continue;
                PathMemory childPmem = childSmem.getPathMemories().get(0);
                flushed.add(new Flushed(childSmem, childPmem));
                TupleEvaluationUtil.forceFlushLeftTuple(childPmem, childSmem, wm, childSmem.getStagedLeftTuples().takeAll());
            }
        }
        int flushCount = 1;
        while (!flushed.isEmpty() && flushCount != 0) {
            flushCount = 0;
            for (Flushed path : flushed) {
                if (path.segmentMemory.getStagedLeftTuples().isEmpty()) continue;
                ++flushCount;
                TupleEvaluationUtil.forceFlushLeftTuple(pmem, path.segmentMemory, wm, path.segmentMemory.getStagedLeftTuples().takeAll());
            }
        }
    }

    private static void flushStagedTuples(LeftTupleNode splitStartNode, PathMemory pmem, InternalWorkingMemory wm) {
        if (!pmem.isInitialized()) {
            return;
        }
        if (pmem.getSegmentMemories().length == 0) {
            return;
        }
        int smemIndex = EagerPhreakBuilder.getSegmentPos(splitStartNode);
        SegmentMemory[] smems = pmem.getSegmentMemories();
        SegmentMemory sm = null;
        int length = smems.length;
        if (splitStartNode.getAssociatedTerminalsSize() == 1) {
            length = 1;
        }
        while (smemIndex < length && ((sm = smems[smemIndex]) == null || sm.getStagedLeftTuples().isEmpty())) {
            ++smemIndex;
        }
        if (smemIndex < length) {
            TupleEvaluationUtil.forceFlushLeftTuple(pmem, sm, wm, sm.getStagedLeftTuples().takeAll());
        }
    }

    private static Map<PathMemory, SegmentMemory[]> reInitPathMemories(List<PathMemory> pathMems) {
        HashMap<PathMemory, SegmentMemory[]> previousSmems = new HashMap<PathMemory, SegmentMemory[]>();
        for (PathMemory pmem : pathMems) {
            previousSmems.put(pmem, pmem.getSegmentMemories());
            PathEndNode pathEndNode = pmem.getPathEndNode();
            AbstractTerminalNode.initPathMemory(pathEndNode, pmem);
        }
        return previousSmems;
    }

    private static void notifySegments(PathEndNodeMemories tnms, InternalWorkingMemory wm) {
        tnms.otherPmems.stream().flatMap(pmem -> Arrays.stream(pmem.getSegmentMemories())).filter(Objects::nonNull).forEach(sm -> sm.notifyRuleLinkSegment(wm));
        tnms.subjectPmems.stream().flatMap(pmem -> Arrays.stream(pmem.getSegmentMemories())).filter(Objects::nonNull).forEach(sm -> sm.notifyRuleLinkSegment(wm));
    }

    private static void correctMemoryOnSplitsChanged(LeftTupleNode splitStart, TerminalNode removingTN, InternalWorkingMemory wm) {
        QueryElementNode.QueryElementNodeMemory mem;
        if (splitStart.getType() == 165 && (mem = (QueryElementNode.QueryElementNodeMemory)wm.getNodeMemories().peekNodeMemory(splitStart)) != null) {
            mem.correctMemoryOnSinksChanged(removingTN);
        }
    }

    private static int getSegmentPos(LeftTupleNode lts) {
        int counter = 0;
        while (lts.getType() != 120) {
            if (!BuildtimeSegmentUtilities.isTipNode(lts = lts.getLeftTupleSource(), null)) continue;
            ++counter;
        }
        return counter;
    }

    private static void insertLiaFacts(LeftTupleNode startNode, InternalWorkingMemory wm) {
        PropagationContextFactory pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
        PropagationContext pctx = pctxFactory.createPropagationContext(wm.getNextPropagationIdCounter(), PropagationContext.Type.RULE_ADDITION, null, null, null);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)startNode;
        LeftInputAdapterNode.RightTupleSinkAdapter liaAdapter = new LeftInputAdapterNode.RightTupleSinkAdapter(lian);
        lian.getObjectSource().updateSink(liaAdapter, pctx, wm);
    }

    private static void insertFacts(PathEndNodes endNodes, InternalWorkingMemory wm) {
        HashSet<Integer> visited = new HashSet<Integer>();
        for (PathEndNode endNode : endNodes.subjectEndNodes) {
            LeftTupleNode[] nodes = endNode.getPathNodes();
            for (int i = 0; i < nodes.length; ++i) {
                BetaNode bn;
                LeftTupleNode node = nodes[i];
                if (!NodeTypeEnums.isBetaNode(node) || node.getAssociatedTerminalsSize() != 1 || !visited.add(node.getId()) || (bn = (BetaNode)node).isRightInputIsRiaNode()) continue;
                PropagationContextFactory pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
                PropagationContext pctx = pctxFactory.createPropagationContext(wm.getNextPropagationIdCounter(), PropagationContext.Type.RULE_ADDITION, null, null, null);
                bn.getRightInput().updateSink(bn, pctx, wm);
            }
        }
    }

    private static void deleteRightInputData(LeftTupleSink node, InternalWorkingMemory wm) {
        if (wm.getNodeMemories().peekNodeMemory(node) != null) {
            BetaNode bn = (BetaNode)node;
            BetaMemory bm = bn.getType() == 211 ? ((AccumulateNode.AccumulateMemory)wm.getNodeMemory(bn)).getBetaMemory() : (BetaMemory)wm.getNodeMemory(bn);
            TupleMemory rtm = bm.getRightTupleMemory();
            FastIterator it = rtm.fullFastIterator();
            Tuple rightTuple = BetaNode.getFirstTuple(rtm, it);
            while (rightTuple != null) {
                Tuple next = (Tuple)it.next(rightTuple);
                rtm.remove(rightTuple);
                rightTuple.unlinkFromRightParent();
                rightTuple = next;
            }
            if (!bm.getStagedRightTuples().isEmpty()) {
                bm.setNodeDirtyWithoutNotify();
            }
            TupleSets<RightTuple> srcRightTuples = bm.getStagedRightTuples().takeAll();
            EagerPhreakBuilder.unlinkRightTuples(srcRightTuples.getInsertFirst());
            EagerPhreakBuilder.unlinkRightTuples(srcRightTuples.getUpdateFirst());
            EagerPhreakBuilder.unlinkRightTuples(srcRightTuples.getDeleteFirst());
            EagerPhreakBuilder.deleteFactsFromRightInput(bn, wm);
        }
    }

    private static void deleteFactsFromRightInput(BetaNode bn, InternalWorkingMemory wm) {
        ObjectSource source = bn.getRightInput();
        if (source instanceof WindowNode) {
            WindowNode.WindowMemory memory = wm.getNodeMemory((WindowNode)source);
            for (EventFactHandle factHandle : memory.getFactHandles()) {
                factHandle.forEachRightTuple(rt -> {
                    if (source.equals(rt.getTupleSink())) {
                        rt.unlinkFromRightParent();
                    }
                });
            }
        }
    }

    private static void unlinkRightTuples(RightTuple rightTuple) {
        RightTuple rt = rightTuple;
        while (rt != null) {
            RightTuple next = (RightTuple)rt.getStagedNext();
            if (rt.getFactHandle() != null) {
                rt.unlinkFromRightParent();
            }
            rt = next;
        }
    }

    private static void processLeftTuples(LeftTupleNode node, InternalWorkingMemory wm, boolean insert, TerminalNode tn) {
        if (node instanceof AlphaTerminalNode) {
            EagerPhreakBuilder.processLeftTuplesOnLian(wm, insert, tn, (LeftInputAdapterNode)node);
            return;
        }
        Memory memory = wm.getNodeMemories().peekNodeMemory(node);
        if (memory == null || memory.getSegmentMemory() == null) {
            return;
        }
        SegmentMemory sm = memory.getSegmentMemory();
        while (120 != node.getType()) {
            if (NodeTypeEnums.isBetaNode(node)) {
                if (211 == node.getType()) {
                    AccumulateNode.AccumulateMemory am = (AccumulateNode.AccumulateMemory)memory;
                    BetaMemory bm = am.getBetaMemory();
                    FastIterator it = bm.getLeftTupleMemory().fullFastIterator();
                    Tuple lt = BetaNode.getFirstTuple(bm.getLeftTupleMemory(), it);
                    while (lt != null) {
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)lt.getContextObject();
                        EagerPhreakBuilder.visitChild(accctx.getResultLeftTuple(), insert, wm, tn);
                        lt = (LeftTuple)it.next(lt);
                    }
                } else if (201 == node.getType() && !((BetaNode)node).isRightInputIsRiaNode()) {
                    BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                    FastIterator it = bm.getRightTupleMemory().fullFastIterator();
                    RightTuple rt = (RightTuple)BetaNode.getFirstTuple(bm.getRightTupleMemory(), it);
                    while (rt != null) {
                        for (LeftTuple lt = rt.getBlocked(); lt != null; lt = lt.getBlockedNext()) {
                            EagerPhreakBuilder.visitChild(wm, insert, tn, it, lt);
                        }
                        rt = (RightTuple)it.next(rt);
                    }
                } else {
                    BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                    FastIterator it = bm.getLeftTupleMemory().fullFastIterator();
                    Tuple lt = BetaNode.getFirstTuple(bm.getLeftTupleMemory(), it);
                    EagerPhreakBuilder.visitChild(wm, insert, tn, it, lt);
                }
                return;
            }
            if (151 == node.getType()) {
                FromNode.FromMemory fm = (FromNode.FromMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                TupleMemory ltm = fm.getBetaMemory().getLeftTupleMemory();
                FastIterator it = ltm.fullFastIterator();
                LeftTuple lt = (LeftTuple)ltm.getFirst(null);
                while (lt != null) {
                    EagerPhreakBuilder.visitChild(lt, insert, wm, tn);
                    lt = (LeftTuple)it.next(lt);
                }
                return;
            }
            if (sm.getRootNode() == node) {
                sm = wm.getNodeMemory((MemoryFactory)((Object)node.getLeftTupleSource())).getSegmentMemory();
            }
            node = node.getLeftTupleSource();
        }
        EagerPhreakBuilder.processLeftTuplesOnLian(wm, insert, tn, (LeftInputAdapterNode)node);
    }

    private static void processLeftTuplesOnLian(InternalWorkingMemory wm, boolean insert, TerminalNode tn, LeftInputAdapterNode lian) {
        ObjectSource os = lian.getObjectSource();
        while (os.getType() != 30) {
            os = os.getParentObjectSource();
        }
        ObjectTypeNode otn = (ObjectTypeNode)os;
        ObjectTypeNode.ObjectTypeNodeMemory omem = wm.getNodeMemory(otn);
        if (omem == null) {
            return;
        }
        Iterator<InternalFactHandle> it = omem.iterator();
        while (it.hasNext()) {
            InternalFactHandle fh = it.next();
            fh.forEachLeftTuple(lt -> {
                LeftTuple nextLt = (LeftTuple)lt.getHandleNext();
                if (BuildtimeSegmentUtilities.isAssociatedWith(lt.getTupleSource(), tn)) {
                    EagerPhreakBuilder.visitChild(lt, insert, wm, tn);
                    if (lt.getHandlePrevious() != null) {
                        lt.getHandlePrevious().setHandleNext(nextLt);
                        if (nextLt != null) {
                            nextLt.setHandlePrevious((Tuple)lt.getHandlePrevious());
                        }
                    }
                }
            });
        }
    }

    private static void visitChild(InternalWorkingMemory wm, boolean insert, TerminalNode tn, FastIterator it, Tuple lt) {
        while (lt != null) {
            LeftTuple childLt = lt.getFirstChild();
            while (childLt != null) {
                LeftTuple nextLt = (LeftTuple)childLt.getHandleNext();
                EagerPhreakBuilder.visitChild(childLt, insert, wm, tn);
                childLt = nextLt;
            }
            lt = (LeftTuple)it.next(lt);
        }
    }

    private static void visitChild(LeftTuple lt, boolean insert, InternalWorkingMemory wm, TerminalNode tn) {
        LeftTuple prevLt = null;
        for (LeftTupleSinkNode sink = (LeftTupleSinkNode)lt.getTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            block4: {
                block5: {
                    block6: {
                        block7: {
                            if (lt == null) break block4;
                            if (!BuildtimeSegmentUtilities.isAssociatedWith(lt.getTupleSink(), tn)) break block5;
                            if (lt.getTupleSink().getAssociatedTerminalsSize() <= 1) break block6;
                            if (lt.getFirstChild() == null) break block7;
                            for (LeftTuple child = lt.getFirstChild(); child != null; child = (LeftTuple)child.getHandleNext()) {
                                EagerPhreakBuilder.visitChild(child, insert, wm, tn);
                            }
                            break block5;
                        }
                        if (lt.getTupleSink().getType() != 71) break block5;
                        EagerPhreakBuilder.insertPeerRightTuple(lt, wm, tn, insert);
                        break block5;
                    }
                    if (!insert) {
                        EagerPhreakBuilder.iterateLeftTuple(lt, wm);
                        LeftTuple lt2 = null;
                        for (LeftTuple peerLt = lt.getPeer(); peerLt != null && BuildtimeSegmentUtilities.isAssociatedWith(peerLt.getTupleSink(), tn) && peerLt.getTupleSink().getAssociatedTerminalsSize() == 1; peerLt = peerLt.getPeer()) {
                            EagerPhreakBuilder.iterateLeftTuple(peerLt, wm);
                            lt2 = peerLt;
                        }
                        EagerPhreakBuilder.deleteLeftTuple(lt, lt2, prevLt);
                        break;
                    }
                }
                prevLt = lt;
                lt = lt.getPeer();
                continue;
            }
            prevLt = EagerPhreakBuilder.insertPeerLeftTuple(prevLt, sink, wm, insert);
        }
    }

    private static void insertPeerRightTuple(LeftTuple lt, InternalWorkingMemory wm, TerminalNode tn, boolean insert) {
        LeftTuple prevLt = null;
        RightInputAdapterNode rian = (RightInputAdapterNode)lt.getTupleSink();
        for (ObjectSink sink : rian.getObjectSinkPropagator().getSinks()) {
            if (lt != null) {
                if (prevLt != null && !insert && BuildtimeSegmentUtilities.isAssociatedWith(sink, tn) && sink.getAssociatedTerminalsSize() == 1) {
                    prevLt.setPeer(null);
                }
                prevLt = lt;
                lt = lt.getPeer();
                continue;
            }
            if (!insert) continue;
            BetaMemory bm = (BetaMemory)wm.getNodeMemory((BetaNode)sink);
            prevLt = rian.createPeer(prevLt);
            bm.linkNode((BetaNode)sink, wm);
            bm.getStagedRightTuples().addInsert((RightTuple)((Object)prevLt));
        }
    }

    private static LeftTuple insertPeerLeftTuple(LeftTuple lt, LeftTupleSinkNode node, InternalWorkingMemory wm, boolean insert) {
        Memory memory;
        LeftTuple peer = node.createPeer(lt);
        if (node.getLeftTupleSource() instanceof AlphaTerminalNode) {
            if (insert) {
                TerminalNode rtn = (TerminalNode)node;
                InternalAgenda agenda = wm.getAgenda();
                RuleAgendaItem agendaItem = AlphaTerminalNode.getRuleAgendaItem(wm, agenda, rtn, insert);
                PhreakRuleTerminalNode.doLeftTupleInsert(rtn, agendaItem.getRuleExecutor(), agenda, agendaItem, peer);
            }
            return peer;
        }
        LeftInputAdapterNode.LiaNodeMemory liaMem = null;
        if (node.getLeftTupleSource().getType() == 120) {
            liaMem = wm.getNodeMemory((LeftInputAdapterNode)node.getLeftTupleSource());
        }
        if ((memory = wm.getNodeMemories().peekNodeMemory(node)) == null || memory.getSegmentMemory() == null) {
            throw new IllegalStateException("Defensive Programming: this should not be possilbe, as the addRule code should init child segments if they are needed ");
        }
        if (liaMem == null) {
            memory.getSegmentMemory().getStagedLeftTuples().addInsert(peer);
        } else {
            LeftInputAdapterNode.doInsertSegmentMemoryWithFlush(wm, true, liaMem, memory.getSegmentMemory(), peer, node.getLeftTupleSource().isStreamMode());
        }
        return peer;
    }

    private static void iterateLeftTuple(LeftTuple lt, InternalWorkingMemory wm) {
        if (NodeTypeEnums.isTerminalNode(lt.getTupleSink())) {
            PathMemory pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory((NetworkNode)lt.getTupleSink());
            if (pmem != null) {
                PhreakRuleTerminalNode.doLeftDelete(pmem.getActualActivationsManager(wm), pmem.getRuleAgendaItem().getRuleExecutor(), lt);
            }
        } else {
            LeftTuple resultLt;
            if (lt.getContextObject() instanceof AccumulateNode.AccumulateContext && (resultLt = ((AccumulateNode.AccumulateContext)lt.getContextObject()).getResultLeftTuple()) != null) {
                EagerPhreakBuilder.iterateLeftTuple(resultLt, wm);
            }
            for (LeftTuple child = lt.getFirstChild(); child != null; child = (LeftTuple)child.getHandleNext()) {
                for (LeftTuple peer = child; peer != null; peer = peer.getPeer()) {
                    if (peer.getPeer() != null) continue;
                    EagerPhreakBuilder.iterateLeftTuple(peer, wm);
                }
            }
        }
    }

    private static void deleteLeftTuple(LeftTuple removingLt, LeftTuple removingLt2, LeftTuple prevLt) {
        LeftTuple nextPeerLt;
        boolean isFirstLt = prevLt == null;
        LeftTuple leftTuple = nextPeerLt = removingLt2 == null ? removingLt.getPeer() : removingLt2.getPeer();
        if (!isFirstLt) {
            prevLt.setPeer(nextPeerLt);
        } else {
            if (nextPeerLt == null) {
                removingLt.unlinkFromLeftParent();
                removingLt.unlinkFromRightParent();
                return;
            }
            InternalFactHandle fh = removingLt.getFactHandle();
            LeftTuple leftPrevious = (LeftTuple)removingLt.getHandlePrevious();
            LeftTuple leftNext = (LeftTuple)removingLt.getHandleNext();
            LeftTuple rightPrevious = removingLt.getRightParentPrevious();
            LeftTuple rightNext = removingLt.getRightParentNext();
            LeftTuple leftParent = removingLt.getLeftParent();
            RightTuple rightParent = removingLt.getRightParent();
            nextPeerLt.setFactHandle(removingLt.getFactHandle());
            if (leftPrevious != null) {
                nextPeerLt.setHandlePrevious(leftPrevious);
                leftPrevious.setHandleNext(nextPeerLt);
            }
            if (leftNext != null) {
                nextPeerLt.setHandleNext(leftNext);
                leftNext.setHandlePrevious(nextPeerLt);
            }
            if (rightPrevious != null) {
                nextPeerLt.setRightParentPrevious(rightPrevious);
                rightPrevious.setRightParentNext(nextPeerLt);
            }
            if (rightNext != null) {
                nextPeerLt.setRightParentNext(rightNext);
                rightNext.setRightParentPrevious(nextPeerLt);
            }
            if (leftParent != null) {
                nextPeerLt.setLeftParent(leftParent);
                if (leftParent.getFirstChild() == removingLt) {
                    leftParent.setFirstChild(nextPeerLt);
                }
                if (leftParent.getLastChild() == removingLt) {
                    leftParent.setLastChild(nextPeerLt);
                }
            } else {
                fh.removeLeftTuple(removingLt);
                if (leftPrevious == null) {
                    fh.addFirstLeftTuple(nextPeerLt);
                }
            }
            if (rightParent != null) {
                nextPeerLt.setRightParent(rightParent);
                if (rightParent.getFirstChild() == removingLt) {
                    rightParent.setFirstChild(nextPeerLt);
                }
                if (rightParent.getLastChild() == removingLt) {
                    rightParent.setLastChild(nextPeerLt);
                }
            }
        }
    }

    private static void addNetworkSplitPoint(LeftTupleNode node, Set<LeftTupleNode> splitNodes) {
        while (node.getLeftTupleSource() != null) {
            if (node.getLeftTupleSource().getAssociatedTerminalsSize() != 1) {
                if (node.getAssociatedTerminalsSize() == 1) {
                    splitNodes.add(node.getLeftTupleSource());
                }
                return;
            }
            node = node.getLeftTupleSource();
        }
        splitNodes.add(node);
    }

    public static SegmentMemory splitSegment(InternalWorkingMemory wm, SegmentMemory sm1, LeftTupleNode splitNode, RuleBase kbase) {
        LeftTupleSinkNode childNode = splitNode.getSinkPropagator().getFirstLeftTupleSink();
        SegmentMemory.SegmentPrototype proto2 = kbase.getSegmentPrototype(childNode);
        SegmentMemory sm2 = proto2.newSegmentMemory(wm);
        wm.getNodeMemories().peekNodeMemory(childNode).setSegmentMemory(sm2);
        if (sm1.getFirst() != null) {
            SegmentMemory sm = (SegmentMemory)sm1.getFirst();
            while (sm != null) {
                SegmentMemory next = sm.getNext();
                sm1.remove(sm);
                sm2.add(sm);
                sm = next;
            }
        }
        sm1.add(sm2);
        sm2.mergePathMemories(sm1);
        long currentLinkedNodeMask = sm1.getLinkedNodeMask();
        SegmentMemory.SegmentPrototype proto1 = kbase.getSegmentPrototype(sm1.getRootNode());
        proto1.updateSegmentMemory(sm1, wm);
        if (sm1.getTipNode().getType() == 120 && !sm1.getStagedLeftTuples().isEmpty()) {
            sm2.getStagedLeftTuples().addAll(sm1.getStagedLeftTuples());
        }
        EagerPhreakBuilder.splitBitMasks(sm1, sm2, currentLinkedNodeMask);
        return sm2;
    }

    private static void mergeSegment(SegmentMemory sm1, SegmentMemory sm2, RuleBase kbase, InternalWorkingMemory wm) {
        if (sm1.getTipNode().getType() == 120 && !sm2.getStagedLeftTuples().isEmpty()) {
            sm1.getStagedLeftTuples().addAll(sm2.getStagedLeftTuples());
        }
        if (sm1.contains(sm2)) {
            sm1.remove(sm2);
        }
        if (sm2.getFirst() != null) {
            SegmentMemory sm = (SegmentMemory)sm2.getFirst();
            while (sm != null) {
                SegmentMemory next = sm.getNext();
                sm2.remove(sm);
                sm1.add(sm);
                sm = next;
            }
        }
        long currentLinkedNodeMask = sm1.getLinkedNodeMask();
        SegmentMemory.SegmentPrototype proto1 = kbase.getSegmentPrototype(sm1.getRootNode());
        proto1.updateSegmentMemory(sm1, wm);
        EagerPhreakBuilder.mergeBitMasks(sm1, sm2, currentLinkedNodeMask);
    }

    private static void splitBitMasks(SegmentMemory sm1, SegmentMemory sm2, long currentLinkedNodeMask) {
        int splitPos = sm1.getSegmentPrototype().getNodesInSegment().length;
        long currentDirtyNodeMask = sm1.getDirtyNodeMask();
        long splitAsBinary = (1L << splitPos) - 1L;
        sm1.setDirtyNodeMask(currentDirtyNodeMask & splitAsBinary);
        sm1.setLinkedNodeMask(currentLinkedNodeMask & sm1.getAllLinkedMaskTest());
        sm2.setLinkedNodeMask(currentLinkedNodeMask >> splitPos);
        sm2.setDirtyNodeMask(currentDirtyNodeMask >> splitPos);
    }

    private static void mergeBitMasks(SegmentMemory sm1, SegmentMemory sm2, long currentLinkedNodeMask) {
        int shiftBits = 0;
        for (LeftTupleNode node : sm1.getSegmentPrototype().getNodesInSegment()) {
            if (node == sm2.getRootNode()) break;
            ++shiftBits;
        }
        long linkedBitsToAdd = sm2.getLinkedNodeMask() << shiftBits;
        long dirtyBitsToAdd = sm2.getLinkedNodeMask() << shiftBits;
        sm1.setLinkedNodeMask(linkedBitsToAdd | currentLinkedNodeMask);
        sm1.setDirtyNodeMask(dirtyBitsToAdd | sm1.getDirtyNodeMask());
    }

    private static PathEndNodeMemories getPathEndMemories(InternalWorkingMemory wm, PathEndNodes pathEndNodes) {
        PathMemory pmem;
        PathEndNodeMemories tnMems = new PathEndNodeMemories();
        for (LeftTupleNode leftTupleNode : pathEndNodes.otherEndNodes) {
            pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(leftTupleNode);
            if (pmem == null) continue;
            tnMems.otherPmems.add(pmem);
        }
        tnMems.subjectPmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(pathEndNodes.subjectTermNode);
        if (tnMems.subjectPmem == null && !tnMems.otherPmems.isEmpty()) {
            tnMems.subjectPmem = RuntimeSegmentUtilities.initializePathMemory(wm, pathEndNodes.subjectTermNode);
        }
        for (PathEndNode pathEndNode : pathEndNodes.subjectEndNodes) {
            pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(pathEndNode);
            if (pmem == null && !tnMems.otherPmems.isEmpty()) {
                pmem = RuntimeSegmentUtilities.initializePathMemory(wm, pathEndNode);
            }
            if (pmem == null) continue;
            tnMems.subjectPmems.add(pmem);
        }
        return tnMems;
    }

    private static PathEndNodes getPathEndNodes(TerminalNode tn, Set<LeftTupleNode> splitNodes) {
        PathEndNodes endNodes = new PathEndNodes();
        endNodes.subjectTermNode = tn;
        endNodes.subjectEndNodes.add(tn);
        endNodes.subjectSplits.addAll(splitNodes);
        HashSet visited = new HashSet();
        if (!endNodes.subjectSplits.isEmpty()) {
            endNodes.subjectSplits.forEach(n -> EagerPhreakBuilder.invalidateRootNode(n, endNodes));
            endNodes.subjectSplits.forEach(n -> EagerPhreakBuilder.collectPathEndNodes(n, endNodes, tn, visited));
        }
        return endNodes;
    }

    private static void collectPathEndNodes(LeftTupleNode lt, PathEndNodes endNodes, TerminalNode tn, Set<Integer> visited) {
        for (LeftTupleSinkNode sink = lt.getSinkPropagator().getLastLeftTupleSink(); sink != null; sink = sink.getPreviousLeftTupleSinkNode()) {
            if (!visited.add(sink.getId())) continue;
            if (BuildtimeSegmentUtilities.isRootNode(sink, null)) {
                endNodes.nodesToInvalidate.add(sink);
            }
            if (NodeTypeEnums.isLeftTupleSource(sink)) {
                EagerPhreakBuilder.collectPathEndNodes(sink, endNodes, tn, visited);
                continue;
            }
            if (NodeTypeEnums.isTerminalNode(sink)) {
                if (sink == tn) continue;
                endNodes.otherTermNodes.add((TerminalNode)sink);
                endNodes.otherEndNodes.add((TerminalNode)sink);
                continue;
            }
            if (71 == sink.getType()) {
                if (BuildtimeSegmentUtilities.sinkNotExclusivelyAssociatedWithTerminal(tn, sink)) {
                    Arrays.stream(((PathEndNode)sink).getPathEndNodes()).filter(NodeTypeEnums::isTerminalNode).forEach(endNode -> {
                        if (endNode != tn) {
                            endNodes.otherTermNodes.add((TerminalNode)endNode);
                        }
                    });
                    endNodes.otherEndNodes.add((PathEndNode)sink);
                    continue;
                }
                endNodes.subjectEndNodes.add((PathEndNode)sink);
                continue;
            }
            if (NodeTypeEnums.isTerminalNode(sink) && BuildtimeSegmentUtilities.isAssociatedWith(sink, tn)) continue;
            throw new RuntimeException("Error: Unknown Node. Defensive programming test..");
        }
    }

    private static void invalidateRootNode(LeftTupleNode lt, PathEndNodes endNodes) {
        while (!BuildtimeSegmentUtilities.isRootNode(lt, null)) {
            lt = lt.getLeftTupleSource();
        }
        endNodes.nodesToInvalidate.add(lt);
    }

    private static class PathEndNodes {
        TerminalNode subjectTermNode;
        private final Set<PathEndNode> subjectEndNodes = new HashSet<PathEndNode>();
        private final Set<LeftTupleNode> subjectSplits = new HashSet<LeftTupleNode>();
        private final Set<PathEndNode> otherEndNodes = new HashSet<PathEndNode>();
        private final Set<TerminalNode> otherTermNodes = new HashSet<TerminalNode>();
        private final Set<LeftTupleNode> nodesToInvalidate = new HashSet<LeftTupleNode>();

        private PathEndNodes() {
        }
    }

    private static class PathEndNodeMemories {
        PathMemory subjectPmem;
        List<PathMemory> subjectPmems = new ArrayList<PathMemory>();
        List<PathMemory> otherPmems = new ArrayList<PathMemory>();

        private PathEndNodeMemories() {
        }
    }

    public static class Flushed {
        SegmentMemory segmentMemory;
        PathMemory pathMemory;

        public Flushed(SegmentMemory segmentMemory, PathMemory pathMemory) {
            this.segmentMemory = segmentMemory;
            this.pathMemory = pathMemory;
        }
    }

    static class RemoveExistingPaths
    implements ExistingPathStrategy {
        RemoveExistingPaths() {
        }

        @Override
        public SegmentMemory[] getSegmenMemories(PathMemory pmem) {
            return new SegmentMemory[pmem.getSegmentMemories().length];
        }

        @Override
        public void handleSplit(PathMemory pmem, SegmentMemory[] prevSmems, SegmentMemory[] smems, int smemIndex, int prevSmemIndex, LeftTupleNode parentNode, LeftTupleNode node, TerminalNode tn, Set<Integer> visited, Map<LeftTupleNode, SegmentMemory> nodeToSegmentMap, InternalWorkingMemory wm) {
            if (visited.contains(node.getId())) {
                return;
            }
            EagerPhreakBuilder.correctMemoryOnSplitsChanged(parentNode, tn, wm);
            SegmentMemory sm1 = smems[smemIndex];
            SegmentMemory sm2 = prevSmems[prevSmemIndex];
            if (sm1 == null && sm2 == null) {
                return;
            }
            LeftTupleSource removedTerminalSource = tn.getLeftTupleSource();
            removedTerminalSource.removeTupleSink(tn);
            if (sm1 == null) {
                smems[smemIndex] = sm1 = RuntimeSegmentUtilities.createChildSegment(wm, parentNode);
                sm1.add(sm2);
            }
            if (sm2 != null) {
                EagerPhreakBuilder.mergeSegment(sm1, sm2, wm.getKnowledgeBase(), wm);
                sm2.unlinkSegment(wm);
            } else {
                SegmentMemory.SegmentPrototype proto = wm.getKnowledgeBase().getSegmentPrototype(sm1.getRootNode());
                proto.updateSegmentMemory(sm1, wm);
                long currentLinkedNodeMask = sm1.getLinkedNodeMask();
                proto.updateSegmentMemory(sm1, wm);
                sm1.setLinkedNodeMask(currentLinkedNodeMask);
            }
            sm1.unlinkSegment(wm);
            visited.add(node.getId());
            removedTerminalSource.addTupleSink(tn);
        }

        @Override
        public void processSegmentMemories(SegmentMemory[] smems, PathMemory pmem) {
            for (int i = 0; i < smems.length; ++i) {
                if (smems[i] == null) continue;
                pmem.setSegmentMemory(smems[i].getPos(), smems[i]);
            }
        }

        @Override
        public int incSmemIndex1(int smemIndex) {
            return smemIndex;
        }

        @Override
        public int incPrevSmemIndex1(int prevSmemIndex) {
            return prevSmemIndex + 1;
        }

        @Override
        public int incSmemIndex2(int smemIndex) {
            return smemIndex + 1;
        }

        @Override
        public int incPrevSmemIndex2(int prevSmemIndex) {
            return prevSmemIndex;
        }
    }

    static class AddExistingPaths
    implements ExistingPathStrategy {
        AddExistingPaths() {
        }

        @Override
        public SegmentMemory[] getSegmenMemories(PathMemory pmem) {
            return pmem.getSegmentMemories();
        }

        @Override
        public void handleSplit(PathMemory pmem, SegmentMemory[] prevSmems, SegmentMemory[] smems, int smemIndex, int prevSmemIndex, LeftTupleNode parentNode, LeftTupleNode node, TerminalNode tn, Set<Integer> visited, Map<LeftTupleNode, SegmentMemory> nodeToSegmentMap, InternalWorkingMemory wm) {
            if (smems[smemIndex - 1] != null) {
                SegmentMemory sm2 = nodeToSegmentMap.get(node);
                if (sm2 == null) {
                    SegmentMemory sm1 = smems[smemIndex - 1];
                    EagerPhreakBuilder.correctMemoryOnSplitsChanged(parentNode, null, wm);
                    sm2 = EagerPhreakBuilder.splitSegment(wm, sm1, parentNode, wm.getKnowledgeBase());
                    nodeToSegmentMap.put(node, sm2);
                }
                smems[smemIndex] = sm2;
            }
        }

        @Override
        public void processSegmentMemories(SegmentMemory[] smems, PathMemory pmem) {
        }

        @Override
        public int incSmemIndex1(int smemIndex) {
            return smemIndex + 1;
        }

        @Override
        public int incPrevSmemIndex1(int prevSmemIndex) {
            return prevSmemIndex;
        }

        @Override
        public int incSmemIndex2(int smemIndex) {
            return smemIndex;
        }

        @Override
        public int incPrevSmemIndex2(int prevSmemIndex) {
            return prevSmemIndex + 1;
        }
    }

    static interface ExistingPathStrategy {
        public static final ExistingPathStrategy ADD_STRATEGY = new AddExistingPaths();
        public static final ExistingPathStrategy REMOVE_STRATEGY = new RemoveExistingPaths();

        public SegmentMemory[] getSegmenMemories(PathMemory var1);

        public void handleSplit(PathMemory var1, SegmentMemory[] var2, SegmentMemory[] var3, int var4, int var5, LeftTupleNode var6, LeftTupleNode var7, TerminalNode var8, Set<Integer> var9, Map<LeftTupleNode, SegmentMemory> var10, InternalWorkingMemory var11);

        public void processSegmentMemories(SegmentMemory[] var1, PathMemory var2);

        public int incSmemIndex1(int var1);

        public int incSmemIndex2(int var1);

        public int incPrevSmemIndex1(int var1);

        public int incPrevSmemIndex2(int var1);
    }
}

