/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.template.parser.DataListener;
import org.drools.template.parser.DecisionTableParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelParser
implements DecisionTableParser {
    public static final String DEFAULT_RULESHEET_NAME = "Decision Tables";
    private Map<String, List<DataListener>> _listners = new HashMap<String, List<DataListener>>();
    private boolean _useFirstSheet;

    public ExcelParser(Map<String, List<DataListener>> sheetListners) {
        this._listners = sheetListners;
    }

    public ExcelParser(List<DataListener> sheetListners) {
        this._listners.put(DEFAULT_RULESHEET_NAME, sheetListners);
        this._useFirstSheet = true;
    }

    public ExcelParser(DataListener listener) {
        ArrayList<DataListener> listeners = new ArrayList<DataListener>();
        listeners.add(listener);
        this._listners.put(DEFAULT_RULESHEET_NAME, listeners);
        this._useFirstSheet = true;
    }

    @Override
    public void parseFile(InputStream inStream) {
        try {
            Workbook workbook = Workbook.getWorkbook((InputStream)inStream);
            if (this._useFirstSheet) {
                Sheet sheet = workbook.getSheet(0);
                this.processSheet(sheet, this._listners.get(DEFAULT_RULESHEET_NAME));
            } else {
                for (String sheetName : this._listners.keySet()) {
                    Sheet sheet = workbook.getSheet(sheetName);
                    this.processSheet(sheet, this._listners.get(sheetName));
                }
            }
        }
        catch (BiffException e) {
            throw new DecisionTableParseException("An error occured opening the workbook. It is possible that the encoding of the document did not match the encoding of the reader.", (Throwable)e);
        }
        catch (IOException e) {
            throw new DecisionTableParseException("Failed to open Excel stream, please check that the content is xls97 format.", (Throwable)e);
        }
    }

    private void processSheet(Sheet sheet, List<? extends DataListener> listeners) {
        int maxRows = sheet.getRows();
        Range[] mergedRanges = sheet.getMergedCells();
        int i = 0;
        while (i < maxRows) {
            Cell[] row = sheet.getRow(i);
            this.newRow(listeners, i, row.length);
            int cellNum = 0;
            while (cellNum < row.length) {
                Cell cell = row[cellNum];
                Range merged = this.getRangeIfMerged(cell, mergedRanges);
                if (merged != null) {
                    Cell topLeft = merged.getTopLeft();
                    this.newCell(listeners, i, cellNum, topLeft.getContents(), topLeft.getColumn());
                } else {
                    this.newCell(listeners, i, cellNum, cell.getContents(), -1);
                }
                ++cellNum;
            }
            ++i;
        }
        this.finishSheet(listeners);
    }

    Range getRangeIfMerged(Cell cell, Range[] mergedRanges) {
        int i = 0;
        while (i < mergedRanges.length) {
            Range r = mergedRanges[i];
            Cell topLeft = r.getTopLeft();
            Cell bottomRight = r.getBottomRight();
            if (cell.getRow() >= topLeft.getRow() && cell.getRow() <= bottomRight.getRow() && cell.getColumn() >= topLeft.getColumn() && cell.getColumn() <= bottomRight.getColumn()) {
                return r;
            }
            ++i;
        }
        return null;
    }

    static String removeTrailingZero(String stringVal) {
        if (stringVal.endsWith(".0")) {
            stringVal = stringVal.substring(0, stringVal.length() - 2);
        }
        return stringVal;
    }

    private void finishSheet(List<? extends DataListener> listeners) {
        for (DataListener dataListener : listeners) {
            dataListener.finishSheet();
        }
    }

    private void newRow(List<? extends DataListener> listeners, int row, int cols) {
        for (DataListener dataListener : listeners) {
            dataListener.newRow(row, cols);
        }
    }

    public void newCell(List<? extends DataListener> listeners, int row, int column, String value, int mergedColStart) {
        for (DataListener dataListener : listeners) {
            dataListener.newCell(row, column, value, mergedColStart);
        }
    }
}

