/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.template.parser.DecisionTableParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSheetParserUtil {
    private RuleSheetParserUtil() {
    }

    public static String getRuleName(String ruleRow) {
        int left = ruleRow.indexOf("RuleTable");
        if (ruleRow.indexOf(40) > -1 || ruleRow.indexOf(41) > -1) {
            RuleSheetParserUtil.invalidRuleTableDef(ruleRow);
        }
        return ruleRow.substring(left + "RuleTable".length()).trim();
    }

    private static void invalidRuleTableDef(String ruleRow) {
        throw new IllegalArgumentException("Invalid rule table header cell. Should be in the format of 'RuleTable YourRuleName'. It was: \n [" + ruleRow + "] \n");
    }

    public static List<Import> getImportList(String importCell) {
        LinkedList<Import> importList = new LinkedList<Import>();
        if (importCell == null) {
            return importList;
        }
        StringTokenizer tokens = new StringTokenizer(importCell, ",");
        while (tokens.hasMoreTokens()) {
            Import imp = new Import();
            imp.setClassName(tokens.nextToken().trim());
            importList.add(imp);
        }
        return importList;
    }

    public static List<Global> getVariableList(String variableCell) {
        LinkedList<Global> variableList = new LinkedList<Global>();
        if (variableCell == null) {
            return variableList;
        }
        StringTokenizer tokens = new StringTokenizer(variableCell, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            Global vars = new Global();
            StringTokenizer paramTokens = new StringTokenizer(token, " ");
            vars.setClassName(paramTokens.nextToken());
            if (!paramTokens.hasMoreTokens()) {
                throw new DecisionTableParseException("The format for global variables is incorrect. It should be: [Class name, Class otherName]. But it was: [" + variableCell + "]");
            }
            vars.setIdentifier(paramTokens.nextToken());
            variableList.add(vars);
        }
        return variableList;
    }

    public static boolean isStringMeaningTrue(String property) {
        if (property == null) {
            return false;
        }
        if ((property = property.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (property.startsWith("Y")) {
            return true;
        }
        if (property.startsWith("y")) {
            return true;
        }
        return property.equalsIgnoreCase("on");
    }
}

