/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser.lang.dsl;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.drools.drl.parser.lang.Expander;
import org.drools.drl.parser.lang.ExpanderResolver;
import org.drools.drl.parser.lang.dsl.DSLTokenizedMappingFile;
import org.drools.drl.parser.lang.dsl.DefaultExpander;

public class DefaultExpanderResolver
implements ExpanderResolver {
    private final Map expanders = new HashMap();

    public DefaultExpanderResolver() {
    }

    public DefaultExpanderResolver(Reader reader) throws IOException {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        if (!file.parseAndLoad(reader)) {
            throw new RuntimeException("Error parsing and loading DSL file." + file.getErrors());
        }
        DefaultExpander expander = new DefaultExpander();
        expander.addDSLMapping(file.getMapping());
        this.expanders.put("*", expander);
    }

    public void addExpander(String name, Expander expander) {
        this.expanders.put(name, expander);
    }

    @Override
    public Expander get(String name, String config) {
        if (this.expanders.containsKey(name)) {
            return (Expander)this.expanders.get(name);
        }
        Expander exp = (Expander)this.expanders.get("*");
        if (exp == null) {
            throw new IllegalArgumentException("Unable to provide an expander for " + name + " or a default expander.");
        }
        return exp;
    }
}

