/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.internal.commands;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.command.Context;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItemHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterWorkItemHandlerRemoteCommand
implements GenericCommand<Object> {
    private String handlerClassName;
    private String workItemName;

    public RegisterWorkItemHandlerRemoteCommand() {
    }

    public RegisterWorkItemHandlerRemoteCommand(String workItemName, String handlerClassName) {
        this.handlerClassName = handlerClassName;
        this.workItemName = workItemName;
    }

    public String getHandlerClassName() {
        return this.handlerClassName;
    }

    public String getWorkItemName() {
        return this.workItemName;
    }

    public void setWorkItemName(String workItemName) {
        this.workItemName = workItemName;
    }

    public Object execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        Class<?> workItemHandlerClass = null;
        try {
            workItemHandlerClass = Class.forName(this.handlerClassName);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(RegisterWorkItemHandlerRemoteCommand.class.getName()).log(Level.SEVERE, null, ex);
        }
        Constructor<?> constructor = null;
        boolean initializeWithSession = false;
        try {
            constructor = workItemHandlerClass.getConstructor(KnowledgeRuntime.class);
            initializeWithSession = true;
        }
        catch (NoSuchMethodException noex) {
            // empty catch block
        }
        if (!initializeWithSession) {
            try {
                constructor = workItemHandlerClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noex) {
                // empty catch block
            }
        }
        WorkItemHandler reflectionHandler = null;
        if (initializeWithSession) {
            try {
                reflectionHandler = (WorkItemHandler)constructor.newInstance(ksession);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(RegisterWorkItemHandlerRemoteCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(RegisterWorkItemHandlerRemoteCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(RegisterWorkItemHandlerRemoteCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(RegisterWorkItemHandlerRemoteCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                reflectionHandler = (WorkItemHandler)constructor.newInstance(new Object[0]);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(RegisterWorkItemHandlerRemoteCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(RegisterWorkItemHandlerRemoteCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(RegisterWorkItemHandlerRemoteCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(RegisterWorkItemHandlerRemoteCommand.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (reflectionHandler == null) {
            throw new IllegalStateException("No WorkItemHandler Instantiated for " + this.workItemName);
        }
        ksession.getWorkItemManager().registerWorkItemHandler(this.workItemName, reflectionHandler);
        return null;
    }

    public String toString() {
        return "Remote: session.getWorkItemManager().registerWorkItemHandler(" + this.workItemName + ", " + this.handlerClassName + ");";
    }
}

