/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.impl;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.SystemEventListener;
import org.drools.grid.Grid;
import org.drools.grid.GridConnection;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.MessageReceiverHandlerFactoryService;
import org.drools.grid.SocketService;
import org.drools.grid.impl.MultiplexSocket;
import org.drools.grid.io.Acceptor;
import org.drools.grid.io.AcceptorFactoryService;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.local.LocalGridNodeConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexSocketServerImpl
implements SocketService {
    private AcceptorFactoryService factory;
    private String ip;
    private SystemEventListener l;
    private Map<Integer, Acceptor> acceptors;
    private Grid grid;
    private static Logger logger = LoggerFactory.getLogger(MultiplexSocketServerImpl.class);

    public MultiplexSocketServerImpl(String ip, AcceptorFactoryService factory, SystemEventListener l, Grid grid) {
        this.factory = factory;
        this.ip = ip;
        this.l = l;
        this.acceptors = new HashMap<Integer, Acceptor>();
        this.grid = grid;
    }

    @Override
    public synchronized void addService(String id, int port, Object object) {
        MultiplexSocket ms;
        if (logger.isDebugEnabled()) {
            logger.debug(" ### Trying to add a service -> " + id + " @ " + this.ip + ":" + port + " >> " + object + " [[ " + (object instanceof MessageReceiverHandlerFactoryService));
        }
        MessageReceiverHandlerFactoryService handlerFactory = (MessageReceiverHandlerFactoryService)object;
        Acceptor acc = this.acceptors.get(port);
        MessageReceiverHandler h = handlerFactory.getMessageReceiverHandler();
        if (acc == null) {
            acc = this.factory.newAcceptor();
            ms = new MultiplexSocket();
            if (logger.isDebugEnabled()) {
                logger.debug(" ### Opening new Acceptor for -> " + this.ip + ":" + port + " >> " + object);
            }
            acc.open(new InetSocketAddress(this.ip, port), ms, this.l);
            this.acceptors.put(port, acc);
        } else if (logger.isDebugEnabled()) {
            logger.debug(" ### Found existing Acceptor: " + this.ip + ":" + port + " >> " + object);
        }
        ms = (MultiplexSocket)acc.getMessageReceiverHandler();
        ms.getHandlers().put(id, h);
        handlerFactory.registerSocketService(this.grid, id, this.ip, port);
    }

    @Override
    public synchronized void removeService(int socket, String id) {
        Acceptor acc = this.acceptors.get(socket);
        if (acc != null) {
            MultiplexSocket ms = (MultiplexSocket)acc.getMessageReceiverHandler();
            ms.getHandlers().remove(id);
            if (ms.getHandlers().isEmpty()) {
                acc.close();
            }
        }
    }

    @Override
    public void close() {
        for (Acceptor acc : this.acceptors.values()) {
            if (!acc.isOpen()) continue;
            if (logger.isTraceEnabled()) {
                logger.trace(" ### Closing Acceptor: " + acc.isOpen());
            }
            acc.close();
            if (!logger.isTraceEnabled()) continue;
            logger.trace(" ### Acceptor Closed: " + acc.isOpen());
        }
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public Set<Integer> getPorts() {
        return this.acceptors.keySet();
    }

    public <T> GridConnection<T> getConnection(GridServiceDescription<T> gsd) {
        GridNode gnode = this.grid.getGridNode(gsd.getId());
        if (gnode != null) {
            LocalGridNodeConnection localGridNodeConnection = new LocalGridNodeConnection(gnode);
        }
        if (gsd.getServiceInterface().isAssignableFrom(GridNode.class)) {
            // empty if block
        }
        return null;
    }
}

