/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Set;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.conf.AccumulateFunctionOption;
import org.drools.builder.conf.KnowledgeBuilderOption;
import org.drools.builder.conf.MultiValueKnowledgeBuilderOption;
import org.drools.builder.conf.SingleValueKnowledgeBuilderOption;
import org.drools.command.CommandFactory;
import org.drools.grid.Grid;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.internal.commands.KnowledgeBuilderConfigurationRemoteCommands;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.remote.ConversationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeBuilderConfigurationRemoteClient
implements KnowledgeBuilderConfiguration,
Serializable {
    public static final String PROPERTY_MESSAGE_TIMEOUT = "grid.kbuilder.message.timeout";
    public static final String PROPERTY_MESSAGE_MINIMUM_WAIT_TIME = "grid.kbuilder.message.min.wait";
    private static Logger logger = LoggerFactory.getLogger(KnowledgeBuilderConfigurationRemoteClient.class);
    private String instanceId;
    private GridServiceDescription<GridNode> gsd;
    private Grid grid;

    KnowledgeBuilderConfigurationRemoteClient(String instanceId, Grid grid, GridServiceDescription<GridNode> gsd) {
        this.instanceId = instanceId;
        this.gsd = gsd;
        this.grid = grid;
    }

    public void setProperty(String name, String value) {
        logger.info("This InstanceId (ConfRemoteClient) = " + this.instanceId);
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeBuilderConfigurationRemoteCommands.SetPropertyRemoteCommand(this.instanceId, name, value)));
        ConversationUtil.sendMessage(this.grid.get(ConversationManager.class), (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
    }

    public String getProperty(String name) {
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeBuilderConfigurationRemoteCommands.GetPropertyRemoteCommand(this.instanceId, name)));
        return (String)ConversationUtil.sendMessage(this.grid.get(ConversationManager.class), (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
    }

    public <T extends KnowledgeBuilderOption> void setOption(T option) {
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(CommandFactory.newKnowledgeBuilderSetPropertyCommand((String)this.instanceId, (String)option.getPropertyName(), (String)((AccumulateFunctionOption)option).getFunction().getClass().getCanonicalName())));
        ConversationUtil.sendMessage(this.grid.get(ConversationManager.class), (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
    }

    public <T extends SingleValueKnowledgeBuilderOption> T getOption(Class<T> option) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends MultiValueKnowledgeBuilderOption> T getOption(Class<T> option, String key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T extends MultiValueKnowledgeBuilderOption> Set<String> getOptionKeys(Class<T> option) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getId() {
        return this.instanceId;
    }

    public void setId(String instanceId) {
        this.instanceId = instanceId;
    }
}

