/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.drools.KnowledgeBase;
import org.drools.command.Command;
import org.drools.command.CommandFactory;
import org.drools.command.ExecuteCommand;
import org.drools.command.GetSessionClockCommand;
import org.drools.command.KnowledgeContextResolveFromContextCommand;
import org.drools.command.SetVariableCommandFromCommand;
import org.drools.command.runtime.DisposeCommand;
import org.drools.command.runtime.GetFactCountCommand;
import org.drools.command.runtime.GetGlobalsCommand;
import org.drools.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.command.runtime.process.CreateProcessInstanceCommand;
import org.drools.command.runtime.process.GetProcessInstanceCommand;
import org.drools.command.runtime.process.GetProcessInstancesCommand;
import org.drools.command.runtime.process.SignalEventCommand;
import org.drools.command.runtime.process.StartProcessCommand;
import org.drools.command.runtime.process.StartProcessInstanceCommand;
import org.drools.command.runtime.rule.FireAllRulesCommand;
import org.drools.command.runtime.rule.FireUntilHaltCommand;
import org.drools.command.runtime.rule.GetFactHandleCommand;
import org.drools.command.runtime.rule.GetFactHandlesCommand;
import org.drools.command.runtime.rule.GetObjectCommand;
import org.drools.command.runtime.rule.GetObjectsCommand;
import org.drools.command.runtime.rule.HaltCommand;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.command.runtime.rule.UpdateCommand;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.grid.GridNode;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.remote.ConversationUtil;
import org.drools.grid.remote.KnowledgeSessionConfigurationRemoteClient;
import org.drools.grid.remote.QueryResultsRemoteClient;
import org.drools.grid.remote.WorkItemManagerRemoteClient;
import org.drools.grid.remote.WorkingMemoryEntryPointRemoteClient;
import org.drools.grid.remote.command.AsyncBatchExecutionCommandImpl;
import org.drools.grid.remote.command.GetWorkingMemoryEntryPointRemoteCommand;
import org.drools.grid.remote.command.QueryRemoteCommand;
import org.drools.runtime.Calendars;
import org.drools.runtime.Channel;
import org.drools.runtime.Environment;
import org.drools.runtime.ExitPoint;
import org.drools.runtime.Globals;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.rule.Agenda;
import org.drools.runtime.rule.AgendaFilter;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.LiveQuery;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.ViewChangedEventListener;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.time.SessionClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulKnowledgeSessionRemoteClient
implements StatefulKnowledgeSession {
    private static Logger logger = LoggerFactory.getLogger(StatefulKnowledgeSessionRemoteClient.class);
    private String instanceId;
    private GridServiceDescription<GridNode> gsd;
    private ConversationManager cm;
    private KnowledgeSessionConfigurationRemoteClient conf;
    private Long timeout;
    private Long minWaitTime;

    public StatefulKnowledgeSessionRemoteClient(String localId, GridServiceDescription gsd, ConversationManager cm, KnowledgeSessionConfigurationRemoteClient conf) {
        this.instanceId = localId;
        this.gsd = gsd;
        this.cm = cm;
        this.conf = conf;
        if (this.conf != null) {
            String configuredMinWaitTime;
            String configuredTimeout = this.conf.getProperty("grid.ksession.message.timeout");
            if (configuredTimeout != null) {
                this.timeout = Long.parseLong(configuredTimeout);
            }
            if ((configuredMinWaitTime = this.conf.getProperty("grid.ksession.message.min.wait")) != null) {
                this.minWaitTime = Long.parseLong(configuredMinWaitTime);
            }
        }
    }

    public int getId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void dispose() {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new DisposeCommand(), null, null, this.instanceId, kresultsId), this.instanceId));
        this.sendMessage(cmd);
    }

    public int fireAllRules() {
        return this.fireAllRules(-1);
    }

    public int fireAllRules(int max) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand(CommandFactory.newFireAllRules((int)max), null, null, this.instanceId, kresultsId)));
        return (Integer)this.sendMessage(cmd);
    }

    public int fireAllRules(AgendaFilter agendaFilter) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new FireAllRulesCommand(agendaFilter), null, null, this.instanceId, kresultsId)));
        return (Integer)this.sendMessage(cmd);
    }

    public int fireAllRules(AgendaFilter agendaFilter, int max) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new FireAllRulesCommand(agendaFilter, max), null, null, this.instanceId, kresultsId)));
        return (Integer)this.sendMessage(cmd);
    }

    public void fireUntilHalt() {
        this.fireUntilHalt(null);
    }

    public void fireUntilHalt(AgendaFilter agendaFilter) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new FireUntilHaltCommand(agendaFilter), null, null, this.instanceId, kresultsId)));
        this.sendMessage(cmd);
    }

    public <T> T execute(Command<T> command) {
        String kresultsId = "kresults_" + this.gsd.getId();
        if (logger.isDebugEnabled()) {
            logger.debug(" ### Calling Execute from the SKS Remote Client with instanceId: " + this.instanceId);
        }
        Object result = null;
        if (command instanceof AsyncBatchExecutionCommandImpl) {
            CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new ExecuteCommand(command, false), null, null, this.instanceId, kresultsId), this.instanceId));
            ConversationUtil.sendAsyncMessage(this.cm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), cmd);
        } else {
            CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new ExecuteCommand(command, true), null, null, this.instanceId, kresultsId), this.instanceId));
            result = this.sendMessage(cmd);
            if (logger.isDebugEnabled()) {
                logger.debug(" ### Execute Method Returns: " + result);
            }
        }
        return (T)result;
    }

    public <T extends SessionClock> T getSessionClock() {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetSessionClockCommand(), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (T)((SessionClock)result);
    }

    public void setGlobal(String identifier, Object object) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand(CommandFactory.newSetGlobal((String)identifier, (Object)object), null, null, this.instanceId, kresultsId)));
        this.sendMessage(cmd);
    }

    public Object getGlobal(String identifier) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand(CommandFactory.newGetGlobal((String)identifier), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return result;
    }

    public Globals getGlobals() {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetGlobalsCommand(), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (Globals)result;
    }

    public Calendars getCalendars() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Environment getEnvironment() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public KnowledgeBase getKnowledgeBase() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void registerExitPoint(String name, ExitPoint exitPoint) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unregisterExitPoint(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void registerChannel(String name, Channel channel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unregisterChannel(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, Channel> getChannels() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public KnowledgeSessionConfiguration getSessionConfiguration() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void halt() {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new HaltCommand(), null, null, this.instanceId, kresultsId)));
        this.sendMessage(cmd);
    }

    public Agenda getAgenda() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetWorkingMemoryEntryPointRemoteCommand(name), null, null, this.instanceId, name, kresultsId)));
        this.sendMessage(cmd);
        return new WorkingMemoryEntryPointRemoteClient(this.instanceId, name, this.gsd, this.cm);
    }

    public Collection<? extends WorkingMemoryEntryPoint> getWorkingMemoryEntryPoints() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public QueryResults getQueryResults(String query, Object ... arguments) {
        String localId = "query_" + UUID.randomUUID().toString();
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new SetVariableCommandFromCommand("__TEMP__", localId, (Command)new KnowledgeContextResolveFromContextCommand((Command)new QueryRemoteCommand(localId, query, false, arguments), null, null, this.instanceId, kresultsId))));
        this.sendMessage(cmd);
        return new QueryResultsRemoteClient(query, this.instanceId, localId, this.gsd, this.cm);
    }

    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getEntryPointId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FactHandle insert(Object object) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new InsertObjectCommand(object, true), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (FactHandle)result;
    }

    public void retract(FactHandle handle) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand(CommandFactory.newRetract((FactHandle)handle), null, null, this.instanceId, kresultsId)));
        this.sendMessage(cmd);
    }

    public void update(FactHandle handle, Object object) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new UpdateCommand(handle, object), null, null, this.instanceId, kresultsId)));
        this.sendMessage(cmd);
    }

    public FactHandle getFactHandle(Object object) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetFactHandleCommand(object, true), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (FactHandle)result;
    }

    public Object getObject(FactHandle factHandle) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetObjectCommand(factHandle), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return result;
    }

    public Collection<Object> getObjects() {
        return this.getObjects(null);
    }

    public Collection<Object> getObjects(ObjectFilter filter) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetObjectsCommand(filter), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (Collection)result;
    }

    public <T extends FactHandle> Collection<T> getFactHandles() {
        return this.getFactHandles(null);
    }

    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetFactHandlesCommand(filter, true), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (Collection)result;
    }

    public long getFactCount() {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetFactCountCommand(), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (Long)result;
    }

    public ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new StartProcessCommand(processId, parameters), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (ProcessInstance)result;
    }

    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new CreateProcessInstanceCommand(processId, parameters), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (ProcessInstance)result;
    }

    public ProcessInstance startProcessInstance(long processInstanceId) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new StartProcessInstanceCommand(Long.valueOf(processInstanceId)), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (ProcessInstance)result;
    }

    public void signalEvent(String type, Object event) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new SignalEventCommand(type, event), null, null, this.instanceId, kresultsId)));
        this.sendMessage(cmd);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new SignalEventCommand(type, event), null, null, this.instanceId, kresultsId)));
        this.sendMessage(cmd);
    }

    public Collection<ProcessInstance> getProcessInstances() {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetProcessInstancesCommand(), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (Collection)result;
    }

    public ProcessInstance getProcessInstance(long processInstanceId) {
        String kresultsId = "kresults_" + this.gsd.getId();
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)new GetProcessInstanceCommand(Long.valueOf(processInstanceId)), null, null, this.instanceId, kresultsId)));
        Object result = this.sendMessage(cmd);
        return (ProcessInstance)result;
    }

    public void abortProcessInstance(long processInstanceId) {
        String kresultsId = "kresults_" + this.gsd.getId();
        AbortProcessInstanceCommand cmdAbort = new AbortProcessInstanceCommand();
        cmdAbort.setProcessInstanceId(Long.valueOf(processInstanceId));
        CommandImpl cmd = new CommandImpl("execute", Arrays.asList(new KnowledgeContextResolveFromContextCommand((Command)cmdAbort, null, null, this.instanceId, kresultsId)));
        this.sendMessage(cmd);
    }

    public WorkItemManager getWorkItemManager() {
        return new WorkItemManagerRemoteClient(this.instanceId, this.gsd, this.cm);
    }

    private Object sendMessage(Object body) {
        return ConversationUtil.sendMessage(this.cm, (InetSocketAddress)this.gsd.getAddresses().get("socket").getObject(), this.gsd.getId(), body, this.minWaitTime, this.timeout);
    }

    public void addEventListener(WorkingMemoryEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeEventListener(WorkingMemoryEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<WorkingMemoryEventListener> getWorkingMemoryEventListeners() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addEventListener(AgendaEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeEventListener(AgendaEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addEventListener(ProcessEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeEventListener(ProcessEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

