/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.remote.mina;

import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.drools.SystemEventListener;
import org.drools.grid.io.Message;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.io.impl.ConversationImpl;
import org.drools.grid.io.impl.ExceptionMessage;
import org.drools.grid.io.impl.RequestResponseDispatchListener;
import org.drools.grid.remote.mina.MinaIoWriter;

public class MinaIoHandler
extends IoHandlerAdapter {
    private final SystemEventListener systemEventListener;
    private MessageReceiverHandler messageHandler;
    private String senderId;
    private RequestResponseDispatchListener dispathListener;

    public MinaIoHandler(SystemEventListener systemEventListener) {
        this(systemEventListener, null);
    }

    public MinaIoHandler(SystemEventListener systemEventListener, MessageReceiverHandler messageHandler) {
        this.systemEventListener = systemEventListener;
        this.messageHandler = messageHandler;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.systemEventListener.exception("Uncaught exception on Server", cause);
    }

    public void messageReceived(IoSession session, Object object) throws Exception {
        Message msg = (Message)object;
        ConversationImpl conversation = new ConversationImpl(null, msg.getConversationId(), this.senderId, msg.getSenderId(), this.dispathListener, msg, new MinaIoWriter(session), null);
        if (msg instanceof ExceptionMessage) {
            this.messageHandler.exceptionReceived(conversation, (ExceptionMessage)msg);
        } else {
            this.messageHandler.messageReceived(conversation, msg);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        this.systemEventListener.debug("Server IDLE " + session.getIdleCount(status));
    }
}

