/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.service.directory.impl;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.grid.GridServiceDescription;
import org.drools.grid.io.ConversationManager;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.service.directory.Address;
import org.drools.grid.service.directory.impl.AddressClient;
import org.drools.grid.service.directory.impl.WhitePagesClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridServiceDescriptionClient
implements GridServiceDescription {
    private GridServiceDescription whitePagesGsd;
    private ConversationManager conversationManager;
    private String id;
    private Class serviceInterface;
    private Map<String, Address> addresses = new HashMap<String, Address>();
    private Serializable data;
    private String ownerGridId;

    public GridServiceDescriptionClient(GridServiceDescription gsd, GridServiceDescription whitePagesGsd, ConversationManager conversationManager) {
        this.id = gsd.getId();
        this.serviceInterface = gsd.getServiceInterface();
        this.addresses = new HashMap<String, Address>(gsd.getAddresses());
        this.data = gsd.getData();
        this.whitePagesGsd = whitePagesGsd;
        this.conversationManager = conversationManager;
    }

    @Override
    public Address addAddress(String transport) {
        InetSocketAddress[] sockets = (InetSocketAddress[])this.whitePagesGsd.getAddresses().get("socket").getObject();
        CommandImpl cmd = new CommandImpl("GridServiceDescription.addAddress", Arrays.asList(this.id, transport));
        Address address = (Address)WhitePagesClient.sendMessage(this.conversationManager, (Serializable)sockets, this.whitePagesGsd.getId(), cmd);
        this.addresses.put(transport, address);
        return new AddressClient(address, this.whitePagesGsd, this.conversationManager);
    }

    @Override
    public Map<String, Address> getAddresses() {
        HashMap<String, AddressClient> addresses = new HashMap<String, AddressClient>();
        for (Address address : this.addresses.values()) {
            addresses.put(address.getTransport(), new AddressClient(address, this.whitePagesGsd, this.conversationManager));
        }
        return Collections.unmodifiableMap(addresses);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void removeAddress(String transport) {
        InetSocketAddress[] sockets = (InetSocketAddress[])this.whitePagesGsd.getAddresses().get("socket").getObject();
        CommandImpl cmd = new CommandImpl("GridServiceDescription.removeAddress", Arrays.asList(this.id, transport));
        WhitePagesClient.sendMessage(this.conversationManager, (Serializable)sockets, this.whitePagesGsd.getId(), cmd);
        this.addresses.remove(transport);
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(Class cls) {
        InetSocketAddress[] sockets = (InetSocketAddress[])this.whitePagesGsd.getAddresses().get("socket").getObject();
        CommandImpl cmd = new CommandImpl("GridServiceDescription.setServiceInterface", Arrays.asList(this.id, cls));
        WhitePagesClient.sendMessage(this.conversationManager, (Serializable)sockets, this.whitePagesGsd.getId(), cmd);
        this.serviceInterface = cls;
    }

    public boolean equals(Object obj) {
        GridServiceDescription other = (GridServiceDescription)obj;
        return this.getId().equals(other.getId());
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.whitePagesGsd != null ? this.whitePagesGsd.hashCode() : 0);
        hash = 47 * hash + (this.conversationManager != null ? this.conversationManager.hashCode() : 0);
        hash = 47 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    @Override
    public Serializable getData() {
        InetSocketAddress[] sockets = (InetSocketAddress[])this.whitePagesGsd.getAddresses().get("socket").getObject();
        CommandImpl cmd = new CommandImpl("GridServiceDescription.getData", null);
        Serializable data = (Serializable)WhitePagesClient.sendMessage(this.conversationManager, (Serializable)sockets, this.whitePagesGsd.getId(), cmd);
        return data;
    }

    @Override
    public void setData(Serializable data) {
        InetSocketAddress[] sockets = (InetSocketAddress[])this.whitePagesGsd.getAddresses().get("socket").getObject();
        CommandImpl cmd = new CommandImpl("GridServiceDescription.setData", Arrays.asList(data));
        WhitePagesClient.sendMessage(this.conversationManager, (Serializable)sockets, this.whitePagesGsd.getId(), cmd);
    }

    @Override
    public String getOwnerGridId() {
        return this.ownerGridId;
    }

    @Override
    public void setOwnerGridId(String ownerGridId) {
        this.ownerGridId = ownerGridId;
    }
}

