/*
 * Decompiled with CFR 0.152.
 */
package org.drools.grid.timer.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.grid.io.Conversation;
import org.drools.grid.io.Message;
import org.drools.grid.io.MessageReceiverHandler;
import org.drools.grid.io.impl.CommandImpl;
import org.drools.grid.io.impl.ExceptionMessage;
import org.drools.grid.timer.impl.ScheduledJob;
import org.drools.time.SchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerServer
implements MessageReceiverHandler {
    private static Logger logger = LoggerFactory.getLogger(SchedulerServer.class);
    private SchedulerService scheduler = null;
    private Map<String, Exec> execs = new HashMap<String, Exec>(){
        {
            this.put("Scheduler.scheduleJob", new Exec(){

                public void execute(Object object, Conversation con, Message msg, CommandImpl cmd) {
                    SchedulerService scheduler = (SchedulerService)object;
                    List<Object> list = cmd.getArguments();
                    scheduler.scheduleJob(((ScheduledJob)list.get(0)).getJob(), ((ScheduledJob)list.get(0)).getJobContext(), ((ScheduledJob)list.get(0)).getTrigger());
                    con.respond(((ScheduledJob)list.get(0)).getJobHandle());
                }
            });
        }
    };

    public SchedulerServer(SchedulerService scheduler) {
        this.scheduler = scheduler;
    }

    public void messageReceived(Conversation conversation, Message msg) {
        CommandImpl cmd = (CommandImpl)msg.getBody();
        try {
            this.execs.get(cmd.getName()).execute(this.scheduler, conversation, msg, cmd);
        }
        catch (Throwable t) {
            conversation.respondError(t);
        }
    }

    public void exceptionReceived(Conversation conversation, ExceptionMessage msg) {
        logger.error("SchedulerServer received and exception when it shouldn't");
    }

    public static interface Exec {
        public void execute(Object var1, Conversation var2, Message var3, CommandImpl var4);
    }
}

