/*
 * Decompiled with CFR 0.152.
 */
package org.drools.karaf.itest;

import java.util.ArrayList;
import java.util.Properties;
import javax.inject.Inject;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

public class KieSpringIntegrationTestSupport {
    protected static final transient Logger LOG = LoggerFactory.getLogger(KieSpringIntegrationTestSupport.class);
    protected static final String DroolsVersion;
    protected OsgiBundleXmlApplicationContext applicationContext;
    @Inject
    protected BundleContext bc;

    protected void refresh() {
        this.applicationContext.setBundleContext(this.bc);
        this.applicationContext.refresh();
    }

    public static MavenArtifactProvisionOption getFeaturesUrl(String groupId, String artifactId, String version) {
        MavenArtifactProvisionOption mapo = CoreOptions.mavenBundle().groupId(groupId).artifactId(artifactId);
        mapo.type("xml");
        mapo.classifier("features");
        if (version == null) {
            mapo.versionAsInProject();
        } else {
            mapo.version(version);
        }
        LOG.info("Features URL : " + mapo.getURL());
        return mapo;
    }

    public static UrlReference getCamelKarafFeaturesUrl(String version) {
        MavenArtifactProvisionOption mapo = KieSpringIntegrationTestSupport.getFeaturesUrl("org.apache.camel.karaf", "apache-camel", version);
        return mapo;
    }

    public static Option loadDroolsKieFeatures(String ... features) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("drools-module");
        for (String feature : features) {
            result.add(feature);
        }
        return KarafDistributionOption.features((UrlReference)KieSpringIntegrationTestSupport.getFeaturesUrl("org.drools", "drools-karaf-features", DroolsVersion), (String[])result.toArray(new String[1 + features.length]));
    }

    static {
        Properties testProps = new Properties();
        try {
            testProps.load(KieSpringIntegrationTestSupport.class.getResourceAsStream("/test.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize DroolsVersion property: " + e.getMessage(), e);
        }
        DroolsVersion = testProps.getProperty("project.version");
        LOG.info("Drools Project Version : " + DroolsVersion);
    }
}

