/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.pattern;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.visitor.DSLNode;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternConstraintParseResult;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternDSL;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternDSLSimpleConstraint;

class PatternDSLPattern
extends PatternDSL {
    protected PatternDSLPattern(RuleContext context, PackageModel packageModel, PatternDescr pattern, List<? extends BaseDescr> constraintDescrs, Class<?> patternType, boolean allConstraintsPositional) {
        super(context, packageModel, pattern, constraintDescrs, allConstraintsPositional, patternType);
    }

    @Override
    protected void buildPattern(DeclarationSpec declarationSpec, List<PatternConstraintParseResult> patternConstraintParseResults) {
        MethodCallExpr patternExpression = this.createPatternExpression(this.pattern, declarationSpec);
        ArrayList exprs = new ArrayList();
        this.context.pushExprPointer(exprs::add);
        this.buildConstraints(this.pattern, this.patternType, patternConstraintParseResults);
        this.context.popExprPointer();
        ArrayList<Expression> additionalPatterns = new ArrayList<Expression>();
        for (Expression expr : exprs) {
            Optional<Expression> rootScope = DrlxParseUtil.findRootNodeViaScope(expr);
            if (rootScope.isPresent() && ((MethodCallExpr)rootScope.get()).getNameAsString().equals("D.pattern")) {
                additionalPatterns.add(expr);
                continue;
            }
            MethodCallExpr currentExpr = (MethodCallExpr)expr;
            DrlxParseUtil.findLastMethodInChain(currentExpr).setScope((Expression)patternExpression);
            patternExpression = currentExpr;
        }
        this.context.addExpression((Expression)this.addWatchToPattern(patternExpression));
        additionalPatterns.forEach(this.context::addExpression);
    }

    @Override
    public MethodCallExpr input(DeclarationSpec declarationSpec) {
        return this.addWatchToPattern(this.createPatternExpression(this.pattern, declarationSpec));
    }

    private MethodCallExpr addWatchToPattern(MethodCallExpr patternExpression) {
        Set<String> settableWatchedProps = this.getSettableWatchedProps();
        if (!settableWatchedProps.isEmpty()) {
            patternExpression = new MethodCallExpr((Expression)patternExpression, "watch");
            settableWatchedProps.stream().map(StringLiteralExpr::new).forEach(arg_0 -> ((MethodCallExpr)patternExpression).addArgument(arg_0));
        }
        return patternExpression;
    }

    private MethodCallExpr createPatternExpression(PatternDescr pattern, DeclarationSpec declarationSpec) {
        MethodCallExpr dslExpr = new MethodCallExpr(null, "D.pattern");
        dslExpr.addArgument(this.context.getVarExpr(pattern.getIdentifier()));
        if (this.context.isQuery() && declarationSpec.getDeclarationSource().isPresent()) {
            dslExpr.addArgument(declarationSpec.getDeclarationSource().get());
        }
        return dslExpr;
    }

    private void buildConstraints(PatternDescr pattern, Class<?> patternType, List<PatternConstraintParseResult> patternConstraintParseResults) {
        for (PatternConstraintParseResult patternConstraintParseResult : patternConstraintParseResults) {
            this.buildConstraint(pattern, patternType, patternConstraintParseResult);
        }
    }

    @Override
    protected DSLNode createSimpleConstraint(DrlxParseSuccess drlxParseResult, PatternDescr pattern) {
        return new PatternDSLSimpleConstraint(this.context, pattern, drlxParseResult);
    }
}

