/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.query;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.stream.IntStream;

abstract class Generator {
    final int arity;
    static final String QUERY = "query";
    static final String STRINGLITERAL = "String";
    static final String CLASS = "Class";
    static final String VIEWBUILDER = "VIEW_BUILDER";

    Generator(int arity) {
        this.arity = arity;
    }

    String stringWithIndex(String pre, int i) {
        return pre + i;
    }

    String argNameWithIndex(int i) {
        return "arg" + i + "name";
    }

    IntStream rangeArity() {
        return IntStream.range(1, this.arity + 1);
    }

    String genericType(String typeName, String genericTypeName) {
        return typeName + "<" + genericTypeName + ">";
    }

    String typeWithIndex(int i) {
        return this.stringWithIndex("type", i);
    }

    void addPackageParameter(NodeWithParameters declaration) {
        declaration.addParameter(STRINGLITERAL, "pkg");
    }

    String genericTypeName(int i) {
        return this.stringWithIndex("T", i);
    }

    void addPkgValue(MethodCallExpr constructor) {
        constructor.addArgument("pkg");
    }

    void addViewBuilderValue(MethodCallExpr constructor) {
        constructor.addArgument("viewBuilder");
    }

    void addViewBuilderParameter(NodeWithParameters constructorDeclaration2) {
        constructorDeclaration2.addParameter("ViewBuilder", "viewBuilder");
    }

    void addNameValue(MethodCallExpr constructor) {
        constructor.addArgument("name");
    }

    String argIndex(int i) {
        return this.stringWithIndex("arg", i);
    }

    String getArgIndex(int i) {
        return this.stringWithIndex("getArg", i);
    }

    String classGenericName(int i) {
        return this.classGenericParameter(this.genericTypeName(i));
    }

    void addDefaultPackageValue(MethodCallExpr constructor) {
        constructor.addArgument("DEFAULT_PACKAGE");
    }

    void addNameParameter(NodeWithParameters constructor) {
        constructor.addParameter(STRINGLITERAL, "name");
    }

    void addOverride(MethodDeclaration method) {
        method.addAnnotation("Override");
    }

    String classGenericParameter(String genericTypeName) {
        return this.genericType(CLASS, genericTypeName);
    }

    String stringWithIndexInside(int i) {
        return "arg" + i + "name";
    }

    String genericType(String genericTypeName) {
        return "Class<" + genericTypeName + ">";
    }

    Type stringType() {
        return StaticJavaParser.parseType((String)STRINGLITERAL);
    }

    ClassOrInterfaceType queryDefImplType() {
        return StaticJavaParser.parseClassOrInterfaceType((String)("Query" + this.arity + "DefImpl<>"));
    }

    ClassOrInterfaceType queryDefType() {
        return StaticJavaParser.parseClassOrInterfaceType((String)("Query" + this.arity + "Def"));
    }
}

