/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor;

import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.CollectDescr;
import org.drools.compiler.lang.descr.ConditionalBranchDescr;
import org.drools.compiler.lang.descr.ConditionalElementDescr;
import org.drools.compiler.lang.descr.DescrVisitor;
import org.drools.compiler.lang.descr.EvalDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.ForallDescr;
import org.drools.compiler.lang.descr.FromDescr;
import org.drools.compiler.lang.descr.NamedConsequenceDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.OrDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.PatternSourceDescr;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.visitor.AccumulateVisitor;
import org.drools.modelcompiler.builder.generator.visitor.AndVisitor;
import org.drools.modelcompiler.builder.generator.visitor.ConditionalElementVisitor;
import org.drools.modelcompiler.builder.generator.visitor.EvalVisitor;
import org.drools.modelcompiler.builder.generator.visitor.FromCollectVisitor;
import org.drools.modelcompiler.builder.generator.visitor.FromVisitor;
import org.drools.modelcompiler.builder.generator.visitor.NamedConsequenceVisitor;
import org.drools.modelcompiler.builder.generator.visitor.OrVisitor;
import org.drools.modelcompiler.builder.generator.visitor.PatternVisitor;

public class ModelGeneratorVisitor
implements DescrVisitor {
    private final AccumulateVisitor accumulateVisitor;
    private final AndVisitor andVisitor;
    private final ConditionalElementVisitor conditionalElementVisitor;
    private final OrVisitor orVisitor;
    private final EvalVisitor evalVisitor;
    private final FromVisitor fromVisitor;
    private final NamedConsequenceVisitor namedConsequenceVisitor;
    private final PatternVisitor patternVisitor;
    private final FromCollectVisitor fromCollectVisitor;

    public ModelGeneratorVisitor(RuleContext context, PackageModel packageModel) {
        this.accumulateVisitor = new AccumulateVisitor(this, context, packageModel);
        this.andVisitor = new AndVisitor(this, context);
        this.conditionalElementVisitor = new ConditionalElementVisitor(context, this);
        this.orVisitor = new OrVisitor(this, context);
        this.evalVisitor = new EvalVisitor(context, packageModel);
        this.fromVisitor = new FromVisitor(context, packageModel);
        this.namedConsequenceVisitor = new NamedConsequenceVisitor(context, packageModel);
        this.patternVisitor = new PatternVisitor(context, packageModel);
        this.fromCollectVisitor = new FromCollectVisitor(this);
    }

    public void visit(BaseDescr descr) {
        throw new UnsupportedOperationException("Unknown descr" + descr);
    }

    public void visit(AccumulateDescr descr) {
        throw new UnsupportedOperationException("AccumulateDescr are always nested in pattern and need their context anyway");
    }

    public void visit(AndDescr descr) {
        this.andVisitor.visit(descr);
    }

    public void visit(NotDescr descr) {
        this.conditionalElementVisitor.visit((ConditionalElementDescr)descr, "not");
    }

    public void visit(ExistsDescr descr) {
        this.conditionalElementVisitor.visit((ConditionalElementDescr)descr, "exists");
    }

    public void visit(ForallDescr descr) {
        this.conditionalElementVisitor.visit((ConditionalElementDescr)descr, "forall");
    }

    public void visit(OrDescr descr) {
        this.orVisitor.visit((ConditionalElementDescr)descr, "or");
    }

    public void visit(EvalDescr descr) {
        this.evalVisitor.visit(descr);
    }

    public void visit(FromDescr descr) {
        this.fromVisitor.visit((PatternSourceDescr)descr);
    }

    public void visit(NamedConsequenceDescr descr) {
        this.namedConsequenceVisitor.visit(descr);
    }

    public void visit(ConditionalBranchDescr descr) {
        this.namedConsequenceVisitor.visit(descr);
    }

    public void visit(PatternDescr descr) {
        PatternSourceDescr patternSource = descr.getSource();
        if (patternSource != null && patternSource instanceof CollectDescr) {
            this.fromCollectVisitor.trasformFromCollectToCollectList(descr, (CollectDescr)patternSource);
        } else {
            this.patternVisitor.visit(descr);
            if (descr.getSource() instanceof AccumulateDescr) {
                this.accumulateVisitor.visit((AccumulateDescr)descr.getSource(), descr);
            }
        }
    }
}

