/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.appformer.maven.support.DependencyFilter;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBaseUpdateContext;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kie.util.KieJarChangeSet;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.common.ResourceProvider;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.util.IoUtils;
import org.drools.model.Model;
import org.drools.model.NamedModelItem;
import org.drools.model.impl.ModelComponent;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.drools.modelcompiler.KiePackagesBuilder;
import org.drools.modelcompiler.builder.CanonicalKieBaseUpdater;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.drools.modelcompiler.util.StringUtil;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;

public class CanonicalKieModule
implements InternalKieModule {
    public static final String MODEL_FILE = "META-INF/kie/drools-model";
    private final InternalKieModule internalKieModule;
    private Collection<String> ruleClassesNames;
    private final Map<String, CanonicalKiePackages> pkgsInKbase = new HashMap<String, CanonicalKiePackages>();
    private final Map<String, Model> models = new HashMap<String, Model>();
    private ProjectClassLoader moduleClassLoader;

    public CanonicalKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file) {
        this(releaseId, kieProject, file, null);
    }

    public CanonicalKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file, Collection<String> ruleClassesNames) {
        this((InternalKieModule)(file.isDirectory() ? new FileKieModule(releaseId, kieProject, file) : new ZipKieModule(releaseId, kieProject, file)), ruleClassesNames);
    }

    public CanonicalKieModule(InternalKieModule internalKieModule) {
        this(internalKieModule, null);
    }

    public CanonicalKieModule(InternalKieModule internalKieModule, Collection<String> ruleClassesNames) {
        this.internalKieModule = internalKieModule;
        this.ruleClassesNames = ruleClassesNames;
    }

    public Map<String, byte[]> getClassesMap(boolean includeTypeDeclarations) {
        return this.internalKieModule.getClassesMap(true);
    }

    public ResultsImpl build() {
        return new ResultsImpl();
    }

    public InternalKnowledgeBase createKieBase(KieBaseModelImpl kBaseModel, KieProject kieProject, ResultsImpl messages, KieBaseConfiguration conf) {
        this.moduleClassLoader = (ProjectClassLoader)kieProject.getClassLoader();
        KieBaseConfiguration kBaseConf = CanonicalKieModule.getKieBaseConfiguration(kBaseModel, (ClassLoader)this.moduleClassLoader, conf);
        CanonicalKiePackages kpkgs = this.pkgsInKbase.computeIfAbsent(kBaseModel.getName(), k -> this.createKiePackages(kBaseModel, kBaseConf));
        return new KieBaseBuilder(kBaseModel, kBaseConf).createKieBase(kpkgs);
    }

    private CanonicalKiePackages createKiePackages(KieBaseModelImpl kBaseModel, KieBaseConfiguration conf) {
        return new KiePackagesBuilder(conf, this.getModelForKBase(kBaseModel), this.moduleClassLoader).build();
    }

    public CanonicalKiePackages getKiePackages(KieBaseModelImpl kBaseModel) {
        return this.pkgsInKbase.computeIfAbsent(kBaseModel.getName(), k -> this.createKiePackages(kBaseModel, CanonicalKieModule.getKnowledgeBaseConfiguration(kBaseModel, (ClassLoader)this.getModuleClassLoader())));
    }

    public ProjectClassLoader getModuleClassLoader() {
        if (this.moduleClassLoader == null) {
            this.moduleClassLoader = this.createModuleClassLoader(null);
            this.moduleClassLoader.storeClasses(this.getClassesMap(true));
        }
        return this.moduleClassLoader;
    }

    public void setModuleClassLoader(ProjectClassLoader moduleClassLoader) {
        this.pkgsInKbase.clear();
        this.models.clear();
        this.moduleClassLoader = moduleClassLoader;
    }

    private Map<String, Model> getModels() {
        if (this.models.isEmpty()) {
            for (String rulesFile : this.getRuleClassNames()) {
                Model model = (Model)CanonicalKieModule.createInstance((ClassLoader)this.getModuleClassLoader(), rulesFile);
                this.models.put(model.getName(), model);
            }
        }
        return this.models;
    }

    private Collection<String> getRuleClassNames() {
        if (this.ruleClassesNames == null) {
            this.ruleClassesNames = CanonicalKieModule.findRuleClassesNames((ClassLoader)this.getModuleClassLoader());
        }
        return this.ruleClassesNames;
    }

    private Collection<Model> getModelForKBase(KieBaseModelImpl kBaseModel) {
        Map<String, Model> modelsMap = this.getModels();
        if (kBaseModel.getPackages().isEmpty()) {
            return modelsMap.values();
        }
        ArrayList<Model> models = new ArrayList<Model>();
        for (String pkg : kBaseModel.getPackages()) {
            if (pkg.equals("*")) {
                return modelsMap.values();
            }
            Model model = modelsMap.get(pkg);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    private static Collection<String> findRuleClassesNames(ClassLoader kieProjectCL) {
        String modelFiles;
        try {
            modelFiles = new String(IoUtils.readBytesFromInputStream((InputStream)kieProjectCL.getResourceAsStream(MODEL_FILE)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Arrays.asList(modelFiles.split("\n"));
    }

    private static <T> T createInstance(ClassLoader cl, String className) {
        try {
            return (T)cl.loadClass(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public KieJarChangeSet getChanges(InternalKieModule newKieModule) {
        KieJarChangeSet result = new KieJarChangeSet();
        this.findChanges(result, newKieModule);
        Map<String, Model> oldModels = this.getModels();
        Map<String, Model> newModels = ((CanonicalKieModule)newKieModule).getModels();
        for (Map.Entry<String, Model> entry : oldModels.entrySet()) {
            Model oldModel;
            ResourceChangeSet changeSet;
            Model newModel = newModels.get(entry.getKey());
            if (newModel == null || (changeSet = this.calculateResourceChangeSet(oldModel = entry.getValue(), newModel)).getChanges().isEmpty()) continue;
            result.registerChanges(entry.getKey(), changeSet);
        }
        return result;
    }

    private void findChanges(KieJarChangeSet result, InternalKieModule newKieModule) {
        Collection<String> oldFiles = this.getFileNames();
        Collection newFiles = newKieModule.getFileNames();
        ArrayList<String> removedFiles = new ArrayList<String>(oldFiles);
        removedFiles.removeAll(newFiles);
        if (!removedFiles.isEmpty()) {
            for (String file : removedFiles) {
                if (!this.isChange(file, this)) continue;
                result.removeFile(file);
            }
        }
        for (String file : newFiles) {
            if (oldFiles.contains(file) && this.isChange(file, this)) {
                byte[] newBytes;
                byte[] oldBytes = this.getBytes(file);
                if (Arrays.equals(oldBytes, newBytes = newKieModule.getBytes(file))) continue;
                result.registerChanges(file, new ResourceChangeSet(file, ChangeType.UPDATED));
                continue;
            }
            if (!this.isChange(file, (CanonicalKieModule)newKieModule)) continue;
            result.addFile(file);
        }
    }

    private boolean isChange(String fileName, CanonicalKieModule module) {
        return fileName.endsWith(".class") && !module.getRuleClassNames().contains(StringUtil.fileNameToClass(fileName));
    }

    private ResourceChangeSet calculateResourceChangeSet(Model oldModel, Model newModel) {
        ResourceChangeSet changeSet = new ResourceChangeSet(oldModel.getName(), ChangeType.UPDATED);
        this.addModifiedItemsToChangeSet(changeSet, ResourceChange.Type.RULE, oldModel.getRules(), newModel.getRules());
        this.addModifiedItemsToChangeSet(changeSet, ResourceChange.Type.RULE, oldModel.getQueries(), newModel.getQueries());
        this.addModifiedItemsToChangeSet(changeSet, ResourceChange.Type.GLOBAL, oldModel.getGlobals(), newModel.getGlobals());
        return changeSet;
    }

    private void addModifiedItemsToChangeSet(ResourceChangeSet changeSet, ResourceChange.Type type, List<? extends NamedModelItem> oldItems, List<? extends NamedModelItem> newItems) {
        if (oldItems.isEmpty()) {
            if (!newItems.isEmpty()) {
                for (NamedModelItem namedModelItem : newItems) {
                    changeSet.getChanges().add(new ResourceChange(ChangeType.ADDED, type, namedModelItem.getName()));
                }
            }
            return;
        }
        if (newItems.isEmpty()) {
            for (NamedModelItem namedModelItem : oldItems) {
                changeSet.getChanges().add(new ResourceChange(ChangeType.REMOVED, type, namedModelItem.getName()));
            }
            return;
        }
        oldItems.sort(Comparator.comparing(NamedModelItem::getName));
        newItems.sort(Comparator.comparing(NamedModelItem::getName));
        Iterator<? extends NamedModelItem> oldRulesIterator = oldItems.iterator();
        Iterator<? extends NamedModelItem> iterator = newItems.iterator();
        NamedModelItem currentOld = oldRulesIterator.next();
        NamedModelItem currentNew = iterator.next();
        while (true) {
            int compare;
            if ((compare = currentOld.getName().compareTo(currentNew.getName())) == 0) {
                if (!ModelComponent.areEqualInModel((Object)currentOld, (Object)currentNew)) {
                    changeSet.getChanges().add(new ResourceChange(ChangeType.UPDATED, type, currentOld.getName()));
                }
                if (!oldRulesIterator.hasNext()) break;
                currentOld = oldRulesIterator.next();
                if (!iterator.hasNext()) break;
                currentNew = iterator.next();
                continue;
            }
            if (compare < 0) {
                changeSet.getChanges().add(new ResourceChange(ChangeType.REMOVED, type, currentOld.getName()));
                if (!oldRulesIterator.hasNext()) break;
                currentOld = oldRulesIterator.next();
                continue;
            }
            changeSet.getChanges().add(new ResourceChange(ChangeType.ADDED, type, currentNew.getName()));
            if (!iterator.hasNext()) break;
            currentNew = iterator.next();
        }
        while (oldRulesIterator.hasNext()) {
            changeSet.getChanges().add(new ResourceChange(ChangeType.REMOVED, type, oldRulesIterator.next().getName()));
        }
        while (iterator.hasNext()) {
            changeSet.getChanges().add(new ResourceChange(ChangeType.ADDED, type, iterator.next().getName()));
        }
    }

    public Runnable createKieBaseUpdater(KieBaseUpdateContext context) {
        return new CanonicalKieBaseUpdater(context);
    }

    private static KieBaseConfiguration getKieBaseConfiguration(KieBaseModelImpl kBaseModel, ClassLoader cl, KieBaseConfiguration conf) {
        if (conf == null) {
            conf = CanonicalKieModule.getKnowledgeBaseConfiguration(kBaseModel, cl);
        } else if (conf instanceof RuleBaseConfiguration) {
            ((RuleBaseConfiguration)conf).setClassLoader(cl);
        }
        return conf;
    }

    private static KieBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModelImpl kBaseModel, ClassLoader cl) {
        KieBaseConfiguration kbConf = KieServices.get().newKieBaseConfiguration(null, cl);
        if (kBaseModel != null) {
            kbConf.setOption((KieBaseOption)kBaseModel.getEqualsBehavior());
            kbConf.setOption((KieBaseOption)kBaseModel.getEventProcessingMode());
            kbConf.setOption((KieBaseOption)kBaseModel.getDeclarativeAgenda());
        }
        return kbConf;
    }

    public void cacheKnowledgeBuilderForKieBase(String kieBaseName, KnowledgeBuilder kbuilder) {
        this.internalKieModule.cacheKnowledgeBuilderForKieBase(kieBaseName, kbuilder);
    }

    public KnowledgeBuilder getKnowledgeBuilderForKieBase(String kieBaseName) {
        return this.internalKieModule.getKnowledgeBuilderForKieBase(kieBaseName);
    }

    public Collection<KiePackage> getKnowledgePackagesForKieBase(String kieBaseName) {
        return this.internalKieModule.getKnowledgePackagesForKieBase(kieBaseName);
    }

    public void cacheResultsForKieBase(String kieBaseName, Results results) {
        this.internalKieModule.cacheResultsForKieBase(kieBaseName, results);
    }

    public Map<String, Results> getKnowledgeResultsCache() {
        return this.internalKieModule.getKnowledgeResultsCache();
    }

    public KieModuleModel getKieModuleModel() {
        return this.internalKieModule.getKieModuleModel();
    }

    public byte[] getBytes() {
        return this.internalKieModule.getBytes();
    }

    public boolean hasResource(String fileName) {
        return this.internalKieModule.hasResource(fileName);
    }

    public Resource getResource(String fileName) {
        return this.internalKieModule.getResource(fileName);
    }

    public ResourceConfiguration getResourceConfiguration(String fileName) {
        return this.internalKieModule.getResourceConfiguration(fileName);
    }

    public Map<ReleaseId, InternalKieModule> getKieDependencies() {
        return this.internalKieModule.getKieDependencies();
    }

    public void addKieDependency(InternalKieModule dependency) {
        this.internalKieModule.addKieDependency(dependency);
    }

    public Collection<ReleaseId> getJarDependencies(DependencyFilter filter) {
        return this.internalKieModule.getJarDependencies(filter);
    }

    public Collection<ReleaseId> getUnresolvedDependencies() {
        return this.internalKieModule.getUnresolvedDependencies();
    }

    public void setUnresolvedDependencies(Collection<ReleaseId> unresolvedDependencies) {
        this.internalKieModule.setUnresolvedDependencies(unresolvedDependencies);
    }

    public boolean isAvailable(String pResourceName) {
        return this.internalKieModule.isAvailable(pResourceName);
    }

    public byte[] getBytes(String pResourceName) {
        return this.internalKieModule.getBytes(pResourceName);
    }

    public Collection<String> getFileNames() {
        return this.internalKieModule.getFileNames();
    }

    public File getFile() {
        return this.internalKieModule.getFile();
    }

    public ResourceProvider createResourceProvider() {
        return this.internalKieModule.createResourceProvider();
    }

    public boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName) {
        return this.internalKieModule.addResourceToCompiler(ckbuilder, kieBaseModel, fileName);
    }

    public boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName, ResourceChangeSet rcs) {
        return this.internalKieModule.addResourceToCompiler(ckbuilder, kieBaseModel, fileName, rcs);
    }

    public long getCreationTimestamp() {
        return this.internalKieModule.getCreationTimestamp();
    }

    public InputStream getPomAsStream() {
        return this.internalKieModule.getPomAsStream();
    }

    public PomModel getPomModel() {
        return this.internalKieModule.getPomModel();
    }

    public KnowledgeBuilderConfiguration getBuilderConfiguration(KieBaseModel kBaseModel) {
        return this.internalKieModule.getBuilderConfiguration(kBaseModel);
    }

    public ReleaseId getReleaseId() {
        return this.internalKieModule.getReleaseId();
    }
}

