/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.index.IndexUtil;
import org.drools.drlx.DrlxParser;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.body.Parameter;
import org.drools.javaparser.ast.drlx.expr.DrlxExpression;
import org.drools.javaparser.ast.drlx.expr.InlineCastExpr;
import org.drools.javaparser.ast.drlx.expr.NullSafeFieldAccessExpr;
import org.drools.javaparser.ast.expr.ArrayAccessExpr;
import org.drools.javaparser.ast.expr.ArrayCreationExpr;
import org.drools.javaparser.ast.expr.BinaryExpr;
import org.drools.javaparser.ast.expr.BooleanLiteralExpr;
import org.drools.javaparser.ast.expr.CastExpr;
import org.drools.javaparser.ast.expr.CharLiteralExpr;
import org.drools.javaparser.ast.expr.DoubleLiteralExpr;
import org.drools.javaparser.ast.expr.EnclosedExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.HalfBinaryExpr;
import org.drools.javaparser.ast.expr.InstanceOfExpr;
import org.drools.javaparser.ast.expr.IntegerLiteralExpr;
import org.drools.javaparser.ast.expr.LambdaExpr;
import org.drools.javaparser.ast.expr.LiteralExpr;
import org.drools.javaparser.ast.expr.LongLiteralExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.NullLiteralExpr;
import org.drools.javaparser.ast.expr.SimpleName;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.expr.ThisExpr;
import org.drools.javaparser.ast.expr.UnaryExpr;
import org.drools.javaparser.ast.nodeTypes.NodeWithOptionalScope;
import org.drools.javaparser.ast.nodeTypes.NodeWithSimpleName;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.ExpressionStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.PrimitiveType;
import org.drools.javaparser.ast.type.ReferenceType;
import org.drools.javaparser.ast.type.Type;
import org.drools.javaparser.ast.type.UnknownType;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.util.ClassUtil;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class DrlxParseUtil {
    public static final NameExpr _THIS_EXPR = new NameExpr("_this");

    public static IndexUtil.ConstraintType toConstraintType(BinaryExpr.Operator operator) {
        switch (operator) {
            case EQUALS: {
                return IndexUtil.ConstraintType.EQUAL;
            }
            case NOT_EQUALS: {
                return IndexUtil.ConstraintType.NOT_EQUAL;
            }
            case GREATER: {
                return IndexUtil.ConstraintType.GREATER_THAN;
            }
            case GREATER_EQUALS: {
                return IndexUtil.ConstraintType.GREATER_OR_EQUAL;
            }
            case LESS: {
                return IndexUtil.ConstraintType.LESS_THAN;
            }
            case LESS_EQUALS: {
                return IndexUtil.ConstraintType.LESS_OR_EQUAL;
            }
        }
        return IndexUtil.ConstraintType.UNKNOWN;
    }

    public static TypedExpression toTypedExpression(RuleContext context, PackageModel packageModel, Class<?> patternType, Expression drlxExpr, List<String> usedDeclarations, Set<String> reactOnProperties, Expression parentExpression, boolean isPositional) {
        Class<?> typeCursor = patternType;
        if (drlxExpr instanceof EnclosedExpr) {
            drlxExpr = ((EnclosedExpr)drlxExpr).getInner();
        }
        if (drlxExpr instanceof UnaryExpr) {
            UnaryExpr unaryExpr = (UnaryExpr)drlxExpr;
            TypedExpression typedExpr = DrlxParseUtil.toTypedExpression(context, packageModel, patternType, unaryExpr.getExpression(), usedDeclarations, reactOnProperties, (Expression)unaryExpr, isPositional);
            return new TypedExpression((Expression)new UnaryExpr(typedExpr.getExpression(), unaryExpr.getOperator()), typedExpr.getType());
        }
        if (drlxExpr instanceof BinaryExpr) {
            BinaryExpr binaryExpr = (BinaryExpr)drlxExpr;
            BinaryExpr.Operator operator = binaryExpr.getOperator();
            TypedExpression left = DrlxParseUtil.toTypedExpression(context, packageModel, patternType, binaryExpr.getLeft(), usedDeclarations, reactOnProperties, (Expression)binaryExpr, isPositional);
            TypedExpression right = DrlxParseUtil.toTypedExpression(context, packageModel, patternType, binaryExpr.getRight(), usedDeclarations, reactOnProperties, (Expression)binaryExpr, isPositional);
            BinaryExpr combo = new BinaryExpr(left.getExpression(), right.getExpression(), operator);
            return new TypedExpression((Expression)combo, left.getType());
        }
        if (drlxExpr instanceof HalfBinaryExpr) {
            HalfBinaryExpr halfBinaryExpr = (HalfBinaryExpr)drlxExpr;
            Expression parentLeft = DrlxParseUtil.findLeftLeafOfNameExpr(parentExpression);
            BinaryExpr.Operator operator = DrlxParseUtil.toBinaryExprOperator(halfBinaryExpr.getOperator());
            TypedExpression left = DrlxParseUtil.toTypedExpression(context, packageModel, patternType, parentLeft, usedDeclarations, reactOnProperties, (Expression)halfBinaryExpr, isPositional);
            TypedExpression right = DrlxParseUtil.toTypedExpression(context, packageModel, patternType, halfBinaryExpr.getRight(), usedDeclarations, reactOnProperties, (Expression)halfBinaryExpr, isPositional);
            BinaryExpr combo = new BinaryExpr(left.getExpression(), right.getExpression(), operator);
            return new TypedExpression((Expression)combo, left.getType());
        }
        if (drlxExpr instanceof LiteralExpr) {
            return new TypedExpression(drlxExpr, DrlxParseUtil.getLiteralExpressionType((LiteralExpr)drlxExpr));
        }
        if (drlxExpr instanceof ThisExpr) {
            return new TypedExpression((Expression)new NameExpr("_this"), patternType);
        }
        if (drlxExpr instanceof CastExpr) {
            CastExpr castExpr = (CastExpr)drlxExpr;
            return new TypedExpression((Expression)castExpr, DrlxParseUtil.getClassFromContext(context.getPkg().getTypeResolver(), castExpr.getType().asString()));
        }
        if (drlxExpr instanceof NameExpr) {
            TypedExpression expression;
            String name = drlxExpr.toString();
            Optional<DeclarationSpec> decl = context.getDeclarationById(name);
            if (decl.isPresent()) {
                usedDeclarations.add(name);
                return new TypedExpression(drlxExpr, decl.get().getDeclarationClass());
            }
            if (context.getQueryParameters().stream().anyMatch(qp -> qp.name.equals(name))) {
                usedDeclarations.add(name);
                return new TypedExpression(drlxExpr);
            }
            if (packageModel.getGlobals().containsKey(name)) {
                NameExpr plusThis = new NameExpr(name);
                usedDeclarations.add(name);
                return new TypedExpression((Expression)plusThis, packageModel.getGlobals().get(name));
            }
            try {
                expression = DrlxParseUtil.nameExprToMethodCallExpr(name, typeCursor, null);
            }
            catch (IllegalArgumentException e) {
                if (isPositional || context.getQueryName().isPresent()) {
                    String unificationVariable = context.getOrCreateUnificationId(name);
                    TypedExpression expression2 = new TypedExpression(unificationVariable, typeCursor, name);
                    return expression2;
                }
                return null;
            }
            reactOnProperties.add(name);
            Expression plusThis = DrlxParseUtil.prepend((Expression)new NameExpr("_this"), expression.getExpression());
            return new TypedExpression(plusThis, expression.getType(), name);
        }
        if (drlxExpr instanceof FieldAccessExpr || drlxExpr instanceof MethodCallExpr) {
            return DrlxParseUtil.toTypedExpressionFromMethodCallOrField(context, patternType, drlxExpr, usedDeclarations, reactOnProperties, context.getPkg().getTypeResolver());
        }
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypedExpression toTypedExpressionFromMethodCallOrField(RuleContext context, Class<?> patternType, Expression drlxExpr, Collection<String> usedDeclarations, Set<String> reactOnProperties, TypeResolver typeResolver) {
        NameExpr previous;
        Class<?> typeCursor = patternType;
        List<Node> childNodes = DrlxParseUtil.flattenScope(drlxExpr);
        Node firstNode = childNodes.get(0);
        boolean isInLineCast = firstNode instanceof InlineCastExpr;
        if (isInLineCast) {
            InlineCastExpr inlineCast = (InlineCastExpr)firstNode;
            try {
                typeCursor = typeResolver.resolveType(inlineCast.getType().toString());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            firstNode = inlineCast.getExpression();
        }
        if (firstNode instanceof NameExpr) {
            NameExpr firstNodeName = (NameExpr)firstNode;
            String firstName = firstNodeName.getName().getIdentifier();
            Optional<DeclarationSpec> declarationById = context.getDeclarationById(firstName);
            if (declarationById.isPresent()) {
                usedDeclarations.add(firstName);
                if (!isInLineCast) {
                    typeCursor = declarationById.get().getDeclarationClass();
                }
                previous = new NameExpr(firstName);
            } else {
                Method firstAccessor;
                Optional<Object> backReference = Optional.empty();
                if (firstNodeName.getBackReferencesCount() > 0) {
                    List<DeclarationSpec> ooPathDeclarations = context.getOOPathDeclarations();
                    DeclarationSpec backReferenceDeclaration = ooPathDeclarations.get(ooPathDeclarations.size() - 1 - firstNodeName.getBackReferencesCount());
                    typeCursor = backReferenceDeclaration.getDeclarationClass();
                    backReference = Optional.of(backReferenceDeclaration);
                    usedDeclarations.add(backReferenceDeclaration.getBindingId());
                }
                if ((firstAccessor = ClassUtils.getAccessor((Class)(!isInLineCast ? typeCursor : patternType), (String)firstName)) == null) throw new UnsupportedOperationException("firstNode I don't know about");
                if (!"".equals(firstName) && Character.isLowerCase(firstName.charAt(0))) {
                    reactOnProperties.add(firstName);
                }
                if (!isInLineCast) {
                    typeCursor = firstAccessor.getReturnType();
                }
                NameExpr thisAccessor = new NameExpr("_this");
                NameExpr scope = backReference.map(d -> new NameExpr(d.getBindingId())).orElse(thisAccessor);
                previous = new MethodCallExpr((Expression)scope, firstAccessor.getName());
            }
        } else if (firstNode instanceof ThisExpr) {
            previous = new NameExpr("_this");
            if (childNodes.size() > 1 && !isInLineCast) {
                SimpleName fieldName = null;
                if (childNodes.get(1) instanceof NameExpr) {
                    fieldName = ((NameExpr)childNodes.get(1)).getName();
                } else if (childNodes.get(1) instanceof SimpleName) {
                    fieldName = (SimpleName)childNodes.get(1);
                }
                if (fieldName != null) {
                    reactOnProperties.add(DrlxParseUtil.getFieldName(drlxExpr, fieldName));
                }
            }
        } else if (firstNode instanceof FieldAccessExpr && ((FieldAccessExpr)firstNode).getScope() instanceof ThisExpr) {
            String firstName = ((FieldAccessExpr)firstNode).getName().getIdentifier();
            Method firstAccessor = ClassUtils.getAccessor((Class)typeCursor, (String)firstName);
            if (firstAccessor == null) throw new UnsupportedOperationException("firstNode I don't know about");
            reactOnProperties.add(firstName);
            typeCursor = firstAccessor.getReturnType();
            previous = new MethodCallExpr((Expression)new NameExpr("_this"), firstAccessor.getName());
        } else {
            if (firstNode instanceof SimpleName) {
                previous = new NameExpr("_this");
                SimpleName fieldName = (SimpleName)firstNode;
                String name = DrlxParseUtil.getFieldName(drlxExpr, fieldName);
                reactOnProperties.add(name);
                TypedExpression expression = DrlxParseUtil.nameExprToMethodCallExpr(name, typeCursor, null);
                Expression plusThis = DrlxParseUtil.prepend((Expression)new NameExpr("_this"), expression.getExpression());
                if (childNodes.size() == 1) return new TypedExpression(plusThis, expression.getType());
                throw new UnsupportedOperationException("then the below should not be a return");
            }
            if (firstNode instanceof MethodCallExpr) {
                MethodCallExpr methodCallExpr = (MethodCallExpr)firstNode;
                previous = new NameExpr("_this");
                methodCallExpr.setScope((Expression)previous);
                typeCursor = DrlxParseUtil.returnTypeOfMethodCallExpr(context, typeResolver, methodCallExpr, typeCursor, usedDeclarations);
                previous = methodCallExpr;
            } else {
                if (!(firstNode instanceof StringLiteralExpr)) throw new UnsupportedOperationException("Unknown node: " + firstNode);
                typeCursor = String.class;
                previous = (StringLiteralExpr)firstNode;
            }
        }
        childNodes = childNodes.subList(1, childNodes.size());
        TypedExpression typedExpression = new TypedExpression();
        if (isInLineCast) {
            ClassOrInterfaceType castType = JavaParser.parseClassOrInterfaceType((String)typeCursor.getName());
            typedExpression.setPrefixExpression((Expression)new InstanceOfExpr((Expression)previous, (ReferenceType)castType));
            previous = new EnclosedExpr((Expression)new CastExpr((Type)castType, (Expression)previous));
        }
        if (drlxExpr instanceof NullSafeFieldAccessExpr) {
            typedExpression.setPrefixExpression((Expression)new BinaryExpr((Expression)previous, (Expression)new NullLiteralExpr(), BinaryExpr.Operator.NOT_EQUALS));
        }
        for (Node part : childNodes) {
            if (typeCursor.isEnum()) {
                previous = drlxExpr;
                continue;
            }
            if (part instanceof SimpleName) {
                String field = part.toString();
                TypedExpression expression = DrlxParseUtil.nameExprToMethodCallExpr(field, typeCursor, (Expression)previous);
                typeCursor = expression.getType();
                previous = expression.getExpression();
                continue;
            }
            if (!(part instanceof MethodCallExpr)) throw new UnsupportedOperationException();
            MethodCallExpr methodCallExprPart = (MethodCallExpr)part;
            typeCursor = DrlxParseUtil.returnTypeOfMethodCallExpr(context, typeResolver, (MethodCallExpr)part, typeCursor, usedDeclarations);
            methodCallExprPart.setScope((Expression)previous);
            previous = methodCallExprPart;
        }
        return typedExpression.setExpression((Expression)previous).setType(typeCursor);
    }

    private static Expression findLeftLeafOfNameExpr(Expression expression) {
        if (expression instanceof BinaryExpr) {
            BinaryExpr be = (BinaryExpr)expression;
            return DrlxParseUtil.findLeftLeafOfNameExpr(be.getLeft());
        }
        if (expression instanceof NameExpr) {
            return expression;
        }
        throw new UnsupportedOperationException("Unknown expression: " + expression);
    }

    public static Expression findLeftLeafOfMethodCall(Expression expression) {
        if (expression instanceof BinaryExpr) {
            BinaryExpr be = (BinaryExpr)expression;
            return DrlxParseUtil.findLeftLeafOfMethodCall(be.getLeft());
        }
        if (expression instanceof MethodCallExpr) {
            return expression;
        }
        throw new UnsupportedOperationException("Unknown expression: " + expression);
    }

    private static BinaryExpr.Operator toBinaryExprOperator(HalfBinaryExpr.Operator operator) {
        return BinaryExpr.Operator.valueOf((String)operator.name());
    }

    private static List<Node> flattenScope(Expression expressionWithScope) {
        ArrayList<Node> res = new ArrayList<Node>();
        if (expressionWithScope instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)expressionWithScope;
            res.addAll(DrlxParseUtil.flattenScope(fieldAccessExpr.getScope()));
            res.add((Node)fieldAccessExpr.getName());
        } else if (expressionWithScope instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)expressionWithScope;
            if (methodCallExpr.getScope().isPresent()) {
                res.addAll(DrlxParseUtil.flattenScope((Expression)methodCallExpr.getScope().get()));
            }
            res.add((Node)methodCallExpr.setScope(null));
        } else {
            res.add((Node)expressionWithScope);
        }
        return res;
    }

    private static String getFieldName(Expression drlxExpr, SimpleName fieldName) {
        String name;
        if (drlxExpr instanceof MethodCallExpr && (name = ClassUtils.getter2property((String)fieldName.getIdentifier())) != null) {
            return name;
        }
        return fieldName.getIdentifier();
    }

    public static TypedExpression nameExprToMethodCallExpr(String name, Class<?> clazz, Expression scope) {
        Method accessor = ClassUtils.getAccessor(clazz, (String)name);
        if (accessor != null) {
            MethodCallExpr body = new MethodCallExpr(scope, accessor.getName());
            return new TypedExpression((Expression)body, accessor.getReturnType());
        }
        try {
            Field field = clazz.getField(name);
            FieldAccessExpr expr = new FieldAccessExpr(scope, name);
            return new TypedExpression((Expression)expr, field.getType());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Unknown field " + name + " on " + clazz);
        }
    }

    public static Class<?> returnTypeOfMethodCallExpr(RuleContext context, TypeResolver typeResolver, MethodCallExpr methodCallExpr, Class<?> clazz, Collection<String> usedDeclarations) {
        Class[] argsType = (Class[])methodCallExpr.getArguments().stream().map(e -> DrlxParseUtil.getExpressionType(context, typeResolver, e, usedDeclarations)).toArray(Class[]::new);
        return ClassUtil.findMethod(clazz, methodCallExpr.getNameAsString(), argsType).getReturnType();
    }

    public static Class<?> getExpressionType(RuleContext context, TypeResolver typeResolver, Expression expr, Collection<String> usedDeclarations) {
        if (expr instanceof LiteralExpr) {
            return DrlxParseUtil.getLiteralExpressionType((LiteralExpr)expr);
        }
        if (expr instanceof ArrayAccessExpr) {
            return DrlxParseUtil.getClassFromContext(typeResolver, ((ArrayCreationExpr)((ArrayAccessExpr)expr).getName()).getElementType().asString());
        }
        if (expr instanceof ArrayCreationExpr) {
            return DrlxParseUtil.getClassFromContext(typeResolver, ((ArrayCreationExpr)expr).getElementType().asString());
        }
        if (expr instanceof NameExpr) {
            String name = ((NameExpr)expr).getNameAsString();
            if (usedDeclarations != null) {
                usedDeclarations.add(name);
            }
            return context.getDeclarationById(name).map(DeclarationSpec::getDeclarationClass).get();
        }
        if (expr instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)expr;
            Class<?> scopeType = DrlxParseUtil.getExpressionType(context, typeResolver, (Expression)methodCallExpr.getScope().get(), usedDeclarations);
            return DrlxParseUtil.returnTypeOfMethodCallExpr(context, typeResolver, methodCallExpr, scopeType, usedDeclarations);
        }
        throw new RuntimeException("Unknown expression type: " + expr);
    }

    public static Class<?> getLiteralExpressionType(LiteralExpr expr) {
        if (expr instanceof BooleanLiteralExpr) {
            return Boolean.class;
        }
        if (expr instanceof CharLiteralExpr) {
            return Character.class;
        }
        if (expr instanceof DoubleLiteralExpr) {
            return Double.class;
        }
        if (expr instanceof IntegerLiteralExpr) {
            return Integer.class;
        }
        if (expr instanceof LongLiteralExpr) {
            return Long.class;
        }
        if (expr instanceof NullLiteralExpr) {
            return ClassUtil.NullType.class;
        }
        if (expr instanceof StringLiteralExpr) {
            return String.class;
        }
        throw new RuntimeException("Unknown literal: " + expr);
    }

    public static Expression prepend(Expression scope, Expression expr) {
        Optional<Expression> rootNode = DrlxParseUtil.findRootNode(expr);
        if (!rootNode.isPresent()) {
            throw new UnsupportedOperationException("No root found");
        }
        rootNode.map(f -> {
            if (f instanceof NodeWithOptionalScope) {
                ((NodeWithOptionalScope)f).setScope(scope);
            }
            return f;
        });
        return expr;
    }

    public static Optional<Expression> findRootNode(Expression expr) {
        if (expr instanceof NodeWithOptionalScope) {
            NodeWithOptionalScope exprWithScope = (NodeWithOptionalScope)expr;
            return exprWithScope.getScope().map(DrlxParseUtil::findRootNode).orElse(Optional.of(expr));
        }
        if (expr instanceof NameExpr) {
            return Optional.of(expr);
        }
        return Optional.empty();
    }

    public static RemoveRootNodeResult removeRootNode(Expression expr) {
        Optional<Expression> rootNode = DrlxParseUtil.findRootNode(expr);
        if (rootNode.isPresent()) {
            Expression root = rootNode.get();
            Optional parent = root.getParentNode();
            parent.ifPresent(p -> p.remove((Node)root));
            return new RemoveRootNodeResult(rootNode, parent.orElse(expr));
        }
        return new RemoveRootNodeResult(rootNode, expr);
    }

    public static String toVar(String key) {
        return "var_" + key;
    }

    public static BlockStmt parseBlock(String ruleConsequenceAsBlock) {
        return JavaParser.parseBlock((String)String.format("{\n%s\n}", ruleConsequenceAsBlock));
    }

    public static Expression generateLambdaWithoutParameters(Collection<String> usedDeclarations, Expression expr) {
        return DrlxParseUtil.generateLambdaWithoutParameters(usedDeclarations, expr, false);
    }

    public static Expression generateLambdaWithoutParameters(Collection<String> usedDeclarations, Expression expr, boolean skipFirstParamAsThis) {
        LambdaExpr lambdaExpr = new LambdaExpr();
        lambdaExpr.setEnclosingParameters(true);
        if (!skipFirstParamAsThis) {
            lambdaExpr.addParameter(new Parameter((Type)new UnknownType(), "_this"));
        }
        usedDeclarations.stream().map(s -> new Parameter((Type)new UnknownType(), s)).forEach(arg_0 -> ((LambdaExpr)lambdaExpr).addParameter(arg_0));
        lambdaExpr.setBody((Statement)new ExpressionStmt(expr));
        return lambdaExpr;
    }

    public static TypedExpression toMethodCallWithClassCheck(RuleContext context, Expression expr, Class<?> clazz, TypeResolver typeResolver) {
        LinkedList<ParsedMethod> callStackLeftToRight = new LinkedList<ParsedMethod>();
        DrlxParseUtil.createExpressionCall(expr, callStackLeftToRight);
        ArrayList<Object> methodCall = new ArrayList<Object>();
        Class<?> previousClass = clazz;
        for (ParsedMethod e : callStackLeftToRight) {
            if (e.expression instanceof NameExpr || e.expression instanceof FieldAccessExpr) {
                TypedExpression te = DrlxParseUtil.nameExprToMethodCallExpr(e.fieldToResolve, previousClass, null);
                Class<?> returnType = te.getType();
                methodCall.add(te.getExpression());
                previousClass = returnType;
                continue;
            }
            if (!(e.expression instanceof MethodCallExpr)) continue;
            Class<?> returnType = DrlxParseUtil.returnTypeOfMethodCallExpr(context, typeResolver, (MethodCallExpr)e.expression, previousClass, null);
            MethodCallExpr cloned = ((MethodCallExpr)e.expression.clone()).removeScope();
            methodCall.add(cloned);
            previousClass = returnType;
        }
        Expression call = (Expression)methodCall.stream().reduce((a, b) -> {
            ((NodeWithOptionalScope)b).setScope(a);
            return b;
        }).orElseThrow(() -> new UnsupportedOperationException("No Expression converted"));
        return new TypedExpression(call, previousClass);
    }

    private static Expression createExpressionCall(Expression expr, Deque<ParsedMethod> expressions) {
        if (expr instanceof NodeWithSimpleName) {
            NodeWithSimpleName fae = (NodeWithSimpleName)expr;
            expressions.push(new ParsedMethod(expr, fae.getName().asString()));
        }
        if (expr instanceof NodeWithOptionalScope) {
            NodeWithOptionalScope exprWithScope = (NodeWithOptionalScope)expr;
            exprWithScope.getScope().map(scope -> DrlxParseUtil.createExpressionCall(scope, expressions));
        } else if (expr instanceof FieldAccessExpr) {
            DrlxParseUtil.createExpressionCall(((FieldAccessExpr)expr).getScope(), expressions);
        }
        return expr;
    }

    public static Type classToReferenceType(Class<?> declClass) {
        Type parsedType = JavaParser.parseType((String)declClass.getCanonicalName());
        return parsedType instanceof PrimitiveType ? ((PrimitiveType)parsedType).toBoxedType() : parsedType.getElementType();
    }

    public static Type toType(Class<?> declClass) {
        return JavaParser.parseType((String)declClass.getCanonicalName());
    }

    public static Optional<String> findBindingIdFromDotExpression(String expression) {
        int dot = expression.indexOf(46);
        if (dot < 0) {
            return Optional.empty();
        }
        return Optional.of(expression.substring(0, dot));
    }

    public static Optional<String> findBindingId(String expression, Collection<String> availableBindings) {
        DrlxExpression drlx = DrlxParser.parseExpression((String)expression);
        if (drlx == null) {
            throw new RuntimeException("unable to parse " + expression);
        }
        return DrlxParseUtil.findBindingId(drlx.getExpr(), availableBindings);
    }

    public static Optional<String> findBindingId(Expression expr, Collection<String> availableBindings) {
        if (expr instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)expr;
            Optional<String> scope = methodCallExpr.getScope().flatMap(e -> DrlxParseUtil.findBindingId(e, availableBindings)).filter(availableBindings::contains);
            if (scope.isPresent()) {
                return scope;
            }
            return methodCallExpr.getArguments().stream().map(DrlxParseUtil::findRootNode).map(opt -> opt.flatMap(e -> DrlxParseUtil.findBindingId(e, availableBindings))).filter(opt -> opt.map(availableBindings::contains).orElse(false)).map(Optional::get).findFirst();
        }
        if (expr instanceof NameExpr) {
            String name = ((NameExpr)expr).getNameAsString();
            return availableBindings.contains(name) ? Optional.of(name) : Optional.empty();
        }
        if (expr instanceof BinaryExpr) {
            BinaryExpr binaryExpr = (BinaryExpr)expr;
            Optional<String> left = DrlxParseUtil.findBindingId(binaryExpr.getLeft(), availableBindings);
            return left.isPresent() ? left : DrlxParseUtil.findBindingId(binaryExpr.getRight(), availableBindings);
        }
        return Optional.empty();
    }

    public static Class<?> getClassFromContext(TypeResolver typeResolver, String className) {
        Class patternType;
        try {
            patternType = typeResolver.resolveType(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return patternType;
    }

    public static boolean isPrimitiveExpression(Expression expr) {
        if (!(expr instanceof LiteralExpr)) {
            return false;
        }
        return expr instanceof NullLiteralExpr || expr instanceof IntegerLiteralExpr || expr instanceof DoubleLiteralExpr || expr instanceof BooleanLiteralExpr || expr instanceof LongLiteralExpr;
    }

    static class ParsedMethod {
        final Expression expression;
        final String fieldToResolve;

        public ParsedMethod(Expression expression, String fieldToResolve) {
            this.expression = expression;
            this.fieldToResolve = fieldToResolve;
        }

        public String toString() {
            return "{expression=" + this.expression + ", fieldToResolve='" + this.fieldToResolve + '\'' + '}';
        }
    }

    public static class RemoveRootNodeResult {
        private Optional<Expression> rootNode;
        private Expression withoutRootNode;

        public RemoveRootNodeResult(Optional<Expression> rootNode, Expression withoutRootNode) {
            this.rootNode = rootNode;
            this.withoutRootNode = withoutRootNode;
        }

        public Optional<Expression> getRootNode() {
            return this.rootNode;
        }

        public Expression getWithoutRootNode() {
            return this.withoutRootNode;
        }
    }
}

