/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BehaviorDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.rule.Behavior;
import org.drools.core.ruleunit.RuleUnitDescr;
import org.drools.core.time.TimeUtils;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.MVELSafeHelper;
import org.drools.core.util.StringUtils;
import org.drools.core.util.index.IndexUtil;
import org.drools.drlx.DrlxParser;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.body.Parameter;
import org.drools.javaparser.ast.drlx.OOPathExpr;
import org.drools.javaparser.ast.drlx.expr.DrlxExpression;
import org.drools.javaparser.ast.drlx.expr.PointFreeExpr;
import org.drools.javaparser.ast.expr.AssignExpr;
import org.drools.javaparser.ast.expr.BinaryExpr;
import org.drools.javaparser.ast.expr.ClassExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.LambdaExpr;
import org.drools.javaparser.ast.expr.LiteralExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.NullLiteralExpr;
import org.drools.javaparser.ast.expr.ObjectCreationExpr;
import org.drools.javaparser.ast.expr.SimpleName;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.expr.ThisExpr;
import org.drools.javaparser.ast.expr.UnaryExpr;
import org.drools.javaparser.ast.expr.VariableDeclarationExpr;
import org.drools.javaparser.ast.nodeTypes.NodeWithArguments;
import org.drools.javaparser.ast.nodeTypes.NodeWithOptionalScope;
import org.drools.javaparser.ast.nodeTypes.NodeWithSimpleName;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.EmptyStmt;
import org.drools.javaparser.ast.stmt.ExpressionStmt;
import org.drools.javaparser.ast.stmt.ReturnStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.Type;
import org.drools.javaparser.ast.type.UnknownType;
import org.drools.javaparser.printer.PrintUtil;
import org.drools.model.BitMask;
import org.drools.model.Rule;
import org.drools.model.UnitData;
import org.drools.model.Variable;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.ParseExpressionErrorResult;
import org.drools.modelcompiler.builder.errors.UnknownDeclarationError;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.FunctionGenerator;
import org.drools.modelcompiler.builder.generator.IndexIdGenerator;
import org.drools.modelcompiler.builder.generator.QueryGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.WindowReferenceGenerator;
import org.drools.modelcompiler.builder.generator.operatorspec.CustomOperatorSpec;
import org.drools.modelcompiler.builder.generator.operatorspec.InOperatorSpec;
import org.drools.modelcompiler.builder.generator.operatorspec.TemporalOperatorSpec;
import org.drools.modelcompiler.builder.generator.visitor.ModelGeneratorVisitor;
import org.drools.modelcompiler.util.StringUtil;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class ModelGenerator {
    private static final ClassOrInterfaceType RULE_TYPE = JavaParser.parseClassOrInterfaceType((String)Rule.class.getCanonicalName());
    private static final ClassOrInterfaceType BITMASK_TYPE = JavaParser.parseClassOrInterfaceType((String)BitMask.class.getCanonicalName());
    private static final Map<String, Expression> attributesMap = new HashMap<String, Expression>();
    private static final Map<String, Expression> consequenceMethods = new HashMap<String, Expression>();
    private static final Map<String, CustomOperatorSpec> customOperators = new HashMap<String, CustomOperatorSpec>();
    private static final IndexIdGenerator indexIdGenerator = new IndexIdGenerator();
    public static final boolean GENERATE_EXPR_ID = true;
    public static final String BUILD_CALL = "build";
    public static final String RULE_CALL = "rule";
    public static final String UNIT_CALL = "unit";
    public static final String EXECUTE_CALL = "execute";
    public static final String EXECUTESCRIPT_CALL = "executeScript";
    public static final String ON_CALL = "on";
    public static final String EXPR_CALL = "expr";
    public static final String BIND_CALL = "bind";
    public static final String BIND_AS_CALL = "as";
    public static final String ATTRIBUTE_CALL = "attribute";
    public static final String METADATA_CALL = "metadata";
    public static final String DECLARATION_OF_CALL = "declarationOf";
    public static final String TYPE_CALL = "type";
    public static final String QUERY_INVOCATION_CALL = "call";
    public static final String VALUE_OF_CALL = "valueOf";
    public static final String UNIT_DATA_CALL = "unitData";

    public static void generateModel(KnowledgeBuilderImpl kbuilder, InternalKnowledgePackage pkg, PackageDescr packageDescr, PackageModel packageModel) {
        packageModel.addImports(pkg.getTypeResolver().getImports());
        packageModel.addGlobals(pkg.getGlobals());
        packageModel.addAccumulateFunctions(pkg.getAccumulateFunctions());
        new WindowReferenceGenerator(packageModel, pkg).addWindowReferences(kbuilder, packageDescr.getWindowDeclarations());
        packageModel.addAllFunctions(packageDescr.getFunctions().stream().map(FunctionGenerator::toFunction).collect(Collectors.toList()));
        for (RuleDescr descr : packageDescr.getRules()) {
            if (!(descr instanceof QueryDescr)) continue;
            QueryGenerator.processQueryDef(kbuilder, pkg, packageModel, (QueryDescr)descr);
        }
        for (RuleDescr descr : packageDescr.getRules()) {
            if (descr instanceof QueryDescr) {
                QueryGenerator.processQuery(kbuilder, packageModel, (QueryDescr)descr);
                continue;
            }
            ModelGenerator.processRule(kbuilder, pkg, packageModel, descr);
        }
    }

    private static void processRule(KnowledgeBuilderImpl kbuilder, InternalKnowledgePackage pkg, PackageModel packageModel, RuleDescr ruleDescr) {
        RuleContext context = new RuleContext(kbuilder, pkg, packageModel.getExprIdGenerator(), ruleDescr);
        for (Map.Entry kv : ruleDescr.getNamedConsequences().entrySet()) {
            context.addNamedConsequence((String)kv.getKey(), kv.getValue().toString());
        }
        new ModelGeneratorVisitor(context, packageModel).visit(ruleDescr.getLhs());
        MethodDeclaration ruleMethod = new MethodDeclaration(EnumSet.of(Modifier.PRIVATE), (Type)RULE_TYPE, "rule_" + StringUtil.toId(ruleDescr.getName()));
        ruleMethod.setJavadocComment(" Rule name: " + ruleDescr.getName() + " ");
        VariableDeclarationExpr ruleVar = new VariableDeclarationExpr((Type)RULE_TYPE, RULE_CALL);
        MethodCallExpr ruleCall = new MethodCallExpr(null, RULE_CALL);
        if (!ruleDescr.getNamespace().isEmpty()) {
            ruleCall.addArgument((Expression)new StringLiteralExpr(ruleDescr.getNamespace()));
        }
        ruleCall.addArgument((Expression)new StringLiteralExpr(ruleDescr.getName()));
        RuleUnitDescr ruleUnitDescr = context.getRuleUnitDescr();
        MethodCallExpr buildCallScope = ruleUnitDescr != null ? (MethodCallExpr)new MethodCallExpr((Expression)ruleCall, UNIT_CALL).addArgument((Expression)new ClassExpr(DrlxParseUtil.classToReferenceType(ruleUnitDescr.getRuleUnitClass()))) : ruleCall;
        for (MethodCallExpr attributeExpr : ModelGenerator.ruleAttributes(context, ruleDescr)) {
            attributeExpr.setScope((Expression)buildCallScope);
            buildCallScope = attributeExpr;
        }
        for (MethodCallExpr metaAttributeExpr : ModelGenerator.ruleMetaAttributes(context, ruleDescr)) {
            metaAttributeExpr.setScope((Expression)buildCallScope);
            buildCallScope = metaAttributeExpr;
        }
        MethodCallExpr buildCall = new MethodCallExpr((Expression)buildCallScope, BUILD_CALL, NodeList.nodeList(context.getExpressions()));
        BlockStmt ruleVariablesBlock = new BlockStmt();
        ModelGenerator.createUnitData(ruleUnitDescr, ruleVariablesBlock);
        ModelGenerator.createVariables(kbuilder, ruleVariablesBlock, packageModel, context);
        ruleMethod.setBody(ruleVariablesBlock);
        MethodCallExpr executeCall = ModelGenerator.createConsequenceCall(packageModel, ruleDescr, context, ruleDescr.getConsequence().toString(), ruleVariablesBlock, false);
        buildCall.addArgument((Expression)executeCall);
        ruleVariablesBlock.addStatement((Expression)new AssignExpr((Expression)ruleVar, (Expression)buildCall, AssignExpr.Operator.ASSIGN));
        ruleVariablesBlock.addStatement((Statement)new ReturnStmt(RULE_CALL));
        packageModel.putRuleMethod("rule_" + StringUtil.toId(ruleDescr.getName()), ruleMethod);
    }

    private static List<MethodCallExpr> ruleAttributes(RuleContext context, RuleDescr ruleDescr) {
        ArrayList<MethodCallExpr> ruleAttributes = new ArrayList<MethodCallExpr>();
        for (Map.Entry as : ruleDescr.getAttributes().entrySet()) {
            if (((String)as.getKey()).equals("dialect")) {
                if (!((AttributeDescr)as.getValue()).getValue().equals("mvel")) continue;
                context.setRuleDialect(RuleContext.RuleDialect.MVEL);
                continue;
            }
            MethodCallExpr attributeCall = new MethodCallExpr(null, ATTRIBUTE_CALL);
            attributeCall.addArgument(attributesMap.get(as.getKey()));
            switch ((String)as.getKey()) {
                case "dialect": {
                    throw new RuntimeException("should not have reached this part of the code");
                }
                case "no-loop": 
                case "salience": 
                case "enabled": 
                case "auto-focus": 
                case "lock-on-active": {
                    attributeCall.addArgument(JavaParser.parseExpression((String)((AttributeDescr)as.getValue()).getValue()));
                    break;
                }
                case "agenda-group": 
                case "activation-group": 
                case "ruleflow-group": 
                case "duration": 
                case "timer": {
                    attributeCall.addArgument((Expression)new StringLiteralExpr(((AttributeDescr)as.getValue()).getValue()));
                    break;
                }
                case "calendars": {
                    String value = ((AttributeDescr)as.getValue()).getValue().trim();
                    if (value.startsWith("[")) {
                        value = value.substring(1, value.length() - 1).trim();
                    }
                    Expression arrayExpr = JavaParser.parseExpression((String)("new String[] { " + value + " }"));
                    attributeCall.addArgument(arrayExpr);
                    break;
                }
                case "date-effective": 
                case "date-expires": {
                    attributeCall.addArgument(JavaParser.parseExpression((String)String.format("GregorianCalendar.from(LocalDate.parse(\"%s\", dateTimeFormatter).atStartOfDay(ZoneId.systemDefault()))", ((AttributeDescr)as.getValue()).getValue())));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled case for rule attribute: " + (String)as.getKey());
                }
            }
            ruleAttributes.add(attributeCall);
        }
        return ruleAttributes;
    }

    private static List<MethodCallExpr> ruleMetaAttributes(RuleContext context, RuleDescr ruleDescr) {
        ArrayList<MethodCallExpr> ruleMetaAttributes = new ArrayList<MethodCallExpr>();
        for (String metaAttr : ruleDescr.getAnnotationNames()) {
            MethodCallExpr metaAttributeCall = new MethodCallExpr(METADATA_CALL, new Expression[0]);
            metaAttributeCall.addArgument((Expression)new StringLiteralExpr(metaAttr));
            AnnotationDescr ad = ruleDescr.getAnnotation(metaAttr);
            String adFqn = ad.getFullyQualifiedName();
            if (adFqn != null) {
                AnnotationDefinition annotationDefinition;
                try {
                    annotationDefinition = AnnotationDefinition.build((Class)context.getPkg().getTypeResolver().resolveType(adFqn), (Map)ad.getValueMap(), (TypeResolver)context.getPkg().getTypeResolver());
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                if (annotationDefinition.getValues().size() == 1 && annotationDefinition.getValues().containsKey("value")) {
                    Object annValue = annotationDefinition.getPropertyValue("value");
                    metaAttributeCall.addArgument(ModelGenerator.objectAsJPExpression(annValue));
                } else {
                    HashMap<String, Object> map = new HashMap<String, Object>(annotationDefinition.getValues().size());
                    for (String key : annotationDefinition.getValues().keySet()) {
                        map.put(key, annotationDefinition.getPropertyValue(key));
                    }
                    metaAttributeCall.addArgument(ModelGenerator.objectAsJPExpression(map));
                }
            } else if (ad.hasValue()) {
                if (ad.getValues().size() == 1) {
                    metaAttributeCall.addArgument(ModelGenerator.objectAsJPExpression(ModelGenerator.resolveValue(ad.getSingleValueAsString())));
                } else {
                    metaAttributeCall.addArgument(ModelGenerator.objectAsJPExpression(ad.getValueMap()));
                }
            } else {
                metaAttributeCall.addArgument((Expression)new NullLiteralExpr());
            }
            ruleMetaAttributes.add(metaAttributeCall);
        }
        return ruleMetaAttributes;
    }

    private static Expression objectAsJPExpression(Object annValue) {
        if (annValue instanceof String) {
            StringLiteralExpr aStringLiteral = new StringLiteralExpr();
            aStringLiteral.setString(annValue.toString());
            return aStringLiteral;
        }
        if (annValue instanceof Number) {
            return JavaParser.parseExpression((String)annValue.toString());
        }
        if (annValue instanceof Map) {
            throw new UnsupportedOperationException("cannot define a canonical representation for a java.util.Map yet.");
        }
        throw new UnsupportedOperationException("I was unable to define a canonical String representation to give to JP yet about: " + annValue);
    }

    private static Object resolveValue(String value) {
        Object result = value;
        try {
            result = MVELSafeHelper.getEvaluator().eval(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static MethodCallExpr createConsequenceCall(PackageModel packageModel, RuleDescr ruleDescr, RuleContext context, String consequenceString, BlockStmt ruleVariablesBlock, boolean isBreaking) {
        BlockStmt ruleConsequence = ModelGenerator.rewriteConsequence(context, consequenceString);
        Collection<String> usedDeclarationInRHS = ModelGenerator.extractUsedDeclarations(packageModel, context, ruleConsequence, consequenceString);
        MethodCallExpr onCall = ModelGenerator.onCall(usedDeclarationInRHS);
        if (isBreaking) {
            onCall = new MethodCallExpr((Expression)onCall, "breaking");
        }
        MethodCallExpr executeCall = null;
        if (context.getRuleDialect() == RuleContext.RuleDialect.JAVA) {
            executeCall = ModelGenerator.executeCall(context, ruleVariablesBlock, ruleConsequence, usedDeclarationInRHS, onCall);
        } else if (context.getRuleDialect() == RuleContext.RuleDialect.MVEL) {
            executeCall = ModelGenerator.executeScriptCall(packageModel, ruleDescr, onCall);
        }
        return executeCall;
    }

    private static BlockStmt rewriteConsequence(RuleContext context, String consequence) {
        if (context.getRuleDialect() == RuleContext.RuleDialect.MVEL) {
            return null;
        }
        String ruleConsequenceAsBlock = ModelGenerator.rewriteConsequenceBlock(context, consequence.trim());
        return DrlxParseUtil.parseBlock(ruleConsequenceAsBlock);
    }

    private static Collection<String> extractUsedDeclarations(PackageModel packageModel, RuleContext context, BlockStmt ruleConsequence, String consequenceString) {
        HashSet<String> existingDecls = new HashSet<String>();
        existingDecls.addAll(context.getDeclarations().stream().map(DeclarationSpec::getBindingId).collect(Collectors.toList()));
        existingDecls.addAll(packageModel.getGlobals().keySet());
        if (context.getRuleUnitDescr() != null) {
            existingDecls.addAll(context.getRuleUnitDescr().getUnitVars());
        }
        if (context.getRuleDialect() == RuleContext.RuleDialect.MVEL) {
            return existingDecls.stream().filter(consequenceString::contains).collect(Collectors.toSet());
        }
        Set declUsedInRHS = ruleConsequence.getChildNodesByType(NameExpr.class).stream().map(NodeWithSimpleName::getNameAsString).collect(Collectors.toSet());
        return existingDecls.stream().filter(declUsedInRHS::contains).collect(Collectors.toSet());
    }

    private static MethodCallExpr executeCall(RuleContext context, BlockStmt ruleVariablesBlock, BlockStmt ruleConsequence, Collection<String> verifiedDeclUsedInRHS, MethodCallExpr onCall) {
        boolean requireDrools = ModelGenerator.rewriteRHS(context, ruleVariablesBlock, ruleConsequence);
        MethodCallExpr executeCall = new MethodCallExpr((Expression)onCall, EXECUTE_CALL);
        LambdaExpr executeLambda = new LambdaExpr();
        executeCall.addArgument((Expression)executeLambda);
        executeLambda.setEnclosingParameters(true);
        if (requireDrools) {
            executeLambda.addParameter(new Parameter((Type)new UnknownType(), "drools"));
        }
        verifiedDeclUsedInRHS.stream().map(x -> new Parameter((Type)new UnknownType(), x)).forEach(arg_0 -> ((LambdaExpr)executeLambda).addParameter(arg_0));
        executeLambda.setBody((Statement)ruleConsequence);
        return executeCall;
    }

    private static MethodCallExpr executeScriptCall(PackageModel packageModel, RuleDescr ruleDescr, MethodCallExpr onCall) {
        MethodCallExpr executeCall = new MethodCallExpr((Expression)onCall, EXECUTESCRIPT_CALL);
        executeCall.addArgument((Expression)new StringLiteralExpr("mvel"));
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(StringBuilder.class.getCanonicalName());
        ObjectCreationExpr mvelSB = objectCreationExpr;
        for (String i : packageModel.getImports()) {
            if (i.equals(packageModel.getName() + ".*")) continue;
            MethodCallExpr appendCall = new MethodCallExpr((Expression)mvelSB, "append");
            StringLiteralExpr importAsStringLiteral = new StringLiteralExpr();
            importAsStringLiteral.setString("import " + i + ";\n");
            appendCall.addArgument((Expression)importAsStringLiteral);
            mvelSB = appendCall;
        }
        StringLiteralExpr mvelScriptBodyStringLiteral = new StringLiteralExpr();
        mvelScriptBodyStringLiteral.setString(ruleDescr.getConsequence().toString());
        MethodCallExpr appendCall = new MethodCallExpr((Expression)mvelSB, "append");
        appendCall.addArgument((Expression)mvelScriptBodyStringLiteral);
        mvelSB = appendCall;
        MethodCallExpr toStringCall = new MethodCallExpr((Expression)mvelSB, "toString");
        mvelSB = toStringCall;
        executeCall.addArgument((Expression)mvelSB);
        return executeCall;
    }

    private static MethodCallExpr onCall(Collection<String> usedArguments) {
        MethodCallExpr onCall = null;
        if (!usedArguments.isEmpty()) {
            onCall = new MethodCallExpr(null, ON_CALL);
            usedArguments.stream().map(DrlxParseUtil::toVar).forEach(arg_0 -> ((MethodCallExpr)onCall).addArgument(arg_0));
        }
        return onCall;
    }

    private static void createUnitData(RuleUnitDescr ruleUnitDescr, BlockStmt ruleVariablesBlock) {
        if (ruleUnitDescr != null) {
            for (String unitVar : ruleUnitDescr.getUnitVars()) {
                ModelGenerator.addUnitData(unitVar, (Class)ruleUnitDescr.getVarType(unitVar).get(), ruleVariablesBlock);
            }
        }
    }

    private static void addUnitData(String unitVar, Class<?> type, BlockStmt ruleBlock) {
        Type declType = DrlxParseUtil.classToReferenceType(type);
        ClassOrInterfaceType varType = JavaParser.parseClassOrInterfaceType((String)UnitData.class.getCanonicalName());
        varType.setTypeArguments(new Type[]{declType});
        VariableDeclarationExpr var_ = new VariableDeclarationExpr((Type)varType, DrlxParseUtil.toVar(unitVar), new Modifier[]{Modifier.FINAL});
        MethodCallExpr unitDataCall = new MethodCallExpr(null, UNIT_DATA_CALL);
        MethodCallExpr typeCall = new MethodCallExpr(null, TYPE_CALL);
        typeCall.addArgument((Expression)new ClassExpr(declType));
        unitDataCall.addArgument((Expression)typeCall);
        unitDataCall.addArgument((Expression)new StringLiteralExpr(unitVar));
        AssignExpr var_assign = new AssignExpr((Expression)var_, (Expression)unitDataCall, AssignExpr.Operator.ASSIGN);
        ruleBlock.addStatement((Expression)var_assign);
    }

    public static void createVariables(KnowledgeBuilderImpl kbuilder, BlockStmt block, PackageModel packageModel, RuleContext context) {
        for (DeclarationSpec decl : context.getDeclarations()) {
            if (packageModel.getGlobals().containsKey(decl.getBindingId()) || context.queryParameterWithName(p -> p.name.equals(decl.getBindingId())).isPresent()) continue;
            ModelGenerator.addVariable(kbuilder, block, decl);
        }
    }

    private static void addVariable(KnowledgeBuilderImpl kbuilder, BlockStmt ruleBlock, DeclarationSpec decl) {
        if (decl.getDeclarationClass() == null) {
            kbuilder.addBuilderResult((KnowledgeBuilderResult)new UnknownDeclarationError(decl.getBindingId()));
            return;
        }
        Type declType = DrlxParseUtil.classToReferenceType(decl.getDeclarationClass());
        ClassOrInterfaceType varType = JavaParser.parseClassOrInterfaceType((String)Variable.class.getCanonicalName());
        varType.setTypeArguments(new Type[]{declType});
        VariableDeclarationExpr var_ = new VariableDeclarationExpr((Type)varType, DrlxParseUtil.toVar(decl.getBindingId()), new Modifier[]{Modifier.FINAL});
        MethodCallExpr declarationOfCall = new MethodCallExpr(null, DECLARATION_OF_CALL);
        MethodCallExpr typeCall = new MethodCallExpr(null, TYPE_CALL);
        typeCall.addArgument((Expression)new ClassExpr(decl.getType()));
        declarationOfCall.addArgument((Expression)typeCall);
        declarationOfCall.addArgument((Expression)new StringLiteralExpr(decl.getVariableName().orElse(decl.getBindingId())));
        decl.getDeclarationSource().ifPresent(arg_0 -> ((MethodCallExpr)declarationOfCall).addArgument(arg_0));
        decl.getEntryPoint().ifPresent(ep -> {
            MethodCallExpr entryPointCall = new MethodCallExpr(null, "entryPoint");
            entryPointCall.addArgument((Expression)new StringLiteralExpr(ep));
            declarationOfCall.addArgument((Expression)entryPointCall);
        });
        for (BehaviorDescr behaviorDescr : decl.getBehaviors()) {
            MethodCallExpr windowCall = new MethodCallExpr(null, "window");
            if (Behavior.BehaviorType.TIME_WINDOW.matches(behaviorDescr.getSubType())) {
                windowCall.addArgument("Window.Type.TIME");
                windowCall.addArgument("" + TimeUtils.parseTimeString((String)((String)behaviorDescr.getParameters().get(0))));
            }
            if (Behavior.BehaviorType.LENGTH_WINDOW.matches(behaviorDescr.getSubType())) {
                windowCall.addArgument("Window.Type.LENGTH");
                windowCall.addArgument("" + Integer.valueOf((String)behaviorDescr.getParameters().get(0)));
            }
            declarationOfCall.addArgument((Expression)windowCall);
        }
        AssignExpr var_assign = new AssignExpr((Expression)var_, (Expression)declarationOfCall, AssignExpr.Operator.ASSIGN);
        ruleBlock.addStatement((Expression)var_assign);
    }

    private static String rewriteConsequenceBlock(RuleContext context, String consequence) {
        int modifyPos = StringUtils.indexOfOutOfQuotes((String)consequence, (String)"modify");
        if (modifyPos < 0) {
            return consequence;
        }
        int lastCopiedEnd = 0;
        StringBuilder sb = new StringBuilder();
        sb.append(consequence.substring(lastCopiedEnd, modifyPos));
        lastCopiedEnd = modifyPos + 1;
        while (modifyPos >= 0) {
            int blockStart;
            int blockEnd;
            String decl;
            int declStart = consequence.indexOf(40, modifyPos + 6);
            int declEnd = consequence.indexOf(41, declStart + 1);
            if (declEnd >= 0 && context.getDeclarationById(decl = consequence.substring(declStart + 1, declEnd).trim()).isPresent() && (blockEnd = consequence.indexOf(125, (blockStart = consequence.indexOf(123, declEnd + 1)) + 1)) >= 0) {
                if (lastCopiedEnd < modifyPos) {
                    sb.append(consequence.substring(lastCopiedEnd, modifyPos));
                }
                NameExpr declAsNameExpr = new NameExpr(decl);
                String originalBlock = consequence.substring(blockStart + 1, blockEnd).trim();
                BlockStmt modifyBlock = JavaParser.parseBlock((String)("{" + originalBlock + ";}"));
                List originalMethodCalls = modifyBlock.getChildNodesByType(MethodCallExpr.class);
                for (MethodCallExpr mc : originalMethodCalls) {
                    Expression mcWithScope = DrlxParseUtil.prepend((Expression)declAsNameExpr, (Expression)mc);
                    modifyBlock.replace((Node)mc, (Node)mcWithScope);
                }
                for (Statement n : modifyBlock.getStatements()) {
                    if (n instanceof EmptyStmt) continue;
                    sb.append(n);
                }
                sb.append("update(").append(decl).append(");\n");
                lastCopiedEnd = blockEnd + 1;
            }
            modifyPos = StringUtils.indexOfOutOfQuotes((String)consequence, (String)"modify", (int)(modifyPos + 6));
        }
        if (lastCopiedEnd < consequence.length()) {
            sb.append(consequence.substring(lastCopiedEnd));
        }
        return sb.toString();
    }

    private static boolean rewriteRHS(RuleContext context, BlockStmt ruleBlock, BlockStmt rhs) {
        AtomicBoolean requireDrools = new AtomicBoolean(false);
        List methodCallExprs = rhs.getChildNodesByType(MethodCallExpr.class);
        ArrayList<MethodCallExpr> updateExprs = new ArrayList<MethodCallExpr>();
        for (MethodCallExpr methodCallExpr : methodCallExprs) {
            if (ModelGenerator.isDroolsMethod(methodCallExpr)) {
                if (!methodCallExpr.getScope().isPresent()) {
                    methodCallExpr.setScope((Expression)new NameExpr("drools"));
                }
                if (methodCallExpr.getNameAsString().equals("update")) {
                    updateExprs.add(methodCallExpr);
                } else if (methodCallExpr.getNameAsString().equals("retract")) {
                    methodCallExpr.setName(new SimpleName("delete"));
                }
                requireDrools.set(true);
                continue;
            }
            methodCallExpr.getScope().ifPresent(scope -> {
                if (scope instanceof MethodCallExpr && ModelGenerator.hasScope((MethodCallExpr)scope, "drools")) {
                    Expression newScope = consequenceMethods.get(((MethodCallExpr)scope).getNameAsString());
                    if (newScope != null) {
                        methodCallExpr.setScope(newScope);
                    }
                    requireDrools.set(true);
                }
            });
        }
        for (MethodCallExpr updateExpr : updateExprs) {
            Expression argExpr = updateExpr.getArgument(0);
            if (!(argExpr instanceof NameExpr)) continue;
            String updatedVar = ((NameExpr)argExpr).getNameAsString();
            Class updatedClass = context.getDeclarationById(updatedVar).map(DeclarationSpec::getDeclarationClass).orElseThrow(RuntimeException::new);
            MethodCallExpr bitMaskCreation = new MethodCallExpr((Expression)new NameExpr(BitMask.class.getCanonicalName()), "getPatternMask");
            bitMaskCreation.addArgument((Expression)new ClassExpr((Type)JavaParser.parseClassOrInterfaceType((String)updatedClass.getCanonicalName())));
            methodCallExprs.subList(0, methodCallExprs.indexOf(updateExpr)).stream().filter(mce -> mce.getScope().isPresent() && ModelGenerator.hasScope(mce, updatedVar)).map(mce -> ClassUtils.setter2property((String)mce.getNameAsString())).filter(Objects::nonNull).distinct().forEach(s -> {
                MethodCallExpr cfr_ignored_0 = (MethodCallExpr)bitMaskCreation.addArgument((Expression)new StringLiteralExpr(s));
            });
            VariableDeclarationExpr bitMaskVar = new VariableDeclarationExpr((Type)BITMASK_TYPE, "mask_" + updatedVar, new Modifier[]{Modifier.FINAL});
            AssignExpr bitMaskAssign = new AssignExpr((Expression)bitMaskVar, (Expression)bitMaskCreation, AssignExpr.Operator.ASSIGN);
            ruleBlock.addStatement((Expression)bitMaskAssign);
            updateExpr.addArgument("mask_" + updatedVar);
        }
        return requireDrools.get();
    }

    private static boolean isDroolsMethod(MethodCallExpr mce) {
        return ModelGenerator.hasScope(mce, "drools") || !mce.getScope().isPresent() && (mce.getNameAsString().equals("insert") || mce.getNameAsString().equals("insertLogical") || mce.getNameAsString().equals("delete") || mce.getNameAsString().equals("retract") || mce.getNameAsString().equals("update"));
    }

    private static boolean hasScope(MethodCallExpr mce, String scope) {
        return mce.getScope().map(s -> s instanceof NameExpr && ((NameExpr)s).getNameAsString().equals(scope)).orElse(false);
    }

    public static void processExpression(RuleContext context, DrlxParseResult drlxParseResult) {
        Expression dslExpr;
        if (drlxParseResult.hasUnificationVariable()) {
            dslExpr = ModelGenerator.buildUnificationExpression(context, drlxParseResult);
            context.addExpression(dslExpr);
        } else if (drlxParseResult.isValidExpression()) {
            dslExpr = ModelGenerator.buildExpressionWithIndexing(context, drlxParseResult);
            context.addExpression(dslExpr);
        }
        if (drlxParseResult.getExprBinding() != null) {
            dslExpr = ModelGenerator.buildBinding(drlxParseResult);
            context.addExpression(dslExpr);
        }
    }

    public static DrlxParseResult drlxParse(RuleContext context, PackageModel packageModel, Class<?> patternType, String bindingId, String expression) {
        return ModelGenerator.drlxParse(context, packageModel, patternType, bindingId, expression, false);
    }

    public static DrlxParseResult drlxParse(RuleContext context, PackageModel packageModel, Class<?> patternType, String bindingId, String expression, boolean isPositional) {
        if (expression.startsWith(bindingId + ".")) {
            expression = expression.substring(bindingId.length() + 1);
        }
        DrlxExpression drlx = DrlxParser.parseExpression((String)expression);
        DrlxParseResult result = ModelGenerator.getDrlxParseResult(context, packageModel, patternType, bindingId, expression, drlx, isPositional);
        if (drlx.getBind() != null) {
            String bindId = drlx.getBind().asString();
            context.addDeclaration(new DeclarationSpec(bindId, result.getExprType()));
            result.setExprBinding(bindId);
        }
        return result;
    }

    private static DrlxParseResult getDrlxParseResult(RuleContext context, PackageModel packageModel, Class<?> patternType, String bindingId, String expression, DrlxExpression drlx, boolean isPositional) {
        Expression drlxExpr = drlx.getExpr();
        String exprId = context.getExprId(patternType, expression);
        if (drlxExpr instanceof BinaryExpr) {
            BinaryExpr combo;
            BinaryExpr binaryExpr = (BinaryExpr)drlxExpr;
            BinaryExpr.Operator operator = binaryExpr.getOperator();
            IndexUtil.ConstraintType decodeConstraintType = DrlxParseUtil.toConstraintType(operator);
            ArrayList<String> usedDeclarations = new ArrayList<String>();
            HashSet<String> reactOnProperties = new HashSet<String>();
            TypedExpression left = DrlxParseUtil.toTypedExpression(context, packageModel, patternType, binaryExpr.getLeft(), usedDeclarations, reactOnProperties, (Expression)binaryExpr, isPositional);
            TypedExpression right = DrlxParseUtil.toTypedExpression(context, packageModel, patternType, binaryExpr.getRight(), usedDeclarations, reactOnProperties, (Expression)binaryExpr, isPositional);
            if (left.isPrimitive()) {
                combo = new BinaryExpr(left.getExpression(), right.getExpression(), operator);
            } else {
                if (left == null || right == null) {
                    context.addCompilationError((KnowledgeBuilderResult)new ParseExpressionErrorResult(drlxExpr));
                    return null;
                }
                switch (operator) {
                    case EQUALS: 
                    case NOT_EQUALS: {
                        combo = ModelGenerator.getEqualityExpression(left, right, operator);
                        break;
                    }
                    default: {
                        if (left.getExpression() == null || right.getExpression() == null) {
                            context.addCompilationError((KnowledgeBuilderResult)new ParseExpressionErrorResult(drlxExpr));
                            return null;
                        }
                        combo = ModelGenerator.getBinaryExpression(operator, left, right);
                    }
                }
            }
            if (left.getPrefixExpression() != null) {
                combo = new BinaryExpr(left.getPrefixExpression(), (Expression)combo, BinaryExpr.Operator.AND);
            }
            return new DrlxParseResult(patternType, exprId, bindingId, (Expression)combo, left.getType()).setDecodeConstraintType(decodeConstraintType).setUsedDeclarations(usedDeclarations).setReactOnProperties(reactOnProperties).setLeft(left).setRight(right);
        }
        if (drlxExpr instanceof UnaryExpr) {
            UnaryExpr unaryExpr = (UnaryExpr)drlxExpr;
            ArrayList<String> usedDeclarations = new ArrayList<String>();
            HashSet<String> reactOnProperties = new HashSet<String>();
            TypedExpression left = DrlxParseUtil.toTypedExpression(context, packageModel, patternType, (Expression)unaryExpr, usedDeclarations, reactOnProperties, (Expression)unaryExpr, isPositional);
            return new DrlxParseResult(patternType, exprId, bindingId, left.getExpression(), left.getType()).setUsedDeclarations(usedDeclarations).setReactOnProperties(reactOnProperties).setLeft(left);
        }
        if (drlxExpr instanceof PointFreeExpr) {
            PointFreeExpr pointFreeExpr = (PointFreeExpr)drlxExpr;
            ArrayList<String> usedDeclarations = new ArrayList<String>();
            HashSet<String> reactOnProperties = new HashSet<String>();
            TypedExpression left = DrlxParseUtil.toTypedExpression(context, packageModel, patternType, pointFreeExpr.getLeft(), usedDeclarations, reactOnProperties, (Expression)pointFreeExpr, isPositional);
            for (Expression rightExpr : pointFreeExpr.getRight()) {
                DrlxParseUtil.toTypedExpression(context, packageModel, patternType, rightExpr, usedDeclarations, reactOnProperties, (Expression)pointFreeExpr, isPositional);
            }
            String operator = pointFreeExpr.getOperator().asString();
            CustomOperatorSpec opSpec = customOperators.get(operator);
            if (opSpec == null) {
                throw new UnsupportedOperationException("Unknown operator '" + operator + "' in expression: " + PrintUtil.toDrlx((Node)drlxExpr));
            }
            MethodCallExpr methodCallExpr = opSpec.getMethodCallExpr(pointFreeExpr, left);
            return new DrlxParseResult(patternType, exprId, bindingId, (Expression)methodCallExpr, left.getType()).setUsedDeclarations(usedDeclarations).setReactOnProperties(reactOnProperties).setLeft(left).setStatic(opSpec.isStatic()).setValidExpression(true);
        }
        if (drlxExpr instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)drlxExpr;
            List rewriteThisExprs = ModelGenerator.recurseCollectArguments(methodCallExpr).stream().filter(ThisExpr.class::isInstance).map(ThisExpr.class::cast).collect(Collectors.toList());
            for (ThisExpr t : rewriteThisExprs) {
                methodCallExpr.replace((Node)t, (Node)new NameExpr("_this"));
            }
            Optional<MethodDeclaration> functionCall = packageModel.getFunctions().stream().filter(m -> m.getName().equals((Object)methodCallExpr.getName())).findFirst();
            if (functionCall.isPresent()) {
                Class<?> returnType = DrlxParseUtil.getClassFromContext(context.getPkg().getTypeResolver(), functionCall.get().getType().asString());
                NodeList arguments = methodCallExpr.getArguments();
                ArrayList<String> usedDeclarations = new ArrayList<String>();
                for (Expression arg : arguments) {
                    if (!(arg instanceof NameExpr) || arg.toString().equals("_this")) continue;
                    usedDeclarations.add(arg.toString());
                }
                return new DrlxParseResult(patternType, exprId, bindingId, (Expression)methodCallExpr, returnType).setUsedDeclarations(usedDeclarations);
            }
            if (methodCallExpr.getScope().isPresent() && methodCallExpr.getScope().get() instanceof StringLiteralExpr) {
                ArrayList<String> usedDeclarations = new ArrayList<String>();
                TypedExpression converted = DrlxParseUtil.toTypedExpressionFromMethodCallOrField(context, String.class, (Expression)methodCallExpr, usedDeclarations, new HashSet<String>(), context.getPkg().getTypeResolver());
                return new DrlxParseResult(String.class, exprId, bindingId, converted.getExpression(), converted.getType()).setLeft(converted).setUsedDeclarations(usedDeclarations);
            }
            NameExpr _this = new NameExpr("_this");
            TypedExpression converted = DrlxParseUtil.toMethodCallWithClassCheck(context, (Expression)methodCallExpr, patternType, context.getPkg().getTypeResolver());
            Expression withThis = DrlxParseUtil.prepend((Expression)_this, converted.getExpression());
            return new DrlxParseResult(patternType, exprId, bindingId, withThis, converted.getType()).setLeft(converted);
        }
        if (drlxExpr instanceof FieldAccessExpr) {
            FieldAccessExpr fieldCallExpr = (FieldAccessExpr)drlxExpr;
            NameExpr _this = new NameExpr("_this");
            TypedExpression converted = DrlxParseUtil.toMethodCallWithClassCheck(context, (Expression)fieldCallExpr, patternType, context.getPkg().getTypeResolver());
            Expression withThis = DrlxParseUtil.prepend((Expression)_this, converted.getExpression());
            return new DrlxParseResult(patternType, exprId, bindingId, withThis, converted.getType()).setLeft(converted);
        }
        if (drlxExpr instanceof NameExpr) {
            NameExpr methodCallExpr = (NameExpr)drlxExpr;
            NameExpr _this = new NameExpr("_this");
            TypedExpression converted = DrlxParseUtil.toMethodCallWithClassCheck(context, (Expression)methodCallExpr, patternType, context.getPkg().getTypeResolver());
            Expression withThis = DrlxParseUtil.prepend((Expression)_this, converted.getExpression());
            if (drlx.getBind() != null) {
                return new DrlxParseResult(patternType, exprId, bindingId, null, converted.getType()).setLeft(new TypedExpression(withThis, converted.getType())).addReactOnProperty(methodCallExpr.getNameAsString());
            }
            return new DrlxParseResult(patternType, exprId, bindingId, withThis, converted.getType()).addReactOnProperty(methodCallExpr.getNameAsString());
        }
        if (drlxExpr instanceof OOPathExpr) {
            return new DrlxParseResult(patternType, exprId, bindingId, drlxExpr, null);
        }
        throw new UnsupportedOperationException("Unknown expression: " + PrintUtil.toDrlx((Node)drlxExpr));
    }

    private static Expression getEqualityExpression(TypedExpression left, TypedExpression right, BinaryExpr.Operator operator) {
        Expression rightOperand = right.getExpression();
        if (DrlxParseUtil.isPrimitiveExpression(right.getExpression())) {
            if (left.getType() != String.class) {
                return new BinaryExpr(left.getExpression(), rightOperand, operator == BinaryExpr.Operator.EQUALS ? BinaryExpr.Operator.EQUALS : BinaryExpr.Operator.NOT_EQUALS);
            }
            if (rightOperand instanceof LiteralExpr) {
                rightOperand = new StringLiteralExpr(rightOperand.toString());
            }
        }
        MethodCallExpr methodCallExpr = new MethodCallExpr(null, "org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals");
        methodCallExpr.addArgument(left.getExpression());
        methodCallExpr.addArgument(rightOperand);
        return operator == BinaryExpr.Operator.EQUALS ? methodCallExpr : new UnaryExpr((Expression)methodCallExpr, UnaryExpr.Operator.LOGICAL_COMPLEMENT);
    }

    private static Expression getBinaryExpression(BinaryExpr.Operator operator, TypedExpression left, TypedExpression right) {
        if (left.getType() == String.class && right.getType() == String.class && ModelGenerator.isComparisonOperator(operator)) {
            MethodCallExpr methodCallExpr = new MethodCallExpr(null, "org.drools.modelcompiler.util.EvaluationUtil.compareStringsAsNumbers");
            methodCallExpr.addArgument(left.getExpression());
            methodCallExpr.addArgument(right.getExpression());
            methodCallExpr.addArgument((Expression)new StringLiteralExpr(operator.asString()));
            return methodCallExpr;
        }
        return new BinaryExpr(left.getExpression(), right.getExpression(), operator);
    }

    private static boolean isComparisonOperator(BinaryExpr.Operator op) {
        return op == BinaryExpr.Operator.LESS || op == BinaryExpr.Operator.GREATER || op == BinaryExpr.Operator.LESS_EQUALS || op == BinaryExpr.Operator.GREATER_EQUALS;
    }

    private static List<Expression> recurseCollectArguments(NodeWithArguments<?> methodCallExpr) {
        Object scope;
        NodeWithOptionalScope nodeWithOptionalScope;
        ArrayList<Expression> res = new ArrayList<Expression>();
        res.addAll((Collection<Expression>)methodCallExpr.getArguments());
        if (methodCallExpr instanceof NodeWithOptionalScope && (nodeWithOptionalScope = (NodeWithOptionalScope)methodCallExpr).getScope().isPresent() && (scope = nodeWithOptionalScope.getScope().get()) instanceof NodeWithArguments) {
            res.addAll(ModelGenerator.recurseCollectArguments((NodeWithArguments)scope));
        }
        return res;
    }

    public static Expression buildExpressionWithIndexing(RuleContext context, DrlxParseResult drlxParseResult) {
        String exprId = drlxParseResult.getExprId();
        MethodCallExpr exprDSL = new MethodCallExpr(null, EXPR_CALL);
        if (exprId != null && !"".equals(exprId)) {
            exprDSL.addArgument((Expression)new StringLiteralExpr(exprId));
        }
        exprDSL = ModelGenerator.buildExpression(context, drlxParseResult, exprDSL);
        exprDSL = ModelGenerator.buildIndexedBy(context, drlxParseResult, exprDSL);
        exprDSL = ModelGenerator.buildReactOn(drlxParseResult, exprDSL);
        return exprDSL;
    }

    public static Expression buildUnificationExpression(RuleContext context, DrlxParseResult drlxParseResult) {
        MethodCallExpr exprDSL = ModelGenerator.buildBinding(drlxParseResult);
        context.addDeclaration(new DeclarationSpec(drlxParseResult.getUnificationVariable(), drlxParseResult.getUnificationVariableType(), drlxParseResult.getUnificationName()));
        return exprDSL;
    }

    private static MethodCallExpr buildExpression(RuleContext context, DrlxParseResult drlxParseResult, MethodCallExpr exprDSL) {
        ArrayList<String> usedDeclarationsWithUnification = new ArrayList<String>();
        if (!drlxParseResult.isPatternBindingUnification()) {
            if (drlxParseResult.getPatternBinding() != null) {
                exprDSL.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(drlxParseResult.getPatternBinding())));
            }
        } else {
            usedDeclarationsWithUnification.add(drlxParseResult.getPatternBinding());
        }
        usedDeclarationsWithUnification.addAll(drlxParseResult.getUsedDeclarations());
        usedDeclarationsWithUnification.stream().map(x -> QueryGenerator.substituteBindingWithQueryParameter(context, x)).forEach(arg_0 -> ((MethodCallExpr)exprDSL).addArgument(arg_0));
        exprDSL.addArgument(ModelGenerator.buildConstraintExpression(drlxParseResult, drlxParseResult.getExpr()));
        return exprDSL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MethodCallExpr buildIndexedBy(RuleContext context, DrlxParseResult drlxParseResult, MethodCallExpr exprDSL) {
        IndexUtil.ConstraintType decodeConstraintType = drlxParseResult.getDecodeConstraintType();
        TypedExpression left = drlxParseResult.getLeft();
        TypedExpression right = drlxParseResult.getRight();
        if (decodeConstraintType == null || left.getExpression() instanceof NameExpr && ((NameExpr)left.getExpression()).getName().getIdentifier().equals("_this") || left.getFieldName() == null) return exprDSL;
        Class indexType = Stream.of(left, right).map(TypedExpression::getType).filter(Objects::nonNull).findFirst().get();
        ClassExpr indexedBy_indexedClass = new ClassExpr(JavaParser.parseType((String)indexType.getCanonicalName()));
        FieldAccessExpr indexedBy_constraintType = new FieldAccessExpr((Expression)new NameExpr("org.drools.model.Index.ConstraintType"), decodeConstraintType.toString());
        LambdaExpr indexedBy_leftOperandExtractor = new LambdaExpr();
        indexedBy_leftOperandExtractor.addParameter(new Parameter((Type)new UnknownType(), "_this"));
        boolean leftContainsThis = left.getExpression().toString().contains("_this");
        indexedBy_leftOperandExtractor.setBody((Statement)new ExpressionStmt(leftContainsThis ? left.getExpression() : right.getExpression()));
        MethodCallExpr indexedByDSL = new MethodCallExpr((Expression)exprDSL, "indexedBy");
        indexedByDSL.addArgument((Expression)indexedBy_indexedClass);
        indexedByDSL.addArgument((Expression)indexedBy_constraintType);
        indexedByDSL.addArgument("" + indexIdGenerator.getFieldId(drlxParseResult.getPatternType(), left.getFieldName()));
        indexedByDSL.addArgument((Expression)indexedBy_leftOperandExtractor);
        Collection<String> usedDeclarations = drlxParseResult.getUsedDeclarations();
        if (usedDeclarations.isEmpty()) {
            indexedByDSL.addArgument(right.getExpression());
            return indexedByDSL;
        } else {
            if (usedDeclarations.size() != 1) return exprDSL;
            if (!context.getDeclarationById(right.getExpressionAsString()).isPresent()) return exprDSL;
            LambdaExpr indexedBy_rightOperandExtractor = new LambdaExpr();
            indexedBy_rightOperandExtractor.addParameter(new Parameter((Type)new UnknownType(), usedDeclarations.iterator().next()));
            indexedBy_rightOperandExtractor.setBody((Statement)new ExpressionStmt(!leftContainsThis ? left.getExpression() : right.getExpression()));
            indexedByDSL.addArgument((Expression)indexedBy_rightOperandExtractor);
        }
        return indexedByDSL;
    }

    private static MethodCallExpr buildReactOn(DrlxParseResult drlxParseResult, MethodCallExpr exprDSL) {
        if (!drlxParseResult.getReactOnProperties().isEmpty()) {
            exprDSL = new MethodCallExpr((Expression)exprDSL, "reactOn");
            drlxParseResult.getReactOnProperties().stream().map(StringLiteralExpr::new).forEach(arg_0 -> ((MethodCallExpr)exprDSL).addArgument(arg_0));
        }
        if (drlxParseResult.getWatchedProperties() != null && drlxParseResult.getWatchedProperties().length > 0) {
            exprDSL = new MethodCallExpr((Expression)exprDSL, "watch");
            Stream.of(drlxParseResult.getWatchedProperties()).map(StringLiteralExpr::new).forEach(arg_0 -> ((MethodCallExpr)exprDSL).addArgument(arg_0));
        }
        return exprDSL;
    }

    private static Expression buildConstraintExpression(DrlxParseResult drlxParseResult, Expression expr) {
        return drlxParseResult.isStatic() ? expr : DrlxParseUtil.generateLambdaWithoutParameters(drlxParseResult.getUsedDeclarations(), expr);
    }

    public static MethodCallExpr buildBinding(DrlxParseResult drlxParseResult) {
        MethodCallExpr bindDSL = new MethodCallExpr(null, BIND_CALL);
        if (drlxParseResult.hasUnificationVariable()) {
            bindDSL.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(drlxParseResult.getUnificationVariable())));
        } else {
            bindDSL.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(drlxParseResult.getExprBinding())));
        }
        MethodCallExpr bindAsDSL = new MethodCallExpr((Expression)bindDSL, BIND_AS_CALL);
        bindAsDSL.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(drlxParseResult.getPatternBinding())));
        Expression constraintExpression = ModelGenerator.buildConstraintExpression(drlxParseResult, DrlxParseUtil.findLeftLeafOfMethodCall(drlxParseResult.getLeft().getExpression()));
        bindAsDSL.addArgument(constraintExpression);
        return ModelGenerator.buildReactOn(drlxParseResult, bindAsDSL);
    }

    static {
        attributesMap.put("no-loop", JavaParser.parseExpression((String)"Rule.Attribute.NO_LOOP"));
        attributesMap.put("salience", JavaParser.parseExpression((String)"Rule.Attribute.SALIENCE"));
        attributesMap.put("enabled", JavaParser.parseExpression((String)"Rule.Attribute.ENABLED"));
        attributesMap.put("auto-focus", JavaParser.parseExpression((String)"Rule.Attribute.AUTO_FOCUS"));
        attributesMap.put("lock-on-active", JavaParser.parseExpression((String)"Rule.Attribute.LOCK_ON_ACTIVE"));
        attributesMap.put("agenda-group", JavaParser.parseExpression((String)"Rule.Attribute.AGENDA_GROUP"));
        attributesMap.put("activation-group", JavaParser.parseExpression((String)"Rule.Attribute.ACTIVATION_GROUP"));
        attributesMap.put("ruleflow-group", JavaParser.parseExpression((String)"Rule.Attribute.RULEFLOW_GROUP"));
        attributesMap.put("duration", JavaParser.parseExpression((String)"Rule.Attribute.DURATION"));
        attributesMap.put("timer", JavaParser.parseExpression((String)"Rule.Attribute.TIMER"));
        attributesMap.put("calendars", JavaParser.parseExpression((String)"Rule.Attribute.CALENDARS"));
        attributesMap.put("date-effective", JavaParser.parseExpression((String)"Rule.Attribute.DATE_EFFECTIVE"));
        attributesMap.put("date-expires", JavaParser.parseExpression((String)"Rule.Attribute.DATE_EXPIRES"));
        consequenceMethods.put("getKnowledgeRuntime", JavaParser.parseExpression((String)"drools.getRuntime(org.kie.api.runtime.KieRuntime.class)"));
        consequenceMethods.put("getKieRuntime", JavaParser.parseExpression((String)"drools.getRuntime(org.kie.api.runtime.KieRuntime.class)"));
        customOperators.put("in", InOperatorSpec.INSTANCE);
        customOperators.put("before", TemporalOperatorSpec.INSTANCE);
        customOperators.put("after", TemporalOperatorSpec.INSTANCE);
        customOperators.put("coincides", TemporalOperatorSpec.INSTANCE);
        customOperators.put("metby", TemporalOperatorSpec.INSTANCE);
        customOperators.put("finishedby", TemporalOperatorSpec.INSTANCE);
        customOperators.put("overlaps", TemporalOperatorSpec.INSTANCE);
        customOperators.put("meets", TemporalOperatorSpec.INSTANCE);
        customOperators.put("during", TemporalOperatorSpec.INSTANCE);
        customOperators.put("finishes", TemporalOperatorSpec.INSTANCE);
        customOperators.put("startedby", TemporalOperatorSpec.INSTANCE);
        customOperators.put("overlappedby", TemporalOperatorSpec.INSTANCE);
        customOperators.put("includes", TemporalOperatorSpec.INSTANCE);
        customOperators.put("starts", TemporalOperatorSpec.INSTANCE);
    }
}

