/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.factmodel.GeneratedFact;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.BodyDeclaration;
import org.drools.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.drools.javaparser.ast.body.ConstructorDeclaration;
import org.drools.javaparser.ast.body.FieldDeclaration;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.comments.JavadocComment;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.NormalAnnotationExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.PrimitiveType;
import org.drools.javaparser.ast.type.Type;
import org.drools.modelcompiler.builder.GeneratedClassWithPackage;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.drools.modelcompiler.builder.PackageModel;
import org.kie.api.definition.type.Duration;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.Role;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class POJOGenerator {
    private static final String EQUALS = "equals";
    private static final String HASH_CODE = "hashCode";
    private static final String TO_STRING = "toString";
    private static final String TYPE_META_DATA_CALL = "typeMetaData";
    public static final Map<String, Class<?>> predefinedClassLevelAnnotation = new HashMap();
    private static final Statement referenceEquals;
    private static final Statement classCheckEquals;

    public static void generatePOJO(InternalKnowledgePackage pkg, PackageDescr packageDescr, PackageModel packageModel) {
        TypeResolver typeResolver = pkg.getTypeResolver();
        for (TypeDeclarationDescr typeDescr : packageDescr.getTypeDeclarations()) {
            try {
                POJOGenerator.processType(packageModel, typeDescr, typeResolver.resolveType(typeDescr.getTypeName()));
            }
            catch (ClassNotFoundException e) {
                packageModel.addGeneratedPOJO(POJOGenerator.toClassDeclaration(typeDescr));
                packageModel.addTypeMetaDataExpressions((Expression)POJOGenerator.registerTypeMetaData(packageModel, pkg.getName(), typeDescr.getTypeName()));
            }
        }
    }

    public static Map<String, Class<?>> compileType(KnowledgeBuilderImpl kbuilder, ClassLoader packageClassLoader, List<GeneratedClassWithPackage> classesWithPackage) {
        return JavaParserCompiler.compileAll(kbuilder, packageClassLoader, classesWithPackage);
    }

    public static void registerType(TypeResolver typeResolver, Map<String, Class<?>> classMap) {
        for (Map.Entry<String, Class<?>> entry : classMap.entrySet()) {
            typeResolver.registerClass(entry.getKey(), entry.getValue());
            typeResolver.registerClass(entry.getValue().getSimpleName(), entry.getValue());
        }
    }

    private static void processType(PackageModel packageModel, TypeDeclarationDescr typeDescr, Class<?> type) {
        MethodCallExpr typeMetaDataCall = POJOGenerator.registerTypeMetaData(packageModel, type.getPackage().getName(), type.getSimpleName());
        for (AnnotationDescr ann : typeDescr.getAnnotations()) {
            typeMetaDataCall = new MethodCallExpr((Expression)typeMetaDataCall, "addAnnotation");
            typeMetaDataCall.addArgument((Expression)new StringLiteralExpr(ann.getName()));
            for (Map.Entry entry : ann.getValueMap().entrySet()) {
                MethodCallExpr annotationValueCall = new MethodCallExpr(null, "annotationValue");
                annotationValueCall.addArgument((Expression)new StringLiteralExpr((String)entry.getKey()));
                annotationValueCall.addArgument((Expression)new StringLiteralExpr(entry.getValue().toString()));
                typeMetaDataCall.addArgument((Expression)annotationValueCall);
            }
        }
        packageModel.addTypeMetaDataExpressions((Expression)typeMetaDataCall);
    }

    private static MethodCallExpr registerTypeMetaData(PackageModel packageModel, String pkg, String name) {
        MethodCallExpr typeMetaDataCall = new MethodCallExpr(null, TYPE_META_DATA_CALL);
        typeMetaDataCall.addArgument((Expression)new StringLiteralExpr(pkg));
        typeMetaDataCall.addArgument((Expression)new StringLiteralExpr(name));
        return typeMetaDataCall;
    }

    public static ClassOrInterfaceDeclaration toClassDeclaration(TypeDeclarationDescr typeDeclaration) {
        EnumSet<Modifier> classModifiers = EnumSet.of(Modifier.PUBLIC);
        String generatedClassName = typeDeclaration.getTypeName();
        ClassOrInterfaceDeclaration generatedClass = new ClassOrInterfaceDeclaration(classModifiers, false, generatedClassName);
        generatedClass.addImplementedType(GeneratedFact.class.getName());
        if (typeDeclaration.getSuperTypeName() != null) {
            generatedClass.addExtendedType(typeDeclaration.getSuperTypeName());
        }
        ArrayList<AnnotationDescr> softAnnotations = new ArrayList<AnnotationDescr>();
        for (AnnotationDescr ann : typeDeclaration.getAnnotations()) {
            String annFqn = Optional.ofNullable(ann.getFullyQualifiedName()).orElse(Optional.ofNullable(predefinedClassLevelAnnotation.get(ann.getName())).map(Class::getCanonicalName).orElse(null));
            if (annFqn != null) {
                NormalAnnotationExpr annExpr = generatedClass.addAndGetAnnotation(annFqn);
                ann.getValueMap().forEach((k, v) -> annExpr.addPair(k, POJOGenerator.getAnnotationValue(annFqn, k, v.toString())));
                continue;
            }
            softAnnotations.add(ann);
        }
        if (softAnnotations.size() > 0) {
            String softAnnDictionary = softAnnotations.stream().map(a -> "<dt>" + a.getName() + "</dt><dd>" + a.getValuesAsString() + "</dd>").collect(Collectors.joining());
            JavadocComment generatedClassJavadoc = new JavadocComment("<dl>" + softAnnDictionary + "</dl>");
            generatedClass.setJavadocComment(generatedClassJavadoc);
        }
        generatedClass.addConstructor(new Modifier[]{Modifier.PUBLIC});
        ArrayList<Statement> equalsFieldStatement = new ArrayList<Statement>();
        ArrayList<Statement> hashCodeFieldStatement = new ArrayList<Statement>();
        ArrayList<String> toStringFieldStatement = new ArrayList<String>();
        NodeList ctorFieldStatement = NodeList.nodeList((Node[])new Statement[0]);
        if (!typeDeclaration.getFields().isEmpty()) {
            ConstructorDeclaration fullArgumentsCtor = generatedClass.addConstructor(new Modifier[]{Modifier.PUBLIC});
            int position = 0;
            for (TypeFieldDescr kv : typeDeclaration.getFields().values()) {
                String fieldName = kv.getFieldName();
                String typeName = kv.getPattern().getObjectType();
                Type returnType = JavaParser.parseType((String)typeName);
                FieldDeclaration field = generatedClass.addField(returnType, fieldName, new Modifier[]{Modifier.PRIVATE});
                field.createSetter();
                field.addAndGetAnnotation(Position.class.getName()).addPair("value", "" + position++);
                MethodDeclaration getter = field.createGetter();
                ctorFieldStatement.add((Node)POJOGenerator.replaceFieldName(JavaParser.parseStatement((String)"this.__fieldName = __fieldName;"), fieldName));
                fullArgumentsCtor.addParameter(returnType, fieldName);
                equalsFieldStatement.add(POJOGenerator.generateEqualsForField(getter, fieldName));
                hashCodeFieldStatement.addAll(POJOGenerator.generateHashCodeForField(getter, fieldName));
                toStringFieldStatement.add(MessageFormat.format("+ {0}+{1}", POJOGenerator.quote(fieldName + "="), fieldName));
            }
            fullArgumentsCtor.setBody(new BlockStmt(ctorFieldStatement));
        }
        generatedClass.addMember((BodyDeclaration)POJOGenerator.generateEqualsMethod(generatedClassName, equalsFieldStatement));
        generatedClass.addMember((BodyDeclaration)POJOGenerator.generateHashCodeMethod(hashCodeFieldStatement));
        generatedClass.addMember((BodyDeclaration)POJOGenerator.generateToStringMethod(generatedClassName, toStringFieldStatement));
        return generatedClass;
    }

    private static MethodDeclaration generateEqualsMethod(String generatedClassName, List<Statement> equalsFieldStatement) {
        NodeList equalsStatements = NodeList.nodeList((Node[])new Statement[]{referenceEquals, classCheckEquals});
        equalsStatements.add((Node)POJOGenerator.classCastStatement(generatedClassName));
        equalsStatements.addAll(equalsFieldStatement);
        equalsStatements.add((Node)JavaParser.parseStatement((String)"return true;"));
        Type returnType = JavaParser.parseType((String)Boolean.TYPE.getSimpleName());
        MethodDeclaration equals = new MethodDeclaration(EnumSet.of(Modifier.PUBLIC), returnType, EQUALS);
        equals.addParameter(Object.class, "o");
        equals.addAnnotation("Override");
        equals.setBody(new BlockStmt(equalsStatements));
        return equals;
    }

    private static Statement classCastStatement(String className) {
        Statement statement = JavaParser.parseStatement((String)"__className that = (__className) o;");
        statement.getChildNodesByType(ClassOrInterfaceType.class).stream().filter(n1 -> n1.getName().toString().equals("__className")).forEach(n -> n.replace((Node)JavaParser.parseClassOrInterfaceType((String)className)));
        return statement;
    }

    private static Statement generateEqualsForField(MethodDeclaration getter, String fieldName) {
        Statement statement;
        Type type = getter.getType();
        if (type instanceof ClassOrInterfaceType) {
            statement = JavaParser.parseStatement((String)" if( __fieldName != null ? !__fieldName.equals(that.__fieldName) : that.__fieldName != null) { return false; }");
        } else if (type instanceof PrimitiveType) {
            statement = JavaParser.parseStatement((String)" if( __fieldName != that.__fieldName) { return false; }");
        } else {
            throw new RuntimeException("Unknown type");
        }
        return POJOGenerator.replaceFieldName(statement, fieldName);
    }

    private static Statement replaceFieldName(Statement statement, String fieldName) {
        statement.getChildNodesByType(NameExpr.class).stream().filter(n -> n.getName().toString().equals("__fieldName")).forEach(n -> n.replace((Node)new NameExpr(fieldName)));
        statement.getChildNodesByType(FieldAccessExpr.class).stream().filter(n -> n.getName().toString().equals("__fieldName")).forEach(n -> n.replace((Node)new FieldAccessExpr(n.getScope(), fieldName)));
        return statement;
    }

    private static MethodDeclaration generateHashCodeMethod(List<Statement> hashCodeFieldStatement) {
        Statement header = JavaParser.parseStatement((String)"int result = 17;");
        NodeList hashCodeStatements = NodeList.nodeList((Node[])new Statement[]{header});
        hashCodeStatements.addAll(hashCodeFieldStatement);
        hashCodeStatements.add((Node)JavaParser.parseStatement((String)"return result;"));
        Type returnType = JavaParser.parseType((String)Integer.TYPE.getSimpleName());
        MethodDeclaration equals = new MethodDeclaration(EnumSet.of(Modifier.PUBLIC), returnType, HASH_CODE);
        equals.addAnnotation("Override");
        equals.setBody(new BlockStmt(hashCodeStatements));
        return equals;
    }

    private static List<Statement> generateHashCodeForField(MethodDeclaration getter, String fieldName) {
        Type type = getter.getType();
        if (type instanceof ClassOrInterfaceType) {
            return Arrays.asList(JavaParser.parseStatement((String)MessageFormat.format("result = 31 * result + ({0} != null ? {0}.hashCode() : 0);", fieldName)));
        }
        if (type instanceof PrimitiveType) {
            ArrayList<Statement> result = new ArrayList<Statement>();
            String primitiveToInt = fieldName;
            PrimitiveType.Primitive primitiveType = ((PrimitiveType)type).getType();
            switch (primitiveType) {
                case BOOLEAN: {
                    primitiveToInt = MessageFormat.format("({0} ? 1231 : 1237)", fieldName);
                    break;
                }
                case DOUBLE: {
                    Statement doubleToLongStatement = JavaParser.parseStatement((String)MessageFormat.format("long temp{0} = Double.doubleToLongBits({0});", fieldName));
                    result.add(doubleToLongStatement);
                    primitiveToInt = MessageFormat.format("(int) (temp{0} ^ (temp{0} >>> 32))", fieldName);
                    break;
                }
                case FLOAT: {
                    primitiveToInt = MessageFormat.format("Float.floatToIntBits({0})", fieldName);
                    break;
                }
                case LONG: {
                    primitiveToInt = MessageFormat.format("(int) ({0} ^ ({0} >>> 32))", fieldName);
                }
            }
            Statement primitiveStatement = JavaParser.parseStatement((String)MessageFormat.format("result = 31 * result + {0};", primitiveToInt));
            result.add(primitiveStatement);
            return result;
        }
        throw new RuntimeException("Unknown type");
    }

    private static MethodDeclaration generateToStringMethod(String generatedClassName, List<String> toStringFieldStatement) {
        String header = MessageFormat.format("return {0} + {1}", POJOGenerator.quote(generatedClassName), POJOGenerator.quote("( "));
        String body = String.join((CharSequence)MessageFormat.format("+ {0}", POJOGenerator.quote(", ")), toStringFieldStatement);
        String close = MessageFormat.format("+{0};", POJOGenerator.quote(" )"));
        Statement toStringStatement = JavaParser.parseStatement((String)(header + body + close));
        Type returnType = JavaParser.parseType((String)String.class.getSimpleName());
        MethodDeclaration equals = new MethodDeclaration(EnumSet.of(Modifier.PUBLIC), returnType, TO_STRING);
        equals.addAnnotation("Override");
        equals.setBody(new BlockStmt(NodeList.nodeList((Node[])new Statement[]{toStringStatement})));
        return equals;
    }

    private static String quote(String str) {
        return MessageFormat.format("\"{0}\"", str);
    }

    private static String getAnnotationValue(String annotationName, String valueName, String value) {
        if (annotationName.equals(Role.class.getCanonicalName())) {
            return Role.Type.class.getCanonicalName() + "." + value.toUpperCase();
        }
        if (annotationName.equals(Expires.class.getCanonicalName())) {
            if ("value".equals(valueName)) {
                return POJOGenerator.quote(value);
            }
            if ("policy".equals(valueName)) {
                return Expires.Policy.class.getCanonicalName() + "." + value.toUpperCase();
            }
            throw new UnsupportedOperationException("Unrecognized annotation value for Expires: " + valueName);
        }
        throw new UnsupportedOperationException("Unknown annotation: " + annotationName);
    }

    static {
        predefinedClassLevelAnnotation.put("role", Role.class);
        predefinedClassLevelAnnotation.put("duration", Duration.class);
        predefinedClassLevelAnnotation.put("expires", Expires.class);
        referenceEquals = JavaParser.parseStatement((String)"if (this == o) { return true; }");
        classCheckEquals = JavaParser.parseStatement((String)"if (o == null || getClass() != o.getClass()) { return false; }");
    }
}

