/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.expr.AssignExpr;
import org.drools.javaparser.ast.expr.ClassExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.expr.VariableDeclarationExpr;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.ReturnStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.Type;
import org.drools.model.Query;
import org.drools.model.QueryDef;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.QueryParameter;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.visitor.ModelGeneratorVisitor;
import org.drools.modelcompiler.util.StringUtil;

public class QueryGenerator {
    public static final String QUERY_CALL = "query";

    public static void processQueryDef(KnowledgeBuilderImpl kbuilder, InternalKnowledgePackage pkg, PackageModel packageModel, QueryDescr queryDescr) {
        RuleContext context = new RuleContext(kbuilder, pkg, packageModel.getExprIdGenerator(), (RuleDescr)queryDescr);
        String queryName = queryDescr.getName();
        String queryDefVariableName = QueryGenerator.toQueryDef(queryName);
        context.setQueryName(Optional.of(queryDefVariableName));
        QueryGenerator.parseQueryParameters(context, packageModel, queryDescr);
        ClassOrInterfaceType queryDefType = QueryGenerator.getQueryType(context.getQueryParameters());
        MethodCallExpr queryCall = new MethodCallExpr(null, QUERY_CALL);
        if (!queryDescr.getNamespace().isEmpty()) {
            queryCall.addArgument((Expression)new StringLiteralExpr(queryDescr.getNamespace()));
        }
        queryCall.addArgument((Expression)new StringLiteralExpr(queryName));
        for (QueryParameter qp : context.getQueryParameters()) {
            queryCall.addArgument((Expression)new ClassExpr(JavaParser.parseType((String)qp.type.getCanonicalName())));
            queryCall.addArgument((Expression)new StringLiteralExpr(qp.name));
        }
        packageModel.getQueryDefWithType().put(queryDefVariableName, new QueryDefWithType(queryDefType, queryCall, context));
    }

    public static void processQuery(KnowledgeBuilderImpl kbuilder, PackageModel packageModel, QueryDescr queryDescr) {
        RuleContext context = packageModel.getQueryDefWithType().get(QueryGenerator.toQueryDef(queryDescr.getName())).getContext();
        String queryDefVariableName = QueryGenerator.toQueryDef(queryDescr.getName());
        new ModelGeneratorVisitor(context, packageModel).visit(queryDescr.getLhs());
        Type queryType = JavaParser.parseType((String)Query.class.getCanonicalName());
        MethodDeclaration queryMethod = new MethodDeclaration(EnumSet.of(Modifier.PRIVATE), queryType, "query_" + StringUtil.toId(queryDescr.getName()));
        BlockStmt queryBody = new BlockStmt();
        ModelGenerator.createVariables(kbuilder, queryBody, packageModel, context);
        queryMethod.setBody(queryBody);
        String queryBuildVarName = queryDescr.getName() + "_build";
        VariableDeclarationExpr queryBuildVar = new VariableDeclarationExpr(queryType, queryBuildVarName);
        MethodCallExpr buildCall = new MethodCallExpr((Expression)new NameExpr(queryDefVariableName), "build");
        context.getExpressions().forEach(arg_0 -> ((MethodCallExpr)buildCall).addArgument(arg_0));
        AssignExpr queryBuildAssign = new AssignExpr((Expression)queryBuildVar, (Expression)buildCall, AssignExpr.Operator.ASSIGN);
        queryBody.addStatement((Expression)queryBuildAssign);
        queryBody.addStatement((Statement)new ReturnStmt(queryBuildVarName));
        packageModel.putQueryMethod(queryMethod);
    }

    private static void parseQueryParameters(RuleContext context, PackageModel packageModel, QueryDescr descr) {
        for (int i = 0; i < descr.getParameters().length; ++i) {
            String argument = descr.getParameters()[i];
            String type = descr.getParameterTypes()[i];
            context.addDeclaration(new DeclarationSpec(argument, DrlxParseUtil.getClassFromContext(context.getPkg().getTypeResolver(), type)));
            QueryParameter queryParameter = new QueryParameter(argument, DrlxParseUtil.getClassFromContext(context.getPkg().getTypeResolver(), type));
            context.getQueryParameters().add(queryParameter);
            packageModel.putQueryVariable("query_" + descr.getName(), queryParameter);
        }
    }

    private static ClassOrInterfaceType getQueryType(List<QueryParameter> queryParameters) {
        Class res = QueryDef.getQueryClassByArity((int)queryParameters.size());
        ClassOrInterfaceType queryType = JavaParser.parseClassOrInterfaceType((String)res.getCanonicalName());
        Type[] genericType = (Type[])queryParameters.stream().map(e -> e.type).map(DrlxParseUtil::classToReferenceType).toArray(Type[]::new);
        if (genericType.length > 0) {
            queryType.setTypeArguments(genericType);
        }
        return queryType;
    }

    public static boolean bindQuery(RuleContext context, PackageModel packageModel, PatternDescr pattern, List<? extends BaseDescr> descriptors) {
        String queryName = "query_" + pattern.getObjectType();
        MethodDeclaration queryMethod = packageModel.getQueryMethod(queryName);
        if (queryMethod != null) {
            NameExpr queryCall = new NameExpr(QueryGenerator.toQueryDef(pattern.getObjectType()));
            MethodCallExpr callCall = new MethodCallExpr((Expression)queryCall, "call");
            callCall.addArgument("" + !pattern.isQuery());
            for (int i = 0; i < descriptors.size(); ++i) {
                String itemText = descriptors.get(i).getText();
                if (QueryGenerator.isLiteral(itemText)) {
                    MethodCallExpr valueOfMethod = new MethodCallExpr(null, "valueOf");
                    valueOfMethod.addArgument((Expression)new NameExpr(itemText));
                    callCall.addArgument((Expression)valueOfMethod);
                    continue;
                }
                QueryParameter qp = packageModel.queryVariables(queryName).get(i);
                context.addDeclaration(new DeclarationSpec(itemText, qp.type));
                callCall.addArgument((Expression)new NameExpr(DrlxParseUtil.toVar(itemText)));
            }
            context.addExpression((Expression)callCall);
            return true;
        }
        return false;
    }

    public static boolean isLiteral(String value) {
        return value != null && value.length() > 0 && (Character.isDigit(value.charAt(0)) || value.charAt(0) == '\"' || "true".equals(value) || "false".equals(value) || "null".equals(value));
    }

    public static boolean createQueryCall(PackageModel packageModel, RuleContext context, PatternDescr pattern) {
        String queryDef = QueryGenerator.toQueryDef(pattern.getObjectType());
        if (packageModel.getQueryDefWithType().containsKey(queryDef)) {
            MethodCallExpr callMethod = new MethodCallExpr((Expression)new NameExpr(queryDef), "call");
            callMethod.addArgument("" + !pattern.isQuery());
            List<QueryParameter> parameters = packageModel.getQueryDefWithType().get(queryDef).getContext().getQueryParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                String queryName = context.getQueryName().orElseThrow(RuntimeException::new);
                ExprConstraintDescr variableName = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(i);
                Optional<String> unificationId = context.getUnificationId(variableName.toString());
                int queryIndex = i + 1;
                Expression parameterCall = unificationId.map(name -> new NameExpr(DrlxParseUtil.toVar(name))).orElseGet(() -> new MethodCallExpr((Expression)new NameExpr(queryName), QueryGenerator.toQueryArg(queryIndex)));
                callMethod.addArgument(parameterCall);
            }
            context.addExpression((Expression)callMethod);
            return true;
        }
        return false;
    }

    public static Expression substituteBindingWithQueryParameter(RuleContext context, String x) {
        Optional<QueryParameter> optQueryParameter = context.queryParameterWithName(p -> p.name.equals(x));
        return optQueryParameter.map(qp -> {
            String queryDef = context.getQueryName().orElseThrow(RuntimeException::new);
            int queryParameterIndex = context.getQueryParameters().indexOf(qp) + 1;
            return new MethodCallExpr((Expression)new NameExpr(queryDef), QueryGenerator.toQueryArg(queryParameterIndex));
        }).orElse((Expression)new NameExpr(DrlxParseUtil.toVar(x)));
    }

    public static String toQueryDef(String queryName) {
        return "queryDef_" + queryName;
    }

    private static String toQueryArg(int queryParameterIndex) {
        return "getArg" + queryParameterIndex;
    }

    public static class QueryDefWithType {
        private ClassOrInterfaceType queryType;
        private MethodCallExpr methodCallExpr;
        private RuleContext context;

        public QueryDefWithType(ClassOrInterfaceType queryType, MethodCallExpr methodCallExpr, RuleContext contex) {
            this.queryType = queryType;
            this.methodCallExpr = methodCallExpr;
            this.context = contex;
        }

        public ClassOrInterfaceType getQueryType() {
            return this.queryType;
        }

        public MethodCallExpr getMethodCallExpr() {
            return this.methodCallExpr;
        }

        public RuleContext getContext() {
            return this.context;
        }
    }
}

