/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.util.Objects;
import java.util.Optional;
import org.drools.javaparser.ast.expr.Expression;

public class TypedExpression {
    private Expression expression;
    private Class<?> type;
    private String fieldName;
    private Expression prefixExpression;
    private Optional<String> unificationVariable = Optional.empty();
    private Optional<String> unificationName = Optional.empty();

    public TypedExpression() {
    }

    public TypedExpression(Expression expression) {
        this(expression, null);
    }

    public TypedExpression(Expression expression, Class<?> type) {
        this(expression, type, null);
    }

    public TypedExpression(Expression expression, Class<?> type, String fieldName) {
        this.expression = expression;
        this.type = type;
        this.fieldName = fieldName;
    }

    public TypedExpression(String unificationVariable, Class<?> type, String name) {
        this.unificationVariable = Optional.of(unificationVariable);
        this.type = type;
        this.unificationName = Optional.of(name);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public TypedExpression setExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public TypedExpression setType(Class<?> type) {
        this.type = type;
        return this;
    }

    public Expression getPrefixExpression() {
        return this.prefixExpression;
    }

    public TypedExpression setPrefixExpression(Expression prefixExpression) {
        this.prefixExpression = prefixExpression;
        return this;
    }

    public String getExpressionAsString() {
        return this.expression.toString();
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isPrimitive() {
        return this.type != null && this.type.isPrimitive();
    }

    public Optional<String> getUnificationVariable() {
        return this.unificationVariable;
    }

    public Optional<String> getUnificationName() {
        return this.unificationName;
    }

    public String toString() {
        return "TypedExpression{expression=" + this.expression + ", type=" + this.type + ", fieldName='" + this.fieldName + '\'' + ", prefixExpression=" + this.prefixExpression + ", unificationVariable=" + this.unificationVariable + ", unificationName=" + this.unificationName + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedExpression that = (TypedExpression)o;
        return Objects.equals(this.expression.toString(), that.expression.toString()) && Objects.equals(this.type, that.type) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.prefixExpression, that.prefixExpression) && Objects.equals(this.unificationVariable, that.unificationVariable) && Objects.equals(this.unificationName, that.unificationName);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.type, this.fieldName, this.prefixExpression, this.unificationVariable, this.unificationName);
    }
}

