/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.consequence;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.core.WorkingMemory;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Tuple;
import org.drools.model.Consequence;
import org.drools.model.Variable;
import org.drools.model.functions.ScriptBlock;
import org.drools.modelcompiler.RuleContext;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.mvel2.MVEL;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.CachingMapVariableResolverFactory;

public class MVELConsequence
implements org.drools.core.spi.Consequence {
    private final Consequence consequence;
    private final RuleContext context;

    public MVELConsequence(Consequence consequence, RuleContext context) {
        this.consequence = consequence;
        this.context = context;
    }

    public String getName() {
        return "default";
    }

    public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
        Tuple tuple = knowledgeHelper.getTuple();
        Declaration[] declarations = ((RuleTerminalNode)knowledgeHelper.getMatch().getTuple().getTupleSink()).getRequiredDeclarations();
        Variable[] vars = this.consequence.getVariables();
        LinkedHashMap<Variable, Object> facts = new LinkedHashMap<Variable, Object>();
        int declrCounter = 0;
        for (Variable var : vars) {
            if (var.isFact()) {
                Declaration declaration = declarations[declrCounter++];
                InternalFactHandle fh = tuple.get(declaration);
                facts.put(var, declaration.getValue((InternalWorkingMemory)workingMemory, fh.getObject()));
                continue;
            }
            facts.put(var, workingMemory.getGlobal(var.getName()));
        }
        ScriptBlock scriptBlock = null;
        try {
            scriptBlock = (ScriptBlock)this.consequence.getBlock();
        }
        catch (ClassCastException e) {
            throw new RuntimeException("I tried to access a ScriptBlock but it was not. So something is thinking is a MVEL consequence but did not set the MVEL script textual representation", e);
        }
        String originalRHS = scriptBlock.getScript();
        String name = this.context.getRule().getPackageName() + "." + this.context.getRule().getName();
        String expression = MVELConsequenceBuilder.processMacros((String)originalRHS);
        String[] globalIdentifiers = new String[]{};
        String[] default_inputIdentifiers = new String[]{"this", "drools", "kcontext", "rule"};
        String[] inputIdentifiers = Stream.concat(Arrays.asList(default_inputIdentifiers).stream(), facts.entrySet().stream().map(kv -> ((Variable)kv.getKey()).getName())).collect(Collectors.toList()).toArray(new String[0]);
        String[] default_inputTypes = new String[]{"org.drools.core.spi.KnowledgeHelper", "org.drools.core.spi.KnowledgeHelper", "org.drools.core.spi.KnowledgeHelper", "org.kie.api.definition.rule.Rule"};
        String[] inputTypes = Stream.concat(Arrays.asList(default_inputTypes).stream(), facts.entrySet().stream().map(kv -> ((Variable)kv.getKey()).getType().asClass().getName())).collect(Collectors.toList()).toArray(new String[0]);
        int languageLevel = 4;
        boolean strictMode = true;
        boolean readLocalsFromTuple = false;
        EvaluatorWrapper[] operators = new EvaluatorWrapper[]{};
        Declaration[] previousDeclarations = new Declaration[]{};
        Declaration[] localDeclarations = new Declaration[]{};
        String[] otherIdentifiers = new String[]{};
        MVELCompilationUnit cu = new MVELCompilationUnit(name, expression, globalIdentifiers, operators, previousDeclarations, localDeclarations, otherIdentifiers, inputIdentifiers, inputTypes, languageLevel, strictMode, readLocalsFromTuple);
        MVELDialectRuntimeData runtimeData = new MVELDialectRuntimeData();
        runtimeData.onAdd(null, Thread.currentThread().getContextClassLoader());
        runtimeData.addPackageImport(this.context.getPkg().getName());
        runtimeData.addPackageImport("java.lang");
        for (KiePackage kp : this.context.getKnowledgePackages()) {
            if (kp.getName().equals(this.context.getPkg().getName())) continue;
            runtimeData.addPackageImport(kp.getName());
        }
        Serializable cuResult = cu.getCompiledExpression(runtimeData);
        ExecutableStatement compiledExpression = (ExecutableStatement)cuResult;
        HashMap<String, Object> mvelContext = new HashMap<String, Object>();
        mvelContext.put("this", knowledgeHelper);
        mvelContext.put("drools", knowledgeHelper);
        mvelContext.put("kcontext", knowledgeHelper);
        mvelContext.put("rule", knowledgeHelper.getRule());
        for (Map.Entry kv2 : facts.entrySet()) {
            mvelContext.put(((Variable)kv2.getKey()).getName(), kv2.getValue());
        }
        CachingMapVariableResolverFactory cachingFactory = new CachingMapVariableResolverFactory(mvelContext);
        VariableResolverFactory factory = cu.getFactory((Object)knowledgeHelper, ((AgendaItem)knowledgeHelper.getMatch()).getTerminalNode().getRequiredDeclarations(), (Rule)knowledgeHelper.getRule(), knowledgeHelper.getTuple(), null, (InternalWorkingMemory)workingMemory, workingMemory.getGlobalResolver());
        cachingFactory.setNextFactory(factory);
        MVEL.executeExpression((Object)compiledExpression, (Object)knowledgeHelper, (VariableResolverFactory)cachingFactory);
    }
}

