/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.modelcompiler.util.ClassUtil;

public class TypedExpression {
    private Expression expression;
    private Type type;
    private String fieldName;
    private Optional<String> unificationVariable = Optional.empty();
    private Optional<String> unificationName = Optional.empty();
    private Boolean staticExpr;
    private TypedExpression left;

    public TypedExpression() {
    }

    public TypedExpression(Expression expression) {
        this(expression, null);
    }

    public TypedExpression(Expression expression, Type type) {
        this(expression, type, null);
    }

    public TypedExpression(Expression expression, Type type, String fieldName) {
        this.expression = expression;
        this.type = type;
        this.fieldName = fieldName;
    }

    public TypedExpression(String unificationVariable, Type type, String name) {
        this.unificationVariable = Optional.of(unificationVariable);
        this.type = type;
        this.unificationName = Optional.of(name);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public TypedExpression setExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public TypedExpression setType(Type type) {
        this.type = type;
        return this;
    }

    public String getExpressionAsString() {
        return this.expression.toString();
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getRawClass() {
        return ClassUtil.toRawClass(this.type);
    }

    public boolean isPrimitive() {
        return this.type != null && ClassUtil.toRawClass(this.type).isPrimitive();
    }

    public boolean isArray() {
        return this.type != null && ClassUtil.toRawClass(this.type).isArray();
    }

    public Optional<String> getUnificationVariable() {
        return this.unificationVariable;
    }

    public Optional<String> getUnificationName() {
        return this.unificationName;
    }

    public TypedExpression setStatic(Boolean aStatic) {
        this.staticExpr = aStatic;
        return this;
    }

    public Boolean isStatic() {
        return this.staticExpr;
    }

    public TypedExpression setLeft(TypedExpression left) {
        this.left = left;
        return this;
    }

    public TypedExpression getLeft() {
        return this.left;
    }

    public TypedExpression cloneWithNewExpression(Expression newExpression) {
        TypedExpression cloned = new TypedExpression(newExpression, this.type, this.fieldName);
        cloned.unificationName = this.unificationName;
        cloned.unificationVariable = this.unificationVariable;
        cloned.staticExpr = this.staticExpr;
        cloned.left = this.left;
        return cloned;
    }

    public String toString() {
        return "TypedExpression{expression=" + this.expression + ", jpType=" + (this.expression == null ? "" : this.expression.getClass().getSimpleName()) + ", type=" + this.type + ", fieldName='" + this.fieldName + '\'' + ", unificationVariable=" + this.unificationVariable + ", unificationName=" + this.unificationName + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedExpression that = (TypedExpression)o;
        return Objects.equals(this.expression.toString(), that.expression.toString()) && Objects.equals(this.type, that.type) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.unificationVariable, that.unificationVariable) && Objects.equals(this.unificationName, that.unificationName);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.type, this.fieldName, this.unificationVariable, this.unificationName);
    }
}

