/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.drlxparse;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.core.util.DateUtils;
import org.drools.core.util.StringUtils;
import org.drools.core.util.index.IndexUtil;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.drlx.OOPathExpr;
import org.drools.javaparser.ast.drlx.expr.DrlxExpression;
import org.drools.javaparser.ast.drlx.expr.HalfBinaryExpr;
import org.drools.javaparser.ast.drlx.expr.HalfPointFreeExpr;
import org.drools.javaparser.ast.drlx.expr.PointFreeExpr;
import org.drools.javaparser.ast.expr.BigDecimalLiteralExpr;
import org.drools.javaparser.ast.expr.BigIntegerLiteralExpr;
import org.drools.javaparser.ast.expr.BinaryExpr;
import org.drools.javaparser.ast.expr.CastExpr;
import org.drools.javaparser.ast.expr.EnclosedExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.IntegerLiteralExpr;
import org.drools.javaparser.ast.expr.LiteralExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.ObjectCreationExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.expr.ThisExpr;
import org.drools.javaparser.ast.expr.UnaryExpr;
import org.drools.javaparser.ast.nodeTypes.NodeWithArguments;
import org.drools.javaparser.ast.nodeTypes.NodeWithOptionalScope;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.errors.ParseExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.ModelGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.CoercedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseFail;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.expression.AbstractExpressionBuilder;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyper;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyperContext;
import org.drools.modelcompiler.builder.generator.expressiontyper.TypedExpressionResult;

public class ConstraintParser {
    public static final boolean GENERATE_EXPR_ID = true;
    private RuleContext context;
    private PackageModel packageModel;

    public ConstraintParser(RuleContext context, PackageModel packageModel) {
        this.context = context;
        this.packageModel = packageModel;
    }

    public DrlxParseResult drlxParse(Class<?> patternType, String bindingId, String expression) {
        return this.drlxParse(patternType, bindingId, expression, false);
    }

    public DrlxParseResult drlxParse(Class<?> patternType, String bindingId, String expression, boolean isPositional) {
        return this.drlxParse(patternType, bindingId, new ConstraintExpression(expression), false);
    }

    public DrlxParseResult drlxParse(Class<?> patternType, String bindingId, ConstraintExpression expression, boolean isPositional) {
        DrlxExpression drlx = DrlxParseUtil.parseExpression(expression.getExpression());
        DrlxParseResult drlxParseResult = this.getDrlxParseResult(patternType, bindingId, expression, drlx.getExpr(), drlx.getBind() != null, isPositional);
        drlxParseResult.accept(result -> {
            if (drlx.getBind() != null) {
                String bindId = drlx.getBind().asString();
                this.context.addDeclaration(bindId, result.getExprRawClass());
                result.setExprBinding(bindId);
            }
        });
        return drlxParseResult;
    }

    private DrlxParseResult getDrlxParseResult(Class<?> patternType, String bindingId, ConstraintExpression constraint, Expression drlxExpr, boolean hasBind, boolean isPositional) {
        ExpressionTyper expressionTyper;
        ExpressionTyperContext expressionTyperContext;
        TypedExpression converted;
        boolean isEnclosed = false;
        while (drlxExpr instanceof EnclosedExpr) {
            drlxExpr = ((EnclosedExpr)drlxExpr).getInner();
            isEnclosed = true;
        }
        if (drlxExpr instanceof MethodCallExpr && !((MethodCallExpr)drlxExpr).getScope().isPresent() && ((MethodCallExpr)drlxExpr).getNameAsString().equals("eval")) {
            drlxExpr = ((MethodCallExpr)drlxExpr).getArgument(0);
        }
        String expression = constraint.getExpression();
        String exprId = this.context.getExprId(patternType, hasBind ? expression.substring(expression.indexOf(58) + 1).trim() : expression);
        if (drlxExpr instanceof BinaryExpr) {
            boolean isBetaNode;
            BinaryExpr combo;
            CoercedExpression.CoercedExpressionResult coerced;
            TypedExpression right;
            ArrayList<String> usedDeclarationsOnLeft;
            BinaryExpr binaryExpr = (BinaryExpr)drlxExpr;
            BinaryExpr.Operator operator = binaryExpr.getOperator();
            if (!(operator != BinaryExpr.Operator.AND && operator != BinaryExpr.Operator.OR || binaryExpr.getRight() instanceof HalfPointFreeExpr || binaryExpr.getRight() instanceof HalfBinaryExpr)) {
                DrlxParseResult leftResult = this.getDrlxParseResult(patternType, bindingId, constraint, binaryExpr.getLeft(), hasBind, isPositional);
                DrlxParseResult rightResult = this.getDrlxParseResult(patternType, bindingId, constraint, binaryExpr.getRight(), hasBind, isPositional);
                return leftResult.combineWith(rightResult, operator);
            }
            IndexUtil.ConstraintType decodeConstraintType = DrlxParseUtil.toConstraintType(operator);
            ExpressionTyperContext expressionTyperContext2 = new ExpressionTyperContext();
            ExpressionTyper expressionTyper2 = new ExpressionTyper(this.context, patternType, bindingId, isPositional, expressionTyperContext2);
            TypedExpressionResult leftTypedExpressionResult = expressionTyper2.toTypedExpression(binaryExpr.getLeft());
            Optional<TypedExpression> optLeft = leftTypedExpressionResult.getTypedExpression();
            if (!optLeft.isPresent()) {
                return new DrlxParseFail(new InvalidExpressionErrorResult("Unable to parse left part of expression: " + expression));
            }
            TypedExpression left2 = optLeft.get();
            ArrayList<String> arrayList = usedDeclarationsOnLeft = hasBind ? new ArrayList<String>(expressionTyperContext2.getUsedDeclarations()) : null;
            if (constraint.isNameClashingUnification()) {
                String name = constraint.getUnificationField();
                right = new TypedExpression((Expression)new NameExpr(name), left2.getType());
                expressionTyperContext2.addUsedDeclarations(name);
            } else {
                TypedExpressionResult rightExpressionResult = expressionTyper2.toTypedExpression(binaryExpr.getRight());
                Optional<TypedExpression> optRight = rightExpressionResult.getTypedExpression();
                if (!optRight.isPresent()) {
                    return new DrlxParseFail(new ParseExpressionErrorResult(drlxExpr));
                }
                right = optRight.get();
            }
            try {
                coerced = new CoercedExpression(left2, right).coerce();
            }
            catch (CoercedExpression.CoercedExpressionException e) {
                return new DrlxParseFail(e.getInvalidExpressionErrorResult());
            }
            left2 = coerced.getCoercedLeft();
            right = coerced.getCoercedRight();
            if (left2.isPrimitive()) {
                combo = new BinaryExpr(left2.getExpression(), right.getExpression(), operator);
            } else {
                switch (operator) {
                    case EQUALS: 
                    case NOT_EQUALS: {
                        combo = ConstraintParser.getEqualityExpression(left2, right, operator);
                        break;
                    }
                    default: {
                        if (left2.getExpression() == null || right.getExpression() == null) {
                            return new DrlxParseFail(new ParseExpressionErrorResult(drlxExpr));
                        }
                        combo = ConstraintParser.handleSpecialComparisonCases(operator, left2, right);
                    }
                }
            }
            for (Expression e : leftTypedExpressionResult.getPrefixExpressions()) {
                combo = new BinaryExpr(e, (Expression)combo, BinaryExpr.Operator.AND);
            }
            boolean bl = isBetaNode = right.getExpression() != null && this.context.getDeclarationById(AbstractExpressionBuilder.getExpressionSymbol(right.getExpression())).isPresent();
            if (isEnclosed) {
                combo = new EnclosedExpr((Expression)combo);
            }
            boolean requiresSplit = operator == BinaryExpr.Operator.AND && binaryExpr.getRight() instanceof HalfBinaryExpr && !isBetaNode;
            return new DrlxParseSuccess(patternType, exprId, bindingId, (Expression)combo, left2.getType()).setDecodeConstraintType(decodeConstraintType).setUsedDeclarations(expressionTyperContext2.getUsedDeclarations()).setUsedDeclarationsOnLeft(usedDeclarationsOnLeft).setUnification(constraint.isUnification()).setReactOnProperties(expressionTyperContext2.getReactOnProperties()).setLeft(left2).setRight(right).setBetaNode(isBetaNode).setRequiresSplit(requiresSplit);
        }
        if (drlxExpr instanceof UnaryExpr) {
            UnaryExpr unaryExpr = (UnaryExpr)drlxExpr;
            TypedExpressionResult typedExpressionResult = new ExpressionTyper(this.context, patternType, bindingId, isPositional).toTypedExpression((Expression)unaryExpr);
            return typedExpressionResult.getTypedExpression().map(left -> new DrlxParseSuccess(patternType, exprId, bindingId, left.getExpression(), left.getType()).setUsedDeclarations(typedExpressionResult.getUsedDeclarations()).setReactOnProperties(typedExpressionResult.getReactOnProperties()).setLeft((TypedExpression)left)).orElseGet(() -> new DrlxParseFail(new ParseExpressionErrorResult((Expression)unaryExpr)));
        }
        if (drlxExpr instanceof PointFreeExpr) {
            PointFreeExpr pointFreeExpr = (PointFreeExpr)drlxExpr;
            TypedExpressionResult typedExpressionResult = new ExpressionTyper(this.context, patternType, bindingId, isPositional).toTypedExpression((Expression)pointFreeExpr);
            return typedExpressionResult.getTypedExpression().map(typedExpression -> {
                Expression rightExpr;
                String rightLiteral = null;
                if (ModelGenerator.temporalOperators.contains(pointFreeExpr.getOperator().asString()) && pointFreeExpr.getRight().size() == 1 && (rightExpr = (Expression)pointFreeExpr.getRight().get(0)) instanceof StringLiteralExpr) {
                    String value = ((StringLiteralExpr)rightExpr).getValue();
                    rightLiteral = DateUtils.parseDate((String)value).getTime() + "L";
                }
                return new DrlxParseSuccess(patternType, exprId, bindingId, typedExpression.getExpression(), typedExpression.getType()).setUsedDeclarations(typedExpressionResult.getUsedDeclarations()).setUsedDeclarationsOnLeft(Collections.emptyList()).setReactOnProperties(typedExpressionResult.getReactOnProperties()).setLeft(typedExpression.getLeft()).setRightLiteral(rightLiteral).setStatic(typedExpression.isStatic()).setValidExpression(true);
            }).orElseGet(() -> new DrlxParseFail(new ParseExpressionErrorResult((Expression)pointFreeExpr)));
        }
        if (drlxExpr instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)drlxExpr;
            Optional<MethodDeclaration> functionCall = this.packageModel.getFunctions().stream().filter(m -> m.getName().equals((Object)methodCallExpr.getName())).findFirst();
            if (functionCall.isPresent()) {
                List rewriteThisExprs = ConstraintParser.recurseCollectArguments(methodCallExpr).stream().filter(ThisExpr.class::isInstance).map(ThisExpr.class::cast).collect(Collectors.toList());
                for (ThisExpr t : rewriteThisExprs) {
                    methodCallExpr.replace((Node)t, (Node)new NameExpr("_this"));
                }
                Class<?> returnType = DrlxParseUtil.getClassFromContext(this.context.getTypeResolver(), functionCall.get().getType().asString());
                NodeList arguments = methodCallExpr.getArguments();
                ArrayList<String> usedDeclarations = new ArrayList<String>();
                for (Expression arg : arguments) {
                    if (arg instanceof NameExpr && !arg.toString().equals("_this")) {
                        usedDeclarations.add(arg.toString());
                        continue;
                    }
                    if (arg instanceof CastExpr) {
                        usedDeclarations.add(((CastExpr)arg).getExpression().toString());
                        continue;
                    }
                    if (!(arg instanceof MethodCallExpr)) continue;
                    TypedExpressionResult typedExpressionResult = new ExpressionTyper(this.context, null, bindingId, isPositional).toTypedExpression(arg);
                    usedDeclarations.addAll(typedExpressionResult.getUsedDeclarations());
                }
                return new DrlxParseSuccess(patternType, exprId, bindingId, (Expression)methodCallExpr, returnType).setUsedDeclarations(usedDeclarations);
            }
        }
        if (drlxExpr instanceof FieldAccessExpr) {
            FieldAccessExpr fieldCallExpr = (FieldAccessExpr)drlxExpr;
            converted = DrlxParseUtil.toMethodCallWithClassCheck(this.context, (Expression)fieldCallExpr, bindingId, patternType, this.context.getTypeResolver());
            Expression withThis = DrlxParseUtil.prepend((Expression)new NameExpr("_this"), converted.getExpression());
            return new DrlxParseSuccess(patternType, exprId, bindingId, withThis, converted.getType()).setLeft(converted);
        }
        if (drlxExpr instanceof NameExpr) {
            NameExpr nameExpr = (NameExpr)drlxExpr;
            converted = DrlxParseUtil.toMethodCallWithClassCheck(this.context, (Expression)nameExpr, bindingId, patternType, this.context.getTypeResolver());
            if (converted == null) {
                return new DrlxParseFail();
            }
            Expression withThis = DrlxParseUtil.prepend((Expression)new NameExpr("_this"), converted.getExpression());
            if (hasBind) {
                return new DrlxParseSuccess(patternType, exprId, bindingId, null, converted.getType()).setLeft(new TypedExpression(withThis, converted.getType())).addReactOnProperty(StringUtils.lcFirst((String)nameExpr.getNameAsString()));
            }
            if (this.context.hasDeclaration("b")) {
                return new DrlxParseSuccess(patternType, exprId, bindingId, this.context.getVarExpr(drlxExpr.toString()), (Type)((Object)Boolean.class));
            }
            return new DrlxParseSuccess(patternType, exprId, bindingId, withThis, converted.getType()).addReactOnProperty(nameExpr.getNameAsString());
        }
        if (drlxExpr instanceof OOPathExpr) {
            return new DrlxParseSuccess(patternType, exprId, bindingId, drlxExpr, null);
        }
        if (drlxExpr instanceof LiteralExpr) {
            return new DrlxParseSuccess(patternType, exprId, bindingId, drlxExpr, DrlxParseUtil.getLiteralExpressionType((LiteralExpr)drlxExpr));
        }
        if (patternType != null) {
            expressionTyperContext = new ExpressionTyperContext();
            expressionTyper = new ExpressionTyper(this.context, patternType, bindingId, isPositional, expressionTyperContext);
            TypedExpressionResult leftTypedExpressionResult = expressionTyper.toTypedExpression(drlxExpr);
            Optional<TypedExpression> optLeft = leftTypedExpressionResult.getTypedExpression();
            if (!optLeft.isPresent()) {
                return new DrlxParseFail(new InvalidExpressionErrorResult("Unable to parse left part of expression: " + expression));
            }
            TypedExpression left3 = optLeft.get();
            Expression combo = left3.getExpression();
            for (Expression e : leftTypedExpressionResult.getPrefixExpressions()) {
                combo = new BinaryExpr(e, combo, BinaryExpr.Operator.AND);
            }
            return new DrlxParseSuccess(patternType, exprId, bindingId, combo, left3.getType()).setUsedDeclarations(expressionTyperContext.getUsedDeclarations());
        }
        expressionTyperContext = new ExpressionTyperContext();
        expressionTyper = new ExpressionTyper(this.context, patternType, bindingId, isPositional, expressionTyperContext);
        TypedExpressionResult leftTypedExpressionResult = expressionTyper.toTypedExpression(drlxExpr);
        Optional<TypedExpression> optLeft = leftTypedExpressionResult.getTypedExpression();
        if (!optLeft.isPresent()) {
            return new DrlxParseFail(new InvalidExpressionErrorResult("Unable to parse left part of expression: " + expression));
        }
        TypedExpression left4 = optLeft.get();
        return new DrlxParseSuccess(patternType, exprId, bindingId, drlxExpr, left4.getType()).setUsedDeclarations(expressionTyperContext.getUsedDeclarations());
    }

    private static Expression getEqualityExpression(TypedExpression left, TypedExpression right, BinaryExpr.Operator operator) {
        if (ConstraintParser.isAnyOperandBigDecimal(left, right) || ConstraintParser.isAnyOperandBigInteger(left, right)) {
            return ConstraintParser.compareBigDecimal(operator, left, right);
        }
        Expression rightExpression = right.getExpression();
        Expression leftExpression = left.getExpression();
        if (DrlxParseUtil.isPrimitiveExpression(rightExpression) && DrlxParseUtil.isPrimitiveExpression(leftExpression) && left.getType() != String.class) {
            return new BinaryExpr(leftExpression, rightExpression, operator == BinaryExpr.Operator.EQUALS ? BinaryExpr.Operator.EQUALS : BinaryExpr.Operator.NOT_EQUALS);
        }
        String equalsMethod = !left.getType().equals(right.getType()) && Number.class.isAssignableFrom(left.getRawClass()) ? "org.drools.modelcompiler.util.EvaluationUtil.areNumbersNullSafeEquals" : "org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals";
        MethodCallExpr methodCallExpr = new MethodCallExpr(null, equalsMethod);
        methodCallExpr.addArgument(left.getExpression());
        methodCallExpr.addArgument(right.getExpression());
        return operator == BinaryExpr.Operator.EQUALS ? methodCallExpr : new UnaryExpr((Expression)methodCallExpr, UnaryExpr.Operator.LOGICAL_COMPLEMENT);
    }

    private static Expression handleSpecialComparisonCases(BinaryExpr.Operator operator, TypedExpression left, TypedExpression right) {
        if ((ConstraintParser.isAnyOperandBigDecimal(left, right) || ConstraintParser.isAnyOperandBigInteger(left, right)) && ConstraintParser.isComparisonOperator(operator)) {
            return ConstraintParser.compareBigDecimal(operator, left, right);
        }
        if (ConstraintParser.isComparisonOperator(operator)) {
            MethodCallExpr compareMethod = null;
            if (left.getType() == String.class && right.getType() == String.class) {
                compareMethod = new MethodCallExpr(null, "org.drools.modelcompiler.util.EvaluationUtil.compareStringsAsNumbers");
            } else if (ConstraintParser.isNumericType(left.getRawClass()) || ConstraintParser.isNumericType(right.getRawClass())) {
                compareMethod = new MethodCallExpr(null, "org.drools.modelcompiler.util.EvaluationUtil.compareNumbers");
            } else if (Comparable.class.isAssignableFrom(left.getRawClass()) && Comparable.class.isAssignableFrom(right.getRawClass())) {
                compareMethod = new MethodCallExpr(null, "org.drools.modelcompiler.util.EvaluationUtil.compare");
            }
            if (compareMethod != null) {
                compareMethod.addArgument(left.getExpression());
                compareMethod.addArgument(right.getExpression());
                compareMethod.addArgument((Expression)new StringLiteralExpr(operator.asString()));
                return compareMethod;
            }
        }
        return new BinaryExpr(left.getExpression(), right.getExpression(), operator);
    }

    private static boolean isNumericType(Class<?> type) {
        return Number.class.isAssignableFrom(type) && type != BigInteger.class && type != BigDecimal.class;
    }

    private static boolean isAnyOperandBigDecimal(TypedExpression left, TypedExpression right) {
        return left.getType() == BigDecimal.class || right.getType() == BigDecimal.class;
    }

    private static boolean isAnyOperandBigInteger(TypedExpression left, TypedExpression right) {
        return left.getType() == BigInteger.class || right.getType() == BigInteger.class;
    }

    private static Expression compareBigDecimal(BinaryExpr.Operator operator, TypedExpression left, TypedExpression right) {
        TypedExpression convertedLeft = left.cloneWithNewExpression(ConstraintParser.convertExpressionToBigDecimal(left));
        TypedExpression convertedRight = right.cloneWithNewExpression(ConstraintParser.convertExpressionToBigDecimal(right));
        MethodCallExpr methodCallExpr = new MethodCallExpr(convertedLeft.getExpression(), "compareTo");
        methodCallExpr.addArgument(convertedRight.getExpression());
        return new BinaryExpr((Expression)methodCallExpr, (Expression)new IntegerLiteralExpr(0), operator);
    }

    private static Expression convertExpressionToBigDecimal(TypedExpression te) {
        Object convertedExpression = te.getType() == BigInteger.class ? (te.getExpression() instanceof BigIntegerLiteralExpr ? DrlxParseUtil.toNewBigDecimalExpr((Expression)new StringLiteralExpr(((BigIntegerLiteralExpr)te.getExpression()).asBigInteger().toString())) : new ObjectCreationExpr(null, DrlxParseUtil.toClassOrInterfaceType(BigDecimal.class), NodeList.nodeList((Node[])new Expression[]{te.getExpression()}))) : (te.getType() != BigDecimal.class ? (Expression)new MethodCallExpr((Expression)new NameExpr(BigDecimal.class.getCanonicalName()), "valueOf").addArgument(te.getExpression()) : (te.getExpression() instanceof BigDecimalLiteralExpr ? DrlxParseUtil.toNewBigDecimalExpr((Expression)new StringLiteralExpr(((BigDecimalLiteralExpr)te.getExpression()).asBigDecimal().toString())) : te.getExpression()));
        return convertedExpression;
    }

    private static boolean isComparisonOperator(BinaryExpr.Operator op) {
        return op == BinaryExpr.Operator.LESS || op == BinaryExpr.Operator.GREATER || op == BinaryExpr.Operator.LESS_EQUALS || op == BinaryExpr.Operator.GREATER_EQUALS;
    }

    private static List<Expression> recurseCollectArguments(NodeWithArguments<?> methodCallExpr) {
        Object scope;
        NodeWithOptionalScope nodeWithOptionalScope;
        ArrayList<Expression> res = new ArrayList<Expression>((Collection<Expression>)methodCallExpr.getArguments());
        if (methodCallExpr instanceof NodeWithOptionalScope && (nodeWithOptionalScope = (NodeWithOptionalScope)methodCallExpr).getScope().isPresent() && (scope = nodeWithOptionalScope.getScope().get()) instanceof NodeWithArguments) {
            res.addAll(ConstraintParser.recurseCollectArguments((NodeWithArguments)scope));
        }
        return res;
    }
}

