/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.pattern;

import java.util.List;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.QueryGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.visitor.DSLNode;
import org.drools.modelcompiler.builder.generator.visitor.pattern.FlowAccumulateConstraint;
import org.drools.modelcompiler.builder.generator.visitor.pattern.FlowDSLPattern;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternAccumulateConstraint;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternDSLPattern;
import org.drools.modelcompiler.builder.generator.visitor.pattern.Query;
import org.drools.modelcompiler.builder.generator.visitor.pattern.QueryCall;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class PatternVisitor {
    private final RuleContext context;
    private final PackageModel packageModel;

    public PatternVisitor(RuleContext context, PackageModel packageModel) {
        this.context = context;
        this.packageModel = packageModel;
    }

    public DSLNode visit(PatternDescr pattern) {
        String className = pattern.getObjectType();
        List constraintDescrs = pattern.getConstraint().getDescrs();
        String queryName = "query_" + pattern.getObjectType();
        MethodDeclaration queryMethod = this.packageModel.getQueryMethod(queryName);
        if (queryMethod != null) {
            return new Query(this.context, this.packageModel, pattern, constraintDescrs, queryName);
        }
        String queryDef = QueryGenerator.toQueryDef(pattern.getObjectType());
        if (this.packageModel.getQueryDefWithType().containsKey(queryDef)) {
            return new QueryCall(this.context, this.packageModel, pattern, queryDef);
        }
        if (pattern.getIdentifier() == null && pattern.getObjectType().equals("Object") && pattern.getSource() instanceof AccumulateDescr) {
            if (this.context.isPatternDSL()) {
                return new PatternAccumulateConstraint(this.context, this.packageModel, pattern, (AccumulateDescr)pattern.getSource(), constraintDescrs);
            }
            return new FlowAccumulateConstraint(this.context, this.packageModel, pattern, (AccumulateDescr)pattern.getSource(), constraintDescrs);
        }
        Class patternType = null;
        try {
            patternType = this.context.getTypeResolver().resolveType(className);
        }
        catch (ClassNotFoundException e) {
            this.context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Unable to find class: " + className));
            return () -> {};
        }
        boolean allConstraintsPositional = this.areAllConstraintsPositional(constraintDescrs);
        if (this.context.isPatternDSL()) {
            return new PatternDSLPattern(this.context, this.packageModel, pattern, (List<? extends BaseDescr>)constraintDescrs, patternType, allConstraintsPositional);
        }
        return new FlowDSLPattern(this.context, this.packageModel, pattern, (List<? extends BaseDescr>)constraintDescrs, patternType, allConstraintsPositional);
    }

    private boolean areAllConstraintsPositional(List<? extends BaseDescr> constraintDescrs) {
        return !constraintDescrs.isEmpty() && constraintDescrs.stream().allMatch(c -> c instanceof ExprConstraintDescr && ((ExprConstraintDescr)c).getType().equals((Object)ExprConstraintDescr.Type.POSITIONAL));
    }
}

