/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.Tuple;
import org.drools.modelcompiler.constraints.BindingEvaluator;
import org.kie.api.runtime.rule.AccumulateFunction;

public abstract class LambdaAccumulator
implements Accumulator {
    private final AccumulateFunction accumulateFunction;
    protected final List<String> sourceVariables;

    protected LambdaAccumulator(AccumulateFunction accumulateFunction, List<String> sourceVariables) {
        this.accumulateFunction = accumulateFunction;
        this.sourceVariables = sourceVariables;
    }

    public Object createWorkingMemoryContext() {
        return null;
    }

    public Serializable createContext() {
        try {
            return this.accumulateFunction.createContext();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        this.accumulateFunction.init((Serializable)context);
    }

    public void accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        this.accumulateFunction.accumulate((Serializable)context, this.getAccumulatedObject(declarations, innerDeclarations, handle, leftTuple, (InternalWorkingMemory)workingMemory));
    }

    protected abstract Object getAccumulatedObject(Declaration[] var1, Declaration[] var2, InternalFactHandle var3, Tuple var4, InternalWorkingMemory var5);

    public boolean supportsReverse() {
        return this.accumulateFunction.supportsReverse();
    }

    public void reverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        this.accumulateFunction.reverse((Serializable)context, this.getAccumulatedObject(declarations, innerDeclarations, handle, leftTuple, (InternalWorkingMemory)workingMemory));
    }

    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        return this.accumulateFunction.getResult((Serializable)context);
    }

    public static class FixedValueAcc
    extends LambdaAccumulator {
        private final Object value;

        public FixedValueAcc(AccumulateFunction accumulateFunction, Object value) {
            super(accumulateFunction, Collections.emptyList());
            this.value = value;
        }

        @Override
        protected Object getAccumulatedObject(Declaration[] declarations, Declaration[] innerDeclarations, InternalFactHandle handle, Tuple tuple, InternalWorkingMemory wm) {
            return this.value;
        }
    }

    public static class NotBindingAcc
    extends LambdaAccumulator {
        public NotBindingAcc(AccumulateFunction accumulateFunction, List<String> sourceVariables) {
            super(accumulateFunction, sourceVariables);
        }

        @Override
        protected Object getAccumulatedObject(Declaration[] declarations, Declaration[] innerDeclarations, InternalFactHandle handle, Tuple tuple, InternalWorkingMemory wm) {
            Object accumulateObject = handle.getObject();
            if (accumulateObject instanceof SubnetworkTuple) {
                return ((SubnetworkTuple)accumulateObject).getObject(declarations[0]);
            }
            return accumulateObject;
        }
    }

    public static class BindingAcc
    extends LambdaAccumulator {
        private final BindingEvaluator binding;

        public BindingAcc(AccumulateFunction accumulateFunction, List<String> sourceVariables, BindingEvaluator binding) {
            super(accumulateFunction, sourceVariables);
            this.binding = binding;
        }

        @Override
        protected Object getAccumulatedObject(Declaration[] declarations, Declaration[] innerDeclarations, InternalFactHandle handle, Tuple tuple, InternalWorkingMemory wm) {
            Object accumulateObject = handle.getObject();
            if (accumulateObject instanceof SubnetworkTuple) {
                Object[] args = new Object[this.sourceVariables.size()];
                block0: for (int i = 0; i < this.sourceVariables.size(); ++i) {
                    for (Declaration d : innerDeclarations) {
                        if (!d.getIdentifier().equals(this.sourceVariables.get(i))) continue;
                        args[i] = ((SubnetworkTuple)accumulateObject).getObject(d);
                        continue block0;
                    }
                }
                return this.binding.evaluate(args);
            }
            return this.binding.evaluate(handle, tuple, wm);
        }
    }
}

