/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BehaviorDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.rule.Behavior;
import org.drools.core.ruleunit.RuleUnitDescr;
import org.drools.core.time.TimeUtils;
import org.drools.core.util.MVELSafeHelper;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.expr.AssignExpr;
import org.drools.javaparser.ast.expr.ClassExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NullLiteralExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.expr.VariableDeclarationExpr;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.ReturnStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.model.Rule;
import org.drools.model.UnitData;
import org.drools.model.Variable;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.UnknownDeclarationError;
import org.drools.modelcompiler.builder.generator.Consequence;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.FunctionGenerator;
import org.drools.modelcompiler.builder.generator.QueryGenerator;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.WindowReferenceGenerator;
import org.drools.modelcompiler.builder.generator.visitor.ModelGeneratorVisitor;
import org.drools.modelcompiler.util.ClassUtil;
import org.drools.modelcompiler.util.StringUtil;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class ModelGenerator {
    private static final Map<String, Expression> attributesMap = new HashMap<String, Expression>();
    public static final Set<String> temporalOperators = new HashSet<String>();
    public static final boolean GENERATE_EXPR_ID = true;

    public static void generateModel(KnowledgeBuilderImpl kbuilder, InternalKnowledgePackage pkg, PackageDescr packageDescr, PackageModel packageModel, boolean isPattern) {
        TypeResolver typeResolver = pkg.getTypeResolver();
        packageModel.addImports(pkg.getImports().keySet());
        packageModel.addStaticImports(pkg.getStaticImports());
        packageModel.addGlobals(pkg.getGlobals());
        packageModel.addAccumulateFunctions(pkg.getAccumulateFunctions());
        packageModel.setInternalKnowledgePackage(pkg);
        new WindowReferenceGenerator(packageModel, typeResolver).addWindowReferences(kbuilder, packageDescr.getWindowDeclarations());
        packageModel.addAllFunctions(packageDescr.getFunctions().stream().map(FunctionGenerator::toFunction).collect(Collectors.toList()));
        for (RuleDescr descr : packageDescr.getRules()) {
            if (!(descr instanceof QueryDescr)) continue;
            QueryGenerator.processQueryDef(kbuilder, typeResolver, packageModel, (QueryDescr)descr, isPattern);
        }
        for (RuleDescr descr : packageDescr.getRules()) {
            if (descr instanceof QueryDescr) {
                QueryGenerator.processQuery(kbuilder, packageModel, (QueryDescr)descr);
                continue;
            }
            ModelGenerator.processRule(kbuilder, typeResolver, packageModel, packageDescr, descr, isPattern);
        }
    }

    private static void processRule(KnowledgeBuilderImpl kbuilder, TypeResolver typeResolver, PackageModel packageModel, PackageDescr packageDescr, RuleDescr ruleDescr, boolean isPattern) {
        RuleContext context = new RuleContext(kbuilder, packageModel, ruleDescr, typeResolver, isPattern);
        context.addGlobalDeclarations(packageModel.getGlobals());
        for (Map.Entry kv : ruleDescr.getNamedConsequences().entrySet()) {
            context.addNamedConsequence((String)kv.getKey(), kv.getValue().toString());
        }
        ModelGenerator.setDialectFromRuleDescr(context, ruleDescr);
        RuleUnitDescr ruleUnitDescr = context.getRuleUnitDescr();
        BlockStmt ruleVariablesBlock = new BlockStmt();
        ModelGenerator.createUnitData(context, ruleUnitDescr, ruleVariablesBlock);
        new ModelGeneratorVisitor(context, packageModel).visit(ModelGenerator.getExtendedLhs(packageDescr, ruleDescr));
        String ruleMethodName = "rule_" + StringUtil.toId(ruleDescr.getName());
        MethodDeclaration ruleMethod = new MethodDeclaration(EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), (org.drools.javaparser.ast.type.Type)DrlxParseUtil.toClassOrInterfaceType(Rule.class), ruleMethodName);
        ruleMethod.setJavadocComment(" Rule name: " + ruleDescr.getName() + " ");
        VariableDeclarationExpr ruleVar = new VariableDeclarationExpr((org.drools.javaparser.ast.type.Type)DrlxParseUtil.toClassOrInterfaceType(Rule.class), "rule");
        MethodCallExpr ruleCall = new MethodCallExpr(null, "D.rule");
        if (!ruleDescr.getNamespace().isEmpty()) {
            ruleCall.addArgument((Expression)new StringLiteralExpr(ruleDescr.getNamespace()));
        }
        ruleCall.addArgument((Expression)new StringLiteralExpr(ruleDescr.getName()));
        MethodCallExpr buildCallScope = ruleUnitDescr != null ? (MethodCallExpr)new MethodCallExpr((Expression)ruleCall, "unit").addArgument((Expression)new ClassExpr(DrlxParseUtil.classToReferenceType(ruleUnitDescr.getRuleUnitClass()))) : ruleCall;
        for (MethodCallExpr attributeExpr : ModelGenerator.ruleAttributes(ruleDescr)) {
            attributeExpr.setScope((Expression)buildCallScope);
            buildCallScope = attributeExpr;
        }
        for (MethodCallExpr metaAttributeExpr : ModelGenerator.ruleMetaAttributes(context, ruleDescr)) {
            metaAttributeExpr.setScope((Expression)buildCallScope);
            buildCallScope = metaAttributeExpr;
        }
        MethodCallExpr buildCall = new MethodCallExpr((Expression)buildCallScope, "build", NodeList.nodeList(context.getExpressions()));
        ModelGenerator.createVariables(kbuilder, ruleVariablesBlock, packageModel, context);
        ruleMethod.setBody(ruleVariablesBlock);
        MethodCallExpr executeCall = new Consequence(context).createCall(ruleDescr, ruleDescr.getConsequence().toString(), ruleVariablesBlock, false);
        buildCall.addArgument((Expression)executeCall);
        ruleVariablesBlock.addStatement((Expression)new AssignExpr((Expression)ruleVar, (Expression)buildCall, AssignExpr.Operator.ASSIGN));
        ruleVariablesBlock.addStatement((Statement)new ReturnStmt("rule"));
        packageModel.putRuleMethod(ruleMethodName, ruleMethod);
    }

    private static AndDescr getExtendedLhs(PackageDescr packageDescr, RuleDescr ruleDescr) {
        if (ruleDescr.getParentName() == null) {
            return ruleDescr.getLhs();
        }
        RuleDescr parent = packageDescr.getRules().stream().filter(r -> r.getName().equals(ruleDescr.getParentName())).findFirst().orElseThrow(() -> new RuntimeException("Rule " + ruleDescr.getName() + " extends an unknown rule " + ruleDescr.getParentName()));
        AndDescr extendedLhs = new AndDescr();
        ModelGenerator.getExtendedLhs(packageDescr, parent).getDescrs().forEach(arg_0 -> ((AndDescr)extendedLhs).addDescr(arg_0));
        ruleDescr.getLhs().getDescrs().forEach(arg_0 -> ((AndDescr)extendedLhs).addDescr(arg_0));
        return extendedLhs;
    }

    private static List<MethodCallExpr> ruleAttributes(RuleDescr ruleDescr) {
        ArrayList<MethodCallExpr> ruleAttributes = new ArrayList<MethodCallExpr>();
        Set excludingDialect = ruleDescr.getAttributes().entrySet().stream().filter(r -> !((String)r.getKey()).equals("dialect")).collect(Collectors.toSet());
        for (Map.Entry as : excludingDialect) {
            MethodCallExpr attributeCall = new MethodCallExpr(null, "attribute");
            attributeCall.addArgument(attributesMap.get(as.getKey()));
            switch ((String)as.getKey()) {
                case "no-loop": 
                case "salience": 
                case "enabled": 
                case "auto-focus": 
                case "lock-on-active": {
                    attributeCall.addArgument(JavaParser.parseExpression((String)((AttributeDescr)as.getValue()).getValue()));
                    break;
                }
                case "agenda-group": 
                case "activation-group": 
                case "ruleflow-group": 
                case "duration": 
                case "timer": {
                    attributeCall.addArgument((Expression)new StringLiteralExpr(((AttributeDescr)as.getValue()).getValue()));
                    break;
                }
                case "calendars": {
                    String value = ((AttributeDescr)as.getValue()).getValue().trim();
                    if (value.startsWith("[")) {
                        value = value.substring(1, value.length() - 1).trim();
                    }
                    Expression arrayExpr = JavaParser.parseExpression((String)("new String[] { " + value + " }"));
                    attributeCall.addArgument(arrayExpr);
                    break;
                }
                case "date-effective": 
                case "date-expires": {
                    attributeCall.addArgument(JavaParser.parseExpression((String)String.format("GregorianCalendar.from(LocalDate.parse(\"%s\", DATE_TIME_FORMATTER).atStartOfDay(ZoneId.systemDefault()))", ((AttributeDescr)as.getValue()).getValue())));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled case for rule attribute: " + (String)as.getKey());
                }
            }
            ruleAttributes.add(attributeCall);
        }
        return ruleAttributes;
    }

    public static void setDialectFromRuleDescr(RuleContext context, RuleDescr ruleDescr) {
        for (Map.Entry as : ruleDescr.getAttributes().entrySet()) {
            if (!((String)as.getKey()).equals("dialect")) continue;
            if (((AttributeDescr)as.getValue()).getValue().equals("mvel")) {
                context.setRuleDialect(RuleContext.RuleDialect.MVEL);
            }
            return;
        }
    }

    private static List<MethodCallExpr> ruleMetaAttributes(RuleContext context, RuleDescr ruleDescr) {
        ArrayList<MethodCallExpr> ruleMetaAttributes = new ArrayList<MethodCallExpr>();
        for (String metaAttr : ruleDescr.getAnnotationNames()) {
            MethodCallExpr metaAttributeCall = new MethodCallExpr("metadata", new Expression[0]);
            metaAttributeCall.addArgument((Expression)new StringLiteralExpr(metaAttr));
            AnnotationDescr ad = ruleDescr.getAnnotation(metaAttr);
            String adFqn = ad.getFullyQualifiedName();
            if (adFqn != null) {
                AnnotationDefinition annotationDefinition;
                try {
                    annotationDefinition = AnnotationDefinition.build((Class)context.getTypeResolver().resolveType(adFqn), (Map)ad.getValueMap(), (TypeResolver)context.getTypeResolver());
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                if (annotationDefinition.getValues().size() == 1 && annotationDefinition.getValues().containsKey("value")) {
                    Object annValue = annotationDefinition.getPropertyValue("value");
                    metaAttributeCall.addArgument((Expression)new StringLiteralExpr(annValue.toString()));
                } else {
                    HashMap<String, Object> map = new HashMap<String, Object>(annotationDefinition.getValues().size());
                    for (String key : annotationDefinition.getValues().keySet()) {
                        map.put(key, annotationDefinition.getPropertyValue(key));
                    }
                    metaAttributeCall.addArgument(ModelGenerator.objectAsJPExpression(map));
                }
            } else if (ad.hasValue()) {
                if (ad.getValues().size() == 1) {
                    metaAttributeCall.addArgument(ModelGenerator.objectAsJPExpression(ModelGenerator.resolveValue(ad.getSingleValueAsString())));
                } else {
                    metaAttributeCall.addArgument(ModelGenerator.objectAsJPExpression(ad.getValueMap()));
                }
            } else {
                metaAttributeCall.addArgument((Expression)new NullLiteralExpr());
            }
            ruleMetaAttributes.add(metaAttributeCall);
        }
        return ruleMetaAttributes;
    }

    private static Expression objectAsJPExpression(Object annValue) {
        if (annValue instanceof String) {
            StringLiteralExpr aStringLiteral = new StringLiteralExpr();
            aStringLiteral.setString(annValue.toString());
            return aStringLiteral;
        }
        if (annValue instanceof Number) {
            return JavaParser.parseExpression((String)annValue.toString());
        }
        if (annValue instanceof Map) {
            throw new UnsupportedOperationException("cannot define a canonical representation for a java.util.Map yet.");
        }
        throw new UnsupportedOperationException("I was unable to define a canonical String representation to give to JP yet about: " + annValue);
    }

    private static Object resolveValue(String value) {
        Object result = value;
        try {
            result = MVELSafeHelper.getEvaluator().eval(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static void createUnitData(RuleContext context, RuleUnitDescr ruleUnitDescr, BlockStmt ruleVariablesBlock) {
        if (ruleUnitDescr != null) {
            for (Map.Entry unitVar : ruleUnitDescr.getUnitVarAccessors().entrySet()) {
                ModelGenerator.addUnitData(context, (String)unitVar.getKey(), ((Method)unitVar.getValue()).getGenericReturnType(), ruleVariablesBlock);
            }
        }
    }

    private static void addUnitData(RuleContext context, String unitVar, Type type, BlockStmt ruleBlock) {
        Class<?> rawClass = ClassUtil.toRawClass(type);
        org.drools.javaparser.ast.type.Type declType = DrlxParseUtil.classToReferenceType(ClassUtil.toRawClass(type));
        context.addRuleUnitVar(unitVar, ModelGenerator.getClassForUnitData(type, rawClass));
        ClassOrInterfaceType varType = DrlxParseUtil.toClassOrInterfaceType(UnitData.class);
        varType.setTypeArguments(new org.drools.javaparser.ast.type.Type[]{declType});
        VariableDeclarationExpr var_ = new VariableDeclarationExpr((org.drools.javaparser.ast.type.Type)varType, context.getVar(unitVar), new Modifier[]{Modifier.FINAL});
        MethodCallExpr unitDataCall = new MethodCallExpr(null, "D.unitData");
        unitDataCall.addArgument((Expression)new ClassExpr(declType));
        unitDataCall.addArgument((Expression)new StringLiteralExpr(unitVar));
        AssignExpr var_assign = new AssignExpr((Expression)var_, (Expression)unitDataCall, AssignExpr.Operator.ASSIGN);
        ruleBlock.addStatement((Expression)var_assign);
    }

    private static Class<?> getClassForUnitData(Type type, Class<?> rawClass) {
        if (Iterable.class.isAssignableFrom(rawClass) && type instanceof ParameterizedType) {
            return ClassUtil.toRawClass(((ParameterizedType)type).getActualTypeArguments()[0]);
        }
        if (rawClass.isArray()) {
            return rawClass.getComponentType();
        }
        return rawClass;
    }

    public static void createVariables(KnowledgeBuilderImpl kbuilder, BlockStmt block, PackageModel packageModel, RuleContext context) {
        for (DeclarationSpec decl : context.getAllDeclarations()) {
            if (packageModel.getGlobals().containsKey(decl.getBindingId()) || context.queryParameterWithName(p -> p.name.equals(decl.getBindingId())).isPresent()) continue;
            ModelGenerator.addVariable(kbuilder, block, decl, context);
        }
    }

    private static void addVariable(KnowledgeBuilderImpl kbuilder, BlockStmt ruleBlock, DeclarationSpec decl, RuleContext context) {
        if (decl.getDeclarationClass() == null) {
            kbuilder.addBuilderResult((KnowledgeBuilderResult)new UnknownDeclarationError(decl.getBindingId()));
            return;
        }
        org.drools.javaparser.ast.type.Type declType = DrlxParseUtil.classToReferenceType(decl.getDeclarationClass());
        ClassOrInterfaceType varType = DrlxParseUtil.toClassOrInterfaceType(Variable.class);
        varType.setTypeArguments(new org.drools.javaparser.ast.type.Type[]{declType});
        VariableDeclarationExpr var_ = new VariableDeclarationExpr((org.drools.javaparser.ast.type.Type)varType, context.getVar(decl.getBindingId()), new Modifier[]{Modifier.FINAL});
        MethodCallExpr declarationOfCall = new MethodCallExpr(null, "D.declarationOf");
        declarationOfCall.addArgument((Expression)new ClassExpr(decl.getType()));
        declarationOfCall.addArgument((Expression)new StringLiteralExpr(decl.getVariableName().orElse(decl.getBindingId())));
        decl.getDeclarationSource().ifPresent(arg_0 -> ((MethodCallExpr)declarationOfCall).addArgument(arg_0));
        decl.getEntryPoint().ifPresent(ep -> {
            MethodCallExpr entryPointCall = new MethodCallExpr(null, "D.entryPoint");
            entryPointCall.addArgument((Expression)new StringLiteralExpr(ep));
            declarationOfCall.addArgument((Expression)entryPointCall);
        });
        for (BehaviorDescr behaviorDescr : decl.getBehaviors()) {
            MethodCallExpr windowCall = new MethodCallExpr(null, "D.window");
            if (Behavior.BehaviorType.TIME_WINDOW.matches(behaviorDescr.getSubType())) {
                windowCall.addArgument("Window.Type.TIME");
                windowCall.addArgument("" + TimeUtils.parseTimeString((String)((String)behaviorDescr.getParameters().get(0))));
            }
            if (Behavior.BehaviorType.LENGTH_WINDOW.matches(behaviorDescr.getSubType())) {
                windowCall.addArgument("Window.Type.LENGTH");
                windowCall.addArgument("" + Integer.valueOf((String)behaviorDescr.getParameters().get(0)));
            }
            declarationOfCall.addArgument((Expression)windowCall);
        }
        AssignExpr var_assign = new AssignExpr((Expression)var_, (Expression)declarationOfCall, AssignExpr.Operator.ASSIGN);
        ruleBlock.addStatement((Expression)var_assign);
    }

    static {
        attributesMap.put("no-loop", JavaParser.parseExpression((String)"Rule.Attribute.NO_LOOP"));
        attributesMap.put("salience", JavaParser.parseExpression((String)"Rule.Attribute.SALIENCE"));
        attributesMap.put("enabled", JavaParser.parseExpression((String)"Rule.Attribute.ENABLED"));
        attributesMap.put("auto-focus", JavaParser.parseExpression((String)"Rule.Attribute.AUTO_FOCUS"));
        attributesMap.put("lock-on-active", JavaParser.parseExpression((String)"Rule.Attribute.LOCK_ON_ACTIVE"));
        attributesMap.put("agenda-group", JavaParser.parseExpression((String)"Rule.Attribute.AGENDA_GROUP"));
        attributesMap.put("activation-group", JavaParser.parseExpression((String)"Rule.Attribute.ACTIVATION_GROUP"));
        attributesMap.put("ruleflow-group", JavaParser.parseExpression((String)"Rule.Attribute.RULEFLOW_GROUP"));
        attributesMap.put("duration", JavaParser.parseExpression((String)"Rule.Attribute.DURATION"));
        attributesMap.put("timer", JavaParser.parseExpression((String)"Rule.Attribute.TIMER"));
        attributesMap.put("calendars", JavaParser.parseExpression((String)"Rule.Attribute.CALENDARS"));
        attributesMap.put("date-effective", JavaParser.parseExpression((String)"Rule.Attribute.DATE_EFFECTIVE"));
        attributesMap.put("date-expires", JavaParser.parseExpression((String)"Rule.Attribute.DATE_EXPIRES"));
        temporalOperators.add("before");
        temporalOperators.add("after");
        temporalOperators.add("coincides");
        temporalOperators.add("metby");
        temporalOperators.add("finishedby");
        temporalOperators.add("overlaps");
        temporalOperators.add("meets");
        temporalOperators.add("during");
        temporalOperators.add("finishes");
        temporalOperators.add("startedby");
        temporalOperators.add("overlappedby");
        temporalOperators.add("includes");
        temporalOperators.add("starts");
    }
}

