/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.ClassUtils;
import org.drools.model.AnnotationValue;
import org.drools.model.TypeMetaData;
import org.drools.modelcompiler.constraints.MvelReadAccessor;
import org.kie.api.definition.type.Duration;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.Role;
import org.kie.api.definition.type.Timestamp;

public class TypeDeclarationUtil {
    public static TypeDeclaration createTypeDeclaration(KnowledgePackageImpl pkg, TypeMetaData metaType) {
        Class typeClass = metaType.getType();
        TypeDeclaration typeDeclaration = TypeDeclaration.createTypeDeclarationForBean((Class)typeClass);
        typeDeclaration.setTypeClassDef((ClassDefinition)new ClassDefinitionForModel(typeClass));
        TypeDeclarationUtil.wireClassAnnotations(typeClass, typeDeclaration);
        TypeDeclarationUtil.wireMetaTypeAnnotations(metaType, typeDeclaration);
        return typeDeclaration;
    }

    private static void wireMetaTypeAnnotations(TypeMetaData metaType, TypeDeclaration typeDeclaration) {
        block16: for (Map.Entry ann : metaType.getAnnotations().entrySet()) {
            switch ((String)ann.getKey()) {
                case "role": {
                    for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                        if (!annVal.getKey().equals("value") || !annVal.getValue().equals("event")) continue;
                        typeDeclaration.setRole(Role.Type.EVENT);
                    }
                    continue block16;
                }
                case "duration": {
                    for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                        if (!annVal.getKey().equals("value")) continue;
                        TypeDeclarationUtil.wireDurationAccessor(annVal.getValue().toString(), typeDeclaration);
                    }
                    continue block16;
                }
                case "timestamp": {
                    for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                        if (!annVal.getKey().equals("value")) continue;
                        TypeDeclarationUtil.wireTimestampAccessor(annVal.getValue().toString(), typeDeclaration);
                    }
                    continue block16;
                }
                case "expires": {
                    for (AnnotationValue annVal : (AnnotationValue[])ann.getValue()) {
                        if (annVal.getKey().equals("value")) {
                            long offset = TimeIntervalParser.parseSingle((String)annVal.getValue().toString());
                            typeDeclaration.setExpirationOffset(offset == -1L ? Long.MAX_VALUE : offset);
                            continue;
                        }
                        if (!annVal.getKey().equals("policy")) continue;
                        typeDeclaration.setExpirationType(Enum.valueOf(Expires.Policy.class, annVal.getValue().toString()));
                    }
                    continue block16;
                }
                case "propertyReactive": {
                    typeDeclaration.setPropertyReactive(true);
                    break;
                }
                case "classReactive": {
                    typeDeclaration.setPropertyReactive(false);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown annotation: " + (String)ann.getKey());
                }
            }
        }
    }

    private static void wireClassAnnotations(Class<?> typeClass, TypeDeclaration typeDeclaration) {
        Timestamp timestamp;
        Duration duration = typeClass.getAnnotation(Duration.class);
        if (duration != null) {
            TypeDeclarationUtil.wireDurationAccessor(duration.value(), typeDeclaration);
        }
        if ((timestamp = typeClass.getAnnotation(Timestamp.class)) != null) {
            TypeDeclarationUtil.wireTimestampAccessor(timestamp.value(), typeDeclaration);
        }
    }

    public static TypeDeclaration createTypeDeclaration(Class<?> cls) {
        Timestamp timestamp;
        TypeDeclaration typeDeclaration = TypeDeclaration.createTypeDeclarationForBean(cls);
        Duration duration = cls.getAnnotation(Duration.class);
        if (duration != null) {
            TypeDeclarationUtil.wireDurationAccessor(duration.value(), typeDeclaration);
        }
        if ((timestamp = cls.getAnnotation(Timestamp.class)) != null) {
            TypeDeclarationUtil.wireDurationAccessor(timestamp.value(), typeDeclaration);
        }
        return typeDeclaration;
    }

    private static void wireDurationAccessor(String durationField, TypeDeclaration type) {
        type.setDurationAttribute(durationField);
        type.setDurationExtractor(TypeDeclarationUtil.getFieldExtractor(type, durationField, Long.TYPE));
    }

    private static void wireTimestampAccessor(String timestampField, TypeDeclaration type) {
        type.setTimestampAttribute(timestampField);
        type.setTimestampExtractor(TypeDeclarationUtil.getFieldExtractor(type, timestampField, Long.TYPE));
    }

    private static InternalReadAccessor getFieldExtractor(TypeDeclaration type, String field, Class<?> returnType) {
        return new MvelReadAccessor(type.getTypeClass(), returnType, field);
    }

    public static class ClassDefinitionForModel
    extends ClassDefinition {
        public ClassDefinitionForModel(Class<?> cls) {
            super(cls);
            this.processFields();
        }

        public void processFields() {
            for (Method m : this.getDefinedClass().getDeclaredMethods()) {
                String fieldName;
                if (m.getParameterCount() != 0 || (fieldName = ClassUtils.getter2property((String)m.getName())) == null) continue;
                this.addField(new FieldDefinition(fieldName, m.getReturnType().getCanonicalName()));
            }
        }

        public Object get(Object bean, String field) {
            Field f = ClassUtils.getField((Class)this.getDefinedClass(), (String)field);
            if (f != null) {
                f.setAccessible(true);
                try {
                    return f.get(bean);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        public void set(Object bean, String field, Object value) {
            Field f = ClassUtils.getField((Class)this.getDefinedClass(), (String)field);
            if (f != null) {
                f.setAccessible(true);
                try {
                    f.set(bean, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

