/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.java;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.base.AcceptsClassObjectType;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.accessor.DeclarationScopeResolver;
import org.drools.core.rule.accessor.Wireable;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.parser.DroolsError;
import org.drools.mvel.java.JavaAnalysisResult;
import org.drools.util.StringUtils;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaRuleBuilderHelper {
    private static final Logger logger = LoggerFactory.getLogger(JavaRuleBuilderHelper.class);
    protected static TemplateRegistry RULE_REGISTRY = new SimpleTemplateRegistry();
    protected static TemplateRegistry INVOKER_REGISTRY = new SimpleTemplateRegistry();
    protected static String JAVA_RULE_MVEL = "javaRule.mvel";
    protected static String JAVA_INVOKERS_MVEL = "javaInvokers.mvel";

    public static void setConsequenceTemplate(String name) {
        JAVA_RULE_MVEL = name;
        RULE_REGISTRY = new SimpleTemplateRegistry();
    }

    public static void setInvokerTemplate(String name) {
        JAVA_INVOKERS_MVEL = name;
        INVOKER_REGISTRY = new SimpleTemplateRegistry();
    }

    public static synchronized TemplateRegistry getRuleTemplateRegistry(ClassLoader cl) {
        if (!RULE_REGISTRY.contains("rules")) {
            InputStream javaRuleMvelStream = JavaRuleBuilderHelper.class.getResourceAsStream(JAVA_RULE_MVEL);
            RULE_REGISTRY.addNamedTemplate("rules", TemplateCompiler.compileTemplate((InputStream)javaRuleMvelStream));
            try {
                javaRuleMvelStream.close();
            }
            catch (IOException ex) {
                logger.debug("Failed to close stream!", (Throwable)ex);
            }
            TemplateRuntime.execute((CompiledTemplate)RULE_REGISTRY.getNamedTemplate("rules"), null, (TemplateRegistry)RULE_REGISTRY);
        }
        return RULE_REGISTRY;
    }

    public static synchronized TemplateRegistry getInvokerTemplateRegistry(ClassLoader cl) {
        if (!INVOKER_REGISTRY.contains("invokers")) {
            InputStream javaInvokersMvelStream = JavaRuleBuilderHelper.class.getResourceAsStream(JAVA_INVOKERS_MVEL);
            INVOKER_REGISTRY.addNamedTemplate("invokers", TemplateCompiler.compileTemplate((InputStream)javaInvokersMvelStream));
            try {
                javaInvokersMvelStream.close();
            }
            catch (IOException ex) {
                logger.debug("Failed to close stream!", (Throwable)ex);
            }
            TemplateRuntime.execute((CompiledTemplate)INVOKER_REGISTRY.getNamedTemplate("invokers"), null, (TemplateRegistry)INVOKER_REGISTRY);
        }
        return INVOKER_REGISTRY;
    }

    public static JavaAnalysisResult createJavaAnalysisResult(RuleBuildContext context, String consequenceName, Map<String, Declaration> decls) {
        RuleDescr ruleDescr = context.getRuleDescr();
        BoundIdentifiers bindings = new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses(decls), (PackageBuildContext)context, Collections.EMPTY_MAP, KnowledgeHelper.class);
        Object consequenceStr = "default".equals(consequenceName) ? (String)ruleDescr.getConsequence() : (String)ruleDescr.getNamedConsequences().get(consequenceName);
        consequenceStr = (String)consequenceStr + "\n";
        return (JavaAnalysisResult)context.getDialect().analyzeBlock((PackageBuildContext)context, (BaseDescr)ruleDescr, (String)consequenceStr, bindings);
    }

    public static Map<String, Object> createConsequenceContext(RuleBuildContext context, String consequenceName, String className, String consequenceText, Map<String, Declaration> decls, BoundIdentifiers usedIdentifiers) {
        Declaration[] declarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
        String[] declrStr = new String[declarations.length];
        int j = 0;
        Iterator iterator = usedIdentifiers.getDeclrClasses().keySet().iterator();
        while (iterator.hasNext()) {
            String str;
            declrStr[j] = str = (String)iterator.next();
            declarations[j++] = decls.get(str);
        }
        Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
        for (int i = 0; i < declrStr.length; ++i) {
            declrStr[i] = declarations[i].getIdentifier();
        }
        context.getRule().setRequiredDeclarationsForConsequence(consequenceName, declrStr);
        Map<String, Object> map = JavaRuleBuilderHelper.createVariableContext(className, consequenceText, context, declarations, null, usedIdentifiers.getGlobals());
        map.put("consequenceName", consequenceName);
        Integer[] indexes = new Integer[declarations.length];
        Boolean[] notPatterns = new Boolean[declarations.length];
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            indexes[i] = i;
            Boolean bl = notPatterns[i] = declarations[i].getExtractor() instanceof AcceptsClassObjectType ? Boolean.FALSE : Boolean.TRUE;
            if (indexes[i] != -1) continue;
            context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)context.getRuleDescr(), null, "Internal Error : Unable to find declaration in list while generating the consequence invoker"));
        }
        map.put("indexes", indexes);
        map.put("notPatterns", notPatterns);
        return map;
    }

    public static Map<String, Object> createVariableContext(String className, String text, RuleBuildContext context, Declaration[] declarations, Declaration[] localDeclarations, Map<String, Type> globals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("className", className);
        map.put("methodName", className);
        map.put("package", context.getPkg().getName());
        map.put("ruleClassName", StringUtils.ucFirst((String)context.getRuleDescr().getClassName()));
        map.put("invokerClassName", context.getRuleDescr().getClassName() + StringUtils.ucFirst((String)className) + "Invoker");
        if (text != null) {
            map.put("text", text);
            map.put("hashCode", text.hashCode());
        }
        map.put("declarations", declarations);
        if (localDeclarations != null) {
            map.put("localDeclarations", localDeclarations);
        }
        String[] globalStr = new String[globals.size()];
        String[] globalTypes = new String[globals.size()];
        int i = 0;
        for (Map.Entry<String, Type> entry : globals.entrySet()) {
            globalStr[i] = entry.getKey();
            globalTypes[i] = entry.getValue().getTypeName().replace('$', '.');
            ++i;
        }
        map.put("globals", globalStr);
        map.put("globalTypes", globalTypes);
        return map;
    }

    public static void generateTemplates(String ruleTemplate, String invokerTemplate, RuleBuildContext context, String className, Map vars, Object invokerLookup, BaseDescr descrLookup) {
        JavaRuleBuilderHelper.generateMethodTemplate(ruleTemplate, context, vars);
        JavaRuleBuilderHelper.generateInvokerTemplate(invokerTemplate, context, className, vars, invokerLookup, descrLookup);
    }

    public static void generateMethodTemplate(String ruleTemplate, RuleBuildContext context, Map vars) {
        TemplateRegistry registry = JavaRuleBuilderHelper.getRuleTemplateRegistry(context.getKnowledgeBuilder().getRootClassLoader());
        context.addMethod((String)TemplateRuntime.execute((CompiledTemplate)registry.getNamedTemplate(ruleTemplate), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (TemplateRegistry)registry));
    }

    private static void generateInvokerTemplate(String invokerTemplate, RuleBuildContext context, String className, Map vars, Object invokerLookup, BaseDescr descrLookup) {
        TemplateRegistry registry = JavaRuleBuilderHelper.getInvokerTemplateRegistry(context.getKnowledgeBuilder().getRootClassLoader());
        String invokerClassName = context.getPkg().getName() + "." + context.getRuleDescr().getClassName() + StringUtils.ucFirst((String)className) + "Invoker";
        context.addInvoker(invokerClassName, (String)TemplateRuntime.execute((CompiledTemplate)registry.getNamedTemplate(invokerTemplate), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), (TemplateRegistry)registry));
        context.addInvokerLookup(invokerClassName, invokerLookup);
        context.addDescrLookups(invokerClassName, descrLookup);
    }

    public static void registerInvokerBytecode(RuleBuildContext context, Map<String, Object> vars, byte[] bytecode, Object invokerLookup) {
        String packageName = (String)vars.get("package");
        String invokerClassName = (String)vars.get("invokerClassName");
        String className = packageName + "." + invokerClassName;
        String resourceName = className.replace('.', '/') + ".class";
        JavaDialectRuntimeData data = (JavaDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("java");
        data.write(resourceName, bytecode);
        data.putInvoker(className, (Wireable)invokerLookup);
    }
}

