/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.expr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.base.base.ValueResolver;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.consequence.Consequence;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.expr.MVELCompileable;
import org.drools.mvel.expr.MvelEvaluator;
import org.mvel2.integration.VariableResolverFactory;

public class MVELConsequence
implements Consequence<KnowledgeHelper>,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private String id;
    private String consequenceName;
    private MvelEvaluator<Void> evaluator;

    public MVELConsequence() {
    }

    public MVELConsequence(MVELCompilationUnit unit, String id, String consequenceName) {
        this.unit = unit;
        this.id = id;
        this.consequenceName = consequenceName;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.unit = (MVELCompilationUnit)in.readObject();
        this.id = in.readUTF();
        this.consequenceName = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.unit);
        out.writeUTF(this.id);
        out.writeUTF(this.consequenceName);
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData));
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData, RuleImpl rule) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData, (Object)rule.toRuleNameAndPathString()));
    }

    public void evaluate(KnowledgeHelper knowledgeHelper, ValueResolver valueResolver) throws Exception {
        VariableResolverFactory factory = this.unit.getFactory(knowledgeHelper, knowledgeHelper.getMatch().getTerminalNode().getRequiredDeclarations(), knowledgeHelper.getRule(), knowledgeHelper.getTuple(), null, valueResolver, valueResolver.getGlobalResolver());
        InternalKnowledgePackage pkg = ((InternalKnowledgeBase)valueResolver.getRuleBase()).getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(this.id);
            factory.setNextFactory((VariableResolverFactory)data.getFunctionFactory());
        }
        this.evaluator.evaluate((Object)knowledgeHelper, factory);
    }

    public Serializable getCompExpr() {
        return this.evaluator != null ? this.evaluator.getExpr() : null;
    }

    public String getName() {
        return this.consequenceName;
    }
}

