/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.bigdecimal;

import com.github.javaparser.ast.expr.AssignExpr;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Optional;
import org.drools.mvelcompiler.ast.AssignExprT;
import org.drools.mvelcompiler.ast.MethodCallExprT;
import org.drools.mvelcompiler.ast.TypedExpression;

public abstract class BigDecimalConversion {
    TypedExpression rhs;

    BigDecimalConversion(TypedExpression rhs) {
        this.rhs = rhs;
    }

    public static BigDecimalConversion shouldConvertPlusEqualsOperatorBigDecimal(AssignExpr n, Optional<TypedExpression> optRHS) {
        if (!optRHS.isPresent() || !optRHS.get().getType().isPresent()) {
            return new DoNotConvert(null);
        }
        TypedExpression rhs = optRHS.get();
        Optional<Type> optRHSType = rhs.getType();
        if (!optRHSType.isPresent()) {
            return new DoNotConvert(null);
        }
        Type rhsType = optRHSType.get();
        boolean isBigDecimal = BigDecimal.class.equals((Object)rhsType);
        if (isBigDecimal) {
            if (AssignExpr.Operator.PLUS.equals((Object)n.getOperator())) {
                return new ConvertPlus(rhs);
            }
            if (AssignExpr.Operator.MINUS.equals((Object)n.getOperator())) {
                return new ConvertMinus(rhs);
            }
            return new DoNotConvert(rhs);
        }
        return new DoNotConvert(null);
    }

    public abstract boolean shouldConvert();

    protected abstract TypedExpression convertPlusEqualsOperatorBigDecimal(TypedExpression var1);

    public TypedExpression convertExpression(TypedExpression target) {
        TypedExpression arithmeticExpression = this.convertPlusEqualsOperatorBigDecimal(target);
        return new AssignExprT(AssignExpr.Operator.ASSIGN, target, arithmeticExpression);
    }

    static class DoNotConvert
    extends BigDecimalConversion {
        DoNotConvert(TypedExpression rhs) {
            super(rhs);
        }

        @Override
        public boolean shouldConvert() {
            return false;
        }

        @Override
        public TypedExpression convertPlusEqualsOperatorBigDecimal(TypedExpression target) {
            throw new UnsupportedOperationException();
        }
    }

    static class ConvertMinus
    extends BigDecimalConversion {
        ConvertMinus(TypedExpression rhs) {
            super(rhs);
        }

        @Override
        public boolean shouldConvert() {
            return true;
        }

        @Override
        public TypedExpression convertPlusEqualsOperatorBigDecimal(TypedExpression target) {
            return new MethodCallExprT("subtract", Optional.of(target), Collections.singletonList(this.rhs), Optional.of(BigDecimal.class));
        }
    }

    static class ConvertPlus
    extends BigDecimalConversion {
        ConvertPlus(TypedExpression rhs) {
            super(rhs);
        }

        @Override
        public boolean shouldConvert() {
            return true;
        }

        @Override
        public TypedExpression convertPlusEqualsOperatorBigDecimal(TypedExpression target) {
            return new MethodCallExprT("add", Optional.of(target), Collections.singletonList(this.rhs), Optional.of(BigDecimal.class));
        }
    }
}

