/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.context;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.drools.core.addon.TypeResolver;
import org.drools.core.util.StringUtils;
import org.drools.mvelcompiler.MvelCompilerException;
import org.drools.mvelcompiler.ast.RootTypeThisExpr;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.context.Declaration;
import org.drools.mvelcompiler.context.DeclaredFunction;
import org.drools.mvelcompiler.context.StaticMethod;
import org.drools.mvelcompiler.util.OptionalUtils;

public class MvelCompilerContext {
    private final Map<String, Declaration> declarations = new HashMap<String, Declaration>();
    private final Map<String, StaticMethod> staticMethods = new HashMap<String, StaticMethod>();
    private final Map<String, DeclaredFunction> declaredFunctions = new HashMap<String, DeclaredFunction>();
    private final TypeResolver typeResolver;
    private final String scopeSuffix;
    private final Set<String> usedBindings = new HashSet<String>();
    private Optional<Class<?>> rootPattern = Optional.empty();
    private Optional<String> rootPrefix = Optional.empty();

    public MvelCompilerContext(TypeResolver typeResolver) {
        this(typeResolver, null);
    }

    public MvelCompilerContext(TypeResolver typeResolver, String scopeSuffix) {
        this.typeResolver = typeResolver;
        this.scopeSuffix = StringUtils.isEmpty((CharSequence)scopeSuffix) ? null : scopeSuffix;
    }

    public MvelCompilerContext addDeclaration(String name, Class<?> clazz) {
        this.declarations.put(name, new Declaration(name, clazz));
        return this;
    }

    public Optional<Declaration> findDeclarations(String name) {
        Declaration d = this.declarations.get(name);
        if (d == null && this.scopeSuffix != null) {
            d = this.declarations.get(name + this.scopeSuffix);
        }
        return Optional.ofNullable(d);
    }

    public Optional<Class<?>> findEnum(String name) {
        try {
            return Optional.of(this.typeResolver.resolveType(name));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public Class<?> resolveType(String name) {
        try {
            return this.typeResolver.resolveType(name);
        }
        catch (ClassNotFoundException e) {
            throw new MvelCompilerException(e);
        }
    }

    public MvelCompilerContext addStaticMethod(String name, Method method) {
        this.staticMethods.put(name, new StaticMethod(name, method));
        return this;
    }

    public Optional<Method> findStaticMethod(String name) {
        return Optional.ofNullable(this.staticMethods.get(name)).map(StaticMethod::getMethod);
    }

    public MvelCompilerContext addDeclaredFunction(String name, String returnType, List<String> arguments) {
        this.declaredFunctions.put(name, new DeclaredFunction(this.typeResolver, name, returnType, arguments));
        return this;
    }

    public Optional<DeclaredFunction> findDeclaredFunction(String name) {
        return Optional.ofNullable(this.declaredFunctions.get(name));
    }

    public void setRootPatternPrefix(Class<?> rootPattern, String rootPrefix) {
        this.rootPattern = Optional.of(rootPattern);
        this.rootPrefix = Optional.of(rootPrefix);
    }

    public Optional<Class<?>> getRootPattern() {
        return this.rootPattern;
    }

    public Optional<TypedExpression> createRootTypePrefix() {
        return OptionalUtils.map2(this.rootPattern, this.rootPrefix, RootTypeThisExpr::new);
    }

    public void addUsedBinding(String s) {
        this.usedBindings.add(s);
    }

    public Set<String> getUsedBindings() {
        return this.usedBindings;
    }
}

