/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.SwitchEntry;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.mvel.parser.ast.visitor.DrlGenericVisitor;
import org.drools.mvelcompiler.LHSPhase;
import org.drools.mvelcompiler.RHSPhase;
import org.drools.mvelcompiler.ReProcessRHSPhase;
import org.drools.mvelcompiler.ast.BlockStmtT;
import org.drools.mvelcompiler.ast.DoStmtT;
import org.drools.mvelcompiler.ast.ForEachDowncastStmtT;
import org.drools.mvelcompiler.ast.ForEachStmtT;
import org.drools.mvelcompiler.ast.ForStmtT;
import org.drools.mvelcompiler.ast.IfStmtT;
import org.drools.mvelcompiler.ast.SwitchEntryT;
import org.drools.mvelcompiler.ast.SwitchStmtT;
import org.drools.mvelcompiler.ast.TypedExpression;
import org.drools.mvelcompiler.ast.UnalteredTypedExpression;
import org.drools.mvelcompiler.ast.WhileStmtT;
import org.drools.mvelcompiler.context.Declaration;
import org.drools.mvelcompiler.context.MvelCompilerContext;

public class StatementVisitor
implements DrlGenericVisitor<TypedExpression, Void> {
    private MvelCompilerContext mvelCompilerContext;

    public StatementVisitor(MvelCompilerContext mvelCompilerContext) {
        this.mvelCompilerContext = mvelCompilerContext;
    }

    public TypedExpression visit(ExpressionStmt n, Void arg) {
        return this.compileMVEL((Node)n);
    }

    private TypedExpression compileMVEL(Node n) {
        TypedExpression rhs = new RHSPhase(this.mvelCompilerContext).invoke(n);
        TypedExpression lhs = new LHSPhase(this.mvelCompilerContext, Optional.ofNullable(rhs)).invoke(n);
        Optional<TypedExpression> postProcessedRHS = new ReProcessRHSPhase(this.mvelCompilerContext).invoke(rhs, lhs);
        TypedExpression postProcessedLHS = postProcessedRHS.map(ppr -> new LHSPhase(this.mvelCompilerContext, Optional.of(ppr)).invoke(n)).orElse(lhs);
        return postProcessedLHS;
    }

    public TypedExpression visit(ForEachStmt n, Void arg) {
        Expression iterable = n.getIterable();
        Optional<TypedExpression> convertedToDowncastStmt = iterable.toNameExpr().map(Object::toString).flatMap(this.mvelCompilerContext::findDeclarations).filter(this::isDeclarationIterable).map(d -> this.toForEachDowncastStmtT(n, arg));
        if (convertedToDowncastStmt.isPresent()) {
            return convertedToDowncastStmt.get();
        }
        TypedExpression variableDeclarationExpr = new LHSPhase(this.mvelCompilerContext, Optional.empty()).invoke((Node)n.getVariable());
        TypedExpression typedIterable = new RHSPhase(this.mvelCompilerContext).invoke((Node)n.getIterable());
        TypedExpression body = (TypedExpression)n.getBody().accept((GenericVisitor)this, (Object)arg);
        return new ForEachStmtT(variableDeclarationExpr, typedIterable, body);
    }

    private ForEachDowncastStmtT toForEachDowncastStmtT(ForEachStmt n, Void arg) {
        TypedExpression child = this.visit((BlockStmt)n.getBody(), arg);
        return new ForEachDowncastStmtT(n.getVariable(), n.getIterable().asNameExpr().toString(), child);
    }

    public TypedExpression visit(BlockStmt n, Void arg) {
        List<TypedExpression> compiledStatements = n.getStatements().stream().map(s -> (TypedExpression)s.accept((GenericVisitor)this, (Object)arg)).collect(Collectors.toList());
        return new BlockStmtT(compiledStatements);
    }

    public TypedExpression visit(IfStmt n, Void arg) {
        TypedExpression typedCondition = new RHSPhase(this.mvelCompilerContext).invoke((Node)n.getCondition());
        TypedExpression typedThen = (TypedExpression)n.getThenStmt().accept((GenericVisitor)this, (Object)arg);
        Optional<TypedExpression> typedElse = n.getElseStmt().map(e -> (TypedExpression)e.accept((GenericVisitor)this, (Object)arg));
        return new IfStmtT(typedCondition, typedThen, typedElse);
    }

    public TypedExpression visit(WhileStmt n, Void arg) {
        TypedExpression typedCondition = new RHSPhase(this.mvelCompilerContext).invoke((Node)n.getCondition());
        TypedExpression typedThen = (TypedExpression)n.getBody().accept((GenericVisitor)this, (Object)arg);
        return new WhileStmtT(typedCondition, typedThen);
    }

    public TypedExpression visit(DoStmt n, Void arg) {
        TypedExpression typedCondition = new RHSPhase(this.mvelCompilerContext).invoke((Node)n.getCondition());
        TypedExpression typedThen = (TypedExpression)n.getBody().accept((GenericVisitor)this, (Object)arg);
        return new DoStmtT(typedCondition, typedThen);
    }

    public TypedExpression visit(ForStmt n, Void arg) {
        List<TypedExpression> typedInitialization = n.getInitialization().stream().map(this::compileMVEL).collect(Collectors.toList());
        Optional<TypedExpression> typedCompare = n.getCompare().map(c -> new RHSPhase(this.mvelCompilerContext).invoke((Node)c));
        List<TypedExpression> typedUpdate = n.getUpdate().stream().map(this::compileMVEL).collect(Collectors.toList());
        TypedExpression body = (TypedExpression)n.getBody().accept((GenericVisitor)this, (Object)arg);
        return new ForStmtT(typedInitialization, typedCompare, typedUpdate, body);
    }

    public TypedExpression visit(SwitchStmt n, Void arg) {
        TypedExpression typedSelector = new RHSPhase(this.mvelCompilerContext).invoke((Node)n.getSelector());
        List<TypedExpression> typedEntries = n.getEntries().stream().map(e -> (TypedExpression)e.accept((GenericVisitor)this, (Object)arg)).collect(Collectors.toList());
        return new SwitchStmtT(typedSelector, typedEntries);
    }

    public TypedExpression visit(SwitchEntry n, Void arg) {
        List<TypedExpression> typedStatements = n.getStatements().stream().map(this::compileMVEL).collect(Collectors.toList());
        return new SwitchEntryT((NodeList<Expression>)n.getLabels(), typedStatements);
    }

    private boolean isDeclarationIterable(Declaration declaration) {
        Class<?> declarationClazz = declaration.getClazz();
        return Iterable.class.isAssignableFrom(declarationClazz);
    }

    public TypedExpression defaultMethod(Node n, Void context) {
        return new UnalteredTypedExpression(n);
    }
}

