/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.processinstance;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.drools.marshalling.impl.InputMarshaller;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.OutputMarshaller;
import org.drools.persistence.processinstance.VariablePersistenceStrategy;
import org.drools.persistence.processinstance.VariablePersistenceStrategyFactory;
import org.drools.persistence.processinstance.variabletypes.VariableInstanceInfo;
import org.drools.process.instance.WorkItem;
import org.drools.runtime.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class WorkItemInfo {
    private static final String VARIABLE_SEPARATOR = ":";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long workItemId;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private String name;
    private Date creationDate;
    private long processInstanceId;
    private long state;
    @Lob
    private byte[] workItemByteArray;
    @Transient
    private WorkItem workItem;
    @Transient
    private Environment env;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="workItemId")
    @MapKey(name="name")
    private Map<String, VariableInstanceInfo> variables = new HashMap<String, VariableInstanceInfo>();
    private boolean externalVariables = false;

    protected WorkItemInfo() {
    }

    public WorkItemInfo(WorkItem workItem, Environment env) {
        this.workItem = workItem;
        this.name = workItem.getName();
        this.creationDate = new Date();
        this.processInstanceId = workItem.getProcessInstanceId();
        this.env = env;
    }

    public long getId() {
        return this.workItemId;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public long getState() {
        return this.state;
    }

    public WorkItem getWorkItem(Environment env) {
        this.env = env;
        if (this.workItem == null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.workItemByteArray);
                MarshallerReaderContext context = new MarshallerReaderContext((InputStream)bais, null, null, null);
                this.workItem = InputMarshaller.readWorkItem((MarshallerReaderContext)context, (!this.externalVariables ? 1 : 0) != 0);
                if (this.externalVariables) {
                    this.restoreVariables();
                }
                context.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("IOException while loading process instance: " + e.getMessage());
            }
        }
        return this.workItem;
    }

    private void restoreVariables() {
        for (Map.Entry<String, VariableInstanceInfo> entry : this.variables.entrySet()) {
            String[] variableHierarchy = entry.getKey().split(VARIABLE_SEPARATOR);
            String variableName = variableHierarchy[variableHierarchy.length - 1];
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (int i = 0; i < variableHierarchy.length - 1; ++i) {
                parentIds.add(Long.valueOf(variableHierarchy[i]));
            }
            this.restoreVariable(entry.getValue(), parentIds, variableName, this.workItem);
        }
    }

    private void restoreVariable(VariableInstanceInfo variableInfo, List<Long> parentIds, String variableName, WorkItem workItem) throws NumberFormatException {
        VariablePersistenceStrategy persistenceStrategy = VariablePersistenceStrategyFactory.getVariablePersistenceStrategy();
        Object value = persistenceStrategy.getVariable(variableInfo, this.env);
        System.out.println(">>>>> Restoring variable inside workitem " + variableName + " = " + value);
        workItem.setParameter(variableName, value);
    }

    @PreUpdate
    public void update() {
        this.state = this.workItem.getState();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean variablesChanged = false;
        try {
            MarshallerWriteContext context = new MarshallerWriteContext((OutputStream)baos, null, null, null, null);
            this.externalVariables = VariablePersistenceStrategyFactory.getVariablePersistenceStrategy().isEnabled();
            OutputMarshaller.writeWorkItem((MarshallerWriteContext)context, (org.drools.runtime.process.WorkItem)this.workItem, (!this.externalVariables ? 1 : 0) != 0);
            if (this.externalVariables) {
                variablesChanged = this.persistVariables();
            }
            context.close();
            this.workItemByteArray = baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException while storing workItem " + this.workItem.getId() + ": " + e.getMessage());
        }
    }

    private boolean persistVariables() {
        Map processVariables = this.workItem.getParameters();
        HashMap<String, VariableInstanceInfo> newVariables = new HashMap<String, VariableInstanceInfo>();
        this.persist(processVariables, "workItem.", newVariables);
        if (newVariables.size() > 0 || this.variables.size() > 0) {
            this.variables.clear();
            this.variables.putAll(newVariables);
            return true;
        }
        return false;
    }

    private void persist(Map<String, Object> variables, String prefix, Map<String, VariableInstanceInfo> newVariables) {
        VariablePersistenceStrategy persistenceStrategy = VariablePersistenceStrategyFactory.getVariablePersistenceStrategy();
        for (Map.Entry<String, Object> entries : variables.entrySet()) {
            VariableInstanceInfo oldValue;
            Object value;
            String variableName = prefix + entries.getKey();
            VariableInstanceInfo variable = persistenceStrategy.persistVariable(variableName, value = entries.getValue(), oldValue = this.variables.get(variableName), this.env);
            if (variable != null) {
                System.out.println("<<<<< Persisting variable inside workitem " + variableName + " = " + value);
                newVariables.put(variableName, variable);
                continue;
            }
            System.out.println("<<<<< Variable inside workitem " + variableName + " not persisted (value null)");
        }
    }
}

