/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareViaReflectionUtil {
    private static Logger logger = LoggerFactory.getLogger(CompareViaReflectionUtil.class);
    public static HashSet<Object> seenObjects = new HashSet();
    private static Class<?> OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private static int TO_ARRAY = 0;
    private static int ENTRY_SET = 1;
    private static HashSet<Package> javaPackages = new HashSet();
    private static final int BYTE = 0;
    private static final int SHORT = 1;
    private static final int INT = 2;
    private static final int LONG = 3;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 5;
    private static final int BOOLEAN = 6;
    private static final int CHAR = 7;
    private static final int OBJECT = 8;
    private static final int NULL = 9;
    private static HashMap<Class<?>, Integer> arrClassMap;

    public CompareViaReflectionUtil() {
        arrClassMap.put(new byte[0].getClass(), 0);
        arrClassMap.put(new short[0].getClass(), 1);
        arrClassMap.put(new int[0].getClass(), 2);
        arrClassMap.put(new long[0].getClass(), 3);
        arrClassMap.put(new float[0].getClass(), 4);
        arrClassMap.put(new double[0].getClass(), 5);
        arrClassMap.put(new boolean[0].getClass(), 6);
        arrClassMap.put(new char[0].getClass(), 7);
        arrClassMap.put(new Object[0].getClass(), 8);
    }

    public static boolean compareInstances(Object objA, Object objB) {
        return CompareViaReflectionUtil.compareInstances(null, objA, objB);
    }

    private static boolean compareInstances(DebugContext context, Object objA, Object objB) {
        if (context == null) {
            context = new DebugContext(0, "", true);
        }
        boolean same = false;
        if (objA == null && objB == null) {
            context.name = context.name + "0";
            same = true;
        } else if (objA == null || objB == null) {
            context.name = context.name + "X";
            same = false;
        } else if (objA == objB) {
            context.name = context.name + objA.getClass().getSimpleName() + " ";
            String stateSymbol = "==";
            if (objA instanceof Class | objA instanceof Class) {
                stateSymbol = "(=)";
            }
            context.name = context.name + stateSymbol;
            same = true;
        } else if (objA.getClass().getName().equals(objB.getClass().getName())) {
            Class<?> objClass = objA.getClass();
            context.name = context.name + "|" + context.level + "| " + objClass.getSimpleName();
            boolean primitiveBasedObjectOrCollection = false;
            if (javaPackages.contains(objClass.getPackage())) {
                primitiveBasedObjectOrCollection = true;
                same = CompareViaReflectionUtil.comparePrimitiveBasedOrCollectionInstances(context, objA, objB);
            } else if (objA.getClass().isArray()) {
                same = CompareViaReflectionUtil.compareArrays(objA, objB);
            } else {
                for (Class<?> superClass = objClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                    if (!superClass.equals(Enum.class)) continue;
                    same = objA.equals(objB);
                    primitiveBasedObjectOrCollection = true;
                    break;
                }
            }
            if (!primitiveBasedObjectOrCollection) {
                if (seenObjects.add(objA)) {
                    same = CompareViaReflectionUtil.compareInstancesOfSameClass(context, objA, objB);
                    if (!same) {
                        seenObjects.remove(objA);
                    }
                } else {
                    context.name = context.name + ": !";
                    same = true;
                }
            }
        } else {
            context.name = context.name + ": X";
        }
        if (context.print) {
            logger.trace(context.name);
        }
        return same;
    }

    public static boolean compareArrays(Object objA, Object objB) {
        Integer classTypeValue = arrClassMap.get(objA.getClass());
        int classType = -1;
        if (classTypeValue != null) {
            classType = classTypeValue;
        } else if (objA.getClass().isArray()) {
            classType = 8;
        } else if (classTypeValue == null) {
            classType = 9;
        }
        boolean same = false;
        switch (classType) {
            case 0: {
                same = Arrays.equals((byte[])objB, (byte[])objA);
                break;
            }
            case 1: {
                same = Arrays.equals((short[])objB, (short[])objA);
                break;
            }
            case 2: {
                same = Arrays.equals((int[])objB, (int[])objA);
                break;
            }
            case 3: {
                same = Arrays.equals((long[])objB, (long[])objA);
                break;
            }
            case 4: {
                same = Arrays.equals((float[])objB, (float[])objA);
                break;
            }
            case 5: {
                same = Arrays.equals((double[])objB, (double[])objA);
                break;
            }
            case 6: {
                same = Arrays.equals((boolean[])objB, (boolean[])objA);
                break;
            }
            case 7: {
                same = Arrays.equals((char[])objB, (char[])objA);
                break;
            }
            case 8: {
                int lengthA = Array.getLength(objA);
                int lengthB = Array.getLength(objB);
                if (lengthA != lengthB) {
                    same = false;
                    break;
                }
                if (lengthA == 0) {
                    same = true;
                    break;
                }
                same = true;
                for (int i = 0; same && i < lengthA; ++i) {
                    same = CompareViaReflectionUtil.compareInstances(Array.get(objA, i), Array.get(objB, i));
                }
                break;
            }
            case 9: {
                same = objA == objB;
                break;
            }
            default: {
                Assert.fail((String)("Unable to determine class of array [" + classType + "]"));
            }
        }
        return same;
    }

    private static boolean compareInstancesOfSameClass(DebugContext context, Object objA, Object objB) {
        boolean same = false;
        try {
            Field[] fields = objA.getClass().getDeclaredFields();
            if (fields.length == 0) {
                same = true;
            } else {
                same = true;
                for (int i = 0; same && i < fields.length; ++i) {
                    DebugContext subContext = context.clone();
                    subContext.level = context.level + 1;
                    subContext.name = context.name + ": " + fields[i].getName() + " > ";
                    fields[i].setAccessible(true);
                    Object subObjA = fields[i].get(objA);
                    Object subObjB = fields[i].get(objB);
                    same = CompareViaReflectionUtil.compareInstances(subContext, subObjA, subObjB);
                }
            }
            context.name = context.name + ": " + (same ? "=" : "X");
        }
        catch (Exception e) {
            same = false;
            Assert.fail((String)(e.getClass().getSimpleName() + ":" + e.getMessage()));
        }
        return same;
    }

    private static boolean comparePrimitiveBasedOrCollectionInstances(DebugContext context, Object objA, Object objB) {
        boolean same = false;
        Method[] methods = CompareViaReflectionUtil.getMethodToRetrieveCollection(objA);
        try {
            same = methods[TO_ARRAY] != null ? CompareViaReflectionUtil.compareArrayBasedObjects(context, methods[TO_ARRAY], objA, objB) : (methods[ENTRY_SET] != null ? CompareViaReflectionUtil.compareEntrySetBasedObjects(context, methods[ENTRY_SET], objA, objB) : (objA.getClass().isArray() ? CompareViaReflectionUtil.compareArrays(objA, objB) : objA.equals(objB)));
            context.name = context.name + ": " + (same ? "=" : "X");
        }
        catch (Exception e) {
            same = false;
            Assert.fail((String)(e.getClass().getSimpleName() + ":" + e.getMessage()));
        }
        return same;
    }

    private static Method[] getMethodToRetrieveCollection(Object objA) {
        Method[] methods = new Method[2];
        Class<?> objClass = objA.getClass();
        Method[] objMethods = objClass.getDeclaredMethods();
        for (int m = 0; m < objMethods.length; ++m) {
            if (objMethods[m].getName().equals("toArray") && objMethods[m].getParameterTypes().length == 0 && objMethods[m].getReturnType().equals(OBJECT_ARRAY_CLASS)) {
                methods[CompareViaReflectionUtil.TO_ARRAY] = objMethods[m];
                methods[TO_ARRAY].setAccessible(true);
                break;
            }
            if (!objMethods[m].getName().equals("entrySet") || objMethods[m].getParameterTypes().length != 0 || !objMethods[m].getReturnType().equals(Set.class)) continue;
            methods[CompareViaReflectionUtil.ENTRY_SET] = objMethods[m];
            methods[ENTRY_SET].setAccessible(true);
            break;
        }
        return methods;
    }

    private static boolean compareArrayBasedObjects(DebugContext context, Method toArrayMethod, Object objA, Object objB) throws Exception {
        boolean same = true;
        Object[] arrayA = (Object[])toArrayMethod.invoke(objA, (Object[])null);
        Object[] arrayB = (Object[])toArrayMethod.invoke(objB, (Object[])null);
        if (arrayA == null && arrayB == null) {
            return true;
        }
        if (arrayA == null || arrayB == null) {
            return false;
        }
        if (arrayA.length != arrayB.length) {
            return false;
        }
        if (arrayA.length == 0) {
            return true;
        }
        boolean isSet = false;
        for (Class<?> superClass = objA.getClass().getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!superClass.equals(AbstractSet.class)) continue;
            isSet = true;
        }
        for (int a = 0; same && a < arrayA.length; ++a) {
            Object subObjA = arrayA[a];
            if (!isSet) {
                Object subObjB = arrayB[a];
                same = CompareViaReflectionUtil.compareInstances(context, subObjA, subObjB);
                continue;
            }
            boolean elementIsSame = false;
            for (int b = 0; !elementIsSame && b < arrayB.length; ++b) {
                Object subObjB = arrayB[b];
                elementIsSame = CompareViaReflectionUtil.compareInstances(context, subObjA, subObjB);
            }
            if (elementIsSame) continue;
            same = false;
        }
        return same;
    }

    private static boolean compareEntrySetBasedObjects(DebugContext context, Method entrySetMethod, Object objA, Object objB) throws Exception {
        boolean same = true;
        Set entrySetA = (Set)entrySetMethod.invoke(objA, (Object[])null);
        Set entrySetB = (Set)entrySetMethod.invoke(objB, (Object[])null);
        if (entrySetA == null && entrySetB == null) {
            return true;
        }
        if (entrySetA == null || entrySetB == null) {
            return false;
        }
        if (entrySetA.size() != entrySetB.size()) {
            return false;
        }
        if (entrySetA.size() == 0) {
            return true;
        }
        for (Map.Entry entryA : entrySetA) {
            boolean elementIsSame = false;
            Object keyA = entryA.getKey();
            for (Map.Entry entryB : entrySetB) {
                Object keyB = entryB.getKey();
                DebugContext entryContext = context.clone();
                String name = context.name + ": ";
                entryContext.level = context.level + 1;
                entryContext.name = name + "<key> ";
                entryContext.print = false;
                if (!CompareViaReflectionUtil.compareInstances(entryContext, keyA, keyB)) continue;
                logger.trace(entryContext.name);
                entryContext.name = name + "<entry> ";
                entryContext.print = true;
                elementIsSame = CompareViaReflectionUtil.compareInstances(entryContext, entryA.getValue(), entryB.getValue());
                break;
            }
            if (elementIsSame) continue;
            same = false;
            break;
        }
        return same;
    }

    static {
        javaPackages.add(Long.TYPE.getPackage());
        javaPackages.add(BigDecimal.class.getPackage());
        javaPackages.add(AbstractCollection.class.getPackage());
        javaPackages.add(BlockingQueue.class.getPackage());
        javaPackages.add(AtomicInteger.class.getPackage());
        javaPackages.add(Long.class.getPackage());
        javaPackages.add(BlockingQueue.class.getPackage());
        arrClassMap = new HashMap();
    }

    private static class DebugContext {
        public int level;
        public String name;
        public boolean print;

        public DebugContext(int level, String name, boolean print) {
            this.level = level;
            this.name = name;
            this.print = print;
        }

        public DebugContext clone() {
            DebugContext newDebugContext = new DebugContext(this.level, this.name, this.print);
            return newDebugContext;
        }
    }
}

