/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.marshalling.util.MarshalledData;
import org.drools.marshalling.util.MarshallingTestUtil;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFactoryProxy
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(EntityManagerFactoryProxy.class);
    private EntityManagerFactory emf;
    private EntityManager em;
    protected static ThreadLocal<HashMap<SessionInfo, byte[]>> managedSessionInfoDataMap;
    protected static ThreadLocal<HashMap<WorkItemInfo, byte[]>> managedWorkItemInfoDataMap;
    protected static ThreadLocal<HashMap<Object, byte[]>> managedProcessInstanceInfoDataMap;
    protected static ThreadLocal<HashMap<Integer, byte[]>> sessionMarshalledDataMap;
    protected static ThreadLocal<HashMap<Long, byte[]>> workItemMarshalledDataMap;
    protected static ThreadLocal<HashMap<Long, byte[]>> processInstanceInfoMarshalledDataMap;

    public static Object newInstance(Object obj) {
        if (obj instanceof EntityManagerFactory || obj instanceof EntityManager) {
            return Proxy.newProxyInstance(obj.getClass().getClassLoader(), EntityManagerFactoryProxy.getAllInterfaces(obj), (InvocationHandler)new EntityManagerFactoryProxy(obj));
        }
        throw new UnsupportedOperationException("This proxy is only for " + EntityManagerFactory.class.getSimpleName() + " and " + EntityManager.class.getSimpleName() + " instances.");
    }

    protected static Class<?>[] getAllInterfaces(Object obj) {
        Class[] interfaces = new Class[]{};
        for (Class<?> superClass = obj.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            Class<?>[] addThese = superClass.getInterfaces();
            if (addThese.length <= 0) continue;
            Class[] moreinterfaces = new Class[interfaces.length + addThese.length];
            System.arraycopy(interfaces, 0, moreinterfaces, 0, interfaces.length);
            System.arraycopy(addThese, 0, moreinterfaces, interfaces.length, addThese.length);
            interfaces = moreinterfaces;
        }
        return interfaces;
    }

    private EntityManagerFactoryProxy(Object obj) {
        if (obj instanceof EntityManagerFactory) {
            this.emf = (EntityManagerFactory)obj;
        } else if (obj instanceof EntityManager) {
            this.em = (EntityManager)obj;
        } else {
            throw new UnsupportedOperationException("This proxy is only for " + EntityManagerFactory.class.getSimpleName() + " and " + EntityManager.class.getSimpleName() + " instances.");
        }
    }

    private synchronized void lazyInitializeStateMaps(Object[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        if (args[0] instanceof SessionInfo) {
            if (managedSessionInfoDataMap == null) {
                managedSessionInfoDataMap = new ThreadLocal();
                sessionMarshalledDataMap = new ThreadLocal();
            }
            if (managedSessionInfoDataMap.get() == null) {
                managedSessionInfoDataMap.set(new HashMap());
                sessionMarshalledDataMap.set(new HashMap());
            }
        } else if (args[0] instanceof WorkItemInfo) {
            if (managedWorkItemInfoDataMap == null) {
                managedWorkItemInfoDataMap = new ThreadLocal();
                workItemMarshalledDataMap = new ThreadLocal();
            }
            if (managedWorkItemInfoDataMap.get() == null) {
                managedWorkItemInfoDataMap.set(new HashMap());
                workItemMarshalledDataMap.set(new HashMap());
            }
        } else if ("org.jbpm.persistence.processinstance.ProcessInstanceInfo".equals(args[0].getClass().getName())) {
            if (managedProcessInstanceInfoDataMap == null) {
                managedProcessInstanceInfoDataMap = new ThreadLocal();
                processInstanceInfoMarshalledDataMap = new ThreadLocal();
            }
            if (managedProcessInstanceInfoDataMap.get() == null) {
                managedProcessInstanceInfoDataMap.set(new HashMap());
                processInstanceInfoMarshalledDataMap.set(new HashMap());
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        String methodName = method.getName();
        logger.trace(methodName);
        this.lazyInitializeStateMaps(args);
        if ("createEntityManager".equals(methodName)) {
            return this.createEntityManager(methodName, args);
        }
        if ("persist".equals(methodName) && args.length == 1) {
            this.em.persist(args[0]);
            String testMethodName = MarshallingTestUtil.getTestMethodName();
            if (testMethodName != null) {
                this.persist(testMethodName, args);
            }
            return result;
        }
        if ("merge".equals(methodName) && args.length == 1) {
            result = this.em.merge(args[0]);
            String testMethodName = MarshallingTestUtil.getTestMethodName();
            if (testMethodName != null) {
                this.merge(testMethodName, result);
            }
            return result;
        }
        if ("joinTransaction".equals(methodName) && args == null) {
            this.em.joinTransaction();
            String testMethodName = MarshallingTestUtil.getTestMethodName();
            if (testMethodName != null) {
                EntityManagerFactoryProxy.updateManagedObjects(testMethodName, this.em);
            }
            return result;
        }
        if ("find".equals(methodName) && args.length == 2) {
            result = this.em.find((Class)args[0], args[1]);
            this.find(result);
        } else {
            Class<?> methodClass = method.getDeclaringClass();
            if (methodClass.equals(EntityManagerFactory.class)) {
                result = this.invoke(method, this.emf, args);
            } else if (methodClass.equals(EntityManager.class)) {
                result = this.invoke(method, this.em, args);
            } else {
                RuntimeException re = new RuntimeException("Unexpected class " + methodClass + " for method " + methodName);
                re.fillInStackTrace();
                throw re;
            }
        }
        return result;
    }

    private Object invoke(Method method, Object object, Object[] args) throws Throwable {
        Object result = null;
        try {
            result = method.invoke(object, args);
        }
        catch (InvocationTargetException ite) {
            logger.warn(method.getName() + " threw " + ite.getClass().getSimpleName() + ": " + ite.getMessage());
            throw ite;
        }
        return result;
    }

    private Object createEntityManager(String methodName, Object[] args) {
        EntityManager realEm = null;
        if (args == null) {
            realEm = this.emf.createEntityManager();
        } else if (args[0] instanceof Map) {
            realEm = this.emf.createEntityManager((Map)args[0]);
        } else {
            String message = "Method " + methodName + " with args (";
            for (int i = 0; i < args.length; ++i) {
                message = message + args[i].getClass() + ", ";
            }
            message = message.substring(0, message.lastIndexOf(",")) + ") not supported!";
            throw new UnsupportedOperationException(message);
        }
        return EntityManagerFactoryProxy.newInstance(realEm);
    }

    private void persist(String methodName, Object[] args) {
        MarshalledData marshalledData = null;
        if (args[0] instanceof SessionInfo) {
            byte[] byteArray;
            SessionInfo sessionInfo;
            managedSessionInfoDataMap.get().put(sessionInfo, (byteArray = (sessionInfo = (SessionInfo)args[0]).getData()) != null ? (byte[])byteArray.clone() : null);
            if (byteArray != null) {
                marshalledData = new MarshalledData(sessionInfo);
                this.em.persist((Object)marshalledData);
                logger.trace("-.-: " + marshalledData);
            }
        } else if (args[0] instanceof WorkItemInfo) {
            byte[] byteArray;
            WorkItemInfo workItemInfo;
            managedWorkItemInfoDataMap.get().put(workItemInfo, (byteArray = MarshallingTestUtil.getWorkItemByteArray(workItemInfo = (WorkItemInfo)args[0])) != null ? (byte[])byteArray.clone() : null);
            if (byteArray != null) {
                marshalledData = new MarshalledData(workItemInfo);
                this.em.persist((Object)marshalledData);
                logger.trace("-.-: " + marshalledData);
            }
        } else if ("org.jbpm.persistence.processinstance.ProcessInstanceInfo".equals(args[0].getClass().getName())) {
            byte[] byteArray = MarshallingTestUtil.getProcessInstanceInfoByteArray(args[0]);
            managedProcessInstanceInfoDataMap.get().put(args[0], byteArray != null ? (byte[])byteArray.clone() : null);
            Long id = MarshallingTestUtil.getProcessInstanceInfoId(args[0]);
            processInstanceInfoMarshalledDataMap.get().put(id, byteArray);
            if (byteArray != null) {
                marshalledData = new MarshalledData(args[0]);
                this.em.persist((Object)marshalledData);
                logger.trace("-.-: " + marshalledData);
            }
        }
    }

    private void merge(String testMethodName, Object updatedObject) {
        HashMap<Object, Object> updatedObjectsMap;
        if (updatedObject instanceof SessionInfo) {
            updatedObjectsMap = new HashMap<SessionInfo, byte[]>();
            EntityManagerFactoryProxy.updateSessionInfoMarshalledData((SessionInfo)updatedObject, testMethodName, this.em, updatedObjectsMap);
            if (!updatedObjectsMap.isEmpty()) {
                managedSessionInfoDataMap.get().put((SessionInfo)updatedObject, (byte[])updatedObjectsMap.get(updatedObject));
            }
        }
        if (updatedObject instanceof WorkItemInfo) {
            updatedObjectsMap = new HashMap();
            EntityManagerFactoryProxy.updateWorkItemInfoMarshalledData((WorkItemInfo)updatedObject, testMethodName, this.em, updatedObjectsMap);
            if (!updatedObjectsMap.isEmpty()) {
                managedWorkItemInfoDataMap.get().put((WorkItemInfo)updatedObject, (byte[])updatedObjectsMap.get(updatedObject));
            }
        }
        if ("org.jbpm.persistence.processinstance.ProcessInstanceInfo".equals(updatedObject.getClass().getName())) {
            updatedObjectsMap = new HashMap();
            EntityManagerFactoryProxy.updateProcessInstanceInfoMarshalledData(updatedObject, testMethodName, this.em, updatedObjectsMap);
            if (!updatedObjectsMap.isEmpty()) {
                managedProcessInstanceInfoDataMap.get().put(updatedObject, (byte[])updatedObjectsMap.get(updatedObject));
            }
        }
    }

    private void find(Object result) {
        byte[] data;
        if (result == null) {
            return;
        }
        if (result instanceof SessionInfo) {
            byte[] data2 = managedSessionInfoDataMap.get().get(result);
            if (data2 == null) {
                byte[] byteArray = ((SessionInfo)result).getData();
                managedSessionInfoDataMap.get().put((SessionInfo)result, byteArray);
            }
        } else if (result instanceof WorkItemInfo) {
            byte[] data3 = managedWorkItemInfoDataMap.get().get(result);
            if (data3 == null) {
                byte[] byteArray = MarshallingTestUtil.getWorkItemByteArray((WorkItemInfo)result);
                managedWorkItemInfoDataMap.get().put((WorkItemInfo)result, byteArray);
            }
        } else if ("org.jbpm.persistence.processinstance.ProcessInstanceInfo".equals(result.getClass().getName()) && (data = managedProcessInstanceInfoDataMap.get().get(result)) == null) {
            byte[] byteArray = MarshallingTestUtil.getProcessInstanceInfoByteArray(result);
            managedProcessInstanceInfoDataMap.get().put(result, byteArray);
        }
    }

    protected static void updateManagedObjects(String testMethodName, EntityManager em) {
        HashMap<SessionInfo, byte[]> updatedObjectsMap;
        if (managedSessionInfoDataMap != null) {
            updatedObjectsMap = new HashMap<SessionInfo, byte[]>();
            for (SessionInfo sessionInfo : managedSessionInfoDataMap.get().keySet()) {
                EntityManagerFactoryProxy.updateSessionInfoMarshalledData(sessionInfo, testMethodName, em, updatedObjectsMap);
            }
            for (SessionInfo sessionInfo : updatedObjectsMap.keySet()) {
                managedSessionInfoDataMap.get().put(sessionInfo, updatedObjectsMap.get(sessionInfo));
            }
        }
        if (managedWorkItemInfoDataMap != null) {
            updatedObjectsMap = new HashMap();
            for (WorkItemInfo workItemInfo : managedWorkItemInfoDataMap.get().keySet()) {
                EntityManagerFactoryProxy.updateWorkItemInfoMarshalledData(workItemInfo, testMethodName, em, updatedObjectsMap);
            }
            for (WorkItemInfo workItemInfo : updatedObjectsMap.keySet()) {
                managedWorkItemInfoDataMap.get().put(workItemInfo, updatedObjectsMap.get(workItemInfo));
            }
        }
        if (managedProcessInstanceInfoDataMap != null) {
            updatedObjectsMap = new HashMap();
            for (Object processInstanceInfo : managedProcessInstanceInfoDataMap.get().keySet()) {
                EntityManagerFactoryProxy.updateProcessInstanceInfoMarshalledData(processInstanceInfo, testMethodName, em, updatedObjectsMap);
            }
            for (Object processInstanceInfoObject : updatedObjectsMap.keySet()) {
                managedProcessInstanceInfoDataMap.get().put(processInstanceInfoObject, updatedObjectsMap.get(processInstanceInfoObject));
            }
        }
    }

    private static void updateSessionInfoMarshalledData(SessionInfo sessionInfo, String testMethodName, EntityManager em, HashMap<SessionInfo, byte[]> updateManagedSessionInfoMap) {
        byte[] origMarshalledBytes = managedSessionInfoDataMap.get().get(sessionInfo);
        if (Arrays.equals(origMarshalledBytes, sessionInfo.getData())) {
            return;
        }
        updateManagedSessionInfoMap.put(sessionInfo, sessionInfo.getData());
        byte[] thisMarshalledData = sessionMarshalledDataMap.get().get(testMethodName);
        if (thisMarshalledData == null || !Arrays.equals(thisMarshalledData, sessionInfo.getData())) {
            MarshalledData marshalledData = new MarshalledData(sessionInfo);
            em.persist((Object)marshalledData);
            sessionMarshalledDataMap.get().put(sessionInfo.getId(), marshalledData.byteArray);
            logger.trace("-!-: " + marshalledData);
        }
    }

    private static void updateWorkItemInfoMarshalledData(WorkItemInfo workItemInfo, String testMethodName, EntityManager em, HashMap<WorkItemInfo, byte[]> updateManagedWorkItemInfoMap) {
        byte[] workItemByteArray;
        byte[] origMarshalledBytes = managedWorkItemInfoDataMap.get().get(workItemInfo);
        if (Arrays.equals(origMarshalledBytes, workItemByteArray = MarshallingTestUtil.getWorkItemByteArray(workItemInfo))) {
            return;
        }
        updateManagedWorkItemInfoMap.put(workItemInfo, workItemByteArray);
        byte[] thisMarshalledData = workItemMarshalledDataMap.get().get(testMethodName);
        if (thisMarshalledData == null || !Arrays.equals(thisMarshalledData, workItemByteArray)) {
            MarshalledData marshalledData = new MarshalledData(workItemInfo);
            em.persist((Object)marshalledData);
            workItemMarshalledDataMap.get().put(workItemInfo.getId(), marshalledData.byteArray);
            logger.trace("-!-: " + marshalledData);
        }
    }

    private static void updateProcessInstanceInfoMarshalledData(Object processInstanceInfo, String testMethodName, EntityManager em, HashMap<Object, byte[]> updateManagedProcessInfoMap) {
        byte[] currMarshalledBytes;
        byte[] origMarshalledBytes = managedProcessInstanceInfoDataMap.get().get(processInstanceInfo);
        if (Arrays.equals(origMarshalledBytes, currMarshalledBytes = MarshallingTestUtil.getProcessInstanceInfoByteArray(processInstanceInfo))) {
            return;
        }
        updateManagedProcessInfoMap.put(processInstanceInfo, currMarshalledBytes);
        Long id = MarshallingTestUtil.getProcessInstanceInfoId(processInstanceInfo);
        byte[] thisMarshalledData = processInstanceInfoMarshalledDataMap.get().get(id);
        if (thisMarshalledData == null || !Arrays.equals(thisMarshalledData, currMarshalledBytes)) {
            MarshalledData marshalledData = new MarshalledData(processInstanceInfo);
            em.persist((Object)marshalledData);
            processInstanceInfoMarshalledDataMap.get().put(id, marshalledData.byteArray);
            logger.trace("-!-: " + marshalledData);
        }
    }
}

