/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.util;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Table;
import org.drools.marshalling.util.MarshalledData;
import org.drools.marshalling.util.MarshallingTestUtil;
import org.drools.persistence.util.PersistenceUtil;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallingDBUtil {
    protected static String MARSHALLING_TEST_DB = "marshalling/testData";
    protected static final String MARSHALLING_BASE_DB = "marshalling/baseData-current";
    protected static boolean clearMarshallingTestDb = true;

    public static String initializeTestDb(Properties jdbcProps, Class<?> testClass) {
        String makeBaseDb = jdbcProps.getProperty("makeBaseDb");
        if ("true".equals(makeBaseDb)) {
            MARSHALLING_TEST_DB = MARSHALLING_BASE_DB;
            MarshallingTestUtil.DO_NOT_COMPARE_MAKING_BASE_DB = true;
        }
        String dbPath = MarshallingDBUtil.generatePathToTestDb(testClass);
        if (clearMarshallingTestDb) {
            clearMarshallingTestDb = false;
            URL dbUrl = Object.class.getResource("/" + MARSHALLING_TEST_DB + ".h2.db");
            MarshallingDBUtil.deleteTestDatabase(dbUrl, dbPath);
            MarshallingDBUtil.createMarshallingTestDatabase(dbPath, jdbcProps.getProperty("driverClassName"));
        }
        String jdbcURLBase = jdbcProps.getProperty("url");
        return jdbcURLBase + dbPath;
    }

    protected static String generatePathToTestDb(Class<?> testClass) {
        URL classUrl = testClass.getResource(testClass.getSimpleName() + ".class");
        String projectPath = classUrl.getPath().replaceFirst("target.*", "");
        String resourcesPath = projectPath + "src/test/resources/";
        new File(resourcesPath).mkdirs();
        new File(resourcesPath + "marshalling").mkdir();
        String dbPath = resourcesPath + MARSHALLING_TEST_DB;
        return dbPath;
    }

    private static void createMarshallingTestDatabase(String dbPath, String driverClass) {
        try {
            Class.forName(driverClass);
            Connection conn = DriverManager.getConnection("jdbc:h2:" + dbPath);
            conn.setAutoCommit(true);
            Statement stat = conn.createStatement();
            String dropTableQuery = "drop table if exists " + MarshallingDBUtil.getTableName(MarshalledData.class);
            stat.executeUpdate(dropTableQuery);
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to create marshalling database: " + dbPath));
        }
    }

    private static void deleteTestDatabase(URL dbUrl, String dbPath) {
        if (dbUrl != null) {
            new File(dbUrl.getPath()).delete();
        }
        new File(dbPath + ".h2.db").delete();
    }

    private static String getTableName(Class<?> dataClass) {
        String tableName = null;
        Annotation[] anno = dataClass.getDeclaredAnnotations();
        for (int i = 0; i < anno.length; ++i) {
            int a;
            Class<? extends Annotation> annoClass = anno[i].annotationType();
            if (!annoClass.equals(Table.class)) continue;
            Method[] annoMethod = annoClass.getMethods();
            for (a = 0; a < annoMethod.length && !annoMethod[a].getName().equals("name"); ++a) {
            }
            try {
                tableName = (String)annoMethod[a].invoke((Object)anno[i], new Object[0]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Unable to generate HQL query - could not get table name: " + e.getMessage()));
            }
        }
        if (tableName == null) {
            tableName = dataClass.getName();
            tableName = tableName.substring(tableName.lastIndexOf(46) + 1).toLowerCase();
        }
        return tableName;
    }

    public static HashMap<String, Object> initializeMarshalledDataEMF(String persistenceUnitName, Class<?> testClass, boolean useBaseDb) {
        return MarshallingDBUtil.initializeMarshalledDataEMF(persistenceUnitName, testClass, useBaseDb, null);
    }

    protected static String[] getListOfBaseDbVers(Class<?> testClass) {
        FilenameFilter baseDatafilter;
        ArrayList<String> versionList = new ArrayList<String>();
        String path = MarshallingDBUtil.generatePathToTestDb(testClass);
        File marshallingDir = new File(path = path.replace(File.separatorChar + "testData", ""));
        String[] dbFiles = marshallingDir.list(baseDatafilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("baseData");
            }
        });
        Assert.assertTrue((String)"No files found in marshalling directory!", (dbFiles != null && dbFiles.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < dbFiles.length; ++i) {
            String ver = dbFiles[i];
            ver = ver.replace(".h2.db", "");
            ver = ver.replace("baseData", "");
            ver = ver.replace("-", "");
            versionList.add(ver);
        }
        String[] versions = new String[versionList.size()];
        for (int v = 0; v < versions.length; ++v) {
            versions[v] = (String)versionList.get(v);
        }
        return versions;
    }

    public static HashMap<String, Object> initializeMarshalledDataEMF(String persistenceUnitName, Class<?> testClass, boolean useBaseDb, String baseDbVer) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Properties dsProps = PersistenceUtil.getDatasourceProperties();
        String driverClass = dsProps.getProperty("driverClassName");
        if (!driverClass.startsWith("org.h2")) {
            return null;
        }
        String tempDbPath = MarshallingDBUtil.generatePathToTestDb(testClass);
        if (useBaseDb) {
            String thisDbPath = tempDbPath = tempDbPath.replace(MARSHALLING_TEST_DB, MARSHALLING_BASE_DB);
            if (baseDbVer != null && baseDbVer.length() > 0) {
                thisDbPath = thisDbPath.replace("current", baseDbVer);
            }
            tempDbPath = tempDbPath.replace("-current", "");
            MarshallingDBUtil.copyH2DbFile(thisDbPath, tempDbPath);
        }
        String jdbcURLBase = dsProps.getProperty("url");
        String jdbcUrl = jdbcURLBase + tempDbPath;
        PoolingDataSource ds1 = PersistenceUtil.setupPoolingDataSource(dsProps);
        ds1.getDriverProperties().setProperty("url", jdbcUrl);
        ds1.init();
        context.put(PersistenceUtil.DATASOURCE, ds1);
        Properties overrideProperties = new Properties();
        overrideProperties.setProperty("hibernate.connection.url", jdbcUrl);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)persistenceUnitName, (Map)overrideProperties);
        context.put("drools.persistence.jpa.EntityManagerFactory", emf);
        return context;
    }

    private static void copyH2DbFile(String source, String dest) {
        source = source + ".h2.db";
        dest = dest + ".h2.db";
        try {
            File sourceFile = new File(source);
            File destFile = new File(dest);
            FileInputStream in = new FileInputStream(sourceFile);
            FileOutputStream out = new FileOutputStream(destFile);
            byte[] buf = new byte[1024];
            int len = ((InputStream)in).read(buf);
            while (len > 0) {
                ((OutputStream)out).write(buf, 0, len);
                len = ((InputStream)in).read(buf);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            Assert.fail((String)("Unable to copy " + source + " to " + dest + ": " + e.getMessage()));
        }
    }
}

