/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.drools.core.factmodel.traits.TraitFactory;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.factmodel.traits.VirtualPropertyMode;
import org.drools.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Variable;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

@RunWith(value=Parameterized.class)
public class JpaPersistenceTraitTest {
    private HashMap<String, Object> context;
    private Environment env;
    private boolean locking;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> persistence() {
        Object[][] locking = new Object[][]{{PersistenceUtil.OPTIMISTIC_LOCKING}, {PersistenceUtil.PESSIMISTIC_LOCKING}};
        return Arrays.asList(locking);
    }

    public JpaPersistenceTraitTest(String locking) {
        this.locking = PersistenceUtil.PESSIMISTIC_LOCKING.equals(locking);
    }

    @Before
    public void setUp() throws Exception {
        this.context = PersistenceUtil.setupWithPoolingDataSource("org.drools.persistence.jpa");
        this.env = PersistenceUtil.createEnvironment(this.context);
        if (this.locking) {
            this.env.set("org.kie.api.persistence.pessimistic", (Object)true);
        }
    }

    @After
    public void tearDown() throws Exception {
        PersistenceUtil.cleanUp(this.context);
    }

    @Test
    public void testTripleBasedTraitsWithJPA() {
        String str = "package org.drools.trait.test; \nglobal java.util.List list; \ndeclare TBean \n  @propertyReactive \n  @Traitable \n  fld : String \nend \n declare trait Mask \n  @propertyReactive \n  fld : String \n  xyz : int  \nend \n\n declare trait Cloak \n  @propertyReactive \n  fld : String \n  ijk : String  \nend \nrule Init \nwhen \nthen \n  insert( new TBean(\"abc\") ); \nend \nrule Don \nno-loop \nwhen \n  $b : TBean( ) \nthen \n  Mask m = don( $b, Mask.class ); \n  modify (m) { setXyz( 10 ); } \n  list.add( m ); \n  System.out.println( \"Don result : \" + m ); \n end \n\nrule Don2 \nno-loop \nwhen \n  $b : TBean( ) \nthen \n  Cloak c = don( $b, Cloak.class ); \n  modify (c) { setIjk( \"ijklmn\" ); } \n  list.add( c ); \n  System.out.println( \"Don result : \" + c ); \n end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        long id = ksession.getIdentifier();
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession2.fireAllRules();
        Collection x = ksession2.getObjects();
        Assert.assertEquals((long)3L, (long)x.size());
        TraitableBean core = null;
        for (Object o : x) {
            if (!(o instanceof TraitableBean)) continue;
            core = (TraitableBean)o;
            break;
        }
        Assert.assertNotNull(core);
        Assert.assertEquals((long)2L, (long)core._getDynamicProperties().size());
        Assert.assertNotNull((Object)core.getTrait("org.drools.trait.test.Mask"));
        Assert.assertNotNull((Object)core.getTrait("org.drools.trait.test.Cloak"));
    }

    @Test
    public void testMapBasedTraitsWithJPA() {
        String str = "package org.drools.trait.test; \nglobal java.util.List list; \ndeclare TBean2 \n  @propertyReactive \n  @Traitable \n  fld : String \nend \n declare trait Mask2 \n  @propertyReactive \n  fld : String \n  xyz : int  \nend \n\n declare trait Cloak2 \n  @propertyReactive \n  fld : String \n  ijk : String  \nend \nrule Init \nwhen \nthen \n  insert( new TBean2(\"abc\") ); \nend \nrule Don \nno-loop \nwhen \n  $b : TBean2( ) \nthen \n  Mask2 m = don( $b, Mask2.class ); \n  modify (m) { setXyz( 10 ); } \n  list.add( m ); \n  System.out.println( \"Don result : \" + m ); \n end \n\nrule Don2 \nno-loop \nwhen \n  $b : TBean2( ) \nthen \n  Cloak2 c = don( $b, Cloak2.class ); \n  modify (c) { setIjk( \"ijklmn\" ); } \n  list.add( c ); \n  System.out.println( \"Don result : \" + c ); \n end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactory.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)kbase);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        long id = ksession.getIdentifier();
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession2.fireAllRules();
        Collection x = ksession2.getObjects();
        Assert.assertEquals((long)3L, (long)x.size());
        TraitableBean core = null;
        for (Object o : x) {
            if (!(o instanceof TraitableBean)) continue;
            core = (TraitableBean)o;
            break;
        }
        Assert.assertNotNull(core);
        Assert.assertEquals((long)2L, (long)core._getDynamicProperties().size());
        Assert.assertNotNull((Object)core.getTrait("org.drools.trait.test.Mask2"));
        Assert.assertNotNull((Object)core.getTrait("org.drools.trait.test.Cloak2"));
    }

    public void traitsLegacyWrapperWithJPA(VirtualPropertyMode mode) {
        String str = "package org.drools.trait.test; \nglobal java.util.List list; \nimport org.drools.core.factmodel.traits.*; \ndeclare TBean \n@Traitable \n  fld : String \nend \n declare trait Mask \n  @propertyReactive \n  fld : String \n  xyz : int  \nend \n\n rule Init \nwhen \nthen \n  insert( new TBean(\"abc\") ); \nend \nrule Don \nno-loop \nwhen \n  $b : TBean( ) \nthen \n  System.out.println( \"Din Don Dan: \"  ); \n   Mask m = don( $b, Mask.class ); \n  modify (m) { setXyz( 10 ); } \n  list.add( m ); \n  System.out.println( \"Don result : \" + m ); \n end \n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        TraitFactory.setMode((VirtualPropertyMode)mode, (KieBase)ksession.getKieBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        long id = ksession.getIdentifier();
        Collection yOld = ksession.getObjects();
        TraitableBean coreOld = null;
        for (Object o : yOld) {
            if (!(o instanceof TraitableBean)) continue;
            coreOld = (TraitableBean)o;
            break;
        }
        Assert.assertNotNull(coreOld);
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase, null, (Environment)this.env);
        ksession2.fireAllRules();
        Collection y = ksession2.getObjects();
        Assert.assertEquals((long)2L, (long)y.size());
        TraitableBean core = null;
        for (Object o : y) {
            if (!(o instanceof TraitableBean)) continue;
            core = (TraitableBean)o;
            break;
        }
        Assert.assertNotNull(core);
        Assert.assertEquals((long)1L, (long)core._getDynamicProperties().size());
        Assert.assertNotNull((Object)core.getTrait("org.drools.trait.test.Mask"));
    }

    @Test
    public void testTraitsOnLegacyJPATriple() {
        this.traitsLegacyWrapperWithJPA(VirtualPropertyMode.TRIPLES);
    }

    @Test
    public void testTraitsOnLegacyJPAMap() {
        this.traitsLegacyWrapperWithJPA(VirtualPropertyMode.MAP);
    }

    @Test
    public void testTraitWithJPAOnFreshKieBase() {
        String str = "package org.drools.trait.test; global java.util.List list; declare TBean2    @propertyReactive    @Traitable  end   declare trait Mask   @propertyReactive  end  query getTraits( Mask $m )   $m := Mask() end rule Init when then don( new TBean2(), Mask.class ); end rule Trig when String() then don( new TBean2(), Mask.class ); end rule Main when $m : Mask() then list.add( $m ); end ";
        ArrayList list = new ArrayList();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)this.env);
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        long id = ksession.getIdentifier();
        KnowledgeBase kbase2 = KnowledgeBaseFactory.newKnowledgeBase();
        TraitFactory.setMode((VirtualPropertyMode)VirtualPropertyMode.MAP, (KieBase)kbase);
        kbase2.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)id, (KieBase)kbase2, null, (Environment)this.env);
        ksession.setGlobal("list", list);
        ksession2.insert((Object)"go");
        ksession2.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Class<?> oldProxyClass = list.get(0).getClass();
        Class<?> newProxyClass = list.get(1).getClass();
        Assert.assertNotSame(oldProxyClass, newProxyClass);
        QueryResults qry = ksession2.getQueryResults("getTraits", new Object[]{Variable.v});
        Assert.assertEquals((long)2L, (long)qry.size());
        Iterator iter = qry.iterator();
        int j = 0;
        while (iter.hasNext()) {
            QueryResultsRow row = (QueryResultsRow)iter.next();
            Object entry = row.get("$m");
            Assert.assertNotNull((Object)entry);
            Assert.assertSame(newProxyClass, entry.getClass());
            ++j;
        }
        Assert.assertEquals((long)2L, (long)j);
        for (Object o : ksession2.getObjects()) {
            if (!o.getClass().getName().contains("Mask")) continue;
            Assert.assertSame(newProxyClass, o.getClass());
        }
    }
}

